/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionLoadingFailed;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.interfaces.InterfaceVARNASelectionListener;
import fr.orsay.lri.varna.models.BaseList;
import fr.orsay.lri.varna.models.FullBackup;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import jalview.analysis.AlignSeq;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.RnaViewerModel;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.ext.varna.RnaModel;
import jalview.gui.AlignmentPanel;
import jalview.gui.AppVarnaBinding;
import jalview.gui.Desktop;
import jalview.structure.SecondaryStructureListener;
import jalview.structure.SelectionListener;
import jalview.structure.SelectionSource;
import jalview.structure.StructureSelectionManager;
import jalview.structure.VamsasSource;
import jalview.util.Comparison;
import jalview.util.MessageManager;
import jalview.util.ShiftList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JInternalFrame;
import javax.swing.JSplitPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class AppVarna
extends JInternalFrame
implements SelectionListener,
SecondaryStructureListener,
InterfaceVARNASelectionListener,
VamsasSource {
    private static final byte[] PAIRS = new byte[]{40, 41, 91, 93, 123, 125, 60, 62};
    private AppVarnaBinding vab;
    private AlignmentPanel ap;
    private String viewId;
    private StructureSelectionManager ssm;
    private Map<RNA, RnaModel> models = new LinkedHashMap<RNA, RnaModel>();
    private Map<RNA, ShiftList> offsets = new Hashtable<RNA, ShiftList>();
    private Map<RNA, ShiftList> offsetsInv = new Hashtable<RNA, ShiftList>();
    private JSplitPane split;
    private VarnaHighlighter mouseOverHighlighter = new VarnaHighlighter();
    private VarnaHighlighter selectionHighlighter = new VarnaHighlighter();

    public AppVarna(SequenceI seq, AlignmentAnnotation aa, AlignmentPanel ap) {
        this(ap);
        String sname = aa.sequenceRef == null ? "secondary structure (alignment)" : seq.getName() + " structure";
        String theTitle = sname + (aa.sequenceRef == null ? " trimmed to " + seq.getName() : "");
        theTitle = MessageManager.formatMessage("label.varna_params", new String[]{theTitle});
        this.setTitle(theTitle);
        String gappedTitle = sname + " (with gaps)";
        RnaModel gappedModel = new RnaModel(gappedTitle, aa, seq, null, true);
        this.addModel(gappedModel, gappedTitle);
        String trimmedTitle = "trimmed " + sname;
        RnaModel trimmedModel = new RnaModel(trimmedTitle, aa, seq, null, false);
        this.addModel(trimmedModel, trimmedTitle);
        this.vab.setSelectedIndex(0);
    }

    protected AppVarna(AlignmentPanel ap) {
        this.setFrameIcon(null);
        this.ap = ap;
        this.viewId = System.currentTimeMillis() + "." + this.hashCode();
        this.vab = new AppVarnaBinding();
        this.initVarna();
        this.ssm = ap.getStructureSelectionManager();
        this.ssm.addStructureViewerListener(this);
        this.ssm.addSelectionListener(this);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                AppVarna.this.close();
            }
        });
    }

    public AppVarna(RnaViewerModel model, AlignmentPanel ap) {
        this(ap);
        this.setTitle(model.title);
        this.viewId = model.viewId;
        this.setBounds(model.x, model.y, model.width, model.height);
        this.split.setDividerLocation(model.dividerLocation);
    }

    public void initVarna() {
        VARNAPanel varnaPanel = this.vab.get_varnaPanel();
        this.setBackground(Color.white);
        this.split = new JSplitPane(1, true, this.vab.getListPanel(), (Component)varnaPanel);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.split, "Center");
        varnaPanel.addSelectionListener((InterfaceVARNASelectionListener)this);
        Desktop.addInternalFrame(this, "", this.getBounds().width, this.getBounds().height);
        this.pack();
        this.showPanel(true);
    }

    public RNA trimRNA(RNA rna, String name) {
        ShiftList offset = new ShiftList();
        RNA rnaTrim = new RNA(name);
        try {
            String structDBN = rna.getStructDBN(true);
            rnaTrim.setRNA(rna.getSeq(), AppVarna.replaceOddGaps(structDBN));
        }
        catch (ExceptionUnmatchedClosingParentheses e2) {
            e2.printStackTrace();
        }
        catch (ExceptionFileFormatOrSyntax e3) {
            e3.printStackTrace();
        }
        String seq = rnaTrim.getSeq();
        StringBuilder struc = new StringBuilder(256);
        struc.append(rnaTrim.getStructDBN(true));
        int ofstart = -1;
        int sleng = seq.length();
        for (int i = 0; i < sleng; ++i) {
            if (Comparison.isGap(seq.charAt(i))) {
                if (ofstart == -1) {
                    ofstart = i;
                }
                if (!rnaTrim.findPair(i).isEmpty()) {
                    int m = (Integer)rnaTrim.findPair(i).get(1);
                    int l = (Integer)rnaTrim.findPair(i).get(0);
                    struc.replace(m, m + 1, "*");
                    struc.replace(l, l + 1, "*");
                    continue;
                }
                struc.replace(i, i + 1, "*");
                continue;
            }
            if (ofstart <= -1) continue;
            offset.addShift(offset.shift(ofstart), ofstart - i);
            ofstart = -1;
        }
        if (ofstart > -1) {
            offset.addShift(offset.shift(ofstart), ofstart - sleng);
            ofstart = -1;
        }
        String newStruc = struc.toString().replace("*", "");
        String newSeq = AlignSeq.extractGaps(Comparison.GapChars, seq);
        try {
            rnaTrim.setRNA(newSeq, newStruc);
            this.registerOffset(rnaTrim, offset);
        }
        catch (ExceptionUnmatchedClosingParentheses e) {
            e.printStackTrace();
        }
        catch (ExceptionFileFormatOrSyntax e) {
            e.printStackTrace();
        }
        return rnaTrim;
    }

    private void registerOffset(RNA rnaTrim, ShiftList offset) {
        this.offsets.put(rnaTrim, offset);
        this.offsetsInv.put(rnaTrim, offset.getInverse());
    }

    public void showPanel(boolean show) {
        this.setVisible(show);
    }

    @Override
    public void mouseOverSequence(SequenceI sequence, int index, int position) {
        RNA rna = this.vab.getSelectedRNA();
        if (rna == null) {
            return;
        }
        RnaModel rnaModel = this.models.get(rna);
        if (rnaModel.seq == sequence) {
            int highlightPos = rnaModel.gapped ? index : position - sequence.getStart();
            this.mouseOverHighlighter.highlightRegion(rna, highlightPos, highlightPos);
            this.vab.updateSelectedRNA(rna);
        }
    }

    @Override
    public void selection(SequenceGroup seqsel, ColumnSelection colsel, HiddenColumns hidden, SelectionSource source) {
        if (source != this.ap.av) {
            return;
        }
        RNA rna = this.vab.getSelectedRNA();
        if (rna == null) {
            return;
        }
        RnaModel rnaModel = this.models.get(rna);
        if (seqsel != null && seqsel.getSize() > 0 && seqsel.contains(rnaModel.seq)) {
            int start = seqsel.getStartRes();
            int end = seqsel.getEndRes();
            if (rnaModel.gapped) {
                ShiftList shift = this.offsets.get(rna);
                if (shift != null) {
                    start = shift.shift(start);
                    end = shift.shift(end);
                }
            } else {
                start = rnaModel.seq.findPosition(start) - rnaModel.seq.getStart();
                end = rnaModel.seq.findPosition(end) - rnaModel.seq.getStart();
            }
            this.selectionHighlighter.highlightRegion(rna, start, end);
            this.selectionHighlighter.getLastHighlight().setOutlineColor(seqsel.getOutlineColour());
            this.vab.updateSelectedRNA(rna);
        } else {
            this.selectionHighlighter.clearSelection();
        }
    }

    public void onHoverChanged(ModeleBase previousBase, ModeleBase newBase) {
        RNA rna = this.vab.getSelectedRNA();
        ShiftList shift = this.offsetsInv.get(rna);
        SequenceI seq = this.models.get((Object)rna).seq;
        if (newBase != null && seq != null) {
            if (shift != null) {
                int i = shift.shift(newBase.getIndex());
                this.ssm.mouseOverVamsasSequence(seq, i, this);
            } else {
                this.ssm.mouseOverVamsasSequence(seq, newBase.getIndex(), this);
            }
        }
    }

    public void onSelectionChanged(BaseList arg0, BaseList arg1, BaseList arg2) {
    }

    public String getStateInfo(RNA rna) {
        return this.vab.getStateInfo(rna);
    }

    public AlignmentPanel getAlignmentPanel() {
        return this.ap;
    }

    public String getViewId() {
        return this.viewId;
    }

    public boolean isListeningFor(SequenceI seq) {
        for (RnaModel model : this.models.values()) {
            if (model.seq != seq) continue;
            return true;
        }
        return false;
    }

    public int getDividerLocation() {
        return this.split == null ? 0 : this.split.getDividerLocation();
    }

    protected void close() {
        if (this.ssm != null) {
            this.ssm.removeStructureViewerListener(this, null);
            this.ssm.removeSelectionListener(this);
        }
    }

    public AlignmentAnnotation getAnnotation(SequenceI seq) {
        for (RnaModel model : this.models.values()) {
            if (model.seq != seq) continue;
            return model.ann;
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.vab.getSelectedIndex();
    }

    public Collection<RnaModel> getModels() {
        return this.models.values();
    }

    public RNA addModel(RnaModel model, String modelName) {
        if (!model.ann.isValidStruc()) {
            throw new IllegalArgumentException("Invalid RNA structure annotation");
        }
        RNA rna = new RNA(modelName);
        String struc = model.ann.getRNAStruc();
        struc = AppVarna.replaceOddGaps(struc);
        String strucseq = model.seq.getSequenceAsString();
        try {
            rna.setRNA(strucseq, struc);
        }
        catch (ExceptionUnmatchedClosingParentheses e2) {
            e2.printStackTrace();
        }
        catch (ExceptionFileFormatOrSyntax e3) {
            e3.printStackTrace();
        }
        if (!model.gapped) {
            rna = this.trimRNA(rna, modelName);
        }
        this.models.put(rna, new RnaModel(modelName, model.ann, model.seq, rna, model.gapped));
        this.vab.addStructure(rna);
        return rna;
    }

    protected ShiftList buildOffset(SequenceI seq) {
        ShiftList offset = new ShiftList();
        int ofstart = -1;
        int sleng = seq.getLength();
        for (int i = 0; i < sleng; ++i) {
            if (Comparison.isGap(seq.getCharAt(i))) {
                if (ofstart != -1) continue;
                ofstart = i;
                continue;
            }
            if (ofstart <= -1) continue;
            offset.addShift(offset.shift(ofstart), ofstart - i);
            ofstart = -1;
        }
        if (ofstart > -1) {
            offset.addShift(offset.shift(ofstart), ofstart - sleng);
            ofstart = -1;
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialSelection(int selectedIndex) {
        AppVarna appVarna = this;
        synchronized (appVarna) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.vab.setSelectedIndex(selectedIndex);
    }

    public RNA addModelSession(RnaModel model, String modelName, String sessionFile) {
        if (!model.ann.isValidStruc()) {
            throw new IllegalArgumentException("Invalid RNA structure annotation");
        }
        try {
            FullBackup fromSession = this.vab.vp.loadSession(sessionFile);
            this.vab.addStructure(fromSession.rna, fromSession.config);
            RNA rna = fromSession.rna;
            RnaModel newModel = new RnaModel(model.title, model.ann, model.seq, rna, model.gapped);
            if (!model.gapped) {
                this.registerOffset(rna, this.buildOffset(model.seq));
            }
            this.models.put(rna, newModel);
            this.selectionHighlighter = new VarnaHighlighter(rna);
            return fromSession.rna;
        }
        catch (ExceptionLoadingFailed e) {
            System.err.println("Error restoring Varna session: " + e.getMessage());
            return null;
        }
    }

    public static String replaceOddGaps(String s) {
        if (s == null) {
            return null;
        }
        boolean changed = false;
        byte[] bytes = s.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            boolean ok = false;
            for (int j = 0; !ok && j < PAIRS.length; ++j) {
                if (bytes[i] != PAIRS[j]) continue;
                ok = true;
            }
            if (ok) continue;
            bytes[i] = 46;
            changed = true;
        }
        return changed ? new String(bytes) : s;
    }

    private class VarnaHighlighter {
        private HighlightRegionAnnotation _lastHighlight;
        private RNA _lastRNAhighlighted = null;

        public VarnaHighlighter() {
        }

        public VarnaHighlighter(RNA rna) {
            this._lastRNAhighlighted = rna;
            ArrayList highlights = rna.getHighlightRegion();
            if (highlights != null && !highlights.isEmpty()) {
                this._lastHighlight = (HighlightRegionAnnotation)highlights.get(0);
            }
        }

        public void highlightRegion(RNA rna, int start, int end) {
            this.clearLastSelection();
            HighlightRegionAnnotation highlight = new HighlightRegionAnnotation(rna.getBasesBetween(start, end));
            rna.addHighlightRegion(highlight);
            this._lastHighlight = highlight;
            this._lastRNAhighlighted = rna;
        }

        public HighlightRegionAnnotation getLastHighlight() {
            return this._lastHighlight;
        }

        public void clearSelection() {
            if (this._lastRNAhighlighted != null) {
                this._lastRNAhighlighted.getHighlightRegion().clear();
                AppVarna.this.vab.updateSelectedRNA(this._lastRNAhighlighted);
                this._lastRNAhighlighted = null;
                this._lastHighlight = null;
            }
        }

        public void clearLastSelection() {
            if (this._lastRNAhighlighted != null) {
                this._lastRNAhighlighted.removeHighlightRegion(this._lastHighlight);
                this._lastRNAhighlighted = null;
                this._lastHighlight = null;
            }
        }
    }
}

