/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignViewportI;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.ContactListI;
import jalview.datamodel.ContactMatrixI;
import jalview.datamodel.ContactRange;
import jalview.datamodel.GraphLine;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.JalviewColourChooser;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.OOMWarning;
import jalview.gui.PaintRefresher;
import jalview.renderer.AnnotationRenderer;
import jalview.renderer.AwtRenderPanelI;
import jalview.renderer.ContactGeometry;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import jalview.util.Format;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.viewmodel.ViewportListenerI;
import jalview.ws.datamodel.MappableContactMatrixI;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import javax.swing.ToolTipManager;

public class AnnotationPanel
extends JPanel
implements AwtRenderPanelI,
MouseListener,
MouseWheelListener,
MouseMotionListener,
ActionListener,
AdjustmentListener,
Scrollable,
ViewportListenerI {
    String HELIX = MessageManager.getString("label.helix");
    String SHEET = MessageManager.getString("label.sheet");
    String STEM = MessageManager.getString("label.rna_helix");
    String LABEL = MessageManager.getString("label.label");
    String REMOVE = MessageManager.getString("label.remove_annotation");
    String COLOUR = MessageManager.getString("action.colour");
    public final Color HELIX_COLOUR = Color.red.darker();
    public final Color SHEET_COLOUR = Color.green.darker().darker();
    public final Color STEM_COLOUR = Color.blue.darker();
    public AlignViewport av;
    AlignmentPanel ap;
    public int activeRow = -1;
    public BufferedImage image;
    public volatile BufferedImage fadedImage;
    public FontMetrics fm;
    public int imgWidth = 0;
    boolean fastPaint = false;
    int graphStretch = -1;
    int mouseDragLastX = -1;
    int mouseDragLastY = -1;
    int firstDragX = -1;
    int firstDragY = -1;
    DragMode dragMode = DragMode.Undefined;
    boolean mouseDragging = false;
    int cursorX = 0;
    int cursorY = 0;
    public final AnnotationRenderer renderer;
    private MouseWheelListener[] _mwl;
    private boolean notJustOne;
    private volatile boolean imageFresh = false;
    private Rectangle visibleRect = new Rectangle();
    private Rectangle clipBounds = new Rectangle();
    private final boolean debugRedraw = false;
    private volatile boolean lastImageGood = false;
    private int[] bounds = new int[2];

    public AnnotationPanel(AlignmentPanel ap) {
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.ap = ap;
        this.av = ap.av;
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        ap.annotationScroller.getVerticalScrollBar().addAdjustmentListener(this);
        this._mwl = ap.annotationScroller.getMouseWheelListeners();
        ap.annotationScroller.addMouseWheelListener(this);
        this.renderer = new AnnotationRenderer();
        this.av.getRanges().addPropertyChangeListener(this);
    }

    public AnnotationPanel(AlignViewport av) {
        this.av = av;
        this.renderer = new AnnotationRenderer();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.isShiftDown()) {
            this.ap.getSeqPanel().mouseWheelMoved(e);
        } else {
            for (MouseWheelListener mwl : this._mwl) {
                if (mwl != null) {
                    mwl.mouseWheelMoved(e);
                }
                if (e.isConsumed()) break;
            }
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension ps = this.getPreferredSize();
        return new Dimension(ps.width, this.adjustForAlignFrame(false, ps.height));
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 30;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 30;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.ap.getAlabels().setScrollOffset(-evt.getValue());
    }

    public int adjustPanelHeight() {
        int height = this.av.calcPanelHeight();
        this.setPreferredSize(new Dimension(1, height));
        if (this.ap != null) {
            this.ap.validate();
        }
        return height;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String action;
        AlignmentAnnotation[] aa = this.av.getAlignment().getAlignmentAnnotation();
        if (aa == null) {
            return;
        }
        Annotation[] anot = aa[this.activeRow].annotations;
        if (anot.length < this.av.getColumnSelection().getMax()) {
            Annotation[] temp = new Annotation[this.av.getColumnSelection().getMax() + 2];
            System.arraycopy(anot, 0, temp, 0, anot.length);
            anot = temp;
            aa[this.activeRow].annotations = anot;
        }
        if ((action = evt.getActionCommand()).equals(this.REMOVE)) {
            for (int index : this.av.getColumnSelection().getSelected()) {
                if (!this.av.getAlignment().getHiddenColumns().isVisible(index)) continue;
                anot[index] = null;
            }
        } else if (action.equals(this.LABEL)) {
            String exMesg = this.collectAnnotVals(anot, this.LABEL);
            String label = JvOptionPane.showInputDialog(MessageManager.getString("label.enter_label"), exMesg);
            if (label == null) {
                return;
            }
            if (label.length() > 0 && !aa[this.activeRow].hasText) {
                aa[this.activeRow].hasText = true;
            }
            for (int index : this.av.getColumnSelection().getSelected()) {
                if (!this.av.getAlignment().getHiddenColumns().isVisible(index)) continue;
                if (anot[index] == null) {
                    anot[index] = new Annotation(label, "", ' ', 0.0f);
                    continue;
                }
                anot[index].displayCharacter = label;
            }
        } else if (action.equals(this.COLOUR)) {
            final Annotation[] fAnot = anot;
            String title = MessageManager.getString("label.select_foreground_colour");
            JalviewColourChooser.ColourChooserListener listener = new JalviewColourChooser.ColourChooserListener(){

                @Override
                public void colourSelected(Color c) {
                    HiddenColumns hiddenColumns = AnnotationPanel.this.av.getAlignment().getHiddenColumns();
                    for (int index : AnnotationPanel.this.av.getColumnSelection().getSelected()) {
                        if (!hiddenColumns.isVisible(index)) continue;
                        if (fAnot[index] == null) {
                            fAnot[index] = new Annotation("", "", ' ', 0.0f);
                        }
                        fAnot[index].colour = c;
                    }
                }
            };
            JalviewColourChooser.showColourChooser(this, title, Color.black, listener);
        } else {
            String label;
            int type = 0;
            String symbol = "\u03b1";
            if (action.equals(this.HELIX)) {
                type = 72;
            } else if (action.equals(this.SHEET)) {
                type = 69;
                symbol = "\u03b2";
            } else if (action.equals(this.STEM)) {
                type = 83;
                int column = this.av.getColumnSelection().getSelectedRanges().get(0)[0];
                symbol = aa[this.activeRow].getDefaultRnaHelixSymbol(column);
            }
            if (!aa[this.activeRow].hasIcons) {
                aa[this.activeRow].hasIcons = true;
            }
            if ((label = JvOptionPane.showInputDialog(MessageManager.getString("label.enter_label_for_the_structure"), symbol)) == null) {
                return;
            }
            if (label.length() > 0 && !aa[this.activeRow].hasText) {
                aa[this.activeRow].hasText = true;
                if (action.equals(this.STEM)) {
                    aa[this.activeRow].showAllColLabels = true;
                }
            }
            for (int index : this.av.getColumnSelection().getSelected()) {
                if (!this.av.getAlignment().getHiddenColumns().isVisible(index)) continue;
                if (anot[index] == null) {
                    anot[index] = new Annotation(label, "", (char)type, 0.0f);
                }
                anot[index].secondaryStructure = type != 83 ? type : (label.length() == 0 ? 32 : (int)label.charAt(0));
                anot[index].displayCharacter = label;
            }
        }
        this.av.getAlignment().validateAnnotation(aa[this.activeRow]);
        this.ap.alignmentChanged();
        this.ap.alignFrame.setMenusForViewport();
        this.adjustPanelHeight();
        this.repaint();
    }

    private String collectAnnotVals(Annotation[] anots, String type) {
        StringBuilder collatedInput = new StringBuilder(64);
        String last = "";
        ColumnSelection viscols = this.av.getColumnSelection();
        HiddenColumns hidden = this.av.getAlignment().getHiddenColumns();
        ArrayList<Integer> selected = new ArrayList<Integer>(viscols.getSelected());
        Collections.sort(selected);
        Iterator iterator = selected.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            if (!hidden.isVisible(index)) continue;
            String tlabel = null;
            if (anots[index] == null) continue;
            if ((type.equals(this.HELIX) || type.equals(this.SHEET) || type.equals(this.STEM) || type.equals(this.LABEL)) && ((tlabel = anots[index].description) == null || tlabel.length() < 1)) {
                tlabel = type.equals(this.HELIX) || type.equals(this.SHEET) || type.equals(this.STEM) ? "" + anots[index].secondaryStructure : "" + anots[index].displayCharacter;
            }
            if (tlabel == null || tlabel.equals(last)) continue;
            if (last.length() > 0) {
                collatedInput.append(" ");
            }
            collatedInput.append(tlabel);
        }
        return collatedInput.toString();
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        AlignmentAnnotation[] aa = this.av.getAlignment().getAlignmentAnnotation();
        if (aa == null) {
            return;
        }
        this.mouseDragLastX = evt.getX();
        this.mouseDragLastY = evt.getY();
        int height = 0;
        this.activeRow = -1;
        int yOffset = 0;
        int y = evt.getY();
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i].isForDisplay()) {
                height += aa[i].height;
            }
            if (y >= height) continue;
            if (aa[i].editable) {
                this.activeRow = i;
                break;
            }
            if (aa[i].graph == 0) break;
            this.graphStretch = i;
            yOffset = height - y;
            break;
        }
        if (evt.isPopupTrigger() && this.activeRow != -1) {
            this.showPopupMenu(y, evt.getX());
            return;
        }
        if (this.graphStretch != -1) {
            if (aa[this.graphStretch].graph == 4 && (evt.isAltDown() || evt.isAltGraphDown())) {
                this.dragMode = DragMode.MatrixSelect;
                this.firstDragX = this.mouseDragLastX;
                this.firstDragY = this.mouseDragLastY;
            }
        } else {
            this.ap.getScalePanel().mousePressed(evt);
        }
    }

    boolean matrix_clicked(MouseEvent evt) {
        ContactGeometry cXcgeom;
        ContactGeometry.contactInterval cXci;
        int[] rowIndex = AnnotationPanel.getRowIndexAndOffset(evt.getY(), this.av.getAlignment().getAlignmentAnnotation());
        if (rowIndex == null) {
            Console.error("IMPLEMENTATION ERROR: matrix click out of range.");
            return false;
        }
        int yOffset = rowIndex[1];
        AlignmentAnnotation[] allAnnotation = this.av.getAlignment().getAlignmentAnnotation();
        if (allAnnotation == null || rowIndex[0] < 0 || rowIndex[0] >= allAnnotation.length) {
            return false;
        }
        AlignmentAnnotation clicked = this.av.getAlignment().getAlignmentAnnotation()[rowIndex[0]];
        if (clicked.graph != 4) {
            return false;
        }
        GraphLine thr = clicked.getThreshold();
        int currentX = this.getColumnForXPos(evt.getX());
        ContactListI forCurrentX = this.av.getContactList(clicked, currentX);
        if (forCurrentX != null && (cXci = (cXcgeom = new ContactGeometry(forCurrentX, clicked.graphHeight)).mapFor(yOffset)) != null) {
            int fr = Math.min(cXci.cStart, cXci.cEnd);
            int to = Math.max(cXci.cStart, cXci.cEnd);
            if (evt.getClickCount() == 2) {
                ContactMatrixI matrix = this.av.getContactMatrix(clicked);
                if (matrix != null && matrix.hasGroups()) {
                    SequenceI rseq = clicked.sequenceRef;
                    BitSet grp = new BitSet();
                    grp.or(matrix.getGroupsFor(forCurrentX.getPosition()));
                    for (int c = fr; c <= to; ++c) {
                        BitSet additionalGrp = matrix.getGroupsFor(c);
                        grp.or(additionalGrp);
                    }
                    HiddenColumns hc = this.av.getAlignment().getHiddenColumns();
                    ColumnSelection cs = this.av.getColumnSelection();
                    int p = grp.nextSetBit(0);
                    while (p >= 0) {
                        if (matrix instanceof MappableContactMatrixI) {
                            int nextp = grp.nextClearBit(p) - 1;
                            int[] pos = ((MappableContactMatrixI)matrix).getMappedPositionsFor(rseq, p, nextp);
                            p = nextp;
                            if (pos != null) {
                                for (int pos_p = pos[0]; pos_p <= pos[1]; ++pos_p) {
                                    int col = rseq.findIndex(pos_p) - 1;
                                    if (col < 0 || this.av.hasHiddenColumns() && !hc.isVisible(col)) continue;
                                    cs.addElement(col);
                                }
                            }
                        } else {
                            int offp;
                            int n = offp = rseq != null ? rseq.findIndex(rseq.getStart() - 1 + p) : p;
                            if (!this.av.hasHiddenColumns() || hc.isVisible(offp)) {
                                cs.addElement(offp);
                            }
                        }
                        p = grp.nextSetBit(p + 1);
                    }
                }
            } else {
                int[] rng = forCurrentX.getMappedPositionsFor(fr, to);
                if (rng != null) {
                    this.av.getColumnSelection().addRangeOfElements(rng, true);
                }
                this.av.getColumnSelection().addElement(currentX);
                if (evt.isControlDown() && "PAE_MATRIX".equals(clicked.getCalcId())) {
                    int[] cols;
                    double cval;
                    int c;
                    ContactRange cr = forCurrentX.getRangeFor(fr, to);
                    double thresh = cr.getMean() + (cr.getMax() - cr.getMean()) * 0.15;
                    for (c = fr; c >= 0; --c) {
                        cval = forCurrentX.getContactAt(c);
                        if (!(cval <= thresh)) continue;
                        cols = forCurrentX.getMappedPositionsFor(c, c);
                        if (cols == null) break;
                        this.av.getColumnSelection().addRangeOfElements(cols, true);
                    }
                    for (c = to; c < forCurrentX.getContactHeight() && (cval = forCurrentX.getContactAt(c)) <= thresh; ++c) {
                        cols = forCurrentX.getMappedPositionsFor(c, c);
                        if (cols == null) continue;
                        this.av.getColumnSelection().addRangeOfElements(cols, true);
                    }
                }
            }
        }
        this.ap.paintAlignment(false, false);
        PaintRefresher.Refresh(this.ap, this.av.getSequenceSetId());
        this.av.sendSelection();
        return true;
    }

    void showPopupMenu(int y, int x) {
        JMenuItem item;
        if (this.av.getColumnSelection() == null || this.av.getColumnSelection().isEmpty()) {
            return;
        }
        JPopupMenu pop = new JPopupMenu(MessageManager.getString("label.structure_type"));
        if (this.av.getAlignment().isNucleotide()) {
            item = new JMenuItem(this.STEM);
            item.addActionListener(this);
            pop.add(item);
        } else {
            item = new JMenuItem(this.HELIX);
            item.addActionListener(this);
            pop.add(item);
            item = new JMenuItem(this.SHEET);
            item.addActionListener(this);
            pop.add(item);
        }
        item = new JMenuItem(this.LABEL);
        item.addActionListener(this);
        pop.add(item);
        item = new JMenuItem(this.COLOUR);
        item.addActionListener(this);
        pop.add(item);
        item = new JMenuItem(this.REMOVE);
        item.addActionListener(this);
        pop.add(item);
        pop.show(this, x, y);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (this.dragMode == DragMode.MatrixSelect) {
            this.matrixSelectRange(evt);
        }
        this.graphStretch = -1;
        this.mouseDragLastX = -1;
        this.mouseDragLastY = -1;
        this.firstDragX = -1;
        this.firstDragY = -1;
        this.mouseDragging = false;
        if (this.dragMode == DragMode.Resize) {
            this.ap.adjustAnnotationHeight();
        }
        this.dragMode = DragMode.Undefined;
        if (!this.matrix_clicked(evt)) {
            this.ap.getScalePanel().mouseReleased(evt);
        }
        if (evt.isPopupTrigger() && this.activeRow != -1) {
            this.showPopupMenu(evt.getY(), evt.getX());
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.mouseDragging = false;
        this.ap.getScalePanel().mouseEntered(evt);
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.ap.getScalePanel().mouseExited(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        if (this.dragMode == DragMode.Undefined) {
            int dx = Math.abs(x - this.mouseDragLastX);
            int dy = Math.abs(y - this.mouseDragLastY);
            if (this.graphStretch == -1 || dx > dy) {
                this.dragMode = DragMode.Select;
            } else if (dy > dx) {
                this.dragMode = DragMode.Resize;
                this.notJustOne = evt.isShiftDown();
                if ((evt.isAltDown() || evt.isAltGraphDown()) && this.av.getAlignment().getAlignmentAnnotation()[this.graphStretch].graph == 4) {
                    this.dragMode = DragMode.MatrixSelect;
                    this.firstDragX = this.mouseDragLastX;
                    this.firstDragY = this.mouseDragLastY;
                }
            }
        }
        if (this.dragMode == DragMode.Undefined) {
            return;
        }
        try {
            if (this.dragMode == DragMode.Resize) {
                int deltaY = this.mouseDragLastY - evt.getY();
                if (deltaY != 0) {
                    AlignmentAnnotation graphAnnotation = this.av.getAlignment().getAlignmentAnnotation()[this.graphStretch];
                    int newHeight = Math.max(0, graphAnnotation.graphHeight + deltaY);
                    if (this.notJustOne) {
                        for (AlignmentAnnotation similar : this.av.getAlignment().findAnnotations(null, graphAnnotation.getCalcId(), graphAnnotation.label)) {
                            similar.graphHeight = newHeight;
                        }
                    } else {
                        graphAnnotation.graphHeight = newHeight;
                    }
                    this.adjustPanelHeight();
                    this.ap.paintAlignment(false, false);
                }
            } else if (this.dragMode == DragMode.MatrixSelect) {
                this.mouseDragLastX = x;
                this.mouseDragLastY = y;
                this.ap.paintAlignment(false, false);
            } else {
                this.ap.getScalePanel().mouseDragged(evt);
            }
        }
        finally {
            this.mouseDragLastX = x;
            this.mouseDragLastY = y;
        }
    }

    public void matrixSelectRange(MouseEvent evt) {
        int fromY = Math.min(this.firstDragY, evt.getY());
        int toY = Math.max(this.firstDragY, evt.getY());
        int fromX = Math.min(this.firstDragX, evt.getX());
        int toX = Math.max(this.firstDragX, evt.getX());
        int deltaY = toY - fromY;
        int deltaX = toX - fromX;
        int[] rowIndex = AnnotationPanel.getRowIndexAndOffset(fromY, this.av.getAlignment().getAlignmentAnnotation());
        int[] toRowIndex = AnnotationPanel.getRowIndexAndOffset(toY, this.av.getAlignment().getAlignmentAnnotation());
        if (rowIndex == null || toRowIndex == null) {
            Console.trace("Drag out of range. needs to be clipped");
        }
        if (rowIndex[0] != toRowIndex[0]) {
            Console.trace("Drag went to another row. needs to be clipped");
        }
        AlignmentAnnotation cma = this.av.getAlignment().getAlignmentAnnotation()[rowIndex[0]];
        int lastX = this.getColumnForXPos(fromX);
        int currentX = this.getColumnForXPos(toX);
        int fromXc = Math.min(lastX, currentX);
        int toXc = Math.max(lastX, currentX);
        ContactListI forFromX = this.av.getContactList(cma, fromXc);
        ContactListI forToX = this.av.getContactList(cma, toXc);
        if (forFromX != null && forToX != null) {
            ContactGeometry xcgeom = new ContactGeometry(forFromX, cma.graphHeight);
            ContactGeometry.contactInterval lastXci = xcgeom.mapFor(rowIndex[1]);
            ContactGeometry.contactInterval cXci = xcgeom.mapFor(rowIndex[1] + deltaY);
            Console.trace("Matrix Selection from last(" + fromXc + ",[" + lastXci.cStart + "," + lastXci.cEnd + "]) to cur(" + toXc + ",[" + cXci.cStart + "," + cXci.cEnd + "])");
            int fr = Math.min(lastXci.cStart, cXci.cStart);
            int to = Math.max(lastXci.cEnd, cXci.cEnd);
            int[] mappedPos = forFromX.getMappedPositionsFor(fr, to);
            if (mappedPos != null) {
                Console.trace("Marking " + fr + " to " + to + " mapping to sequence positions " + mappedPos[0] + " to " + mappedPos[1]);
                for (int pair = 0; pair < mappedPos.length; pair += 2) {
                    for (int c = mappedPos[pair]; c <= mappedPos[pair + 1]; ++c) {
                        this.av.getColumnSelection().addElement(c - 1);
                    }
                }
            }
            fr = Math.min(lastX, currentX);
            to = Math.max(lastX, currentX);
            Console.trace("Marking " + fr + " to " + to);
            for (int c = fr; c <= to; ++c) {
                this.av.getColumnSelection().addElement(c);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        AlignmentAnnotation[] aa;
        int yPos = evt.getY();
        int[] rowAndOffset = AnnotationPanel.getRowIndexAndOffset(yPos, aa = this.av.getAlignment().getAlignmentAnnotation());
        int row = rowAndOffset[0];
        if (row == -1) {
            this.setToolTipText(null);
            return;
        }
        int column = this.getColumnForXPos(evt.getX());
        AlignmentAnnotation ann = aa[row];
        if (row > -1 && ann.annotations != null && column < ann.annotations.length) {
            String toolTip = AnnotationPanel.buildToolTip(ann, column, aa, rowAndOffset[1], this.av, this.ap);
            this.setToolTipText(toolTip == null ? null : JvSwingUtils.wrapTooltip(true, toolTip));
            String msg = AnnotationPanel.getStatusMessage(this.av.getAlignment(), column, ann, rowAndOffset[1], this.av);
            this.ap.alignFrame.setStatus(msg);
        } else {
            this.setToolTipText(null);
            this.ap.alignFrame.setStatus(" ");
        }
    }

    private int getColumnForXPos(int x) {
        int column = x / this.av.getCharWidth() + this.av.getRanges().getStartRes();
        column = Math.min(column, this.av.getRanges().getEndRes());
        if (this.av.hasHiddenColumns()) {
            column = this.av.getAlignment().getHiddenColumns().visibleToAbsoluteColumn(column);
        }
        return column;
    }

    static int getRowIndex(int yPos, AlignmentAnnotation[] aa) {
        if (aa == null) {
            return -1;
        }
        return AnnotationPanel.getRowIndexAndOffset(yPos, aa)[0];
    }

    static int[] getRowIndexAndOffset(int yPos, AlignmentAnnotation[] aa) {
        int[] res = new int[]{-1, 0};
        if (aa == null) {
            return res;
        }
        int row = -1;
        int height = 0;
        int lheight = 0;
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i].isForDisplay()) {
                lheight = height;
                height += aa[i].height;
            }
            if (height <= yPos) continue;
            res[0] = row = i;
            res[1] = yPos - lheight;
            break;
        }
        return res;
    }

    static String buildToolTip(AlignmentAnnotation ann, int column, AlignmentAnnotation[] anns, int rowAndOffset, AlignViewportI av, AlignmentPanel ap) {
        String tooltip = null;
        if (ann.graphGroup > -1) {
            StringBuilder tip = new StringBuilder(32);
            boolean first = true;
            for (int i = 0; i < anns.length; ++i) {
                if (anns[i].graphGroup != ann.graphGroup || anns[i].annotations[column] == null) continue;
                if (!first) {
                    tip.append("<br>");
                    first = false;
                }
                tip.append(anns[i].label);
                String description = anns[i].annotations[column].description;
                if (description == null || description.length() <= 0) continue;
                tip.append(" ").append(description);
            }
            tooltip = first ? null : tip.toString();
        } else if (column < ann.annotations.length && ann.annotations[column] != null) {
            tooltip = AnnotationPanel.getAnnotationBriefSummary(ann.annotations[column]);
        }
        if (ann.graph == 4) {
            if (rowAndOffset >= ann.graphHeight) {
                return null;
            }
            ContactListI clist = av.getContactList(ann, column);
            if (clist != null) {
                Object highlightPos;
                ContactGeometry cgeom = new ContactGeometry(clist, ann.graphHeight);
                ContactGeometry.contactInterval ci = cgeom.mapFor(rowAndOffset);
                ContactRange cr = clist.getRangeFor(ci.cStart, ci.cEnd);
                StringBuilder tooltipb = new StringBuilder();
                tooltipb.append("Contact from ").append(clist.getPosition()).append(", [").append(ci.cStart).append(" - ").append(ci.cEnd).append("]").append("<br/>Mean:");
                Format.appendPercentage(tooltipb, (float)cr.getMean(), 2);
                tooltip = tooltipb.toString();
                int col = ann.sequenceRef.findPosition(column);
                int[] mappedPos = clist.getMappedPositionsFor(ci.cStart, ci.cEnd);
                if (mappedPos != null) {
                    highlightPos = new int[1 + mappedPos.length][2];
                    highlightPos[0] = new int[]{col, col};
                    int h = 0;
                    for (int p = 0; p < mappedPos.length; p += 2) {
                        highlightPos[h][0] = ann.sequenceRef.findPosition(mappedPos[p] - 1);
                        highlightPos[h][1] = ann.sequenceRef.findPosition(mappedPos[p + 1] - 1);
                        ++h;
                    }
                } else {
                    highlightPos = new int[][]{{col, col}};
                }
                ap.getStructureSelectionManager().highlightPositionsOn(ann.sequenceRef, (int[][])highlightPos, null);
            }
        }
        return tooltip == null || tooltip.length() == 0 ? null : tooltip;
    }

    private static String getAnnotationBriefSummary(Annotation a) {
        StringBuilder ttSB = new StringBuilder();
        if (a.secondaryStructure != '\u0000' && a.secondaryStructure != ' ') {
            ttSB.append(a.secondaryStructure);
        } else if (a.description != null && a.description.trim().length() > 0) {
            ttSB.append(a.description);
        } else if (a.displayCharacter != null && a.displayCharacter.trim().length() > 0) {
            ttSB.append(a.displayCharacter);
        } else if (!Float.isNaN(a.value)) {
            if ((double)a.value == Math.floor(a.value)) {
                ttSB.append(String.format("%.0f", Float.valueOf(a.value)));
            } else {
                ttSB.append(String.valueOf(a.value));
            }
        }
        return ttSB.toString();
    }

    static String getStatusMessage(AlignmentI al, int column, AlignmentAnnotation ann, int rowAndOffset, AlignViewportI av) {
        int seqIndex;
        SequenceI seqref;
        String description;
        StringBuilder text = new StringBuilder(32);
        text.append(MessageManager.getString("label.column")).append(" ").append(column + 1);
        if (column < ann.annotations.length && ann.annotations[column] != null && (description = AnnotationPanel.getAnnotationBriefSummary(ann.annotations[column])) != null && description.trim().length() > 0) {
            text.append("  ").append(description);
        }
        if ((seqref = ann.sequenceRef) != null && (seqIndex = al.findIndex(seqref)) != -1) {
            text.append(", ").append(MessageManager.getString("label.sequence")).append(" ").append(seqIndex + 1);
            char residue = seqref.getCharAt(column);
            if (!Comparison.isGap(residue)) {
                text.append(" ");
                if (al.isNucleotide()) {
                    String name = ResidueProperties.nucleotideName.get(String.valueOf(residue));
                    text.append(" Nucleotide: ").append(name != null ? name : Character.valueOf(residue));
                } else {
                    String name = 'X' == residue ? "X" : ('*' == residue ? "STOP" : ResidueProperties.aa2Triplet.get(String.valueOf(residue)));
                    text.append(" Residue: ").append(name != null ? name : Character.valueOf(residue));
                }
                int residuePos = seqref.findPosition(column);
                text.append(" (").append(residuePos).append(")");
            }
        }
        return text.toString();
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    public void drawCursor(Graphics graphics, SequenceI seq, int res, int x1, int y1) {
        int pady = this.av.getCharHeight() / 5;
        int charOffset = 0;
        graphics.setColor(Color.black);
        graphics.fillRect(x1, y1, this.av.getCharWidth(), this.av.getCharHeight());
        if (this.av.validCharWidth) {
            graphics.setColor(Color.white);
            char s = seq.getCharAt(res);
            charOffset = (this.av.getCharWidth() - this.fm.charWidth(s)) / 2;
            graphics.drawString(String.valueOf(s), charOffset + x1, y1 + this.av.getCharHeight() - pady);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D gg;
        block14: {
            block15: {
                this.computeVisibleRect(this.visibleRect);
                g.setColor(Color.white);
                g.fillRect(0, 0, this.visibleRect.width, this.visibleRect.height);
                if (this.image == null) break block14;
                if (this.fastPaint) break block15;
                this.clipBounds = g.getClipBounds(this.clipBounds);
                if (this.visibleRect.width == this.clipBounds.width && this.visibleRect.height == this.clipBounds.height) break block14;
            }
            g.drawImage(this.image, 0, 0, this);
            this.fastPaint = false;
            return;
        }
        this.updateFadedImageWidth();
        if (this.imgWidth < 1) {
            return;
        }
        if (this.image == null || this.imgWidth != this.image.getWidth(this) || this.image.getHeight(this) != this.getHeight()) {
            boolean tried = false;
            this.image = null;
            while (this.image == null && !tried) {
                try {
                    this.image = new BufferedImage(this.imgWidth, this.ap.getAnnotationPanel().getHeight(), 1);
                    tried = true;
                }
                catch (IllegalArgumentException exc) {
                    Console.errPrintln("Serious issue with viewport geometry imgWidth requested was " + this.imgWidth);
                    return;
                }
                catch (OutOfMemoryError oom) {
                    try {
                        System.gc();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    new OOMWarning("Couldn't allocate memory to redraw screen. Please restart Jalview", oom);
                    return;
                }
            }
            gg = (Graphics2D)this.image.getGraphics();
            if (this.av.antiAlias) {
                gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            gg.setFont(this.av.getFont());
            this.fm = gg.getFontMetrics();
            gg.setColor(Color.white);
            gg.fillRect(0, 0, this.imgWidth, this.image.getHeight());
            this.imageFresh = true;
        } else {
            gg = (Graphics2D)this.image.getGraphics();
        }
        this.drawComponent(gg, this.av.getRanges().getStartRes(), this.av.getRanges().getEndRes() + 1);
        gg.dispose();
        this.imageFresh = false;
        g.drawImage(this.image, 0, 0, this);
    }

    public void updateFadedImageWidth() {
        this.imgWidth = (this.av.getRanges().getEndRes() - this.av.getRanges().getStartRes() + 1) * this.av.getCharWidth();
    }

    public void fastPaint(int horizontal) {
        if (horizontal == 0 || this.image == null || this.av.getAlignment().getAlignmentAnnotation() == null || this.av.getAlignment().getAlignmentAnnotation().length < 1 || this.av.isCalcInProgress()) {
            this.repaint();
            return;
        }
        int sr = this.av.getRanges().getStartRes();
        int er = this.av.getRanges().getEndRes() + 1;
        int transX = 0;
        Graphics2D gg = (Graphics2D)this.image.getGraphics();
        if (this.imgWidth > Math.abs(horizontal * this.av.getCharWidth())) {
            gg.copyArea(0, 0, this.imgWidth, this.getHeight(), -horizontal * this.av.getCharWidth(), 0);
            if (horizontal > 0) {
                transX = (er - sr - horizontal) * this.av.getCharWidth();
                sr = er - horizontal;
            } else if (horizontal < 0) {
                er = sr - horizontal;
            }
        }
        gg.translate(transX, 0);
        this.drawComponent(gg, sr, er);
        gg.translate(-transX, 0);
        gg.dispose();
        this.fastPaint = true;
        this.av.getAlignPanel().repaint();
    }

    public void drawComponent(Graphics g, int startRes, int endRes) {
        BufferedImage oldFaded = this.fadedImage;
        if (this.av.isCalcInProgress()) {
            if (this.image == null) {
                this.lastImageGood = false;
                return;
            }
            if (this.lastImageGood && (this.fadedImage == null || this.fadedImage.getWidth() != this.imgWidth || this.fadedImage.getHeight() != this.image.getHeight())) {
                this.fadedImage = new BufferedImage(this.imgWidth, this.image.getHeight(), 1);
                Graphics2D fadedG = (Graphics2D)this.fadedImage.getGraphics();
                fadedG.setColor(Color.white);
                fadedG.fillRect(0, 0, this.imgWidth, this.image.getHeight());
                fadedG.setComposite(AlphaComposite.getInstance(3, 0.3f));
                fadedG.drawImage((Image)this.image, 0, 0, this);
            }
            this.lastImageGood = false;
        } else {
            if (this.fadedImage != null) {
                oldFaded = this.fadedImage;
            }
            this.fadedImage = null;
        }
        g.setColor(Color.white);
        g.fillRect(0, 0, (endRes - startRes) * this.av.getCharWidth(), this.getHeight());
        g.setFont(this.av.getFont());
        if (this.fm == null) {
            this.fm = g.getFontMetrics();
        }
        if (this.av.getAlignment().getAlignmentAnnotation() == null || this.av.getAlignment().getAlignmentAnnotation().length < 1) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.black);
            if (this.av.validCharWidth) {
                g.drawString(MessageManager.getString("label.alignment_has_no_annotations"), 20, 15);
            }
            return;
        }
        this.lastImageGood = this.renderer.drawComponent(this, this.av, g, this.activeRow, startRes, endRes);
        if (!this.lastImageGood && this.fadedImage == null) {
            this.fadedImage = oldFaded;
        }
        if (this.dragMode == DragMode.MatrixSelect) {
            g.setColor(Color.yellow);
            g.drawRect(Math.min(this.firstDragX, this.mouseDragLastX), Math.min(this.firstDragY, this.mouseDragLastY), Math.max(this.firstDragX, this.mouseDragLastX) - Math.min(this.firstDragX, this.mouseDragLastX), Math.max(this.firstDragY, this.mouseDragLastY) - Math.min(this.firstDragY, this.mouseDragLastY));
        }
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.fm;
    }

    @Override
    public Image getFadedImage() {
        return this.fadedImage;
    }

    @Override
    public int getFadedImageWidth() {
        this.updateFadedImageWidth();
        return this.imgWidth;
    }

    @Override
    public int[] getVisibleVRange() {
        if (this.ap != null && this.ap.getAlabels() != null) {
            int sOffset = -this.ap.getAlabels().getScrollOffset();
            int visHeight = sOffset + this.ap.annotationSpaceFillerHolder.getHeight();
            this.bounds[0] = sOffset;
            this.bounds[1] = visHeight;
            return this.bounds;
        }
        return null;
    }

    public void dispose() {
        this.av = null;
        this.ap = null;
        this.image = null;
        this.fadedImage = null;
        this._mwl = null;
        if (this.renderer != null) {
            this.renderer.dispose();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("startres")) {
            this.fastPaint((Integer)evt.getNewValue() - (Integer)evt.getOldValue());
        } else if (evt.getPropertyName().equals("startresandseq")) {
            this.fastPaint(((int[])evt.getNewValue())[0] - ((int[])evt.getOldValue())[0]);
        } else if (evt.getPropertyName().equals("move_viewport")) {
            this.repaint();
        }
    }

    public int adjustForAlignFrame(boolean adjustPanelHeight, int annotationHeight) {
        int stuff = (this.ap.getViewName() != null ? 30 : 0) + (Platform.isAMacAndNotJS() ? 120 : 140);
        int availableHeight = this.ap.alignFrame.getHeight() - stuff;
        int rowHeight = this.av.getCharHeight();
        if (adjustPanelHeight) {
            int alignmentHeight = rowHeight * this.av.getAlignment().getHeight();
            if (annotationHeight + alignmentHeight > availableHeight) {
                annotationHeight = Math.min(annotationHeight, availableHeight - 2 * rowHeight);
            }
        } else {
            annotationHeight = Math.min(this.ap.annotationScroller.getSize().height, availableHeight - 2 * rowHeight);
        }
        return annotationHeight;
    }

    static enum DragMode {
        Select,
        Resize,
        Undefined,
        MatrixSelect;

    }
}

