/*
 * Decompiled with CFR 0.152.
 */
package jalview.fts.service.uniprot;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.fts.api.FTSData;
import jalview.fts.api.FTSDataColumnI;
import jalview.fts.core.FTSRestClient;
import jalview.fts.core.FTSRestRequest;
import jalview.fts.core.FTSRestResponse;
import jalview.javascript.web.Client;
import jalview.util.ChannelProperties;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class UniProtFTSRestClient
extends FTSRestClient {
    private static final String DEFAULT_UNIPROT_DOMAIN = "https://rest.uniprot.org";
    private static final String USER_AGENT = ChannelProperties.getProperty("app_name", "Jalview") + " " + Cache.getDefault("VERSION", "Unknown") + " " + UniProtFTSRestClient.class.toString() + " help@jalview.org";
    private static UniProtFTSRestClient instance;
    public final String uniprotSearchEndpoint;
    private ArrayList<String> cursors;
    private int cursorPage = 0;

    public UniProtFTSRestClient() {
        this.clearCursors();
        this.uniprotSearchEndpoint = Cache.getDefault("UNIPROT_2022_DOMAIN", DEFAULT_UNIPROT_DOMAIN) + "/uniprotkb/search";
    }

    @Override
    public FTSRestResponse executeRequest(FTSRestRequest uniprotRestRequest) throws Exception {
        return this.executeRequest(uniprotRestRequest, null);
    }

    public FTSRestResponse executeRequest(FTSRestRequest uniprotRestRequest, String cursor) throws Exception {
        try {
            String temp;
            String linkHeader;
            Class clientResponseClass;
            com.sun.jersey.api.client.Client client;
            String query;
            String wantedFields = this.getDataColumnsFieldsAsCommaDelimitedString(uniprotRestRequest.getWantedFields());
            int responseSize = uniprotRestRequest.getResponseSize() == 0 ? this.getDefaultResponsePageSize() : uniprotRestRequest.getResponseSize();
            int offSet = uniprotRestRequest.getOffSet();
            if (this.isAdvancedQuery(uniprotRestRequest.getSearchTerm())) {
                query = uniprotRestRequest.getSearchTerm();
            } else {
                String string = query = uniprotRestRequest.getFieldToSearchBy().equalsIgnoreCase("Search All") ? uniprotRestRequest.getSearchTerm() : uniprotRestRequest.getFieldToSearchBy() + ":" + uniprotRestRequest.getSearchTerm();
            }
            if (Platform.isJS()) {
                client = (com.sun.jersey.api.client.Client)new Client();
                clientResponseClass = jalview.javascript.web.ClientResponse.class;
            } else {
                client = com.sun.jersey.api.client.Client.create((ClientConfig)new DefaultClientConfig());
                clientResponseClass = ClientResponse.class;
            }
            WebResource webResource = null;
            webResource = client.resource(this.uniprotSearchEndpoint).queryParam("format", "tsv").queryParam("fields", wantedFields).queryParam("size", String.valueOf(responseSize)).queryParam("query", query);
            if (offSet != 0 && cursor != null && cursor.length() > 0) {
                webResource = webResource.queryParam("cursor", cursor);
            }
            Console.debug("Uniprot FTS Request: " + webResource.getURI().toString());
            WebResource.Builder wrBuilder = webResource.accept(new String[]{"text/plain"});
            if (!Platform.isJS()) {
                wrBuilder.header("User-Agent", (Object)USER_AGENT);
            }
            ClientResponse clientResponse = (ClientResponse)wrBuilder.get(clientResponseClass);
            if (!Platform.isJS() && clientResponse.getHeaders().containsKey((Object)"Link") && (linkHeader = (String)((List)clientResponse.getHeaders().get((Object)"Link")).get(0)).indexOf("<") > -1 && (temp = linkHeader.substring(linkHeader.indexOf("<") + 1)).indexOf(">") > -1) {
                String nextUrl = temp.substring(0, temp.indexOf(">"));
                String nextCursor = UniProtFTSRestClient.getQueryParam("cursor", nextUrl);
                this.setCursor(this.cursorPage + 1, nextCursor);
            }
            String uniProtTabDelimittedResponseString = (String)clientResponse.getEntity(String.class);
            if (clientResponse.getStatus() != 200) {
                String errorMessage = UniProtFTSRestClient.getMessageByHTTPStatusCode(clientResponse.getStatus(), "Uniprot");
                throw new Exception(errorMessage);
            }
            int xTotalResults = 0;
            if (Platform.isJS()) {
                xTotalResults = 1;
            } else {
                List resultsHeaders = (List)clientResponse.getHeaders().get((Object)"X-Total-Results");
                if (resultsHeaders != null && resultsHeaders.size() >= 1) {
                    xTotalResults = Integer.valueOf((String)resultsHeaders.get(0));
                }
            }
            clientResponse = null;
            client = null;
            return this.parseUniprotResponse(uniProtTabDelimittedResponseString, uniprotRestRequest, xTotalResults);
        }
        catch (Exception e) {
            Console.warn("Problem with the query: " + e.getMessage());
            Console.debug("Exception stacktrace:", e);
            String exceptionMsg = e.getMessage();
            if (exceptionMsg.contains("SocketException")) {
                throw new Exception(MessageManager.getString("exception.unable_to_detect_internet_connection"));
            }
            if (exceptionMsg.contains("UnknownHostException")) {
                throw new Exception(MessageManager.formatMessage("exception.fts_server_unreachable", "Uniprot"));
            }
            throw e;
        }
    }

    public boolean isAdvancedQuery(String query) {
        return query.contains(" AND ") || query.contains(" OR ") || query.contains(" NOT ") || query.contains(" ! ") || query.contains(" || ") || query.contains(" && ") || query.contains(":") || query.contains("-");
    }

    public FTSRestResponse parseUniprotResponse(String uniProtTabDelimittedResponseString, FTSRestRequest uniprotRestRequest, int xTotalResults) {
        FTSRestResponse searchResult = new FTSRestResponse();
        ArrayList<FTSData> result = null;
        if (uniProtTabDelimittedResponseString == null || uniProtTabDelimittedResponseString.trim().isEmpty()) {
            searchResult.setNumberOfItemsFound(0);
            return searchResult;
        }
        String[] foundDataRow = uniProtTabDelimittedResponseString.split("\n");
        if (foundDataRow != null && foundDataRow.length > 0) {
            result = new ArrayList<FTSData>();
            boolean firstRow = true;
            for (String dataRow : foundDataRow) {
                if (firstRow) {
                    firstRow = false;
                    continue;
                }
                result.add(UniProtFTSRestClient.getFTSData(dataRow, uniprotRestRequest));
            }
            searchResult.setNumberOfItemsFound(xTotalResults);
            searchResult.setSearchSummary(result);
        }
        return searchResult;
    }

    public static FTSData getFTSData(String tabDelimittedDataStr, FTSRestRequest request) {
        String primaryKey = null;
        Collection<FTSDataColumnI> diplayFields = request.getWantedFields();
        int colCounter = 0;
        Object[] summaryRowData = new Object[diplayFields.size()];
        String[] columns = tabDelimittedDataStr.split("\t");
        for (FTSDataColumnI field : diplayFields) {
            try {
                String fieldData = columns[colCounter];
                if (field.isPrimaryKeyColumn()) {
                    primaryKey = fieldData;
                    summaryRowData[colCounter++] = primaryKey;
                    continue;
                }
                if (fieldData == null || fieldData.isEmpty()) {
                    summaryRowData[colCounter++] = null;
                    continue;
                }
                try {
                    summaryRowData[colCounter++] = field.getDataType().getDataTypeClass() == Integer.class ? Integer.valueOf(fieldData.replace(",", "")) : (field.getDataType().getDataTypeClass() == Double.class ? Double.valueOf(fieldData) : fieldData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Console.outPrintln("offending value:" + fieldData);
                }
            }
            catch (Exception exception) {}
        }
        final String primaryKey1 = primaryKey;
        final Object[] summaryRowData1 = summaryRowData;
        return new FTSData(){

            @Override
            public Object[] getSummaryData() {
                return summaryRowData1;
            }

            @Override
            public Object getPrimaryKey() {
                return primaryKey1;
            }

            public String toString() {
                StringBuilder summaryFieldValues = new StringBuilder();
                for (Object summaryField : summaryRowData1) {
                    summaryFieldValues.append(summaryField == null ? " " : summaryField.toString()).append("\t");
                }
                return summaryFieldValues.toString();
            }

            public int hashCode() {
                return Objects.hash(primaryKey1, this.toString());
            }

            public boolean equals(Object that) {
                return this.toString().equals(that.toString());
            }
        };
    }

    public static UniProtFTSRestClient getInstance() {
        if (instance == null) {
            instance = new UniProtFTSRestClient();
        }
        return instance;
    }

    @Override
    public String getColumnDataConfigFileName() {
        return "/fts/uniprot_data_columns-2022.txt";
    }

    protected int getCursorPage() {
        return this.cursorPage;
    }

    protected void setCursorPage(int i) {
        this.cursorPage = i;
    }

    protected void setPrevCursorPage() {
        if (this.cursorPage > 0) {
            --this.cursorPage;
        }
    }

    protected void setNextCursorPage() {
        ++this.cursorPage;
    }

    protected void clearCursors() {
        this.cursors = new ArrayList(10);
    }

    protected String getCursor(int i) {
        return this.cursors.get(i);
    }

    protected String getNextCursor() {
        if (this.cursors.size() < this.cursorPage + 2) {
            return null;
        }
        return this.cursors.get(this.cursorPage + 1);
    }

    protected String getPrevCursor() {
        if (this.cursorPage == 0) {
            return null;
        }
        return this.cursors.get(this.cursorPage - 1);
    }

    protected void setCursor(int i, String c) {
        this.cursors.ensureCapacity(i + 1);
        while (this.cursors.size() <= i) {
            this.cursors.add(null);
        }
        this.cursors.set(i, c);
        Console.debug("Set UniprotFRSRestClient cursors[" + i + "] to '" + c + "'");
    }

    public static String getQueryParam(String param, String u) {
        if (param == null || u == null) {
            return null;
        }
        try {
            URL url = new URL(u);
            String[] kevs = url.getQuery().split("&");
            for (int j = 0; j < kevs.length; ++j) {
                String[] kev = kevs[j].split("=", 2);
                if (!param.equals(kev[0])) continue;
                return kev[1];
            }
        }
        catch (MalformedURLException e) {
            Console.warn("Could not obtain next page 'cursor' value from 'u");
        }
        return null;
    }

    static {
        Platform.addJ2SDirectDatabaseCall(DEFAULT_UNIPROT_DOMAIN);
        instance = null;
    }
}

