/*
 * Decompiled with CFR 0.152.
 */
package jalview.fts.core;

import jalview.fts.api.FTSDataColumnI;
import jalview.fts.api.FTSRestClientI;
import jalview.fts.api.StructureFTSRestClientI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class FTSDataColumnPreferences
extends JScrollPane {
    protected JTable tbl_FTSDataColumnPrefs = new JTable();
    protected JScrollPane scrl_pdbDocFieldConfig = new JScrollPane(this.tbl_FTSDataColumnPrefs);
    private HashMap<String, FTSDataColumnI> map = new HashMap();
    private Collection<FTSDataColumnI> structSummaryColumns = new LinkedHashSet<FTSDataColumnI>();
    private Collection<FTSDataColumnI> allFTSDataColumns = new LinkedHashSet<FTSDataColumnI>();
    private PreferenceSource currentSource;
    private FTSRestClientI ftsRestClient;

    public FTSDataColumnPreferences(PreferenceSource source, FTSRestClientI ftsRestClient) {
        this.ftsRestClient = ftsRestClient;
        if (source.equals((Object)PreferenceSource.STRUCTURE_CHOOSER) || source.equals((Object)PreferenceSource.PREFERENCES)) {
            this.structSummaryColumns = ((StructureFTSRestClientI)((Object)ftsRestClient)).getAllDefaultDisplayedStructureDataColumns();
        }
        this.allFTSDataColumns.addAll(ftsRestClient.getAllFTSDataColumns());
        this.tbl_FTSDataColumnPrefs.setAutoCreateRowSorter(true);
        this.getViewport().add(this.tbl_FTSDataColumnPrefs);
        this.currentSource = source;
        String[] columnNames = ftsRestClient.getPreferencesColumnsFor(source);
        Object[][] data = new Object[this.allFTSDataColumns.size()][3];
        int x = 0;
        for (FTSDataColumnI field : this.allFTSDataColumns) {
            if (field.getName().equalsIgnoreCase("all")) continue;
            switch (source) {
                case SEARCH_SUMMARY: {
                    data[x++] = new Object[]{ftsRestClient.getAllDefaultDisplayedFTSDataColumns().contains(field), field.getName(), field.getGroup()};
                    break;
                }
                case STRUCTURE_CHOOSER: {
                    data[x++] = new Object[]{this.structSummaryColumns.contains(field), field.getName(), field.getGroup()};
                    break;
                }
                case PREFERENCES: {
                    data[x++] = new Object[]{field.getName(), ftsRestClient.getAllDefaultDisplayedFTSDataColumns().contains(field), this.structSummaryColumns.contains(field)};
                    break;
                }
            }
            this.map.put(field.getName(), field);
        }
        FTSDataColumnPrefsTableModel model = new FTSDataColumnPrefsTableModel(columnNames, data);
        this.tbl_FTSDataColumnPrefs.setModel(model);
        switch (source) {
            case SEARCH_SUMMARY: 
            case STRUCTURE_CHOOSER: {
                this.tbl_FTSDataColumnPrefs.getColumnModel().getColumn(0).setPreferredWidth(30);
                this.tbl_FTSDataColumnPrefs.getColumnModel().getColumn(0).setMinWidth(20);
                this.tbl_FTSDataColumnPrefs.getColumnModel().getColumn(0).setMaxWidth(40);
                this.tbl_FTSDataColumnPrefs.getColumnModel().getColumn(1).setPreferredWidth(150);
                this.tbl_FTSDataColumnPrefs.getColumnModel().getColumn(1).setMinWidth(150);
                this.tbl_FTSDataColumnPrefs.getColumnModel().getColumn(2).setPreferredWidth(150);
                this.tbl_FTSDataColumnPrefs.getColumnModel().getColumn(2).setMinWidth(150);
                TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.tbl_FTSDataColumnPrefs.getModel());
                this.tbl_FTSDataColumnPrefs.setRowSorter(sorter);
                ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
                int columnIndexToSort = 2;
                sortKeys.add(new RowSorter.SortKey(columnIndexToSort, SortOrder.ASCENDING));
                sorter.setComparator(columnIndexToSort, new Comparator<FTSDataColumnI.FTSDataColumnGroupI>(){

                    @Override
                    public int compare(FTSDataColumnI.FTSDataColumnGroupI o1, FTSDataColumnI.FTSDataColumnGroupI o2) {
                        return o1.getSortOrder() - o2.getSortOrder();
                    }
                });
                sorter.setSortKeys(sortKeys);
                this.tbl_FTSDataColumnPrefs.setAutoResizeMode(1);
                break;
            }
        }
    }

    public Collection<FTSDataColumnI> getStructureSummaryFields() {
        return this.structSummaryColumns;
    }

    class FTSDataColumnPrefsTableModel
    extends AbstractTableModel {
        private Object[][] data;
        private String[] columnNames;

        public FTSDataColumnPrefsTableModel(String[] columnNames, Object[][] data) {
            this.data = data;
            this.columnNames = columnNames;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (FTSDataColumnPreferences.this.currentSource) {
                case SEARCH_SUMMARY: 
                case STRUCTURE_CHOOSER: {
                    return col == 0 && !this.isPrimaryKeyCell(row, 1);
                }
                case PREFERENCES: {
                    return (col == 1 || col == 2) && !this.isPrimaryKeyCell(row, 0);
                }
            }
            return false;
        }

        public boolean isPrimaryKeyCell(int row, int col) {
            String name = this.getValueAt(row, col).toString();
            FTSDataColumnI pdbField = (FTSDataColumnI)FTSDataColumnPreferences.this.map.get(name);
            return pdbField.isPrimaryKeyColumn();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            this.data[row][col] = value;
            this.fireTableCellUpdated(row, col);
            String name = null;
            switch (FTSDataColumnPreferences.this.currentSource) {
                case SEARCH_SUMMARY: 
                case STRUCTURE_CHOOSER: {
                    name = this.getValueAt(row, 1).toString();
                    break;
                }
                case PREFERENCES: {
                    name = this.getValueAt(row, 0).toString();
                    break;
                }
            }
            boolean selected = (Boolean)value;
            FTSDataColumnI ftsDataColumn = (FTSDataColumnI)FTSDataColumnPreferences.this.map.get(name);
            if (FTSDataColumnPreferences.this.currentSource == PreferenceSource.SEARCH_SUMMARY) {
                this.updatePrefs(FTSDataColumnPreferences.this.ftsRestClient.getAllDefaultDisplayedFTSDataColumns(), ftsDataColumn, selected);
            } else if (FTSDataColumnPreferences.this.currentSource == PreferenceSource.STRUCTURE_CHOOSER) {
                this.updatePrefs(FTSDataColumnPreferences.this.structSummaryColumns, ftsDataColumn, selected);
            } else if (FTSDataColumnPreferences.this.currentSource == PreferenceSource.PREFERENCES) {
                if (col == 1) {
                    this.updatePrefs(FTSDataColumnPreferences.this.ftsRestClient.getAllDefaultDisplayedFTSDataColumns(), ftsDataColumn, selected);
                } else if (col == 2) {
                    this.updatePrefs(FTSDataColumnPreferences.this.structSummaryColumns, ftsDataColumn, selected);
                }
            }
        }

        private void updatePrefs(Collection<FTSDataColumnI> prefConfig, FTSDataColumnI dataColumn, boolean selected) {
            if (prefConfig.contains(dataColumn) && !selected) {
                prefConfig.remove(dataColumn);
            }
            if (!prefConfig.contains(dataColumn) && selected) {
                prefConfig.add(dataColumn);
            }
        }
    }

    public static enum PreferenceSource {
        SEARCH_SUMMARY,
        STRUCTURE_CHOOSER,
        PREFERENCES;

    }
}

