/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.pymol;

import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.structure.StructureCommandI;
import jalview.util.HttpUtils;
import jalview.util.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class PymolManager {
    private static final int RPC_REPLY_TIMEOUT_MS = 15000;
    private static final int CONNECTION_TIMEOUT_MS = 100;
    private static final String POST1 = "<methodCall><methodName>";
    private static final String POST2 = "</methodName><params>";
    private static final String POST3 = "</params></methodCall>";
    private Process pymolProcess;
    private int pymolXmlRpcPort;

    public static List<String> getPymolPaths() {
        return PymolManager.getPymolPaths(System.getProperty("os.name"));
    }

    protected static List<String> getPymolPaths(String os) {
        ArrayList<String> pathList = new ArrayList<String>();
        String userPath = Cache.getDefault("PYMOL_PATH", null);
        if (userPath != null) {
            pathList.add(userPath);
        }
        String pymol = "PyMOL";
        if (os.startsWith("Linux")) {
            pathList.add("/usr/local/pymol/bin/" + pymol);
            pathList.add("/usr/local/bin/" + pymol);
            pathList.add("/usr/bin/" + pymol);
            pathList.add(System.getProperty("user.home") + "/opt/bin/" + pymol);
        } else if (os.startsWith("Windows")) {
            for (String root : new String[]{String.format("%s\\AppData\\Local", System.getProperty("user.home")), "\\ProgramData", "C:\\ProgramData", System.getProperty("user.home"), "\\Program Files", "C:\\Program Files", "\\Program Files (x86)", "C:\\Program Files (x86)"}) {
                for (String path : new String[]{"Schrodinger\\PyMOL2", "PyMOL"}) {
                    for (String binary : new String[]{"PyMOLWinWithConsole.bat", "Scripts\\pymol.exe", "PyMOLWin.exe"}) {
                        pathList.add(String.format("%s\\%s\\%s", root, path, binary));
                    }
                }
            }
        } else if (os.startsWith("Mac")) {
            pathList.add("/Applications/PyMOL.app/Contents/MacOS/" + pymol);
        }
        return pathList;
    }

    public boolean isPymolLaunched() {
        boolean launched = false;
        if (this.pymolProcess != null) {
            try {
                this.pymolProcess.exitValue();
            }
            catch (IllegalThreadStateException e) {
                launched = true;
            }
        }
        return launched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> sendCommand(StructureCommandI command, boolean getReply) {
        String postBody = PymolManager.getPostRequest(command);
        String rpcUrl = "http://127.0.0.1:" + this.pymolXmlRpcPort;
        PrintWriter out = null;
        BufferedReader in = null;
        ArrayList<String> result = getReply ? new ArrayList<String>() : null;
        try {
            URL realUrl = new URL(rpcUrl);
            HttpURLConnection conn = (HttpURLConnection)HttpUtils.openConnection(realUrl);
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("content-type", "text/xml");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(postBody);
            out.flush();
            int rc = conn.getResponseCode();
            if (rc != 200) {
                Console.error(String.format("Error status from %s: %d", rpcUrl, rc));
                ArrayList<String> arrayList = result;
                return arrayList;
            }
            InputStream inputStream = conn.getInputStream();
            if (getReply) {
                String line;
                in = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = in.readLine()) != null) {
                    result.add(line);
                }
            }
        }
        catch (SocketException e) {
            Console.warn(String.format("Request to %s returned %s", rpcUrl, e.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (Console.isTraceEnabled()) {
                Console.trace("Sent: " + command.toString());
                if (result != null) {
                    Console.trace("Received: " + result);
                }
            }
        }
        return result;
    }

    static String getPostRequest(StructureCommandI command) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(POST1).append(command.getCommand()).append(POST2);
        if (command.hasParameters()) {
            for (String p : command.getParameters()) {
                sb.append("<parameter><value>").append(p).append("</value></parameter>");
            }
        }
        sb.append(POST3);
        return sb.toString();
    }

    public Process launchPymol() {
        if (this.isPymolLaunched()) {
            return this.pymolProcess;
        }
        String error = "Error message: ";
        for (String pymolPath : PymolManager.getPymolPaths()) {
            try {
                pymolPath = Paths.get(pymolPath, new String[0]).toRealPath(new LinkOption[0]).toString();
                File path = new File(pymolPath);
                if (!path.canExecute()) {
                    error = error + "File '" + path + "' does not exist.\n";
                    continue;
                }
                ArrayList<String> args = new ArrayList<String>();
                args.add(pymolPath);
                if (Platform.isWin() && pymolPath.toLowerCase(Locale.ROOT).endsWith("\\pymolwin.exe")) {
                    args.add("+2");
                }
                args.add("-R");
                ProcessBuilder pb = new ProcessBuilder(args);
                Console.debug("Running PyMOL as " + String.join((CharSequence)" ", pb.command()));
                this.pymolProcess = pb.start();
                error = "";
                break;
            }
            catch (Exception e) {
                error = error + e.getMessage();
            }
        }
        if (this.pymolProcess != null) {
            this.pymolXmlRpcPort = this.getPortNumber();
            if (this.pymolXmlRpcPort > 0) {
                Console.info("PyMOL XMLRPC started on port " + this.pymolXmlRpcPort);
            } else {
                error = error + "Failed to read PyMOL XMLRPC port number";
                Console.error(error);
                this.pymolProcess.destroy();
                this.pymolProcess = null;
            }
        }
        return this.pymolProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPortNumber() {
        int port = 0;
        InputStream readChan = this.pymolProcess.getInputStream();
        BufferedReader lineReader = new BufferedReader(new InputStreamReader(readChan));
        StringBuilder responses = new StringBuilder();
        try {
            String response = lineReader.readLine();
            while (response != null) {
                responses.append("\n" + response);
                if (response.contains("xml-rpc")) {
                    String[] tokens = response.split(" ");
                    for (int i = 0; i < tokens.length - 1; ++i) {
                        if (!"port".equals(tokens[i])) continue;
                        port = Integer.parseInt(tokens[i + 1]);
                        break;
                    }
                }
                if (port > 0) {
                    break;
                }
                response = lineReader.readLine();
            }
        }
        catch (Exception e) {
            Console.error("Failed to get REST port number from " + responses + ": " + e.getMessage());
        }
        finally {
            try {
                lineReader.close();
            }
            catch (IOException iOException) {}
        }
        if (port == 0) {
            Console.error("Failed to start PyMOL with XMLRPC, response was: " + responses);
        }
        Console.info("PyMOL started with XMLRPC on port " + port);
        return port;
    }
}

