/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.bin.Console;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HiddenSequences {
    public SequenceI[] hiddenSequences;
    AlignmentI alignment;

    public HiddenSequences(AlignmentI al) {
        this.alignment = al;
    }

    public int getSize() {
        if (this.hiddenSequences == null) {
            return 0;
        }
        int count = 0;
        for (SequenceI seq : this.hiddenSequences) {
            if (seq == null) continue;
            ++count;
        }
        return count;
    }

    public int getWidth() {
        if (this.hiddenSequences == null) {
            return 0;
        }
        int width = 0;
        for (SequenceI seq : this.hiddenSequences) {
            if (seq == null || seq.getLength() <= width) continue;
            width = seq.getLength();
        }
        return width;
    }

    public void adjustHeightSequenceDeleted(int seqIndex) {
        if (this.hiddenSequences == null) {
            return;
        }
        int alHeight = this.alignment.getHeight();
        SequenceI[] tmp = new SequenceI[alHeight + this.getSize()];
        int deletionIndex = this.adjustForHiddenSeqs(seqIndex);
        for (int i = 0; i < this.hiddenSequences.length; ++i) {
            if (this.hiddenSequences[i] == null) continue;
            if (i > deletionIndex) {
                tmp[i - 1] = this.hiddenSequences[i];
                continue;
            }
            tmp[i] = this.hiddenSequences[i];
        }
        this.hiddenSequences = tmp;
    }

    public void adjustHeightSequenceAdded() {
        if (this.hiddenSequences == null) {
            return;
        }
        int alHeight = this.alignment.getHeight();
        SequenceI[] tmp = new SequenceI[alHeight + this.getSize()];
        System.arraycopy(this.hiddenSequences, 0, tmp, 0, this.hiddenSequences.length);
        this.hiddenSequences = tmp;
    }

    public void hideSequence(SequenceI sequence) {
        int absAlignmentIndex;
        int alignmentIndex;
        if (this.hiddenSequences == null) {
            this.hiddenSequences = new SequenceI[this.alignment.getHeight()];
        }
        if ((alignmentIndex = this.adjustForHiddenSeqs(absAlignmentIndex = this.alignment.findIndex(sequence))) < 0 || this.hiddenSequences[alignmentIndex] != null) {
            Console.outPrintln("ERROR!!!!!!!!!!!");
            return;
        }
        this.hiddenSequences[alignmentIndex] = sequence;
        this.alignment.deleteHiddenSequence(absAlignmentIndex);
    }

    public List<SequenceI> showAll(Map<SequenceI, SequenceCollectionI> hiddenRepSequences) {
        ArrayList<SequenceI> revealedSeqs = new ArrayList<SequenceI>();
        if (this.hiddenSequences == null) {
            return revealedSeqs;
        }
        for (int i = 0; i < this.hiddenSequences.length; ++i) {
            if (this.hiddenSequences[i] == null) continue;
            List<SequenceI> tmp = this.showSequence(i, hiddenRepSequences);
            for (SequenceI seq : tmp) {
                revealedSeqs.add(seq);
            }
        }
        return revealedSeqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SequenceI> showSequence(int alignmentIndex, Map<SequenceI, SequenceCollectionI> hiddenRepSequences) {
        List<SequenceI> asequences;
        ArrayList<SequenceI> revealedSeqs = new ArrayList<SequenceI>();
        SequenceI repSequence = this.alignment.getSequenceAt(alignmentIndex);
        if (repSequence != null && hiddenRepSequences != null && hiddenRepSequences.containsKey(repSequence)) {
            hiddenRepSequences.remove(repSequence);
            revealedSeqs.add(repSequence);
        }
        int start = this.adjustForHiddenSeqs(alignmentIndex - 1);
        int end = this.adjustForHiddenSeqs(alignmentIndex);
        if (end >= this.hiddenSequences.length) {
            end = this.hiddenSequences.length - 1;
        }
        List<SequenceI> list = asequences = this.alignment.getSequences();
        synchronized (list) {
            for (int index = end; index > start; --index) {
                SequenceI seq = this.hiddenSequences[index];
                this.hiddenSequences[index] = null;
                if (seq == null) continue;
                if (seq.getLength() > 0) {
                    revealedSeqs.add(seq);
                    asequences.add(alignmentIndex, seq);
                    continue;
                }
                Console.outPrintln(seq.getName() + " has been deleted whilst hidden");
            }
        }
        return revealedSeqs;
    }

    public SequenceI getHiddenSequence(int alignmentIndex) {
        return this.hiddenSequences == null ? null : this.hiddenSequences[alignmentIndex];
    }

    public int findIndexWithoutHiddenSeqs(int alignmentIndex) {
        if (this.hiddenSequences == null) {
            return alignmentIndex;
        }
        int index = 0;
        int hiddenSeqs = 0;
        int diff = 0;
        if (this.hiddenSequences.length <= alignmentIndex) {
            diff = alignmentIndex - this.hiddenSequences.length + 1;
            alignmentIndex = this.hiddenSequences.length - 1;
        }
        while (index <= alignmentIndex) {
            if (this.hiddenSequences[index] != null) {
                ++hiddenSeqs;
            }
            ++index;
        }
        return alignmentIndex - hiddenSeqs + diff;
    }

    public int subtractVisibleRows(int visibleDistance, int startRow) {
        int index;
        if (this.hiddenSequences == null) {
            return startRow - visibleDistance;
        }
        int count = 0;
        for (index = Math.min(startRow, this.hiddenSequences.length - 1); index > -1 && count < visibleDistance; --index) {
            if (this.hiddenSequences[index] != null) continue;
            ++count;
        }
        return index;
    }

    public int adjustForHiddenSeqs(int alignmentIndex) {
        if (this.hiddenSequences == null) {
            return alignmentIndex;
        }
        int hSize = this.hiddenSequences.length;
        for (int index = 0; index <= alignmentIndex && index < hSize; ++index) {
            if (this.hiddenSequences[index] == null) continue;
            ++alignmentIndex;
        }
        return alignmentIndex;
    }

    public AlignmentI getFullAlignment() {
        SequenceI[] seq;
        if (this.hiddenSequences == null) {
            seq = this.alignment.getSequencesArray();
        } else {
            int isize = this.hiddenSequences.length;
            seq = new Sequence[isize];
            int index = 0;
            for (int i = 0; i < this.hiddenSequences.length; ++i) {
                if (this.hiddenSequences[i] != null) {
                    seq[i] = this.hiddenSequences[i];
                    continue;
                }
                seq[i] = this.alignment.getSequenceAt(index);
                ++index;
            }
        }
        Alignment fAlignmt = new Alignment(seq);
        fAlignmt.annotations = this.alignment.getAlignmentAnnotation();
        fAlignmt.alignmentProperties = this.alignment.getProperties();
        fAlignmt.groups = this.alignment.getGroups();
        fAlignmt.hasRNAStructure = this.alignment.hasRNAStructure();
        fAlignmt.setSeqrep(this.alignment.getSeqrep());
        return fAlignmt;
    }

    public boolean isHidden(SequenceI seq) {
        if (this.hiddenSequences != null) {
            for (int i = 0; i < this.hiddenSequences.length; ++i) {
                if (this.hiddenSequences[i] == null || this.hiddenSequences[i] != seq) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isHidden(int seq) {
        if (this.hiddenSequences != null) {
            return this.hiddenSequences[seq] != null;
        }
        return false;
    }
}

