/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.bin.Console;
import jalview.datamodel.ContactListI;
import jalview.datamodel.ContactListImpl;
import jalview.datamodel.ContactListProviderI;
import jalview.datamodel.ContactMatrixI;
import jalview.datamodel.GroupSetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class ContactMatrix
extends GroupSetHolder
implements ContactMatrixI {
    boolean symmetric = true;
    List<List<Float>> contacts = null;
    int width = 0;
    int numcontacts = 0;
    float min = 0.0f;
    float max = 0.0f;

    public ContactMatrix(boolean symmetric) {
        this.symmetric = symmetric;
    }

    public void addContact(int left, int right, float strength) {
        List<Float> clist;
        if (left < 0 || right < 0) {
            throw new Error(new RuntimeException("Cannot have negative indices for contact left=" + left + " right=" + right + " strength=" + strength));
        }
        if (this.symmetric && left > right) {
            int r = right;
            right = left;
            left = r;
        }
        if (this.contacts == null) {
            this.contacts = new ArrayList<List<Float>>();
        }
        if ((clist = this.contacts.get(left)) == null) {
            clist = new ArrayList<Float>();
            this.contacts.set(left, clist);
        }
        Float last = clist.set(right, Float.valueOf(strength));
        this.checkBounds(strength);
        if (last == null) {
            ++this.numcontacts;
        }
    }

    private void checkBounds(float strength) {
        if (this.min > strength) {
            this.min = strength;
        }
        if (this.max < strength) {
            this.max = strength;
        }
    }

    @Override
    public ContactListI getContactList(final int column) {
        if (column < 0 || column >= this.width) {
            return null;
        }
        return new ContactListImpl(new ContactListProviderI(){
            int p;
            {
                this.p = column;
            }

            @Override
            public int getPosition() {
                return this.p;
            }

            @Override
            public int getContactHeight() {
                return ContactMatrix.this.width;
            }

            @Override
            public double getContactAt(int column2) {
                Float cl = ContactMatrix.this.getFloatElementAt(column2, this.p);
                if (cl == null) {
                    return Double.NaN;
                }
                return cl.doubleValue();
            }
        });
    }

    private Float getFloatElementAt(int column, int p) {
        Float cl = null;
        if (this.symmetric) {
            if (p < column) {
                List<Float> clist = this.contacts.get(p);
                cl = clist.get(column);
            } else {
                List<Float> clist = this.contacts.get(column);
                cl = clist.get(p);
            }
        } else {
            List<Float> clist = this.contacts.get(p);
            cl = clist.get(column);
        }
        return cl;
    }

    @Override
    public double getElementAt(int column, int row) {
        Float cl = this.getFloatElementAt(column, row);
        if (cl != null) {
            return cl.floatValue();
        }
        throw new RuntimeException("Out of Bounds " + column + "," + row);
    }

    @Override
    public float getMin() {
        return this.min;
    }

    @Override
    public float getMax() {
        return this.max;
    }

    @Override
    public String getAnnotLabel() {
        return "Contact Matrix";
    }

    @Override
    public String getAnnotDescr() {
        return "Contact Matrix";
    }

    public static String contactToFloatString(ContactMatrixI cm) {
        StringBuilder sb = new StringBuilder();
        for (int c = 0; c < cm.getWidth(); ++c) {
            ContactListI cl = cm.getContactList(c);
            long lastsb = -1L;
            if (cl == null) continue;
            for (int h = 0; h <= cl.getContactHeight(); ++h) {
                if (sb.length() > 0) {
                    if ((long)sb.length() - lastsb > 320L) {
                        sb.append('\n');
                        lastsb = sb.length();
                    } else {
                        sb.append('\t');
                    }
                }
                sb.append(cl.getContactAt(h));
            }
        }
        return sb.toString();
    }

    public static float[][] fromFloatStringToContacts(String values, int cols, int rows) {
        float[][] vals = new float[cols][rows];
        StringTokenizer tabsep = new StringTokenizer(values, "\t\n");
        int c = 0;
        int r = 0;
        while (tabsep.hasMoreTokens()) {
            double elem = Double.valueOf(tabsep.nextToken());
            vals[c][r++] = (float)elem;
            if (r >= vals[c].length) {
                r = 0;
                ++c;
            }
            if (c < vals.length) continue;
            break;
        }
        if (tabsep.hasMoreElements()) {
            Console.warn("Ignoring additional elements for Float string to contact matrix parsing.");
        }
        return vals;
    }
}

