/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import java.awt.Color;

public class Annotation {
    public static final Annotation EMPTY_ANNOTATION = new Annotation("", "", ' ', 0.0f);
    public String displayCharacter = "";
    public String description = "";
    public char secondaryStructure = (char)32;
    public float value;
    public Color colour;

    public Annotation(String displayChar, String desc, char ss, float val) {
        this.displayCharacter = displayChar;
        this.description = desc;
        this.secondaryStructure = ss;
        this.value = val;
    }

    public Annotation(String displayChar, String desc, char ss, float val, Color colour) {
        this(displayChar, desc, ss, val);
        this.colour = colour;
    }

    public Annotation(Annotation that) {
        if (that == null || this == that) {
            return;
        }
        if (that.displayCharacter != null) {
            this.displayCharacter = new String(that.displayCharacter);
        }
        if (that.description != null) {
            this.description = new String(that.description);
        }
        this.secondaryStructure = that.secondaryStructure;
        this.value = that.value;
        this.colour = that.colour;
    }

    public Annotation(float val) {
        this(null, null, ' ', val, null);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.displayCharacter != null) {
            sb.append("'");
            sb.append(this.displayCharacter);
            sb.append("'");
        }
        sb.append(",");
        if (this.secondaryStructure != '\u0000' && !("" + this.displayCharacter).equals("" + this.secondaryStructure)) {
            sb.append("'");
            sb.append(this.secondaryStructure);
            sb.append("'");
        }
        sb.append(",");
        if (this.description != null && this.description.length() > 0) {
            sb.append("\"");
            sb.append(this.description);
            sb.append("\"");
        }
        sb.append(",");
        if (!Float.isNaN(this.value)) {
            sb.append(this.value);
        }
        if (this.colour != null) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("[");
            sb.append(this.colour.getRed());
            sb.append(",");
            sb.append(this.colour.getGreen());
            sb.append(",");
            sb.append(this.colour.getBlue());
            sb.append("]");
        }
        return sb.toString();
    }

    public boolean isWhitespace() {
        return !(this.value != 0.0f || this.description != null && this.description.trim().length() != 0 || this.displayCharacter != null && this.displayCharacter.trim().length() != 0 && !this.displayCharacter.equals(" .") || this.secondaryStructure != '\u0000' && this.secondaryStructure != ' ' || this.colour != null);
    }
}

