/*
 * Decompiled with CFR 0.152.
 */
package jalview.commands;

import jalview.commands.EditCommand;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;

public class SlideSequencesCommand
extends EditCommand {
    boolean gapsInsertedBegin = false;

    public SlideSequencesCommand(String description, SequenceI[] seqsLeft, SequenceI[] seqsRight, int slideSize, char gapChar) {
        this.description = description;
        int lSize = seqsLeft.length;
        this.gapsInsertedBegin = false;
        block0: for (int i = 0; i < lSize; ++i) {
            for (int j = 0; j < slideSize; ++j) {
                if (Comparison.isGap(seqsLeft[i].getCharAt(j))) continue;
                this.gapsInsertedBegin = true;
                continue block0;
            }
        }
        EditCommand.Edit e = null;
        if (!this.gapsInsertedBegin) {
            e = (EditCommand)this.new EditCommand.Edit(EditCommand.Action.DELETE_GAP, seqsLeft, 0, slideSize, gapChar);
            this.setEdit(e);
        } else {
            e = (EditCommand)this.new EditCommand.Edit(EditCommand.Action.INSERT_GAP, seqsRight, 0, slideSize, gapChar);
            this.setEdit(e);
        }
        SlideSequencesCommand.performEdit(e, null);
    }

    public boolean getGapsInsertedBegin() {
        return this.gapsInsertedBegin;
    }

    public boolean appendSlideCommand(SlideSequencesCommand command) {
        boolean same = false;
        if (command.getEdit((int)0).seqs.length == this.getEdit((int)0).seqs.length) {
            same = true;
            for (int i = 0; i < command.getEdit((int)0).seqs.length; ++i) {
                if (this.getEdit((int)0).seqs[i] == command.getEdit((int)0).seqs[i]) continue;
                same = false;
            }
        }
        if (same) {
            command.addEdit(this.getEdit(0));
        }
        return same;
    }
}

