/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.bin.Console;
import jalview.datamodel.AlignmentI;
import jalview.io.AppletFormatAdapter;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.FileParse;
import jalview.io.IdentifyFile;
import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;

public class JalviewLiteURLRetrieve
extends Applet {
    private static final long serialVersionUID = 1L;

    @Override
    public void init() {
        this.setSize(300, 200);
        String file = this.getParameter("file");
        if (file == null) {
            System.out.println("Specify a resource to read on the file parameter");
            return;
        }
        DataSourceType protocol = null;
        try {
            Console.outPrintln("Loading thread started with:\n>>file\n" + file + ">>endfile");
            try {
                boolean rtn = false;
                InputStream is = this.getClass().getResourceAsStream("/" + file);
                if (is != null) {
                    rtn = true;
                    is.close();
                }
                Console.errPrintln("Resource '" + file + "' was " + (rtn ? "" : "not") + " located by classloader.");
                if (rtn) {
                    protocol = DataSourceType.CLASSLOADER;
                }
            }
            catch (Exception ex) {
                Console.outPrintln("Exception checking resources: " + file + " " + ex);
            }
            protocol = file.indexOf("://") > -1 ? DataSourceType.URL : DataSourceType.FILE;
            Console.outPrintln("Trying to get contents of resource:");
            FileParse fp = new FileParse(file, protocol);
            if (fp.isValid()) {
                String ln = null;
                while ((ln = fp.nextLine()) != null) {
                    System.out.print(ln);
                }
            } else {
                Console.outPrintln("Resource at " + file + " cannot be read with protocol==" + (Object)((Object)protocol));
                return;
            }
            fp.close();
            FileFormatI format = FileFormats.getInstance().forName(this.getParameter("format"));
            if (format == null) {
                format = new IdentifyFile().identify(file, protocol);
                Console.outPrintln("Format is " + format);
            } else {
                Console.outPrintln("User specified Format is " + format);
            }
            AlignmentI al = null;
            try {
                al = new AppletFormatAdapter().readFile(file, protocol, format);
            }
            catch (IOException ex) {
                Console.errPrintln("Failed to open the file.");
                ex.printStackTrace();
            }
            if (al != null) {
                Console.outPrintln(new AppletFormatAdapter().formatSequences(FileFormat.Fasta, al, false));
            }
        }
        catch (Exception e) {
            Console.errPrintln("bailing out : Unexpected exception:");
            e.printStackTrace();
        }
    }
}

