/*
 * Decompiled with CFR 0.152.
 */
package jalview.bin;

import jalview.bin.Cache;
import jalview.bin.Jalview;
import jalview.log.JLogger;
import jalview.log.JLoggerI;
import jalview.log.JLoggerLog4j;
import jalview.util.ChannelProperties;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Locale;

public class Console {
    public static JLoggerLog4j log;
    private static PrintStream out;
    private static PrintStream err;
    private static File logfile;
    public static final String LOGGING_TEST_MESSAGE = "Logging to STDERR";

    public static PrintStream getOut() {
        return out;
    }

    public static PrintStream getErr() {
        return err;
    }

    public static void setOut(PrintStream p) {
        out = p;
    }

    public static void setErr(PrintStream p) {
        err = p;
    }

    public static boolean setLogFile(String filename, boolean append) {
        boolean usingLogfile = false;
        if (filename != null) {
            if (filename.startsWith("~/")) {
                filename = System.getProperty("user.home") + File.separator + filename.substring(2);
            }
            logfile = new File(filename);
            try {
                PrintStream logFilePrintStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(logfile, append)), true);
                Console.setOut(logFilePrintStream);
                Console.setErr(logFilePrintStream);
                Console.info("LOGFILE_HANDOVER");
                Console.info(ChannelProperties.getProperty("app_name").toUpperCase(Locale.ROOT) + " start of logging");
                Console.debug(ChannelProperties.getProperty("app_name") + " logging to " + filename);
                usingLogfile = true;
            }
            catch (FileNotFoundException e) {
                Console.errPrintln("Error opening logfile: " + e.getMessage());
            }
        }
        return usingLogfile;
    }

    public static void debug(String message, Throwable t) {
        if (Console.initLogger()) {
            log.debug(message, t);
        } else {
            Console.outPrintln(message);
            Console.printStackTrace(t);
        }
    }

    public static void info(String message) {
        if (Console.initLogger()) {
            log.info(message, null);
        } else {
            Console.outPrintln(message);
        }
    }

    public static void trace(String message, Throwable t) {
        if (Console.initLogger()) {
            log.trace(message, t);
        } else {
            Console.outPrintln(message);
            Console.printStackTrace(t);
        }
    }

    public static void debug(String message) {
        if (Console.initLogger()) {
            log.debug(message, null);
        } else {
            Console.outPrintln(message);
        }
    }

    public static void info(String message, Throwable t) {
        if (Console.initLogger()) {
            log.info(message, t);
        } else {
            Console.outPrintln(message);
            Console.printStackTrace(t);
        }
    }

    public static void warn(String message) {
        if (Console.initLogger()) {
            log.warn(message, null);
        } else {
            Console.outPrintln(message);
        }
    }

    public static void trace(String message) {
        if (Console.initLogger()) {
            log.trace(message, null);
        } else {
            Console.outPrintln(message);
        }
    }

    public static void warn(String message, Throwable t) {
        if (Console.initLogger()) {
            log.warn(message, t);
        } else {
            Console.outPrintln(message);
            Console.printStackTrace(t);
        }
    }

    public static void error(String message) {
        if (Console.initLogger()) {
            log.error(message, null);
        } else {
            Console.errPrintln(message);
        }
    }

    public static void error(String message, Throwable t) {
        if (Console.initLogger()) {
            log.error(message, t);
        } else {
            Console.errPrintln(message);
            Console.printStackTrace(t);
        }
    }

    public static void fatal(String message) {
        if (Console.initLogger()) {
            log.fatal(message, null);
        } else {
            Console.errPrintln(message);
        }
    }

    public static void fatal(String message, Throwable t) {
        if (Console.initLogger()) {
            log.fatal(message, t);
        } else {
            Console.errPrintln(message);
            Console.printStackTrace(t);
        }
    }

    public static boolean isDebugEnabled() {
        return log == null ? false : log.isDebugEnabled();
    }

    public static boolean isTraceEnabled() {
        return log == null ? false : log.isTraceEnabled();
    }

    public static JLoggerI.LogLevel getCachedLogLevel() {
        return Console.getCachedLogLevel("logs.Jalview.level");
    }

    public static JLoggerI.LogLevel getCachedLogLevel(String key) {
        return Console.getLogLevel(Cache.getDefault(key, "INFO"));
    }

    public static JLoggerI.LogLevel getLogLevel(String level) {
        return JLogger.toLevel(level);
    }

    public static JLogger getLogger() {
        return log;
    }

    public static boolean initLogger() {
        return Console.initLogger(null);
    }

    public static boolean initLogger(String providedLogLevel) {
        if (log != null) {
            return true;
        }
        try {
            JLoggerI.LogLevel logLevel = JLoggerI.LogLevel.INFO;
            logLevel = providedLogLevel != null && JLogger.isLevel(providedLogLevel) ? Console.getLogLevel(providedLogLevel) : Console.getCachedLogLevel();
            JLoggerLog4j.setLogfile(logfile);
            JLoggerLog4j.getLogger("org.apache.axis", logLevel);
            log = JLoggerLog4j.getLogger("JalviewLogger", logLevel);
        }
        catch (NoClassDefFoundError e) {
            Console.errPrintln("Could not initialise the logger framework");
            Console.printStackTrace(e);
        }
        if (log != null) {
            if (log.loggerExists()) {
                log.debug(LOGGING_TEST_MESSAGE);
            }
            Console.debug(ChannelProperties.getProperty("app_name") + " Debugging Output Follows.");
            return true;
        }
        return false;
    }

    public static void setLogLevel(String logLevelString) {
        JLoggerI.LogLevel l = null;
        try {
            l = JLoggerI.LogLevel.valueOf(logLevelString);
        }
        catch (IllegalArgumentException | NullPointerException e1) {
            Console.debug("Invalid log level '" + logLevelString + "'");
            return;
        }
        Console.setLogLevel(l);
    }

    public static void setLogLevel(JLoggerI.LogLevel l) {
        if (l != null) {
            log.setLevel(l);
            JLoggerLog4j.getLogger("org.apache.axis", l);
        }
    }

    public static void outPrint() {
        Console.outPrint("");
    }

    public static void outPrintln() {
        Console.outPrintln("");
    }

    public static void outPrint(Object message) {
        Console.outPrintMessage(message, false, false);
    }

    public static void outPrint(Object message, boolean forceStdout) {
        Console.outPrintMessage(message, false, forceStdout);
    }

    public static void outPrintln(Object message) {
        Console.outPrintMessage(message, true, false);
    }

    public static PrintStream outputStream(boolean forceStdout) {
        if (!forceStdout && Jalview.getInstance() != null && Jalview.getInstance().getBootstrapArgs() != null && Jalview.getInstance().getBootstrapArgs().outputToStdout()) {
            return err;
        }
        return out;
    }

    public static void outPrintMessage(Object message, boolean newline, boolean forceStdout) {
        PrintStream ps = Console.outputStream(forceStdout);
        if (newline) {
            ps.println(message);
        } else {
            ps.print(message);
        }
    }

    public static void errPrint() {
        Console.errPrint("");
    }

    public static void errPrintln() {
        Console.errPrintln("");
    }

    public static void errPrint(Object message) {
        err.print(message);
    }

    public static void errPrintln(Object message) {
        err.println(message);
    }

    public static void debugPrintStackTrace(Throwable t) {
        if (!Console.isDebugEnabled()) {
            return;
        }
        Console.printStackTrace(t);
    }

    public static void printStackTrace(Throwable t) {
        t.printStackTrace(err);
    }

    static {
        out = System.out;
        err = System.err;
        logfile = null;
    }
}

