/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.api.FeatureColourI;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.FeatureColourChooser;
import jalview.appletgui.JVDialog;
import jalview.appletgui.UserDefinedColours;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.io.FeaturesFile;
import jalview.schemes.FeatureColour;
import jalview.util.ColorUtils;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Hashtable;
import java.util.List;

public class FeatureRenderer
extends jalview.renderer.seqfeatures.FeatureRenderer {
    static String lastFeatureAdded = "feature_1";
    static String lastFeatureGroupAdded = "Jalview";
    Hashtable featureLinks = null;
    int featureIndex = 0;
    boolean deleteFeature = false;
    FeatureColourPanel colourPanel;

    public FeatureRenderer(AlignmentViewport av) {
        super(av);
    }

    boolean amendFeatures(final List<SequenceI> sequences, final List<SequenceFeature> features, boolean create, final AlignmentPanel ap) {
        Panel tmp;
        Panel bigPanel = new Panel(new BorderLayout());
        final TextField name = new TextField(16);
        final TextField group = new TextField(16);
        final TextArea description = new TextArea(3, 35);
        final TextField start = new TextField(8);
        final TextField end = new TextField(8);
        Button deleteButton = new Button("Delete");
        this.deleteFeature = false;
        name.addTextListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent e) {
                FeatureRenderer.this.warnIfTypeHidden(ap.alignFrame, name.getText());
            }
        });
        group.addTextListener(new TextListener(){

            @Override
            public void textValueChanged(TextEvent e) {
                FeatureRenderer.this.warnIfGroupHidden(ap.alignFrame, group.getText());
            }
        });
        this.colourPanel = new FeatureColourPanel();
        this.colourPanel.setSize(110, 15);
        final FeatureRenderer fr = this;
        Panel panel = new Panel(new GridLayout(3, 1));
        this.featureIndex = 0;
        if (!create && features.size() > 1) {
            panel = new Panel(new GridLayout(4, 1));
            tmp = new Panel();
            tmp.add(new Label("Select Feature: "));
            final Choice overlaps = new Choice();
            for (SequenceFeature sf : features) {
                String item = sf.getType() + "/" + sf.getBegin() + "-" + sf.getEnd();
                if (sf.getFeatureGroup() != null) {
                    item = item + " (" + sf.getFeatureGroup() + ")";
                }
                overlaps.addItem(item);
            }
            tmp.add(overlaps);
            overlaps.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    FeatureColourI col;
                    int index = overlaps.getSelectedIndex();
                    if (index != -1) {
                        FeatureRenderer.this.featureIndex = index;
                        SequenceFeature sf = (SequenceFeature)features.get(index);
                        name.setText(sf.getType());
                        description.setText(sf.getDescription());
                        group.setText(sf.getFeatureGroup());
                        start.setText(sf.getBegin() + "");
                        end.setText(sf.getEnd() + "");
                        SearchResults highlight = new SearchResults();
                        highlight.addResult((SequenceI)sequences.get(0), sf.getBegin(), sf.getEnd());
                        ap.seqPanel.seqCanvas.highlightSearchResults(highlight);
                    }
                    if ((col = FeatureRenderer.this.getFeatureStyle(name.getText())) == null) {
                        Color generatedColour = ColorUtils.createColourFromName(name.getText());
                        col = new FeatureColour(generatedColour);
                    }
                    FeatureRenderer.this.colourPanel.updateColor(col);
                }
            });
            panel.add(tmp);
        }
        tmp = new Panel();
        panel.add(tmp);
        tmp.add(new Label(MessageManager.getString("label.name:"), 2));
        tmp.add(name);
        tmp = new Panel();
        panel.add(tmp);
        tmp.add(new Label(MessageManager.getString("label.group:"), 2));
        tmp.add(group);
        tmp = new Panel();
        panel.add(tmp);
        tmp.add(new Label(MessageManager.getString("label.colour"), 2));
        tmp.add(this.colourPanel);
        bigPanel.add((Component)panel, "North");
        panel = new Panel();
        panel.add(new Label(MessageManager.getString("label.description:"), 2));
        panel.add(new ScrollPane().add(description));
        if (!create) {
            bigPanel.add((Component)panel, "South");
            panel = new Panel();
            panel.add(new Label(MessageManager.getString("label.start"), 2));
            panel.add(start);
            panel.add(new Label(MessageManager.getString("label.end"), 2));
            panel.add(end);
            bigPanel.add((Component)panel, "Center");
        } else {
            bigPanel.add((Component)panel, "Center");
        }
        SequenceFeature firstFeature = features.get(0);
        boolean useLastDefaults = firstFeature.getType() == null;
        String featureType = useLastDefaults ? lastFeatureAdded : firstFeature.getType();
        String featureGroup = useLastDefaults ? lastFeatureGroupAdded : firstFeature.getFeatureGroup();
        String title = create ? MessageManager.getString("label.create_new_sequence_features") : MessageManager.formatMessage("label.amend_delete_features", new String[]{sequences.get(0).getName()});
        final JVDialog dialog = new JVDialog(ap.alignFrame, title, true, 385, 240);
        dialog.setMainPanel(bigPanel);
        name.setText(featureType);
        group.setText(featureGroup);
        if (!create) {
            dialog.ok.setLabel(MessageManager.getString("label.amend"));
            dialog.buttonPanel.add((Component)deleteButton, 1);
            deleteButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FeatureRenderer.this.deleteFeature = true;
                    dialog.setVisible(false);
                }
            });
        }
        start.setText(firstFeature.getBegin() + "");
        end.setText(firstFeature.getEnd() + "");
        description.setText(firstFeature.getDescription());
        FeatureColourI fcol = this.getFeatureStyle(name.getText());
        this.colourPanel.updateColor(fcol);
        dialog.setResizable(true);
        this.colourPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (!FeatureRenderer.this.colourPanel.isGcol) {
                    new UserDefinedColours(fr, ap.alignFrame);
                } else {
                    new FeatureColourChooser(ap.alignFrame, name.getText());
                    dialog.transferFocus();
                }
            }
        });
        dialog.setVisible(true);
        FeaturesFile ffile = new FeaturesFile();
        String enteredType = name.getText().trim();
        String enteredGroup = group.getText().trim();
        String enteredDesc = description.getText().replace('\n', ' ');
        if (dialog.accept && useLastDefaults) {
            lastFeatureAdded = enteredType;
            lastFeatureGroupAdded = enteredGroup;
        }
        if (!create) {
            SequenceFeature sf = features.get(this.featureIndex);
            if (dialog.accept) {
                if (!this.colourPanel.isGcol) {
                    this.setColour(enteredType, new FeatureColour(this.colourPanel.getBackground()));
                }
                int newBegin = sf.begin;
                int newEnd = sf.end;
                try {
                    newBegin = Integer.parseInt(start.getText());
                    newEnd = Integer.parseInt(end.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                sequences.get(0).deleteFeature(sf);
                SequenceFeature newSf = new SequenceFeature(sf, enteredType, newBegin, newEnd, enteredGroup, sf.getScore());
                newSf.setDescription(enteredDesc);
                ffile.parseDescriptionHTML(newSf, false);
                sequences.get(0).addSequenceFeature(newSf);
                boolean typeOrGroupChanged = !featureType.equals(newSf.getType()) || !featureGroup.equals(newSf.getFeatureGroup());
                ffile.parseDescriptionHTML(sf, false);
                if (typeOrGroupChanged) {
                    this.featuresAdded();
                }
            }
            if (this.deleteFeature) {
                sequences.get(0).deleteFeature(sf);
                this.featuresAdded();
            }
        } else if (dialog.accept && name.getText().length() > 0) {
            for (int i = 0; i < sequences.size(); ++i) {
                SequenceFeature sf = features.get(i);
                SequenceFeature sf2 = new SequenceFeature(enteredType, enteredDesc, sf.getBegin(), sf.getEnd(), enteredGroup);
                ffile.parseDescriptionHTML(sf2, false);
                sequences.get(i).addSequenceFeature(sf2);
            }
            Color newColour = this.colourPanel.getBackground();
            this.setColour(enteredType, new FeatureColour(newColour));
            this.featuresAdded();
        } else {
            return false;
        }
        if (((AlignViewport)this.av).featureSettings != null) {
            ((AlignViewport)this.av).featureSettings.refreshTable();
        }
        ap.paintAlignment(true, true);
        return true;
    }

    protected void warnIfGroupHidden(Frame frame, String group) {
        if (this.featureGroups.containsKey(group) && !((Boolean)this.featureGroups.get(group)).booleanValue()) {
            String msg = MessageManager.formatMessage("label.warning_hidden", MessageManager.getString("label.group"), group);
            this.showWarning(frame, msg);
        }
    }

    protected void warnIfTypeHidden(Frame frame, String type) {
        if (this.getRenderOrder().contains(type) && !this.showFeatureOfType(type)) {
            String msg = MessageManager.formatMessage("label.warning_hidden", MessageManager.getString("label.feature_type"), type);
            this.showWarning(frame, msg);
        }
    }

    protected void showWarning(Frame frame, String msg) {
        JVDialog d = new JVDialog(frame, "", true, 350, 200);
        Panel mp = new Panel();
        d.ok.setLabel(MessageManager.getString("action.ok"));
        d.cancel.setVisible(false);
        mp.setLayout(new FlowLayout());
        mp.add(new Label(msg));
        d.setMainPanel(mp);
        d.setVisible(true);
    }

    class FeatureColourPanel
    extends Panel {
        String label;
        private Color maxCol;
        private boolean isColourByLabel;
        private boolean isGcol;

        public void updateColor(FeatureColourI newcol) {
            Color bg = null;
            String vlabel = "";
            if (newcol.isSimpleColour()) {
                bg = newcol.getColour();
                this.setBackground(bg);
            } else {
                if (newcol.isAboveThreshold()) {
                    vlabel = vlabel + " (>)";
                } else if (newcol.isBelowThreshold()) {
                    vlabel = vlabel + " (<)";
                }
                this.isColourByLabel = newcol.isColourByLabel();
                if (this.isColourByLabel) {
                    bg = Color.white;
                    this.setBackground(bg);
                    vlabel = vlabel + " (by Label)";
                } else {
                    bg = newcol.getMinColour();
                    this.setBackground(bg);
                    this.maxCol = newcol.getMaxColour();
                }
            }
            this.label = vlabel;
            this.setBackground(bg);
            this.repaint();
        }

        FeatureColourPanel() {
            super(null);
            this.label = "";
        }

        @Override
        public void paint(Graphics g) {
            Dimension d = this.getSize();
            if (this.isGcol) {
                if (this.isColourByLabel) {
                    g.setColor(Color.white);
                    g.fillRect(d.width / 2, 0, d.width / 2, d.height);
                    g.setColor(Color.black);
                    Font f = new Font("Verdana", 0, 10);
                    g.setFont(f);
                    g.drawString(MessageManager.getString("label.label"), 0, 0);
                } else {
                    g.setColor(this.maxCol);
                    g.fillRect(d.width / 2, 0, d.width / 2, d.height);
                }
            }
        }
    }
}

