/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.analysis.scoremodels.PIDModel;
import jalview.analysis.scoremodels.ScoreMatrix;
import jalview.analysis.scoremodels.ScoreModels;
import jalview.analysis.scoremodels.SimilarityParams;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Mapping;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.math.MiscMath;
import jalview.util.Comparison;
import jalview.util.Format;
import jalview.util.MapList;
import jalview.util.MessageManager;
import java.awt.Color;
import java.awt.Graphics;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class AlignSeq {
    private static final int MAX_NAME_LENGTH = 30;
    private static final int DEFAULT_OPENCOST = 120;
    private static final int DEFAULT_EXTENDCOST = 20;
    private int GAP_OPEN_COST = 120;
    private int GAP_EXTEND_COST = 20;
    private static final int GAP_INDEX = -1;
    public static final String PEP = "pep";
    public static final String DNA = "dna";
    private static final String NEWLINE = System.lineSeparator();
    float[][] score;
    float alignmentScore;
    float[][] E;
    float[][] F;
    int[][] traceback;
    int[] seq1;
    int[] seq2;
    SequenceI s1;
    SequenceI s2;
    public String s1str;
    public String s2str;
    int maxi;
    int maxj;
    int[] aseq1;
    int[] aseq2;
    int match = -1;
    public String astr1 = "";
    public String astr2 = "";
    public String indelfreeAstr1 = "";
    public String indelfreeAstr2 = "";
    public int seq1start;
    public int seq1end;
    public int seq2start;
    public int seq2end;
    int count;
    public float maxscore;
    public float meanScore;
    public int hypotheticMaxScore;
    int prev = 0;
    StringBuffer output = new StringBuffer();
    String type;
    private ScoreMatrix scoreMatrix;

    public AlignSeq(int opencost, int extcost) {
        this.GAP_OPEN_COST = opencost;
        this.GAP_EXTEND_COST = extcost;
    }

    public AlignSeq(SequenceI s1, SequenceI s2, String type) {
        this.seqInit(s1, s1.getSequenceAsString(), s2, s2.getSequenceAsString(), type);
    }

    public AlignSeq(SequenceI s1, String string1, SequenceI s2, String string2, String type) {
        this.seqInit(s1, string1.toUpperCase(Locale.ROOT), s2, string2.toUpperCase(Locale.ROOT), type);
    }

    public AlignSeq(SequenceI s1, SequenceI s2, String type, int opencost, int extcost) {
        this(s1, s2, type);
        this.GAP_OPEN_COST = opencost;
        this.GAP_EXTEND_COST = extcost;
    }

    public AlignSeq(SequenceI s12, String string1, SequenceI s22, String string2, String type2, int defaultOpencost, int defaultExtendcost) {
        this(s12, string1, s22, string2, type2);
        this.GAP_OPEN_COST = defaultOpencost;
        this.GAP_EXTEND_COST = defaultExtendcost;
    }

    public float getMaxScore() {
        return this.maxscore;
    }

    public float getAlignmentScore() {
        return this.alignmentScore;
    }

    public int getSeq2Start() {
        return this.seq2start;
    }

    public int getSeq2End() {
        return this.seq2end;
    }

    public int getSeq1Start() {
        return this.seq1start;
    }

    public int getSeq1End() {
        return this.seq1end;
    }

    public String getOutput() {
        return this.output.toString();
    }

    public String getAStr1() {
        return this.astr1;
    }

    public String getAStr2() {
        return this.astr2;
    }

    public int[] getASeq1() {
        return this.aseq1;
    }

    public int[] getASeq2() {
        return this.aseq2;
    }

    public SequenceI getAlignedSeq1() {
        Sequence alSeq1 = new Sequence(this.s1.getName(), this.getAStr1());
        alSeq1.setStart(this.s1.getStart() + this.getSeq1Start() - 1);
        alSeq1.setEnd(this.s1.getStart() + this.getSeq1End() - 1);
        alSeq1.setDatasetSequence(this.s1.getDatasetSequence() == null ? this.s1 : this.s1.getDatasetSequence());
        return alSeq1;
    }

    public SequenceI getAlignedSeq2() {
        Sequence alSeq2 = new Sequence(this.s2.getName(), this.getAStr2());
        alSeq2.setStart(this.s2.getStart() + this.getSeq2Start() - 1);
        alSeq2.setEnd(this.s2.getStart() + this.getSeq2End() - 1);
        alSeq2.setDatasetSequence(this.s2.getDatasetSequence() == null ? this.s2 : this.s2.getDatasetSequence());
        return alSeq2;
    }

    public double getS2Coverage() {
        if (this.match >= 0) {
            return (double)this.match / ((double)this.s2.getEnd() - (double)this.s2.getStart() + 1.0);
        }
        return Double.NaN;
    }

    public double getS1Coverage() {
        if (this.match >= 0) {
            return (double)this.match / ((double)this.s1.getEnd() - (double)this.s1.getStart() + 1.0);
        }
        return Double.NaN;
    }

    public void seqInit(SequenceI s1, String string1, SequenceI s2, String string2, String type) {
        this.seqInit(s1, string1, s2, string2, type, this.GAP_OPEN_COST, this.GAP_EXTEND_COST);
    }

    public void seqInit(SequenceI s1, String string1, SequenceI s2, String string2, String type, int opening, int extension) {
        this.GAP_OPEN_COST = opening;
        this.GAP_EXTEND_COST = extension;
        this.s1 = s1;
        this.s2 = s2;
        this.setDefaultParams(type);
        this.seqInit(string1, string2);
    }

    private void seqInit(String string1, String string2) {
        this.s1str = AlignSeq.extractGaps(Comparison.GapChars, string1);
        this.s2str = AlignSeq.extractGaps(Comparison.GapChars, string2);
        if (this.s1str.length() == 0 || this.s2str.length() == 0) {
            this.output.append("ALL GAPS: " + (this.s1str.length() == 0 ? this.s1.getName() : " ") + (this.s2str.length() == 0 ? this.s2.getName() : ""));
            return;
        }
        this.score = new float[this.s1str.length()][this.s2str.length()];
        this.E = new float[this.s1str.length()][this.s2str.length()];
        this.F = new float[this.s1str.length()][this.s2str.length()];
        this.traceback = new int[this.s1str.length()][this.s2str.length()];
        this.seq1 = this.indexEncode(this.s1str);
        this.seq2 = this.indexEncode(this.s2str);
    }

    private void setDefaultParams(String moleculeType) {
        if (!PEP.equals(moleculeType) && !DNA.equals(moleculeType)) {
            this.output.append("Wrong type = dna or pep only");
            throw new Error(MessageManager.formatMessage("error.unknown_type_dna_or_pep", new String[]{moleculeType}));
        }
        this.type = moleculeType;
        this.scoreMatrix = ScoreModels.getInstance().getDefaultModel(PEP.equals(this.type));
    }

    public void traceAlignment() {
        int i;
        float max = -3.4028235E38f;
        for (i = 0; i < this.seq1.length; ++i) {
            if (!(this.score[i][this.seq2.length - 1] > max)) continue;
            max = this.score[i][this.seq2.length - 1];
            this.maxi = i;
            this.maxj = this.seq2.length - 1;
        }
        for (int j = 0; j < this.seq2.length; ++j) {
            if (!(this.score[this.seq1.length - 1][j] > max)) continue;
            max = this.score[this.seq1.length - 1][j];
            this.maxi = this.seq1.length - 1;
            this.maxj = j;
        }
        i = this.maxi;
        int j = this.maxj;
        this.maxscore = this.score[i][j] / 10.0f;
        this.seq1end = this.maxi + 1;
        this.seq2end = this.maxj + 1;
        this.aseq1 = new int[this.seq1.length + this.seq2.length];
        this.aseq2 = new int[this.seq1.length + this.seq2.length];
        this.match = 0;
        StringBuilder sb1 = new StringBuilder(this.aseq1.length);
        StringBuilder sb2 = new StringBuilder(this.aseq2.length);
        this.count = this.seq1.length + this.seq2.length - 1;
        while (i > 0 && j > 0) {
            this.aseq1[this.count] = this.seq1[i];
            sb1.append(this.s1str.charAt(i));
            this.aseq2[this.count] = this.seq2[j];
            sb2.append(this.s2str.charAt(j));
            int trace = this.findTrace(i, j);
            if (trace == 0) {
                ++this.match;
                --i;
                --j;
            } else if (trace == 1) {
                --j;
                this.aseq1[this.count] = -1;
                sb1.replace(sb1.length() - 1, sb1.length(), "-");
            } else if (trace == -1) {
                --i;
                this.aseq2[this.count] = -1;
                sb2.replace(sb2.length() - 1, sb2.length(), "-");
            }
            --this.count;
        }
        this.seq1start = i + 1;
        this.seq2start = j + 1;
        if (this.aseq1[this.count] != -1) {
            this.aseq1[this.count] = this.seq1[i];
            sb1.append(this.s1str.charAt(i));
        }
        if (this.aseq2[this.count] != -1) {
            this.aseq2[this.count] = this.seq2[j];
            sb2.append(this.s2str.charAt(j));
            if (this.aseq1[this.count] != -1) {
                ++this.match;
            }
        }
        this.astr1 = sb1.reverse().toString();
        this.astr2 = sb2.reverse().toString();
    }

    public void traceAlignmentWithEndGaps() {
        int j;
        int i;
        float max = -3.4028235E38f;
        for (i = 0; i < this.seq1.length; ++i) {
            if (!(this.score[i][this.seq2.length - 1] > max)) continue;
            max = this.score[i][this.seq2.length - 1];
            this.maxi = i;
            this.maxj = this.seq2.length - 1;
        }
        for (int j2 = 0; j2 < this.seq2.length; ++j2) {
            if (!(this.score[this.seq1.length - 1][j2] > max)) continue;
            max = this.score[this.seq1.length - 1][j2];
            this.maxi = this.seq1.length - 1;
            this.maxj = j2;
        }
        i = this.maxi;
        this.maxscore = this.score[i][j] / 10.0f;
        for (j = this.maxj; i < this.seq1.length - 1 || j < this.seq2.length - 1; ++i, ++j) {
        }
        this.seq1end = i + 1;
        this.seq2end = j + 1;
        this.aseq1 = new int[this.seq1.length + this.seq2.length];
        this.aseq2 = new int[this.seq1.length + this.seq2.length];
        StringBuilder sb1 = new StringBuilder(this.aseq1.length);
        StringBuilder sb2 = new StringBuilder(this.aseq2.length);
        this.count = this.seq1.length + this.seq2.length - 1;
        while (i >= this.seq1.length || j >= this.seq2.length) {
            if (i >= this.seq1.length) {
                this.aseq1[this.count] = -1;
                sb1.append("-");
                this.aseq2[this.count] = this.seq2[j];
                sb2.append(this.s2str.charAt(j));
            } else if (j >= this.seq2.length) {
                this.aseq1[this.count] = this.seq1[i];
                sb1.append(this.s1str.charAt(i));
                this.aseq2[this.count] = -1;
                sb2.append("-");
            }
            --i;
            --j;
        }
        while (i > 0 && j > 0) {
            this.aseq1[this.count] = this.seq1[i];
            sb1.append(this.s1str.charAt(i));
            this.aseq2[this.count] = this.seq2[j];
            sb2.append(this.s2str.charAt(j));
            int trace = this.findTrace(i, j);
            if (trace == 0) {
                --i;
                --j;
            } else if (trace == 1) {
                --j;
                this.aseq1[this.count] = -1;
                sb1.replace(sb1.length() - 1, sb1.length(), "-");
            } else if (trace == -1) {
                --i;
                this.aseq2[this.count] = -1;
                sb2.replace(sb2.length() - 1, sb2.length(), "-");
            }
            --this.count;
        }
        this.seq1start = i + 1;
        this.seq2start = j + 1;
        this.aseq1[this.count] = this.seq1[i];
        sb1.append(this.s1str.charAt(i));
        this.aseq2[this.count] = this.seq2[j];
        sb2.append(this.s2str.charAt(j));
        while (j > 0 || i > 0) {
            if (j > 0) {
                sb1.append("-");
                sb2.append(this.s2str.charAt(--j));
                continue;
            }
            if (i <= 0) continue;
            sb1.append(this.s1str.charAt(--i));
            sb2.append("-");
        }
        this.astr1 = sb1.reverse().toString();
        this.astr2 = sb2.reverse().toString();
    }

    public void printAlignment(PrintStream os) {
        String s1id = this.getAlignedSeq1().getDisplayId(true);
        String s2id = this.getAlignedSeq2().getDisplayId(true);
        int nameLength = Math.max(s1id.length(), s2id.length());
        if (nameLength > 30) {
            int slashPos;
            int truncateBy = nameLength - 30;
            nameLength = 30;
            if (s1id.length() > nameLength) {
                slashPos = s1id.lastIndexOf(47);
                s1id = s1id.substring(0, slashPos - truncateBy) + s1id.substring(slashPos);
            }
            if (s2id.length() > nameLength) {
                slashPos = s2id.lastIndexOf(47);
                s2id = s2id.substring(0, slashPos - truncateBy) + s2id.substring(slashPos);
            }
        }
        int len = 72 - nameLength - 1;
        int nochunks = (this.aseq1.length - this.count) / len + ((this.aseq1.length - this.count) % len > 0 ? 1 : 0);
        float pid = 0.0f;
        this.output.append("Score = ").append(this.score[this.maxi][this.maxj]).append(NEWLINE);
        this.output.append("Length of alignment = ").append(String.valueOf(this.aseq1.length - this.count)).append(NEWLINE);
        this.output.append("Sequence ");
        Format nameFormat = new Format("%" + nameLength + "s");
        this.output.append(nameFormat.form(s1id));
        this.output.append(" (Sequence length = ").append(String.valueOf(this.s1str.length())).append(")").append(NEWLINE);
        this.output.append("Sequence ");
        this.output.append(nameFormat.form(s2id));
        this.output.append(" (Sequence length = ").append(String.valueOf(this.s2str.length())).append(")").append(NEWLINE).append(NEWLINE);
        ScoreMatrix pam250 = ScoreModels.getInstance().getPam250();
        for (int j = 0; j < nochunks; ++j) {
            int i;
            this.output.append(nameFormat.form(s1id)).append(" ");
            for (i = 0; i < len; ++i) {
                if (i + j * len >= this.astr1.length()) continue;
                this.output.append(this.astr1.charAt(i + j * len));
            }
            this.output.append(NEWLINE);
            this.output.append(nameFormat.form(" ")).append(" ");
            for (i = 0; i < len; ++i) {
                char c2;
                if (i + j * len >= this.astr1.length()) continue;
                char c1 = this.astr1.charAt(i + j * len);
                boolean sameChar = Comparison.isSameResidue(c1, c2 = this.astr2.charAt(i + j * len), false);
                if (sameChar && !Comparison.isGap(c1)) {
                    pid += 1.0f;
                    this.output.append("|");
                    continue;
                }
                if (PEP.equals(this.type)) {
                    if (pam250.getPairwiseScore(c1, c2) > 0.0f) {
                        this.output.append(".");
                        continue;
                    }
                    this.output.append(" ");
                    continue;
                }
                this.output.append(" ");
            }
            this.output = this.output.append(NEWLINE);
            this.output = this.output.append(nameFormat.form(s2id)).append(" ");
            for (i = 0; i < len; ++i) {
                if (i + j * len >= this.astr2.length()) continue;
                this.output.append(this.astr2.charAt(i + j * len));
            }
            this.output.append(NEWLINE).append(NEWLINE);
        }
        pid = pid / (float)(this.aseq1.length - this.count) * 100.0f;
        this.output.append(new Format("Percentage ID = %3.2f\n").form(pid));
        this.output.append(NEWLINE);
        try {
            os.print(this.output.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int findTrace(int i, int j) {
        int t = 0;
        float pairwiseScore = this.scoreMatrix.getPairwiseScore(this.s1str.charAt(i), this.s2str.charAt(j));
        float max = this.score[i - 1][j - 1] + pairwiseScore * 10.0f;
        if (this.F[i][j] > max) {
            max = this.F[i][j];
            t = -1;
        } else if (this.F[i][j] == max && this.prev == -1) {
            max = this.F[i][j];
            t = -1;
        }
        if (this.E[i][j] >= max) {
            max = this.E[i][j];
            t = 1;
        } else if (this.E[i][j] == max && this.prev == 1) {
            max = this.E[i][j];
            t = 1;
        }
        this.prev = t;
        return t;
    }

    public void calcScoreMatrix() {
        int i;
        float pairwiseScore;
        int n = this.seq1.length;
        int m = this.seq2.length;
        int GAP_EX_COST = this.GAP_EXTEND_COST;
        int GAP_OP_COST = this.GAP_OPEN_COST;
        this.score[0][0] = this.scoreMatrix.getPairwiseScore(this.s1str.charAt(0), this.s2str.charAt(0)) * 10.0f;
        this.E[0][0] = -GAP_EX_COST;
        this.F[0][0] = 0.0f;
        for (int j = 1; j < m; ++j) {
            this.E[0][j] = AlignSeq.max(this.score[0][j - 1] - (float)GAP_OP_COST, this.E[0][j - 1] - (float)GAP_EX_COST);
            this.F[0][j] = -GAP_EX_COST;
            pairwiseScore = this.scoreMatrix.getPairwiseScore(this.s1str.charAt(0), this.s2str.charAt(j));
            this.score[0][j] = AlignSeq.max(pairwiseScore * 10.0f, -GAP_OP_COST, -GAP_EX_COST);
            this.traceback[0][j] = 1;
        }
        for (i = 1; i < n; ++i) {
            this.E[i][0] = -GAP_OP_COST;
            this.F[i][0] = AlignSeq.max(this.score[i - 1][0] - (float)GAP_OP_COST, this.F[i - 1][0] - (float)GAP_EX_COST);
            pairwiseScore = this.scoreMatrix.getPairwiseScore(this.s1str.charAt(i), this.s2str.charAt(0));
            this.score[i][0] = AlignSeq.max(pairwiseScore * 10.0f, this.E[i][0], this.F[i][0]);
            this.traceback[i][0] = -1;
        }
        for (i = 1; i < n; ++i) {
            for (int j = 1; j < m; ++j) {
                this.E[i][j] = AlignSeq.max(this.score[i][j - 1] - (float)GAP_OP_COST, this.E[i][j - 1] - (float)GAP_EX_COST);
                this.F[i][j] = AlignSeq.max(this.score[i - 1][j] - (float)GAP_OP_COST, this.F[i - 1][j] - (float)GAP_EX_COST);
                float pairwiseScore2 = this.scoreMatrix.getPairwiseScore(this.s1str.charAt(i), this.s2str.charAt(j));
                this.score[i][j] = AlignSeq.max(this.score[i - 1][j - 1] + pairwiseScore2 * 10.0f, this.E[i][j], this.F[i][j]);
                this.traceback[i][j] = this.findTrace(i, j);
            }
        }
    }

    public static String extractGaps(String gapChars, String seq) {
        if (gapChars == null || seq == null) {
            return null;
        }
        StringTokenizer str = new StringTokenizer(seq, gapChars);
        StringBuilder newString = new StringBuilder(seq.length());
        while (str.hasMoreTokens()) {
            newString.append(str.nextToken());
        }
        return newString.toString();
    }

    private static float max(float f1, float f2, float f3) {
        float max = f1;
        if (f2 > f1) {
            max = f2;
        }
        if (f3 > max) {
            max = f3;
        }
        return max;
    }

    private static float max(float f1, float f2) {
        float max = f1;
        if (f2 > f1) {
            max = f2;
        }
        return max;
    }

    int[] indexEncode(String s) {
        int[] encoded = new int[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            encoded[i] = this.scoreMatrix.getMatrixIndex(c);
        }
        return encoded;
    }

    public static void displayMatrix(Graphics g, int[][] mat, int n, int m, int psize) {
        int j;
        int i;
        int max = -1000;
        int min = 1000;
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                if (mat[i][j] >= max) {
                    max = mat[i][j];
                }
                if (mat[i][j] > min) continue;
                min = mat[i][j];
            }
        }
        Console.outPrintln(max + " " + min);
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                int x = psize * i;
                int y = psize * j;
                float score = (float)(mat[i][j] - min) / (float)(max - min);
                g.setColor(new Color(score, 0.0f, 0.0f));
                g.fillRect(x, y, psize, psize);
            }
        }
    }

    public static AlignSeq doGlobalNWAlignment(SequenceI s1, SequenceI s2, String type) {
        return AlignSeq.doGlobalNWAlignment(s1, s2, type, 120, 20);
    }

    public static AlignSeq doGlobalNWAlignment(SequenceI s1, SequenceI s2, String type, int opencost, int extcost) {
        AlignSeq as = new AlignSeq(s1, s2, type, opencost, extcost);
        as.calcScoreMatrix();
        as.traceAlignment();
        return as;
    }

    public Mapping getMappingFromS1(boolean allowmismatch) {
        ArrayList<Integer> as1 = new ArrayList<Integer>();
        ArrayList<Integer> as2 = new ArrayList<Integer>();
        int pdbpos = this.s2.getStart() + this.getSeq2Start() - 2;
        int alignpos = this.s1.getStart() + this.getSeq1Start() - 2;
        int lp2 = pdbpos - 3;
        int lp1 = alignpos - 3;
        boolean lastmatch = false;
        for (int i = 0; i < this.astr1.length(); ++i) {
            char c1 = this.astr1.charAt(i);
            char c2 = this.astr2.charAt(i);
            if (c1 != '-') {
                ++alignpos;
            }
            if (c2 != '-') {
                ++pdbpos;
            }
            if (allowmismatch || c1 == c2 || Math.abs(c2 - c1) == 32) {
                if (lp1 + 1 != alignpos || lp2 + 1 != pdbpos) {
                    as1.add(alignpos);
                    as2.add(pdbpos);
                }
                lastmatch = true;
                lp1 = alignpos;
                lp2 = pdbpos;
                continue;
            }
            if (lastmatch) {
                as1.add(lp1);
                as2.add(lp2);
            }
            lastmatch = false;
        }
        int[] mapseq1 = new int[as1.size() + (lastmatch ? 1 : 0)];
        int[] mapseq2 = new int[as2.size() + (lastmatch ? 1 : 0)];
        int i = 0;
        for (Integer ip : as1) {
            mapseq1[i++] = ip;
        }
        i = 0;
        for (Integer ip : as2) {
            mapseq2[i++] = ip;
        }
        if (lastmatch) {
            mapseq1[mapseq1.length - 1] = alignpos;
            mapseq2[mapseq2.length - 1] = pdbpos;
        }
        MapList map = new MapList(mapseq1, mapseq2, 1, 1);
        Mapping mapping = new Mapping(map);
        mapping.setTo(this.s2);
        return mapping;
    }

    public static List<List<? extends Object>> replaceMatchingSeqsWith(List<SequenceI> seqs, List<AlignmentAnnotation> annotations, List<SequenceI> ochains, AlignmentI al, String dnaOrProtein, boolean removeOldAnnots) {
        ArrayList<SequenceI> orig = new ArrayList<SequenceI>();
        ArrayList<SequenceI> repl = new ArrayList<SequenceI>();
        ArrayList<AlignSeq> aligs = new ArrayList<AlignSeq>();
        if (al != null && al.getHeight() > 0) {
            ArrayList<SequenceI> matches = new ArrayList<SequenceI>();
            ArrayList<AlignSeq> aligns = new ArrayList<AlignSeq>();
            for (SequenceI sq : ochains) {
                SequenceI bestm = null;
                AlignSeq bestaseq = null;
                float bestscore = 0.0f;
                for (SequenceI msq : al.getSequences()) {
                    AlignSeq aseq = AlignSeq.doGlobalNWAlignment(msq, sq, dnaOrProtein);
                    if (bestm != null && !(aseq.getMaxScore() > bestscore)) continue;
                    bestscore = aseq.getMaxScore();
                    bestaseq = aseq;
                    bestm = msq;
                }
                matches.add(bestm);
                aligns.add(bestaseq);
                al.deleteSequence(bestm);
            }
            int pSize = seqs.size();
            for (int p = 0; p < pSize; ++p) {
                SequenceI sp = seqs.get(p);
                int q = ochains.indexOf(sp);
                if (q <= -1) continue;
                SequenceI sq = (SequenceI)matches.get(q);
                seqs.set(p, sq);
                orig.add(sp);
                repl.add(sq);
                sq.setName(sp.getName());
                sq.setDescription(sp.getDescription());
                Mapping sp2sq = ((AlignSeq)aligns.get(q)).getMappingFromS1(false);
                sq.transferAnnotation(sp, sp2sq);
                aligs.add((AlignSeq)aligns.get(q));
                int inspos = -1;
                int ap = 0;
                while (ap < annotations.size()) {
                    if (annotations.get((int)ap).sequenceRef == sp) {
                        if (inspos == -1) {
                            inspos = ap;
                        }
                        if (removeOldAnnots) {
                            annotations.remove(ap);
                            continue;
                        }
                        AlignmentAnnotation alan = annotations.remove(ap);
                        alan.liftOver(sq, sp2sq);
                        alan.setSequenceRef(sq);
                        sq.addAlignmentAnnotation(alan);
                        continue;
                    }
                    ++ap;
                }
                if (sq.getAnnotation() == null || sq.getAnnotation().length <= 0) continue;
                annotations.addAll(inspos == -1 ? annotations.size() : inspos, Arrays.asList(sq.getAnnotation()));
            }
        }
        return Arrays.asList(orig, repl, aligs);
    }

    public static float[] computeRedundancyMatrix(SequenceI[] originalSequences, String[] omitHidden, int start, int end, boolean ungapped) {
        int height = originalSequences.length;
        float[] redundancy = new float[height];
        int[] lngth = new int[height];
        for (int i = 0; i < height; ++i) {
            redundancy[i] = 0.0f;
            lngth[i] = -1;
        }
        SimilarityParams pidParams = new SimilarityParams(true, true, true, true);
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < i; ++j) {
                String ug;
                String seqj;
                String seqi;
                if (i == j) continue;
                if (omitHidden == null) {
                    seqi = originalSequences[i].getSequenceAsString(start, end);
                    seqj = originalSequences[j].getSequenceAsString(start, end);
                } else {
                    seqi = omitHidden[i];
                    seqj = omitHidden[j];
                }
                if (lngth[i] == -1) {
                    ug = AlignSeq.extractGaps(Comparison.GapChars, seqi);
                    lngth[i] = ug.length();
                    if (ungapped) {
                        seqi = ug;
                    }
                }
                if (lngth[j] == -1) {
                    ug = AlignSeq.extractGaps(Comparison.GapChars, seqj);
                    lngth[j] = ug.length();
                    if (ungapped) {
                        seqj = ug;
                    }
                }
                float pid = (float)PIDModel.computePID(seqi, seqj, pidParams);
                if (lngth[j] < lngth[i]) {
                    redundancy[j] = Math.max(pid, redundancy[j]);
                    continue;
                }
                redundancy[i] = Math.max(pid, redundancy[i]);
            }
        }
        return redundancy;
    }

    public void meanScore() {
        int length = this.indelfreeAstr1.length();
        HashMap<Character, Integer> seq1ResCount = new HashMap<Character, Integer>();
        HashMap<Character, Integer> seq2ResCount = new HashMap<Character, Integer>();
        for (char residue : this.indelfreeAstr1.toCharArray()) {
            seq1ResCount.putIfAbsent(Character.valueOf(residue), 0);
            seq1ResCount.replace(Character.valueOf(residue), (Integer)seq1ResCount.get(Character.valueOf(residue)) + 1);
        }
        for (char residue : this.indelfreeAstr2.toCharArray()) {
            seq2ResCount.putIfAbsent(Character.valueOf(residue), 0);
            seq2ResCount.replace(Character.valueOf(residue), (Integer)seq2ResCount.get(Character.valueOf(residue)) + 1);
        }
        float _meanscore = 0.0f;
        Iterator iterator = seq1ResCount.keySet().iterator();
        while (iterator.hasNext()) {
            char resA = ((Character)iterator.next()).charValue();
            Iterator iterator2 = seq2ResCount.keySet().iterator();
            while (iterator2.hasNext()) {
                char resB = ((Character)iterator2.next()).charValue();
                int countA = (Integer)seq1ResCount.get(Character.valueOf(resA));
                int countB = (Integer)seq2ResCount.get(Character.valueOf(resB));
                float scoreAB = this.scoreMatrix.getPairwiseScore(resA, resB);
                _meanscore += (float)(countA * countB) * scoreAB;
            }
        }
        this.meanScore = _meanscore /= (float)length;
    }

    public float getMeanScore() {
        return this.meanScore;
    }

    public void hypotheticMaxScore() {
        int _hmsA = 0;
        int _hmsB = 0;
        for (char residue : this.indelfreeAstr1.toCharArray()) {
            _hmsA = (int)((float)_hmsA + this.scoreMatrix.getPairwiseScore(residue, residue));
        }
        for (char residue : this.indelfreeAstr2.toCharArray()) {
            _hmsB = (int)((float)_hmsB + this.scoreMatrix.getPairwiseScore(residue, residue));
        }
        this.hypotheticMaxScore = _hmsA < _hmsB ? _hmsA : _hmsB;
    }

    public int getHypotheticMaxScore() {
        return this.hypotheticMaxScore;
    }

    public void getIndelfreeAstr() {
        int n = this.astr1.length();
        for (int i = 0; i < n; ++i) {
            if (!Character.isLetter(this.astr1.charAt(i)) || !Character.isLetter(this.astr2.charAt(i))) continue;
            this.indelfreeAstr1 = this.indelfreeAstr1 + this.astr1.charAt(i);
            this.indelfreeAstr2 = this.indelfreeAstr2 + this.astr2.charAt(i);
        }
    }

    public void scoreAlignment() {
        this.getIndelfreeAstr();
        this.meanScore();
        this.hypotheticMaxScore();
        if ((float)this.hypotheticMaxScore == this.meanScore) {
            this.alignmentScore = Float.NaN;
            return;
        }
        int n = this.indelfreeAstr1.length();
        float score = 0.0f;
        boolean aGapOpen = false;
        boolean bGapOpen = false;
        for (int i = 0; i < n; ++i) {
            char char1 = this.indelfreeAstr1.charAt(i);
            char char2 = this.indelfreeAstr2.charAt(i);
            boolean aIsLetter = Character.isLetter(char1);
            boolean bIsLetter = Character.isLetter(char2);
            if (aIsLetter && bIsLetter) {
                score += this.scoreMatrix.getPairwiseScore(char1, char2);
            } else if (aIsLetter || bIsLetter) {
                score = !aIsLetter && aGapOpen || !bIsLetter && bGapOpen ? (score -= (float)this.GAP_EXTEND_COST) : (score -= (float)this.GAP_OPEN_COST);
            }
            aGapOpen = !aIsLetter;
            bGapOpen = !bIsLetter;
        }
        float preprescore = score;
        score = (score - this.meanScore) / ((float)this.hypotheticMaxScore - this.meanScore);
        int[] _max = MiscMath.findMax(new int[]{this.astr1.replace("-", "").length(), this.astr2.replace("-", "").length()});
        float coverage = (float)n / (float)_max[1];
        float prescore = score;
        float minScore = 0.0f;
        this.alignmentScore = (score *= coverage) <= minScore ? Float.NaN : score;
    }

    public void setScoreMatrix(ScoreMatrix sm) {
        if (sm != null) {
            this.scoreMatrix = sm;
        }
    }
}

