/*
 * Decompiled with CFR 0.152.
 */
package ext.edu.ucsf.rbvi.strucviz2;

import ext.edu.ucsf.rbvi.strucviz2.ChimeraChain;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraManager;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraModel;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraResidue;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraStructuralObject;
import ext.edu.ucsf.rbvi.strucviz2.StructureSettings;
import jalview.bin.Cache;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureManager {
    private static String[] CHIMERA_VERSIONS = new String[]{"1.18", "1.17.4", "1.17.3", "1.17.2", "1.17.1", "1.17", "1.16.2", "1.16.1", "1.16", "1.15.2", "1.15.1", "1.15", "1.14.2", "1.14.1", "1.14", "1.13.1", "1.13", "1.12.2", "1.12.1", "1.12", "1.11.2", "1.11.2", "1.11.1", "1.11"};
    private static String[] CHIMERAX_VERSIONS = new String[]{"1.7", "1.6.1", "1.6", "1.5", "1.4", "1.3", "1.2.5", "1.0", "0.93", "0.92", "0.91", "0.9"};
    static final String[] defaultStructureKeys = new String[]{"Structure", "pdb", "pdbFileName", "PDB ID", "structure", "biopax.xref.PDB", "pdb_ids", "ModelName", "ModelNumber"};
    static final String[] defaultChemStructKeys = new String[]{"Smiles", "smiles", "SMILES"};
    static final String[] defaultResidueKeys = new String[]{"FunctionalResidues", "ResidueList", "Residues"};
    public static Properties pathProps;
    private String chimeraCommandAttr = "ChimeraCommand";
    private String chimeraOutputTable = "ChimeraTable";
    private String chimeraOutputAttr = "ChimeraOutput";
    private boolean haveGUI = true;
    private ChimeraManager chimeraManager = null;
    private static List<ChimeraStructuralObject> chimSelectionList;
    private boolean ignoreCySelection = false;
    private File configurationDirectory = null;
    private static Logger logger;
    StructureSettings defaultSettings = null;

    public StructureManager(boolean haveGUI) {
        this.haveGUI = haveGUI;
        this.chimeraManager = new ChimeraManager(this);
        chimSelectionList = new ArrayList<ChimeraStructuralObject>();
        pathProps = new Properties();
    }

    public ChimeraManager getChimeraManager() {
        return this.chimeraManager;
    }

    public boolean openStructures(Collection<List<String>> chimObjNames, ModelType type) {
        HashMap<String, List<ChimeraModel>> newModels = new HashMap<String, List<ChimeraModel>>();
        if (chimObjNames.size() > 0) {
            List<String> names = chimObjNames.iterator().next();
            if (names == null) {
                return false;
            }
            for (String chimObjName : names) {
                List<ChimeraModel> currentModels = this.chimeraManager.getChimeraModels(chimObjName, type);
                if (currentModels.size() != 0 || (currentModels = this.chimeraManager.openModel(chimObjName, type)) == null) continue;
                newModels.put(chimObjName, currentModels);
                for (ChimeraModel chimeraModel : currentModels) {
                }
            }
        } else {
            return false;
        }
        return true;
    }

    public void closeStructures(Set<String> chimObjNames) {
        for (String modelName : chimObjNames) {
            List<ChimeraModel> models = this.chimeraManager.getChimeraModels(modelName);
            for (ChimeraModel model : models) {
                this.closeModel(model);
            }
        }
    }

    public File saveChimeraImage() {
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("structureViz", ".png");
            this.chimeraManager.sendChimeraCommand("set bgTransparency", false);
            this.chimeraManager.sendChimeraCommand("copy file " + tmpFile.getAbsolutePath() + " png", true);
            this.chimeraManager.sendChimeraCommand("unset bgTransparency", false);
        }
        catch (IOException ioe) {
            logger.error("Error writing image", (Throwable)ioe);
        }
        return tmpFile;
    }

    public void closeModel(ChimeraModel model) {
        this.chimeraManager.closeModel(model);
    }

    public void exitChimera() {
        this.chimeraManager.exitChimera();
    }

    public void clearOnChimeraExit() {
        chimSelectionList.clear();
    }

    public void updateCytoscapeSelection() {
        this.ignoreCySelection = true;
        this.ignoreCySelection = false;
    }

    public void cytoscapeSelectionChanged(Map<Long, Boolean> selectedRows) {
        this.updateChimeraSelection();
        this.selectionChanged();
    }

    public void updateChimeraSelection() {
        String selSpec = "";
        for (int i = 0; i < chimSelectionList.size(); ++i) {
            ChimeraStructuralObject nodeInfo = chimSelectionList.get(i);
            selSpec = selSpec.concat(nodeInfo.toSpec());
            if (i >= chimSelectionList.size() - 1) continue;
            selSpec.concat("|");
        }
        if (selSpec.length() > 0) {
            this.chimeraManager.select("sel " + selSpec);
        } else {
            this.chimeraManager.select("~sel");
        }
    }

    public void chimeraSelectionChanged() {
        this.clearSelectionList();
        Map<Integer, ChimeraModel> selectedModelsMap = this.chimeraManager.getSelectedModels();
        this.chimeraManager.getSelectedResidues(selectedModelsMap);
        try {
            for (ChimeraModel selectedModel : selectedModelsMap.values()) {
                int modelNumber = selectedModel.getModelNumber();
                int subModelNumber = selectedModel.getSubModelNumber();
                if (!this.chimeraManager.hasChimeraModel(modelNumber, subModelNumber)) continue;
                ChimeraModel dataModel = this.chimeraManager.getChimeraModel(modelNumber, subModelNumber);
                if (dataModel.getResidueCount() == selectedModel.getResidueCount() || dataModel.getModelType() == ModelType.SMILES) {
                    this.addChimSelection(dataModel);
                    continue;
                }
                for (ChimeraChain selectedChain : selectedModel.getChains()) {
                    ChimeraChain dataChain = dataModel.getChain(selectedChain.getChainId());
                    if (selectedChain.getResidueCount() == dataChain.getResidueCount()) {
                        this.addChimSelection(dataChain);
                    }
                    for (ChimeraResidue res : selectedChain.getResidues()) {
                        String residueIndex = res.getIndex();
                        ChimeraResidue residue = dataChain.getResidue(residueIndex);
                        if (residue == null) continue;
                        this.addChimSelection(residue);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.warn("Could not update selection", (Throwable)ex);
        }
        this.selectionChanged();
        this.updateCytoscapeSelection();
    }

    public void selectFunctResidues(Collection<ChimeraModel> models) {
        this.clearSelectionList();
        for (ChimeraModel model : models) {
            for (ChimeraResidue residue : model.getFuncResidues()) {
                this.addChimSelection(residue);
            }
        }
        this.updateChimeraSelection();
        this.updateCytoscapeSelection();
        this.selectionChanged();
    }

    public List<ChimeraStructuralObject> getChimSelectionList() {
        return chimSelectionList;
    }

    public int getChimSelectionCount() {
        return chimSelectionList.size();
    }

    public void addChimSelection(ChimeraStructuralObject selectionToAdd) {
        if (selectionToAdd != null && !chimSelectionList.contains(selectionToAdd)) {
            chimSelectionList.add(selectionToAdd);
            selectionToAdd.setSelected(true);
        }
    }

    public void removeChimSelection(ChimeraStructuralObject selectionToRemove) {
        if (selectionToRemove != null && chimSelectionList.contains(selectionToRemove)) {
            chimSelectionList.remove(selectionToRemove);
            selectionToRemove.setSelected(false);
        }
    }

    public void clearSelectionList() {
        for (ChimeraStructuralObject cso : chimSelectionList) {
            if (cso == null) continue;
            cso.setSelected(false);
        }
        chimSelectionList.clear();
    }

    public void updateModels() {
        this.chimeraManager.stopListening();
        List<ChimeraModel> newModelList = this.chimeraManager.getModelList();
        for (ChimeraModel newModel : newModelList) {
            newModel.setModelColor(this.chimeraManager.getModelColor(newModel));
            int modelNumber = newModel.getModelNumber();
            int subModelNumber = newModel.getSubModelNumber();
            if (this.chimeraManager.hasChimeraModel(modelNumber, subModelNumber)) {
                ChimeraModel oldModel = this.chimeraManager.getChimeraModel(modelNumber, subModelNumber);
                this.chimeraManager.removeChimeraModel(modelNumber, subModelNumber);
                newModel.setModelType(oldModel.getModelType());
                if (oldModel.getModelType() == ModelType.SMILES) {
                    newModel.setModelName(oldModel.getModelName());
                }
            }
            this.chimeraManager.addChimeraModel(modelNumber, subModelNumber, newModel);
            if (newModel.getModelType() == ModelType.SMILES) continue;
            this.chimeraManager.addResidues(newModel);
        }
        this.chimeraManager.startListening();
    }

    public void launchModelNavigatorDialog() {
    }

    public boolean isMNDialogOpen() {
        return false;
    }

    public void modelChanged() {
    }

    public void selectionChanged() {
    }

    public void launchAlignDialog(boolean useChains) {
        ArrayList<ChimeraStructuralObject> chimObjectList = new ArrayList<ChimeraStructuralObject>();
        for (ChimeraModel model : this.chimeraManager.getChimeraModels()) {
            if (useChains) {
                for (ChimeraChain chain : model.getChains()) {
                    chimObjectList.add(chain);
                }
                continue;
            }
            chimObjectList.add(model);
        }
    }

    public List<String> getAllStructureKeys() {
        return Arrays.asList(defaultStructureKeys);
    }

    public List<String> getAllChemStructKeys() {
        return Arrays.asList(defaultChemStructKeys);
    }

    public List<String> getAllResidueKeys() {
        return Arrays.asList(defaultResidueKeys);
    }

    public List<String> getAllChimeraResidueAttributes() {
        ArrayList<String> attributes = new ArrayList<String>();
        attributes.addAll(this.chimeraManager.getAttrList());
        return attributes;
    }

    public static List<String> getChimeraPaths(boolean isChimeraX) {
        String chimeraExe;
        ArrayList<String> pathList = new ArrayList<String>();
        String os = System.getProperty("os.name");
        String userPath = Cache.getDefault(isChimeraX ? "CHIMERAX_PATH" : "CHIMERA_PATH", null);
        String chimera = isChimeraX ? "ChimeraX" : "Chimera";
        String string = chimeraExe = isChimeraX ? "ChimeraX" : "chimera";
        if (userPath != null) {
            String possiblePath;
            boolean adjusted = false;
            if (os.startsWith("Mac") && userPath.endsWith(".app") && new File(possiblePath = String.format("%s/Contents/MacOS/%s", userPath, chimeraExe)).exists()) {
                pathList.add(possiblePath);
                adjusted = true;
            }
            if (!adjusted) {
                pathList.add(userPath);
            }
        }
        if (os.startsWith("Linux")) {
            pathList.add(String.format("/usr/bin/%s", chimeraExe.toLowerCase(Locale.ROOT)));
            pathList.add(String.format("/usr/bin/%s", chimeraExe));
            pathList.add(String.format("/usr/local/bin/%s", chimeraExe.toLowerCase(Locale.ROOT)));
            pathList.add(String.format("/usr/local/bin/%s", chimeraExe));
            pathList.add(String.format("/usr/lib/ucsf-%s/bin/%s", chimera.toLowerCase(Locale.ROOT), chimeraExe));
            pathList.add(String.format("/usr/libexec/UCSF-%s/bin/%s", chimera, chimeraExe));
            pathList.add(String.format("/usr/local/chimera/bin/%s", chimeraExe));
            pathList.add(String.format("%s/bin/%s", System.getProperty("user.home"), chimeraExe.toLowerCase(Locale.ROOT)));
            pathList.add(String.format("%s/bin/%s", System.getProperty("user.home"), chimeraExe));
            pathList.add(String.format("%s/opt/bin/%s", System.getProperty("user.home"), chimeraExe.toLowerCase(Locale.ROOT)));
            pathList.add(String.format("%s/opt/bin/%s", System.getProperty("user.home"), chimeraExe));
            pathList.add(String.format("%s/local/bin/%s", System.getProperty("user.home"), chimeraExe.toLowerCase(Locale.ROOT)));
            pathList.add(String.format("%s/local/bin/%s", System.getProperty("user.home"), chimeraExe));
        } else if (os.startsWith("Windows")) {
            for (String root : new String[]{"\\Program Files", "C:\\Program Files", "\\Program Files (x86)", "C:\\Program Files (x86)", String.format("%s\\AppData\\Local", System.getProperty("user.home"))}) {
                String[] candidates;
                for (String version : candidates = isChimeraX ? CHIMERAX_VERSIONS : CHIMERA_VERSIONS) {
                    String path = String.format("%s\\%s %s\\bin\\%s", root, chimera, version, chimeraExe);
                    pathList.add(path);
                    pathList.add(path + ".exe");
                }
                String path = String.format("%s\\%s\\bin\\%s", root, chimera, chimeraExe);
                pathList.add(path);
                pathList.add(path + ".exe");
            }
        } else if (os.startsWith("Mac")) {
            String[] candidates;
            for (String version : candidates = isChimeraX ? CHIMERAX_VERSIONS : CHIMERA_VERSIONS) {
                pathList.add(String.format("/Applications/%s-%s.app/Contents/MacOS/%s", chimera, version, chimeraExe));
                pathList.add(String.format("%s/Applications/%s-%s.app/Contents/MacOS/%s", System.getProperty("user.home"), chimera, version, chimeraExe));
            }
            pathList.add(String.format("/Applications/%s.app/Contents/MacOS/%s", chimera, chimeraExe));
            pathList.add(String.format("%s/Applications/%s.app/Contents/MacOS/%s", System.getProperty("user.home"), chimera, chimeraExe));
        }
        return pathList;
    }

    public void setChimeraPathProperty(String path) {
    }

    public void setStructureSettings(StructureSettings structureSettings) {
        this.defaultSettings = structureSettings;
    }

    public String getCurrentChimeraPath(Object object) {
        if (this.defaultSettings != null) {
            return this.defaultSettings.getChimeraPath();
        }
        return "";
    }

    static {
        logger = LoggerFactory.getLogger(StructureManager.class);
    }

    public static enum ModelType {
        PDB_MODEL,
        MODBASE_MODEL,
        SMILES;

    }
}

