/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.SequenceAnnotation;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.ScoreManager;
import compbio.data.sequence.SequenceUtil;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.WrongParameterException;
import compbio.ws.client.CmdHelper;
import compbio.ws.client.IOHelper;
import compbio.ws.client.MetadataHelper;
import compbio.ws.server.AAConWS;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

public class AAConClient {
    private static final Logger log = Logger.getLogger(AAConClient.class.getCanonicalName());
    static final String QUALIFIED_SERVICE_NAME = "http://msa.data.compbio/01/12/2010/";
    static final String hostname = "http://www.compbio.dundee.ac.uk/aacon";
    static final String serviceName = "AAConWS";

    AAConClient(String[] cmd) throws IOException {
        boolean listLimits;
        boolean listPreset;
        boolean listParameters;
        File inputFile = IOHelper.getFile(cmd, "-i", true);
        File outFile = IOHelper.getFile(cmd, "-o", false);
        File parametersFile = IOHelper.getFile(cmd, "-f", true);
        String presetName = CmdHelper.getPresetName(cmd);
        SequenceAnnotation<AAConWS> msaws = AAConClient.connect();
        Preset<AAConWS> preset = null;
        if (presetName != null) {
            preset = MetadataHelper.getPreset(msaws, presetName);
        }
        List<Option<AAConWS>> customOptions = null;
        if (parametersFile != null) {
            List<String> prms = IOHelper.loadParameters(parametersFile);
            customOptions = MetadataHelper.processParameters(prms, msaws.getRunnerOptions());
        }
        ScoreManager result = null;
        if (inputFile != null) {
            System.out.println("Calculating conservation...");
            result = AAConClient.analize(inputFile, msaws, preset, customOptions);
            Writer outStream = null;
            outStream = outFile != null ? IOHelper.getWriter(outFile) : new PrintWriter(System.out, true);
            AAConClient.writeOut(outStream, result);
        }
        if (listParameters = CmdHelper.listParameters(cmd)) {
            System.out.println(MetadataHelper.getParametersList(msaws));
        }
        if (listPreset = CmdHelper.listPresets(cmd)) {
            System.out.println(MetadataHelper.getPresetList(msaws));
        }
        if (listLimits = CmdHelper.listLimits(cmd)) {
            System.out.println(MetadataHelper.getLimits(msaws));
        }
        log.fine("Disconnecting...");
        ((Closeable)((Object)msaws)).close();
        log.fine("Disconnected successfully!");
    }

    static void writeOut(Writer writer, ScoreManager result) {
        try {
            result.writeOut(writer);
        }
        catch (IOException e) {
            System.err.println("Problems writing output file! Stack trace is below: ");
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static SequenceAnnotation<AAConWS> connect() throws WebServiceException {
        URL url = null;
        log.log(Level.FINE, "Attempting to connect...");
        try {
            url = new URL("http://www.compbio.dundee.ac.uk/aacon/AAConWS?wsdl");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        QName qname = new QName(QUALIFIED_SERVICE_NAME, serviceName);
        Service serv = Service.create((URL)url, (QName)qname);
        QName portName = new QName(QUALIFIED_SERVICE_NAME, "AAConWSPort");
        SequenceAnnotation serviceIF = (SequenceAnnotation)serv.getPort(portName, SequenceAnnotation.class);
        log.log(Level.FINE, "Connected successfully!");
        return serviceIF;
    }

    static ScoreManager analize(File file, SequenceAnnotation<AAConWS> wsproxy, Preset<AAConWS> preset, List<Option<AAConWS>> customOptions) {
        List<FastaSequence> fastalist = null;
        ScoreManager scores = null;
        try {
            fastalist = SequenceUtil.openInputStream(file.getAbsolutePath());
            String jobId = null;
            if (customOptions != null && preset != null) {
                System.out.println("WARN: Parameters (-f) are defined together with a preset (-r) ignoring preset!");
            }
            jobId = customOptions != null ? wsproxy.customAnalize(fastalist, customOptions) : (preset != null ? wsproxy.presetAnalize(fastalist, preset) : wsproxy.analize(fastalist));
            Thread.sleep(1000L);
            scores = wsproxy.getAnnotation(jobId);
        }
        catch (IOException e) {
            System.err.println("Exception while reading the input file. Check that the input file contains a list of fasta formatted sequences! Exception details are below:");
            e.printStackTrace();
        }
        catch (JobSubmissionException e) {
            System.err.println("Exception while submitting job to a web server. Exception details are below:");
            e.printStackTrace();
        }
        catch (ResultNotAvailableException e) {
            System.err.println("Exception while waiting for results. Exception details are below:");
            e.printStackTrace();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        catch (WrongParameterException e) {
            System.err.println("Exception while parsing the web method input parameters. Exception details are below:");
            e.printStackTrace();
        }
        catch (UnknownFileFormatException e) {
            System.err.println("Exception while attempting to read the input file Exception details are below:");
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        return scores;
    }

    static void printUsage(int exitStatus) {
        System.out.println();
        System.out.println("Usage: <Class or Jar file name>  ACTION [OPTIONS] ");
        System.out.println();
        System.out.println("ACTIONS: ");
        System.out.println("-i=<inputFile> - full path to fasta or Clustal formatted alignment file ");
        System.out.println("-parameters - lists parameters supported by web service");
        System.out.println("-presets - lists presets supported by web service");
        System.out.println("-limits - lists web services limits");
        System.out.println("Please note that if input file is specified other actions are ignored\n");
        System.out.println("OPTIONS (only for use with -i action):");
        System.out.println("-r=<presetName> - name of the preset to use");
        System.out.println("-o=<outputFile> - full path to the file where to write the result");
        System.out.println("-f=<parameterInputFile> - the name of the file with the list of parameters to use.");
        System.out.println("Please note that -r and -f options cannot be used together. Conservation is calculated with either a preset or parameters from the file, but not both!");
        System.exit(exitStatus);
    }

    public static void main(String[] args) {
        if (args == null) {
            AAConClient.printUsage(1);
        }
        if (args.length < 1) {
            System.out.println("No options is specified! ");
            AAConClient.printUsage(1);
        }
        try {
            new AAConClient(args);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "IOException in client! " + e.getMessage(), e.getCause());
            System.err.println("Cannot write output file! Stack trace: ");
            e.printStackTrace();
        }
    }
}

