/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.metadata.Argument;
import compbio.metadata.WrongParameterException;
import compbio.util.SysPrefs;
import compbio.util.Util;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Option<T>
implements Argument<T> {
    @XmlElement(required=true)
    protected String description;
    @XmlElement(required=true)
    Set<String> optionNames = new HashSet<String>();
    @XmlElement(required=true)
    protected String name;
    @XmlAttribute
    protected boolean isRequired;
    @XmlElement
    protected String furtherDetails;
    @XmlElement
    protected String defaultValue;
    @XmlTransient
    private URL basicURL;

    Option() {
    }

    public Option(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBasicURL(URL url) {
        this.basicURL = url;
    }

    public URL getBasicURL() {
        URL out = null;
        if (null != this.basicURL) {
            out = this.basicURL;
        }
        return out;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getFurtherDetails() {
        return this.furtherDetails;
    }

    public void setFurtherDetails(String furtherDetails) {
        this.furtherDetails = furtherDetails;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultVal) throws WrongParameterException {
        if (this.optionNames.isEmpty()) {
            throw new IllegalStateException("Please define optionNames first!");
        }
        if (!Option.valueExist(defaultVal, this.getOptionNames())) {
            throw new WrongParameterException("Attempting to set illegal defaultValue '" + defaultVal + "' which is not defined optionNames for option: " + this);
        }
        this.defaultValue = defaultVal;
    }

    static boolean valueExist(String testValue, List<String> values) {
        assert (!Util.isEmpty(testValue));
        for (String val : values) {
            if (!testValue.equalsIgnoreCase(val)) continue;
            return true;
        }
        return false;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public List<String> getOptionNames() {
        return new ArrayList<String>(this.optionNames);
    }

    public void setOptionNames(Set<String> optionNames) {
        this.optionNames = new HashSet<String>(optionNames);
    }

    public Set<String> addOptionNames(String ... value) {
        for (String v : value) {
            boolean added = this.optionNames.add(v);
            assert (added) : "Duplicated optionName is detected!";
        }
        return this.optionNames;
    }

    public String toString() {
        String value = "Option name: " + this.name + SysPrefs.newlinechar;
        value = value + "Description: " + this.description + SysPrefs.newlinechar;
        if (!Util.isEmpty(this.defaultValue)) {
            value = value + "Default value: " + this.defaultValue + SysPrefs.newlinechar;
        }
        value = null != this.furtherDetails ? (null != this.basicURL ? value + "URL: " + this.basicURL + this.furtherDetails + SysPrefs.newlinechar : value + "Relative URL: " + this.furtherDetails + SysPrefs.newlinechar) : value + "URL: unknown URL" + SysPrefs.newlinechar;
        value = value + "Is required: " + this.isRequired + SysPrefs.newlinechar;
        if (!this.optionNames.isEmpty()) {
            TreeSet<String> sortedPosval = new TreeSet<String>(this.optionNames);
            value = value + "Option(s): ";
            String delim = "";
            for (String val : sortedPosval) {
                value = value + delim + val;
                delim = ", ";
            }
            value = value + SysPrefs.newlinechar;
        }
        return value;
    }

    public String toCommand(String nameValueSeparator) {
        if (this.optionNames.size() == 1) {
            return this.optionNames.iterator().next();
        }
        return this.getDefaultValue();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Option objArg = null;
        if (!(obj instanceof Option)) {
            return false;
        }
        objArg = (Option)obj;
        if (!(Util.isEmpty(objArg.name) || Util.isEmpty(this.name) || objArg.name.equals(this.name))) {
            return false;
        }
        if (!(Util.isEmpty(objArg.description) || Util.isEmpty(this.description) || objArg.description.equals(this.description))) {
            return false;
        }
        if (objArg.isRequired != this.isRequired) {
            return false;
        }
        if (!(Util.isEmpty(objArg.defaultValue) || Util.isEmpty(this.defaultValue) || objArg.defaultValue.equals(this.defaultValue))) {
            return false;
        }
        if (objArg.optionNames.size() != this.optionNames.size()) {
            return false;
        }
        int matchCount = 0;
        block0: for (String oname : objArg.optionNames) {
            if (Util.isEmpty(oname)) continue;
            for (String thisoname : this.optionNames) {
                if (!oname.equals(thisoname)) continue;
                ++matchCount;
                continue block0;
            }
        }
        return matchCount == objArg.optionNames.size();
    }

    public int hashCode() {
        int code = this.name.hashCode() * this.description.hashCode();
        if (this.isRequired) {
            code += this.furtherDetails.hashCode() * 3;
        } else if (this.defaultValue != null) {
            code += this.defaultValue.hashCode() * 2;
        }
        if (this.description != null) {
            code += this.description.hashCode() * 4;
        }
        return code;
    }

    @Override
    public List<String> getPossibleValues() {
        return new ArrayList<String>(this.optionNames);
    }

    @Override
    public void setValue(String dValue) throws WrongParameterException {
        this.setDefaultValue(dValue);
    }

    void validate() throws ValidationException {
        if (this.optionNames == null) {
            throw new ValidationException("Option names are not defined for option: " + this);
        }
        if (this.optionNames.size() > 1 && Util.isEmpty(this.getDefaultValue())) {
            throw new ValidationException("Default value is required as multiple optionNames are defined for option: " + this);
        }
        if (Util.isEmpty(this.name)) {
            throw new ValidationException("No name is defined for option: " + this);
        }
    }
}

