/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.RNAStructScoreManager;
import compbio.data.sequence.Range;
import compbio.data.sequence.Score;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class RNAStructReader {
    static String s = "[+\\s=]+";
    static String bracket = "\\(|\\)|\\{|\\}|\\[|\\]";
    static String notData = "[\\s=+]+";
    static String seqP = "[_\\-a-zA-Z]{2,}";
    static String structP = "[\\.)({}\\[\\],]{2,}";
    static String floatP = "-?\\d+\\.\\d*(e[+\\-]\\d+)?";
    static String energyP = "-?[0-9]*\\.?[0-9]{2}";
    static String freqP = "^-?\\d\\.\\d{6,}(e[+\\-]\\d+)?$";
    static String ps = "\\s*";
    static String alignmentP = "^" + seqP + ps + "$";
    static String mfeStructP = "^" + structP + s + "\\(" + ps + floatP + s + floatP + s + floatP + ps + "\\)" + ps + "$";
    static String justStructP = "^" + structP + ps + "$";
    static String stochBTStructP = "^" + structP + s + floatP + s + floatP + ps + "$";
    static String PStructP = "^" + structP + s + "\\[" + ps + floatP + ps + "\\]" + ps + "$";
    static String centStructP = "^" + structP + s + floatP + ps + "\\{" + ps + floatP + s + floatP + ps + "\\}" + ps + "$";
    static String MEAStructP = "^" + structP + s + "\\{" + ps + floatP + s + "MEA=" + floatP + ps + "\\}" + ps + "$";
    static String freeEnergyP = "^" + ps + "free energy of ensemble" + ps + "=" + ps + floatP + ps + "kcal/mol" + ps + "$";
    static String ensembleFreqP = "^" + ps + "frequency of mfe structure in ensemble " + floatP + ps + "$";

    public static RNAStructScoreManager readRNAStructStream(InputStream stdout) throws IOException {
        String error = "Error in parsing alifold stdout file: ";
        ArrayList<String> structs = new ArrayList<String>();
        ArrayList<TreeSet<Score>> data = new ArrayList<TreeSet<Score>>();
        ArrayList<Float> scores = new ArrayList<Float>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stdout));
        String fline = reader.readLine();
        assert (Pattern.matches(AlifoldLine.alignment.regex, fline)) : error + "Sequence Alignment Expected";
        structs.add(fline.trim());
        data.add(RNAStructReader.newEmptyScore(AlifoldResult.consensusAlignment));
        fline = reader.readLine();
        assert (Pattern.matches(AlifoldLine.mfeStruct.regex, fline)) : error + "Consensus Structure and Energy Expected";
        Scanner sc = new Scanner(fline);
        structs.add(sc.next());
        for (int i = 0; i < 3; ++i) {
            scores.add(Float.valueOf(Float.parseFloat(sc.findInLine(floatP))));
        }
        data.add(RNAStructReader.newSetScore(AlifoldResult.mfeStructure, scores));
        fline = reader.readLine();
        Scanner nsc = null;
        while (fline != null) {
            int i;
            scores.clear();
            AlifoldLine ftype = RNAStructReader.identifyLine(fline);
            String sline = reader.readLine();
            sc = new Scanner(fline);
            if (sline != null) {
                nsc = new Scanner(sline);
            }
            if (ftype.equals((Object)AlifoldLine.PStruct)) {
                assert (sline != null && Pattern.matches(AlifoldLine.ensembleFreq.regex, sline)) : error + "Expected frequency of mfe structure";
                structs.add(sc.next());
                scores.add(Float.valueOf(Float.parseFloat(sc.findInLine(floatP))));
                scores.add(Float.valueOf(Float.parseFloat(nsc.findInLine(floatP))));
                data.add(RNAStructReader.newSetScore(AlifoldResult.contactProbabilityStructure, scores));
                sline = reader.readLine();
            } else if (ftype.equals((Object)AlifoldLine.centStruct)) {
                structs.add(sc.next());
                for (i = 0; i < 3; ++i) {
                    scores.add(Float.valueOf(Float.parseFloat(sc.findInLine(floatP))));
                }
                data.add(RNAStructReader.newSetScore(AlifoldResult.centroidStructure, scores));
            } else if (ftype.equals((Object)AlifoldLine.MEAStruct)) {
                structs.add(sc.next());
                for (i = 0; i < 2; ++i) {
                    scores.add(Float.valueOf(Float.parseFloat(sc.findInLine(floatP))));
                }
                data.add(RNAStructReader.newSetScore(AlifoldResult.MEAStucture, scores));
            } else if (ftype.equals((Object)AlifoldLine.justStruct)) {
                structs.add(sc.next());
                data.add(RNAStructReader.newEmptyScore(AlifoldResult.stochBTStructure));
            } else if (ftype.equals((Object)AlifoldLine.stochBTStruct)) {
                structs.add(sc.next());
                scores.add(Float.valueOf(sc.nextFloat()));
                scores.add(Float.valueOf(sc.nextFloat()));
                data.add(RNAStructReader.newSetScore(AlifoldResult.stochBTStructure, scores));
            } else if (ftype.equals((Object)AlifoldLine.freeEnergy)) {
                assert (sline != null && Pattern.matches(AlifoldLine.ensembleFreq.regex, sline)) : error + "Found 'freeEnergy' line on its own";
                structs.add("Free energy of ensemble (kcal/mol) followed by frequency of mfe structure in ensemble");
                scores.add(Float.valueOf(Float.parseFloat(sc.findInLine(floatP))));
                scores.add(Float.valueOf(Float.parseFloat(nsc.findInLine(floatP))));
                data.add(RNAStructReader.newSetScore(AlifoldResult.ensembleValues, scores));
                sline = reader.readLine();
            }
            assert (!ftype.equals((Object)AlifoldLine.ensembleFreq)) : error + "Wasn't expecting 'frequency of mfe structure'!";
            assert (!ftype.equals((Object)AlifoldLine.mfeStruct)) : error + "'Standard output' line at a place other than line 2!";
            assert (!ftype.equals((Object)AlifoldLine.alignment)) : error + "Wasn't expecting an alignment sequence!";
            assert (!ftype.equals((Object)AlifoldLine.OTHER)) : error + "Wasn't expecting this whatever it is: " + fline;
            fline = sline;
        }
        sc.close();
        if (nsc != null) {
            nsc.close();
        }
        return new RNAStructScoreManager(structs, data);
    }

    private static TreeSet<Score> newSetScore(Enum<?> res, List<Float> scores) {
        float[] scoresf = new float[scores.size()];
        for (int i = 0; i < scoresf.length; ++i) {
            Float f = scores.get(i);
            scoresf[i] = f != null ? f.floatValue() : Float.NaN;
        }
        return new TreeSet<Score>(Arrays.asList(new Score(res, scoresf)));
    }

    public static TreeSet<Score> newEmptyScore(Enum<?> res) {
        return new TreeSet<Score>(Arrays.asList(new Score(res, new float[0])));
    }

    public static RNAStructScoreManager readRNAStructStream(InputStream stdout, InputStream alifold) throws IOException {
        RNAStructScoreManager stdSM = RNAStructReader.readRNAStructStream(stdout);
        List<String> structs = stdSM.getStructs();
        List<TreeSet<Score>> data = stdSM.getData();
        Scanner sc = new Scanner(alifold);
        sc.useDelimiter("[\\s%]+");
        sc.nextLine();
        sc.nextLine();
        ArrayList<Float> scores = new ArrayList<Float>();
        ArrayList<Range> rangeHolder = new ArrayList<Range>();
        String s = "null";
        while (!Pattern.matches("^[\\.)(]{2,}$", s = sc.next()) && sc.hasNextLine()) {
            int t = sc.nextInt();
            rangeHolder.add(new Range(Integer.parseInt(s), t));
            sc.next();
            scores.add(Float.valueOf(sc.nextFloat()));
            sc.nextLine();
        }
        sc.close();
        assert (rangeHolder.size() == scores.size());
        TreeSet<Score> sHolder = new TreeSet<Score>();
        for (int i = 0; i < rangeHolder.size(); ++i) {
            ArrayList<Float> singleS = new ArrayList<Float>(Arrays.asList((Float)scores.get(i)));
            TreeSet<Range> singleR = new TreeSet<Range>(Arrays.asList((Range)rangeHolder.get(i)));
            sHolder.add(new Score(AlifoldResult.contactProbabilities, singleS, singleR));
        }
        data.set(0, sHolder);
        return new RNAStructScoreManager(structs, data);
    }

    private static RNAOut identify(String token) {
        if (Pattern.matches(seqP, token)) {
            return RNAOut.SEQ;
        }
        if (Pattern.matches(structP, token)) {
            return RNAOut.STRUCT;
        }
        if (Pattern.matches(energyP, token)) {
            return RNAOut.ENERGY;
        }
        if (Pattern.matches(freqP, token)) {
            return RNAOut.FREQ;
        }
        return RNAOut.OTHER;
    }

    private static AlifoldLine identifyLine(String line) {
        for (AlifoldLine il : AlifoldLine.values()) {
            if (!Pattern.matches(il.regex, line)) continue;
            return il;
        }
        return AlifoldLine.OTHER;
    }

    public static void main(String[] args) {
        for (AlifoldLine l : AlifoldLine.values()) {
            System.out.println(l.toString() + ": " + l.regex.replace("^", "").replace("$", ""));
        }
    }

    public static enum AlifoldResult {
        mfeStructure,
        contactProbabilityStructure,
        MEAStucture,
        centroidStructure,
        stochBTStructure,
        consensusAlignment,
        ensembleValues,
        contactProbabilities;

    }

    static enum RNAOut {
        SEQ,
        STRUCT,
        ENERGY,
        FREQ,
        OTHER;

    }

    static enum AlifoldLine {
        mfeStruct(mfeStructP),
        justStruct(justStructP),
        stochBTStruct(stochBTStructP),
        PStruct(PStructP),
        centStruct(centStructP),
        MEAStruct(MEAStructP),
        freeEnergy(freeEnergyP),
        ensembleFreq(ensembleFreqP),
        alignment(alignmentP),
        OTHER(".*");

        String regex;

        private AlifoldLine(String regex) {
            this.regex = regex;
        }
    }
}

