/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.ontology;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.biojava.nbio.ontology.AlreadyExistsException;
import org.biojava.nbio.ontology.DefaultOps;
import org.biojava.nbio.ontology.Ontology;
import org.biojava.nbio.ontology.OntologyOps;
import org.biojava.nbio.ontology.Term;
import org.biojava.nbio.ontology.Triple;
import org.biojava.nbio.ontology.Variable;
import org.biojava.nbio.ontology.utils.Annotation;
import org.biojava.nbio.ontology.utils.WeakValueHashMap;

public class IntegerOntology
implements Ontology {
    private final Map termCache = new WeakValueHashMap();

    IntegerOntology() {
    }

    @Override
    public String getName() {
        return "core.integer";
    }

    @Override
    public String getDescription() {
        return "Ontology containing all integers";
    }

    @Override
    public void setDescription(String description) {
    }

    public Set getTerms() {
        return new AbstractSet(){

            @Override
            public boolean contains(Object o) {
                return o instanceof IntTerm;
            }

            @Override
            public int size() {
                return Integer.MAX_VALUE;
            }

            @Override
            public Iterator iterator() {
                return new Iterator(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i > 0;
                    }

                    public Object next() {
                        return IntegerOntology.this.resolveInt(this.i++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Term getTerm(String s) throws NoSuchElementException {
        int val = Integer.parseInt(s);
        return this.resolveInt(val);
    }

    public Set getTriples(Term subject, Term object, Term predicate) {
        return Collections.EMPTY_SET;
    }

    @Override
    public OntologyOps getOps() {
        return new DefaultOps(){

            @Override
            public Set getRemoteTerms() {
                return Collections.EMPTY_SET;
            }
        };
    }

    @Override
    public Term createTerm(String name) throws AlreadyExistsException, IllegalArgumentException {
        throw new IllegalArgumentException(this.getName() + " is immutable");
    }

    @Override
    public Term createTerm(String name, String description) throws AlreadyExistsException, IllegalArgumentException {
        throw new IllegalArgumentException(this.getName() + " is immutable");
    }

    @Override
    public Term createTerm(String name, String description, Object[] synonyms) throws AlreadyExistsException, IllegalArgumentException {
        throw new IllegalArgumentException(this.getName() + " is immutable");
    }

    @Override
    public Variable createVariable(String name, String description) throws AlreadyExistsException, IllegalArgumentException {
        throw new IllegalArgumentException(this.getName() + " is immutable");
    }

    @Override
    public Term importTerm(Term t, String name) {
        throw new IllegalArgumentException(this.getName() + " is immutable");
    }

    @Override
    public Triple createTriple(Term subject, Term object, Term predicate, String name, String description) throws AlreadyExistsException {
        throw new IllegalArgumentException(this.getName() + " is immutable");
    }

    @Override
    public boolean containsTriple(Term subject, Term object, Term predicate) {
        return false;
    }

    @Override
    public void deleteTerm(Term t) {
        throw new RuntimeException(this.getName() + " is immutable");
    }

    @Override
    public boolean containsTerm(String name) {
        try {
            Integer.parseInt(name);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public IntTerm resolveInt(int val) {
        Integer i = new Integer(val);
        IntTerm term = (IntTerm)this.termCache.get(i);
        if (term == null) {
            term = new IntTerm(val);
            this.termCache.put(i, term);
        }
        return term;
    }

    @Override
    public void setName(String name) {
    }

    public final class IntTerm
    implements Term {
        private final int val;
        private Set synonyms;

        public IntTerm(int val) {
            this(val, null);
        }

        public IntTerm(int val, Object[] synonyms) {
            this.val = val;
            this.synonyms = new TreeSet();
            if (synonyms != null) {
                this.synonyms.addAll(Arrays.asList(synonyms));
            }
        }

        @Override
        public void addSynonym(Object synonym) {
            this.synonyms.add(synonym);
        }

        @Override
        public void removeSynonym(Object synonym) {
            this.synonyms.remove(synonym);
        }

        @Override
        public Object[] getSynonyms() {
            return this.synonyms.toArray();
        }

        public int intValue() {
            return this.val;
        }

        @Override
        public String getName() {
            return String.valueOf(this.val);
        }

        @Override
        public String getDescription() {
            return "The integer " + this.getName();
        }

        @Override
        public void setDescription(String description) {
        }

        @Override
        public Ontology getOntology() {
            return IntegerOntology.this;
        }

        @Override
        public Annotation getAnnotation() {
            return Annotation.EMPTY_ANNOTATION;
        }
    }
}

