/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.models.annotations.ChemProbAnnotation;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VueChemProbAnnotation
implements ChangeListener,
ActionListener,
ItemListener {
    private VARNAPanel _vp;
    private JPanel panel;
    private ChemProbAnnotation _an;
    private static int CONTROL_HEIGHT = 50;
    private static int TITLE_WIDTH = 70;
    private static int CONTROL_WIDTH = 200;
    private JButton color = new JButton();
    JSpinner intensity;
    JComboBox outward = new JComboBox<String>(new String[]{"Inward", "Outward"});
    JComboBox type = new JComboBox<ChemProbAnnotation.ChemProbAnnotationType>(ChemProbAnnotation.ChemProbAnnotationType.values());
    HighlightRegionAnnotation _backup = null;

    public VueChemProbAnnotation(VARNAPanel vARNAPanel, ChemProbAnnotation chemProbAnnotation) {
        this._an = chemProbAnnotation;
        this._vp = vARNAPanel;
        this.panel = new JPanel();
        this.panel.setLayout(new FlowLayout(0));
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("Color: ");
        jLabel.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        this.color.setContentAreaFilled(false);
        this.color.setOpaque(true);
        this.color.setPreferredSize(new Dimension(CONTROL_WIDTH, CONTROL_HEIGHT));
        this.color.setBackground(this._an.getColor());
        this.color.addActionListener(this);
        this.color.setActionCommand("outline");
        jPanel.add(jLabel);
        jPanel.add(this.color);
        JPanel jPanel2 = new JPanel();
        jLabel = new JLabel("Intensity: ");
        jLabel.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this._an.getIntensity(), 0.01, 10.0, 0.01);
        this.intensity = new JSpinner(spinnerNumberModel);
        jPanel2.add(jLabel);
        jPanel2.add(this.intensity);
        this.intensity.addChangeListener(this);
        JPanel jPanel3 = new JPanel();
        jLabel = new JLabel("Direction: ");
        jLabel.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        this.outward.addItemListener(this);
        jPanel3.add(jLabel);
        jPanel3.add(this.outward);
        JPanel jPanel4 = new JPanel();
        jLabel = new JLabel("Type: ");
        jLabel.setPreferredSize(new Dimension(TITLE_WIDTH, CONTROL_HEIGHT));
        this.type.addItemListener(this);
        jPanel4.add(jLabel);
        jPanel4.add(this.type);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(4, 1));
        jPanel5.add(jPanel);
        jPanel5.add(jPanel2);
        jPanel5.add(jPanel3);
        jPanel5.add(jPanel4);
        this.panel.add(jPanel5);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public VARNAPanel get_vp() {
        return this._vp;
    }

    public boolean show() {
        boolean bl = false;
        this.intensity.setValue(this._an.getIntensity());
        this.color.setBackground(this._an.getColor());
        this.type.setSelectedItem((Object)this._an.getType());
        this.outward.setSelectedItem(this._an.isOut() ? "Inward" : "Outward");
        if (JOptionPane.showConfirmDialog(this._vp, this.getPanel(), "Edit chemical probing annotation", 2, -1) == 0) {
            bl = true;
        }
        this._vp.repaint();
        return bl;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object;
        if (changeEvent.getSource().equals(this.intensity) && (object = this.intensity.getValue()) instanceof Double) {
            this._an.setIntensity((Double)object);
            this._vp.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color;
        if (actionEvent.getActionCommand().equals("outline") && (color = JColorChooser.showDialog(this.getPanel(), "Choose new outline color", this._an.getColor())) != null) {
            this._an.setColor(color);
        }
        this.color.setBackground(this._an.getColor());
        this._vp.repaint();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.outward) {
            this._an.setOut(!itemEvent.getItem().equals("Outward"));
            this._vp.repaint();
        } else if (itemEvent.getSource() == this.type && itemEvent.getItem() instanceof ChemProbAnnotation.ChemProbAnnotationType) {
            ChemProbAnnotation.ChemProbAnnotationType chemProbAnnotationType = (ChemProbAnnotation.ChemProbAnnotationType)((Object)itemEvent.getItem());
            this._an.setType(chemProbAnnotationType);
            this._vp.repaint();
        }
    }
}

