/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class VueAboutPanel
extends JPanel {
    private static final long serialVersionUID = 4525998278180950602L;
    private AboutAnimator _anim;
    private JPanel _textPanel;
    private JTextArea _textArea;

    public VueAboutPanel() {
        this.init();
    }

    private void init() {
        try {
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setLayout(new BorderLayout());
            this.setBackground(Color.WHITE);
            String string = "VARNA 3.9\n\nCreated by: Kevin Darty, Alain Denise and Yann Ponty\nContact: ponty@lri.fr\n\nVARNA is freely distributed under the terms of the GNU GPL 3.0 license.\n\nSupported by the BRASERO project (ANR-06-BLAN-0045)\n";
            this._textArea = new JTextArea();
            this._textArea.setText(string);
            this._textArea.setEditable(false);
            this._textPanel = new JPanel();
            this._textPanel.setBackground(Color.WHITE);
            this._textPanel.setLayout(new BorderLayout());
            this._textPanel.setBorder(BorderFactory.createMatteBorder(0, 15, 0, 15, this.getBackground()));
            this._textPanel.add(this._textArea);
            VARNAPanel vARNAPanel = new VARNAPanel("GGGGAAAACCCC", "((((....))))");
            vARNAPanel.setModifiable(false);
            vARNAPanel.setPreferredSize(new Dimension(100, 100));
            this._anim = new AboutAnimator(vARNAPanel);
            this._anim.addRNA("GGGGAAGGGGAAAACCCCAACCCC", "((((..((((....))))..))))");
            this._anim.addRNA("GGGGAAGGGGAAGGGGAAAACCCCAACCCCAACCCC", "((((..((((..((((....))))..))))..))))");
            this._anim.addRNA("GGGGAGGGGAAAACCCCAGGGGAGGGGAAAACCCCAGGGGAAAACCCCAGGGGAAAACCCCACCCCAGGGGAAAACCCCACCCC", "((((.((((....)))).((((.((((....)))).((((....)))).((((....)))).)))).((((....)))).))))");
            this._anim.addRNA("GGGGGGGGAAAACCCCAGGGGAAAACCCCAGGGGGGGGAAAACCCCAGGGGAAAACCCCAGGGGAAAACCCCAGGGGAAAACCCCGGGGAAAACCCCACCCCAGGGGAAAACCCCAGGGGAAAACCCCCCCC", "((((((((....)))).((((....)))).((((((((....)))).((((....)))).((((....)))).((((....))))((((....)))).)))).((((....)))).((((....))))))))");
            this._anim.addRNA("GGGGAAAACCCC", "((((....))))");
            this._anim.addRNA("GGGGAAGGGGAAAACCCCAGGGGAAAACCCCACCCC", "((((..((((....)))).((((....)))).))))");
            this._anim.addRNA("GGGGAGGGGAAAACCCCAGGGGAAAACCCCAGGGGAAAACCCCACCCC", "((((.((((....)))).((((....)))).((((....)))).))))");
            this._anim.addRNA("GGGGAGGGGAAAAAAACCCCAGGGGAAAAAAACCCCAGGGGAAAAAAACCCCACCCC", "((((.((((.......)))).((((.......)))).((((.......)))).))))");
            this._anim.start();
            this.add((Component)vARNAPanel, "West");
            this.add((Component)this._textPanel, "Center");
        }
        catch (ExceptionNonEqualLength exceptionNonEqualLength) {
            // empty catch block
        }
    }

    public void gracefulStop() {
        this._anim.gracefulStop();
    }

    private class AboutAnimator
    extends Thread {
        VARNAPanel _vp;
        ArrayList<String> _structures = new ArrayList();
        ArrayList<String> _sequences = new ArrayList();
        int _period = 2000;
        boolean _over = false;

        public AboutAnimator(VARNAPanel vARNAPanel) {
            this._vp = vARNAPanel;
        }

        public void addRNA(String string, String string2) {
            this._sequences.add(string);
            this._structures.add(string2);
        }

        public void gracefulStop() {
            this._over = true;
        }

        @Override
        public void run() {
            try {
                int n = 0;
                while (!this._over) {
                    AboutAnimator.sleep(this._period);
                    String string = this._sequences.get(n);
                    String string2 = this._structures.get(n);
                    this._vp.drawRNAInterpolated(string, string2);
                    AboutAnimator.sleep(500L);
                    n = (n + 1) % this._sequences.size();
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (ExceptionNonEqualLength exceptionNonEqualLength) {
                exceptionNonEqualLength.printStackTrace();
            }
        }
    }
}

