/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.utils;

import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Formatter;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLUtils {
    public static String XML_BASELIST_ELEMENT_NAME = "baselist";
    public static String XML_FONT_ELEMENT_NAME = "font";
    public static String XML_ROLE_NAME = "role";
    public static String XML_NAME_NAME = "name";
    public static String XML_FAMILY_NAME = "family";
    public static String XML_STYLE_NAME = "style";
    public static String XML_SIZE_NAME = "size";

    public static String toHTMLNotation(Color color) {
        Formatter formatter = new Formatter();
        formatter.format("#%02X%02X%02X", color.getRed(), color.getGreen(), color.getBlue());
        return formatter.toString();
    }

    public static void toXML(TransformerHandler transformerHandler, Font font) throws SAXException {
        XMLUtils.toXML(transformerHandler, font, "");
    }

    public static void toXML(TransformerHandler transformerHandler, Font font, String string) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        if (!string.equals("")) {
            attributesImpl.addAttribute("", "", XML_ROLE_NAME, "CDATA", "" + string);
        }
        attributesImpl.addAttribute("", "", XML_NAME_NAME, "CDATA", "" + font.getName());
        attributesImpl.addAttribute("", "", XML_STYLE_NAME, "CDATA", "" + font.getStyle());
        attributesImpl.addAttribute("", "", XML_SIZE_NAME, "CDATA", "" + font.getSize2D());
        transformerHandler.startElement("", "", XML_FONT_ELEMENT_NAME, attributesImpl);
        transformerHandler.endElement("", "", XML_FONT_ELEMENT_NAME);
    }

    public static Font getFont(String string, Attributes attributes) {
        if (string.equals(XML_FONT_ELEMENT_NAME)) {
            int n = Integer.parseInt(attributes.getValue(XML_STYLE_NAME));
            String string2 = attributes.getValue(XML_NAME_NAME);
            double d = Double.parseDouble(attributes.getValue(XML_SIZE_NAME));
            Font font = new Font(string2, n, (int)d);
            return font.deriveFont((float)d);
        }
        return null;
    }

    public static void toXML(TransformerHandler transformerHandler, ModeleBase modeleBase) throws SAXException {
        ArrayList<ModeleBase> arrayList = new ArrayList<ModeleBase>();
        arrayList.add(modeleBase);
        XMLUtils.toXML(transformerHandler, arrayList);
    }

    public static void toXML(TransformerHandler transformerHandler, ArrayList<ModeleBase> arrayList) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        String string = "";
        for (ModeleBase modeleBase : arrayList) {
            if (!string.equals("")) {
                string = string + ",";
            }
            string = string + modeleBase.getIndex();
        }
        transformerHandler.startElement("", "", XML_BASELIST_ELEMENT_NAME, attributesImpl);
        XMLUtils.exportCDATAString(transformerHandler, string);
        transformerHandler.endElement("", "", XML_BASELIST_ELEMENT_NAME);
    }

    public static ArrayList<ModeleBase> toModeleBaseArray(String string, RNA rNA) {
        ArrayList<ModeleBase> arrayList = new ArrayList<ModeleBase>();
        String[] stringArray = string.trim().split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            int n = Integer.parseInt(stringArray[i]);
            arrayList.add(rNA.getBaseAt(n));
        }
        return arrayList;
    }

    public static void exportCDATAElem(TransformerHandler transformerHandler, String string, String string2) throws SAXException {
        char[] cArray = string2.toCharArray();
        AttributesImpl attributesImpl = new AttributesImpl();
        transformerHandler.startElement("", "", string, attributesImpl);
        transformerHandler.startCDATA();
        transformerHandler.characters(cArray, 0, cArray.length);
        transformerHandler.endCDATA();
        transformerHandler.endElement("", "", string);
    }

    public static void exportCDATAString(TransformerHandler transformerHandler, String string) throws SAXException {
        char[] cArray = string.toCharArray();
        transformerHandler.startCDATA();
        transformerHandler.characters(cArray, 0, cArray.length);
        transformerHandler.endCDATA();
    }

    public static boolean getBoolean(Attributes attributes, String string, boolean bl) {
        String string2 = attributes.getValue(string);
        if (string2 != null) {
            return Boolean.parseBoolean(string2);
        }
        return bl;
    }

    public static int getInt(Attributes attributes, String string, int n) {
        String string2 = attributes.getValue(string);
        if (string2 != null) {
            return Integer.parseInt(string2);
        }
        return n;
    }

    public static double getDouble(Attributes attributes, String string, double d) {
        String string2 = attributes.getValue(string);
        if (string2 != null) {
            return Double.parseDouble(string2);
        }
        return d;
    }
}

