/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.templates;

import fr.orsay.lri.varna.applications.templateEditor.Couple;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import fr.orsay.lri.varna.models.templates.RNATemplateMappingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RNATemplateMapping {
    private Map<Integer, RNATemplate.RNATemplateElement> map = new HashMap<Integer, RNATemplate.RNATemplateElement>();
    private Map<RNATemplate.RNATemplateElement, ArrayList<Integer>> invmap = new HashMap<RNATemplate.RNATemplateElement, ArrayList<Integer>>();
    private double distance;

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double d) {
        this.distance = d;
    }

    public void addCouple(int n, RNATemplate.RNATemplateElement rNATemplateElement) throws RNATemplateMappingException {
        if (this.map.containsKey(n)) {
            throw new RNATemplateMappingException("Base index already in mapping: " + n);
        }
        if (n < 0) {
            throw new RNATemplateMappingException("Invalid base index: " + n);
        }
        this.map.put(n, rNATemplateElement);
        if (!this.invmap.containsKey(rNATemplateElement)) {
            this.invmap.put(rNATemplateElement, new ArrayList());
        }
        this.invmap.get(rNATemplateElement).add(n);
    }

    public String showCompact(RNA rNA) {
        Object object;
        Object object2;
        HashMap<Object, Couple<Integer, Integer>> hashMap = new HashMap<Object, Couple<Integer, Integer>>();
        Object object3 = this.map.keySet().iterator();
        while (object3.hasNext()) {
            int n = object3.next();
            Object object4 = this.map.get(n);
            object2 = ((RNATemplate.RNATemplateElement)object4).getName();
            if (object4 instanceof RNATemplate.RNATemplateHelix) {
                object2 = (String)object2 + " (" + ((RNATemplate.RNATemplateHelix)object4).getCaption() + ")";
                object = rNA.getBaseAt(n);
                object2 = ((ModeleBase)object).getElementStructure() > n ? (String)object2 + ":5'" : (String)object2 + ":3'";
            }
            if (!hashMap.containsKey(object2)) {
                hashMap.put(object2, new Couple<Integer, Integer>(Integer.MAX_VALUE, Integer.MIN_VALUE));
            }
            object = (Couple)hashMap.get(object2);
            ((Couple)object).first = Math.min((Integer)((Couple)object).first, n);
            ((Couple)object).second = Math.max((Integer)((Couple)object).second, n);
        }
        object3 = "";
        for (Object object4 : hashMap.keySet()) {
            String string;
            object2 = (Couple)hashMap.get(object4);
            object = this.map.get(((Couple)object2).first);
            String string2 = string = object instanceof RNATemplate.RNATemplateHelix ? "strand" : "loop";
            if (object instanceof RNATemplate.RNATemplateHelix) {
                if (!((String)object4).endsWith("5'")) continue;
                Couple couple = (Couple)hashMap.get(((String)object4).replace("5'", "3'"));
                object3 = (String)object3 + "dummyID\t1\t" + ((String)object4).replace(":5'", "") + "\t" + string + "\t" + ((Couple)object2).first + "-" + ((Couple)object2).second + ":" + couple.first + "-" + couple.second + "\n";
                continue;
            }
            if (!(object instanceof RNATemplate.RNATemplateUnpairedSequence)) continue;
            object3 = (String)object3 + "dummyID\t1\t" + (String)object4 + "\t" + string + "\t" + ((Couple)object2).first + "-" + ((Couple)object2).second + "\n";
        }
        object3 = (String)object3 + "alignment distance = " + this.distance;
        return object3;
    }

    public RNATemplate.RNATemplateElement getPartner(int n) {
        if (this.map.containsKey(n)) {
            return this.map.get(n);
        }
        return null;
    }

    public ArrayList<Integer> getAncestor(RNATemplate.RNATemplateElement rNATemplateElement) {
        if (this.invmap.containsKey(rNATemplateElement)) {
            return this.invmap.get(rNATemplateElement);
        }
        return null;
    }

    public Set<Integer> getSourceElemsAsSet() {
        return this.map.keySet();
    }

    public Set<RNATemplate.RNATemplateElement> getTargetElemsAsSet() {
        return this.invmap.keySet();
    }
}

