/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.templates;

import fr.orsay.lri.varna.exceptions.ExceptionInvalidRNATemplate;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBaseNucleotide;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.models.templates.RNANodeValue2TemplateDistance;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplate;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateBasePair;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateBrokenBasePair;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateSequence;
import fr.orsay.lri.varna.models.templates.RNATemplate;
import fr.orsay.lri.varna.models.templates.RNATemplateDrawingAlgorithmException;
import fr.orsay.lri.varna.models.templates.RNATemplateMapping;
import fr.orsay.lri.varna.models.templates.RNATemplateMappingException;
import fr.orsay.lri.varna.models.treealign.AlignedNode;
import fr.orsay.lri.varna.models.treealign.RNANodeValue;
import fr.orsay.lri.varna.models.treealign.RNANodeValue2;
import fr.orsay.lri.varna.models.treealign.RNATree2;
import fr.orsay.lri.varna.models.treealign.RNATree2Exception;
import fr.orsay.lri.varna.models.treealign.Tree;
import fr.orsay.lri.varna.models.treealign.TreeAlign;
import fr.orsay.lri.varna.models.treealign.TreeAlignException;
import fr.orsay.lri.varna.models.treealign.TreeAlignResult;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RNATemplateAlign {
    private static boolean canBePartOfAnHelix(RNANodeValue2 rNANodeValue2) {
        return rNANodeValue2 != null && rNANodeValue2.isSingleNode() && rNANodeValue2.getNode().getRightBasePosition() > 0;
    }

    private static boolean canBePartOfASequence(RNANodeValue2 rNANodeValue2) {
        return rNANodeValue2 != null && !rNANodeValue2.isSingleNode();
    }

    private static boolean canBePartOfABrokenHelix(RNANodeValue2 rNANodeValue2) {
        return rNANodeValue2 != null && rNANodeValue2.isSingleNode() && rNANodeValue2.getNode().getRightBasePosition() < 0;
    }

    /*
     * WARNING - void declaration
     */
    public static RNATemplateMapping makeTemplateMapping(TreeAlignResult<RNANodeValue2, RNANodeValueTemplate> treeAlignResult, RNA rNA) throws RNATemplateMappingException {
        Object object;
        Object object2;
        Iterable<Tree<Object>> iterable;
        RNATemplateMapping rNATemplateMapping = new RNATemplateMapping();
        Tree<AlignedNode<RNANodeValue2, RNANodeValueTemplate>> tree = treeAlignResult.getAlignment();
        rNATemplateMapping.setDistance(treeAlignResult.getDistance());
        Object object4 = null;
        Object object5 = new LinkedList<Tree<AlignedNode<RNANodeValue2, RNANodeValueTemplate>>>();
        Object object6 = new LinkedList();
        ((LinkedList)object5).add(tree);
        while (!((AbstractCollection)object5).isEmpty()) {
            void var15_48;
            void var15_46;
            void var15_44;
            int n;
            Tree list2 = (Tree)((LinkedList)object5).getLast();
            ((LinkedList)object5).removeLast();
            Tree tree2 = ((AlignedNode)list2.getValue()).getLeftNode();
            iterable = ((AlignedNode)list2.getValue()).getRightNode();
            if (tree2 != null && tree2.getValue() != null) {
                object2 = (RNANodeValue2)tree2.getValue();
                if (iterable != null && ((Tree)iterable).getValue() != null) {
                    RNANodeValueTemplate rNANodeValueTemplate = (RNANodeValueTemplate)((Tree)iterable).getValue();
                    if (rNANodeValueTemplate instanceof RNANodeValueTemplateBasePair && RNATemplateAlign.canBePartOfAnHelix(object2)) {
                        RNATemplate.RNATemplateHelix tree4 = ((RNANodeValueTemplateBasePair)rNANodeValueTemplate).getHelix();
                        object4 = tree4;
                        int tree5 = ((RNANodeValue2)object2).getNode().getLeftBasePosition();
                        int tree6 = ((RNANodeValue2)object2).getNode().getRightBasePosition();
                        rNATemplateMapping.addCouple(tree5, tree4);
                        rNATemplateMapping.addCouple(tree6, tree4);
                        if (object6.size() > 0) {
                            Iterator iterator = object6.iterator();
                            while (iterator.hasNext()) {
                                object = (RNANodeValue2)iterator.next();
                                int n2 = ((RNANodeValue2)object).getNode().getLeftBasePosition();
                                int n3 = ((RNANodeValue2)object).getNode().getRightBasePosition();
                                boolean bl = n2 < tree5 && tree6 < n3;
                                if (!bl) continue;
                                rNATemplateMapping.addCouple(((RNANodeValue2)object).getNode().getLeftBasePosition(), tree4);
                                rNATemplateMapping.addCouple(((RNANodeValue2)object).getNode().getRightBasePosition(), tree4);
                            }
                        }
                        object6.clear();
                    } else if (rNANodeValueTemplate instanceof RNANodeValueTemplateSequence && RNATemplateAlign.canBePartOfASequence(object2)) {
                        object4 = null;
                        object6.clear();
                        RNATemplate.RNATemplateUnpairedSequence bl = ((RNANodeValueTemplateSequence)rNANodeValueTemplate).getSequence();
                        for (RNANodeValue rNANodeValue : ((RNANodeValue2)tree2.getValue()).getNodes()) {
                            rNATemplateMapping.addCouple(rNANodeValue.getLeftBasePosition(), bl);
                        }
                    } else {
                        object4 = null;
                        object6.clear();
                    }
                } else if (RNATemplateAlign.canBePartOfAnHelix((RNANodeValue2)object2)) {
                    if (object4 != null) {
                        boolean bl;
                        n = ((RNANodeValue2)object2).getNode().getLeftBasePosition();
                        int n4 = ((RNANodeValue2)object2).getNode().getRightBasePosition();
                        int n5 = Integer.MAX_VALUE;
                        int n6 = Integer.MIN_VALUE;
                        for (int n7 : rNATemplateMapping.getAncestor((RNATemplate.RNATemplateElement)object4)) {
                            n5 = Math.min(n5, n7);
                            n6 = Math.max(n6, n7);
                        }
                        boolean bl2 = bl = n5 < n && n4 < n6;
                        if (bl) {
                            rNATemplateMapping.addCouple(n, (RNATemplate.RNATemplateElement)object4);
                            rNATemplateMapping.addCouple(n4, (RNATemplate.RNATemplateElement)object4);
                        }
                    } else {
                        object6.add(object2);
                    }
                }
            }
            if ((n = (object2 = list2.getChildren()).size()) <= 0) continue;
            int n8 = 0;
            ArrayList<Tree> arrayList = new ArrayList<Tree>();
            ArrayList<Tree> arrayList2 = new ArrayList<Tree>();
            boolean bl = false;
            while (var15_44 < n) {
                object = (Tree)object2.get((int)var15_44);
                Tree tree3 = ((AlignedNode)((Tree)object).getValue()).getLeftNode();
                if (tree3 != null && tree3.getValue() != null && (RNATemplateAlign.canBePartOfAnHelix((RNANodeValue2)tree3.getValue()) || RNATemplateAlign.canBePartOfABrokenHelix((RNANodeValue2)tree3.getValue()))) {
                    ++n8;
                    arrayList2.add((Tree)object);
                } else {
                    arrayList.add((Tree)object);
                }
                ++var15_44;
            }
            int n9 = arrayList2.size() - 1;
            while (var15_46 >= 0) {
                ((LinkedList)object5).add(arrayList2.get((int)var15_46));
                --var15_46;
            }
            int n10 = arrayList.size() - 1;
            while (var15_48 >= 0) {
                ((LinkedList)object5).add(arrayList.get((int)var15_48));
                --var15_48;
            }
            if (n8 < 2) continue;
            object4 = null;
        }
        object4 = new LinkedList();
        ((LinkedList)object4).add(tree);
        object5 = new RNATemplateMapping();
        while (!((AbstractCollection)object4).isEmpty()) {
            object6 = (Tree)((LinkedList)object4).getLast();
            ((LinkedList)object4).removeLast();
            List list = ((Tree)object6).getChildren();
            int n = list.size();
            if (n <= 0) continue;
            for (int i = n - 1; i >= 0; --i) {
                ((LinkedList)object4).add(list.get(i));
            }
            iterable = new LinkedList();
            object2 = null;
            for (Tree tree4 : ((Tree)object6).getChildren()) {
                Tree tree5 = ((AlignedNode)tree4.getValue()).getLeftNode();
                Tree tree6 = ((AlignedNode)tree4.getValue()).getRightNode();
                if (tree5 != null && tree5.getValue() != null) {
                    RNANodeValue2 rNANodeValue2 = (RNANodeValue2)tree5.getValue();
                    if (tree6 != null && tree6.getValue() != null) {
                        object = (RNANodeValueTemplate)tree6.getValue();
                        if (object instanceof RNANodeValueTemplateBrokenBasePair && RNATemplateAlign.canBePartOfABrokenHelix(rNANodeValue2)) {
                            RNATemplate.RNATemplateHelix rNATemplateHelix = ((RNANodeValueTemplateBrokenBasePair)object).getHelix();
                            object2 = rNATemplateHelix;
                            ((RNATemplateMapping)object5).addCouple(rNANodeValue2.getNode().getLeftBasePosition(), rNATemplateHelix);
                            for (RNANodeValue2 rNANodeValue22 : iterable) {
                                ((RNATemplateMapping)object5).addCouple(rNANodeValue22.getNode().getLeftBasePosition(), rNATemplateHelix);
                            }
                            iterable.clear();
                            continue;
                        }
                        object2 = null;
                        iterable.clear();
                        continue;
                    }
                    if (RNATemplateAlign.canBePartOfABrokenHelix(rNANodeValue2)) {
                        if (object2 != null) {
                            ((RNATemplateMapping)object5).addCouple(rNANodeValue2.getNode().getLeftBasePosition(), (RNATemplate.RNATemplateElement)object2);
                            continue;
                        }
                        iterable.add((RNANodeValue2)rNANodeValue2);
                        continue;
                    }
                    object2 = null;
                    iterable.clear();
                    continue;
                }
                object2 = null;
                iterable.clear();
            }
        }
        for (RNATemplate.RNATemplateElement rNATemplateElement : ((RNATemplateMapping)object5).getTargetElemsAsSet()) {
            RNATemplate.RNATemplateHelix rNATemplateHelix = (RNATemplate.RNATemplateHelix)rNATemplateElement;
            iterable = new HashSet<Integer>(((RNATemplateMapping)object5).getAncestor(rNATemplateHelix));
            object2 = ((HashSet)iterable).iterator();
            while (object2.hasNext()) {
                int n = (Integer)object2.next();
                System.out.println("PK: " + rNATemplateHelix + " aligned with " + n);
                boolean bl = false;
                ArrayList<ModeleBP> arrayList = rNA.getAuxBPs(n);
                for (ModeleBP modeleBP : arrayList) {
                    int n11 = ((ModeleBaseNucleotide)modeleBP.getPartner5()).getIndex();
                    int n12 = ((ModeleBaseNucleotide)modeleBP.getPartner3()).getIndex();
                    if (n == n11) {
                        if (!((HashSet)iterable).contains(n12)) continue;
                        bl = true;
                        break;
                    }
                    if (n != n12 || !((HashSet)iterable).contains(n11)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                rNATemplateMapping.addCouple(n, rNATemplateHelix);
            }
        }
        return rNATemplateMapping;
    }

    public static void printMapping(RNATemplateMapping rNATemplateMapping, RNATemplate rNATemplate, String string) {
        Iterator<RNATemplate.RNATemplateElement> iterator = rNATemplate.rnaIterator();
        while (iterator.hasNext()) {
            RNATemplate.RNATemplateElement rNATemplateElement = iterator.next();
            System.out.println(rNATemplateElement.toString());
            ArrayList<Integer> arrayList = rNATemplateMapping.getAncestor(rNATemplateElement);
            if (arrayList != null) {
                RNATemplateAlign.printIntArrayList(arrayList);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    System.out.print("\t" + string.charAt(arrayList.get(i)));
                }
                System.out.println("");
                continue;
            }
            System.out.println("\tno match");
        }
    }

    public static TreeAlignResult<RNANodeValue2, RNANodeValueTemplate> alignRNAWithTemplate(RNA rNA, RNATemplate rNATemplate) throws RNATemplateDrawingAlgorithmException {
        try {
            Tree<RNANodeValue2> tree = RNATree2.RNATree2FromRNA(rNA);
            Tree<RNANodeValueTemplate> tree2 = rNATemplate.toTree();
            TreeAlign<RNANodeValue2, RNANodeValueTemplate> treeAlign = new TreeAlign<RNANodeValue2, RNANodeValueTemplate>(new RNANodeValue2TemplateDistance());
            TreeAlignResult<RNANodeValue2, RNANodeValueTemplate> treeAlignResult = treeAlign.align(tree, tree2);
            return treeAlignResult;
        }
        catch (RNATree2Exception rNATree2Exception) {
            throw new RNATemplateDrawingAlgorithmException("RNATree2Exception: " + rNATree2Exception.getMessage());
        }
        catch (ExceptionInvalidRNATemplate exceptionInvalidRNATemplate) {
            throw new RNATemplateDrawingAlgorithmException("ExceptionInvalidRNATemplate: " + exceptionInvalidRNATemplate.getMessage());
        }
        catch (TreeAlignException treeAlignException) {
            throw new RNATemplateDrawingAlgorithmException("TreeAlignException: " + treeAlignException.getMessage());
        }
    }

    public static RNATemplateMapping mapRNAWithTemplate(RNA rNA, RNATemplate rNATemplate) throws RNATemplateDrawingAlgorithmException {
        try {
            TreeAlignResult<RNANodeValue2, RNANodeValueTemplate> treeAlignResult = RNATemplateAlign.alignRNAWithTemplate(rNA, rNATemplate);
            RNATemplateMapping rNATemplateMapping = RNATemplateAlign.makeTemplateMapping(treeAlignResult, rNA);
            return rNATemplateMapping;
        }
        catch (RNATemplateMappingException rNATemplateMappingException) {
            rNATemplateMappingException.printStackTrace();
            throw new RNATemplateDrawingAlgorithmException("RNATemplateMappingException: " + rNATemplateMappingException.getMessage());
        }
    }

    public static void printIntArray(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            System.out.print("\t" + nArray[i]);
        }
        System.out.println("");
    }

    public static void printIntArrayList(ArrayList<Integer> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.print("\t" + arrayList.get(i));
        }
        System.out.println("");
    }

    public static void printShortMatrix(short[][] sArray) {
        System.out.println("Begin matrix");
        for (int i = 0; i < sArray.length; ++i) {
            for (int j = 0; j < sArray[i].length; ++j) {
                System.out.print("\t" + sArray[i][j]);
            }
            System.out.println("");
        }
        System.out.println("End matrix");
    }

    public static int[] intArrayFromList(List<Integer> list) {
        if (list != null) {
            int n = list.size();
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = list.get(i);
            }
            return nArray;
        }
        return null;
    }
}

