/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.templates;

import fr.orsay.lri.varna.exceptions.ExceptionEdgeEndpointAlreadyConnected;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionInvalidRNATemplate;
import fr.orsay.lri.varna.exceptions.ExceptionXMLGeneration;
import fr.orsay.lri.varna.exceptions.ExceptionXmlLoading;
import fr.orsay.lri.varna.models.rna.RNA;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplate;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateBasePair;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateBrokenBasePair;
import fr.orsay.lri.varna.models.templates.RNANodeValueTemplateSequence;
import fr.orsay.lri.varna.models.templates.RNATemplateAlign;
import fr.orsay.lri.varna.models.treealign.Tree;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RNATemplate {
    private Collection<RNATemplateElement> elements = new ArrayList<RNATemplateElement>();
    private final RNATemplate template = this;
    private static int NEXT_ID = 1;

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public RNATemplateElement getFirst() {
        return this.getFirstEndPoint().getElement();
    }

    public RNATemplateElement.EdgeEndPoint getFirstEndPoint() {
        if (this.elements.isEmpty()) {
            return null;
        }
        HashSet<RNATemplateElement.EdgeEndPoint> hashSet = new HashSet<RNATemplateElement.EdgeEndPoint>();
        RNATemplateElement.EdgeEndPoint edgeEndPoint = this.getAnyEndPoint();
        while (!hashSet.contains(edgeEndPoint)) {
            hashSet.add(edgeEndPoint);
            RNATemplateElement.EdgeEndPoint edgeEndPoint2 = edgeEndPoint.getPreviousEndPoint();
            if (edgeEndPoint2 == null) {
                return edgeEndPoint;
            }
            edgeEndPoint = edgeEndPoint2;
        }
        return edgeEndPoint;
    }

    public RNATemplateElement getAny() {
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements.iterator().next();
    }

    public RNATemplateElement.EdgeEndPoint getAnyEndPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getAny().getIn1EndPoint();
    }

    public Iterator<RNATemplateElement> rnaIterator() {
        return new RNAIterator();
    }

    public Iterator<RNATemplateElement> classicIterator() {
        return this.elements.iterator();
    }

    public Iterator<RNATemplateElement.EdgeEndPoint> vertexIterator() {
        return new VertexIterator();
    }

    public List<RNATemplateElement.EdgeEndPoint> makeEdgeList() {
        MakeEdgeList makeEdgeList = new MakeEdgeList();
        return makeEdgeList.make();
    }

    public boolean connectedComponentIsCyclic(RNATemplateElement.EdgeEndPoint edgeEndPoint) {
        HashSet<RNATemplateElement.EdgeEndPoint> hashSet = new HashSet<RNATemplateElement.EdgeEndPoint>();
        RNATemplateElement.EdgeEndPoint edgeEndPoint2 = edgeEndPoint;
        while (!hashSet.contains(edgeEndPoint2)) {
            hashSet.add(edgeEndPoint2);
            RNATemplateElement.EdgeEndPoint edgeEndPoint3 = edgeEndPoint2.getPreviousEndPoint();
            if (edgeEndPoint3 == null) {
                return false;
            }
            edgeEndPoint2 = edgeEndPoint3;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isConnected() {
        void var3_5;
        if (this.isEmpty()) {
            return true;
        }
        int n = 0;
        for (RNATemplateElement object2 : this.elements) {
            if (object2 instanceof RNATemplateHelix) {
                n += 4;
                continue;
            }
            if (!(object2 instanceof RNATemplateUnpairedSequence)) continue;
            n += 2;
        }
        HashSet hashSet = new HashSet();
        RNATemplateElement.EdgeEndPoint edgeEndPoint = this.getFirstEndPoint();
        while (!hashSet.contains(var3_5)) {
            hashSet.add(var3_5);
            RNATemplateElement.EdgeEndPoint edgeEndPoint2 = var3_5.getNextEndPoint();
            if (edgeEndPoint2 == null) break;
            RNATemplateElement.EdgeEndPoint edgeEndPoint3 = edgeEndPoint2;
        }
        return hashSet.size() == n;
    }

    public void checkIsValidTemplate() throws ExceptionInvalidRNATemplate {
        if (this.isEmpty()) {
            throw new ExceptionInvalidRNATemplate("The template is empty.");
        }
        if (!this.isConnected()) {
            throw new ExceptionInvalidRNATemplate("The template is a non-connected graph.");
        }
        if (this.connectedComponentIsCyclic(this.getAnyEndPoint())) {
            throw new ExceptionInvalidRNATemplate("The template is cyclic.");
        }
    }

    public Tree<RNANodeValueTemplate> toTree() throws ExceptionInvalidRNATemplate {
        this.computeIn1Is();
        RemovePseudoKnots removePseudoKnots = new RemovePseudoKnots();
        Set<RNATemplateHelix> set = removePseudoKnots.removePseudoKnots();
        ConvertToTree convertToTree = new ConvertToTree(set);
        return convertToTree.convert();
    }

    public RNA toRNA() throws ExceptionInvalidRNATemplate {
        Object object;
        Object object2;
        this.checkIsValidTemplate();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        HashMap<Object, ArrayList> hashMap = new HashMap<Object, ArrayList>();
        Iterator<RNATemplateElement> iterator = this.rnaIterator();
        while (iterator.hasNext()) {
            int n;
            int n2;
            object2 = iterator.next();
            if (object2 instanceof RNATemplateHelix) {
                int n3;
                ArrayList arrayList2;
                object = (RNATemplateHelix)object2;
                n2 = ((RNATemplateHelix)object).getLength();
                if (hashMap.containsKey(object)) {
                    n = arrayList.size();
                    arrayList2 = (ArrayList)hashMap.get(object);
                    for (n3 = 0; n3 < n2; ++n3) {
                        int n4 = (Integer)arrayList2.get(n2 - 1 - n3);
                        arrayList.set(n4, n + n3);
                        arrayList.add(n4);
                    }
                    continue;
                }
                n = arrayList.size();
                arrayList2 = new ArrayList();
                for (n3 = 0; n3 < n2; ++n3) {
                    arrayList.add(-1);
                    arrayList2.add(n + n3);
                }
                hashMap.put(object, arrayList2);
                continue;
            }
            if (object2 instanceof RNATemplateUnpairedSequence) {
                object = (RNATemplateUnpairedSequence)object2;
                n2 = ((RNATemplateUnpairedSequence)object).getLength();
                for (n = 0; n < n2; ++n) {
                    arrayList.add(-1);
                }
                continue;
            }
            throw new ExceptionInvalidRNATemplate("We have an endpoint which is neither an helix nor a sequence. What is that?");
        }
        object2 = RNATemplateAlign.intArrayFromList(arrayList);
        object = new String[((int[])object2).length];
        Arrays.fill((Object[])object, " ");
        RNA rNA = new RNA();
        try {
            rNA.setRNA((String[])object, (int[])object2);
        }
        catch (ExceptionFileFormatOrSyntax exceptionFileFormatOrSyntax) {
            throw new RuntimeException("Bug in toRNA(): setRNA() threw an ExceptionFileFormatOrSyntax exception.");
        }
        return rNA;
    }

    public void toXMLFile(File file) throws ExceptionXMLGeneration, ExceptionInvalidRNATemplate {
        try {
            Document document = this.toXMLDocument();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(file);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new ExceptionXMLGeneration("TransformerConfigurationException: " + transformerConfigurationException.getMessage());
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new ExceptionXMLGeneration("TransformerFactoryConfigurationError: " + transformerFactoryConfigurationError.getMessage());
        }
        catch (TransformerException transformerException) {
            throw new ExceptionXMLGeneration("TransformerException: " + transformerException.getMessage());
        }
    }

    public Document toXMLDocument() throws ExceptionXMLGeneration, ExceptionInvalidRNATemplate {
        ConvertToXml convertToXml = new ConvertToXml();
        return convertToXml.toXMLDocument();
    }

    public static RNATemplate fromXMLFile(File file) throws ExceptionXmlLoading {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            return RNATemplate.fromXMLDocument(document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ExceptionXmlLoading("ParserConfigurationException: " + parserConfigurationException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new ExceptionXmlLoading("SAXException: " + sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new ExceptionXmlLoading("IOException: " + iOException.getMessage());
        }
    }

    public static RNATemplate fromXMLDocument(Document document) throws ExceptionXmlLoading {
        RNATemplate rNATemplate;
        RNATemplate rNATemplate2 = rNATemplate = new RNATemplate();
        rNATemplate2.getClass();
        LoadFromXml loadFromXml = rNATemplate2.new LoadFromXml(document);
        loadFromXml.load();
        return rNATemplate;
    }

    public void computeIn1Is() throws ExceptionInvalidRNATemplate {
        this.checkIsValidTemplate();
        Iterator<RNATemplateElement.EdgeEndPoint> iterator = this.vertexIterator();
        HashSet<RNATemplateHelix> hashSet = new HashSet<RNATemplateHelix>();
        while (iterator.hasNext()) {
            RNATemplateHelix rNATemplateHelix;
            RNATemplateElement.EdgeEndPoint edgeEndPoint = iterator.next();
            RNATemplateElement rNATemplateElement = edgeEndPoint.getElement();
            if (!(rNATemplateElement instanceof RNATemplateHelix) || hashSet.contains(rNATemplateHelix = (RNATemplateHelix)rNATemplateElement)) continue;
            switch (edgeEndPoint.getPosition()) {
                case IN1: 
                case OUT1: {
                    rNATemplateHelix.setIn1Is(In1Is.IN1_IS_5PRIME);
                    break;
                }
                case IN2: 
                case OUT2: {
                    rNATemplateHelix.setIn1Is(In1Is.IN1_IS_3PRIME);
                }
            }
            hashSet.add(rNATemplateHelix);
        }
    }

    public boolean removeElement(RNATemplateElement rNATemplateElement) throws ExceptionInvalidRNATemplate {
        if (this.elements.contains(rNATemplateElement)) {
            rNATemplateElement.disconnectFromAny();
            this.elements.remove(rNATemplateElement);
            return true;
        }
        return false;
    }

    static /* synthetic */ int access$708() {
        return NEXT_ID++;
    }

    public class RNATemplateUnpairedSequence
    extends RNATemplateElement {
        private int length;
        private static final double defaultTangentVectorAngle = 1.5707963267948966;
        private static final double defaultTangentVectorLength = 100.0;
        private double inTangentVectorAngle;
        private double inTangentVectorLength;
        private double outTangentVectorAngle;
        private double outTangentVectorLength;
        private Point2D.Double vertex5;
        private Point2D.Double vertex3;
        private final RNATemplateElement.EdgeEndPoint in;
        private final RNATemplateElement.EdgeEndPoint out;
        private String _name;

        public Point2D.Double getVertex5() {
            return this.vertex5;
        }

        public void setVertex5(Point2D.Double double_) {
            this.vertex5 = double_;
        }

        public Point2D.Double getVertex3() {
            return this.vertex3;
        }

        public void setVertex3(Point2D.Double double_) {
            this.vertex3 = double_;
        }

        public RNATemplateUnpairedSequence(String string) {
            this.inTangentVectorAngle = 1.5707963267948966;
            this.inTangentVectorLength = 100.0;
            this.outTangentVectorAngle = 1.5707963267948966;
            this.outTangentVectorLength = 100.0;
            this.in = new RNATemplateElement.EdgeEndPoint();
            this.out = new RNATemplateElement.EdgeEndPoint();
            this._name = string;
        }

        public String toString() {
            return "Sequence @" + Integer.toHexString(this.hashCode()) + " len=" + this.length;
        }

        @Override
        public String getName() {
            return "" + this._name;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int n) {
            this.length = n;
        }

        public double getInTangentVectorAngle() {
            return this.inTangentVectorAngle;
        }

        public void setInTangentVectorAngle(double d) {
            this.inTangentVectorAngle = d;
        }

        public double getInTangentVectorLength() {
            return this.inTangentVectorLength;
        }

        public void setInTangentVectorLength(double d) {
            this.inTangentVectorLength = d;
        }

        public double getOutTangentVectorAngle() {
            return this.outTangentVectorAngle;
        }

        public void setOutTangentVectorAngle(double d) {
            this.outTangentVectorAngle = d;
        }

        public double getOutTangentVectorLength() {
            return this.outTangentVectorLength;
        }

        public void setOutTangentVectorLength(double d) {
            this.outTangentVectorLength = d;
        }

        public RNATemplateElement.EdgeEndPoint getIn() {
            return this.in;
        }

        public RNATemplateElement.EdgeEndPoint getOut() {
            return this.out;
        }

        @Override
        public void disconnectFromAny() {
            this.getIn().disconnect();
            this.getOut().disconnect();
        }

        @Override
        protected RNATemplateElement.EdgeEndPoint getNextEndPoint(RNATemplateElement.EdgeEndPoint edgeEndPoint) {
            if (edgeEndPoint == this.in) {
                return this.out;
            }
            return edgeEndPoint.getOtherEndPoint();
        }

        @Override
        protected RNATemplateElement.EdgeEndPoint getPreviousEndPoint(RNATemplateElement.EdgeEndPoint edgeEndPoint) {
            if (edgeEndPoint == this.out) {
                return this.in;
            }
            return edgeEndPoint.getOtherEndPoint();
        }

        @Override
        public RNATemplateElement.EdgeEndPoint getIn1EndPoint() {
            return this.in;
        }

        @Override
        public RNATemplateElement.EdgeEndPoint getEndPointFromPosition(EdgeEndPointPosition edgeEndPointPosition) {
            switch (edgeEndPointPosition) {
                case IN1: {
                    return this.getIn();
                }
                case OUT1: {
                    return this.getOut();
                }
            }
            return null;
        }

        @Override
        public EdgeEndPointPosition getPositionFromEndPoint(RNATemplateElement.EdgeEndPoint edgeEndPoint) {
            if (edgeEndPoint == this.in) {
                return EdgeEndPointPosition.IN1;
            }
            if (edgeEndPoint == this.out) {
                return EdgeEndPointPosition.OUT1;
            }
            return null;
        }
    }

    public class RNATemplateHelix
    extends RNATemplateElement {
        private int length;
        private Point2D.Double startPosition;
        private Point2D.Double endPosition;
        private boolean flipped;
        private In1Is in1Is;
        private String caption;
        private final RNATemplateElement.EdgeEndPoint in1;
        private final RNATemplateElement.EdgeEndPoint out1;
        private final RNATemplateElement.EdgeEndPoint in2;
        private final RNATemplateElement.EdgeEndPoint out2;
        private String _name;

        public boolean isFlipped() {
            return this.flipped;
        }

        public void setFlipped(boolean bl) {
            this.flipped = bl;
        }

        public In1Is getIn1Is() {
            return this.in1Is;
        }

        public void setIn1Is(In1Is in1Is) {
            this.in1Is = in1Is;
        }

        public String getCaption() {
            return this.caption;
        }

        public void setCaption(String string) {
            this.caption = string;
        }

        public boolean hasCaption() {
            return this.caption != null;
        }

        public RNATemplateHelix(String string) {
            this.flipped = false;
            this.in1Is = null;
            this.caption = null;
            this.in1 = new RNATemplateElement.EdgeEndPoint();
            this.out1 = new RNATemplateElement.EdgeEndPoint();
            this.in2 = new RNATemplateElement.EdgeEndPoint();
            this.out2 = new RNATemplateElement.EdgeEndPoint();
            this._name = string;
        }

        public String toString() {
            return "Helix    @" + Integer.toHexString(this.hashCode()) + " len=" + this.length + " caption=" + this.caption;
        }

        @Override
        public String getName() {
            return "" + this._name;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int n) {
            this.length = n;
        }

        public Point2D.Double getStartPosition() {
            return this.startPosition;
        }

        public void setStartPosition(Point2D.Double double_) {
            this.startPosition = double_;
        }

        public Point2D.Double getEndPosition() {
            return this.endPosition;
        }

        public void setEndPosition(Point2D.Double double_) {
            this.endPosition = double_;
        }

        public RNATemplateElement.EdgeEndPoint getIn1() {
            return this.in1;
        }

        public RNATemplateElement.EdgeEndPoint getOut1() {
            return this.out1;
        }

        public RNATemplateElement.EdgeEndPoint getIn2() {
            return this.in2;
        }

        public RNATemplateElement.EdgeEndPoint getOut2() {
            return this.out2;
        }

        @Override
        public void disconnectFromAny() {
            this.getIn1().disconnect();
            this.getIn2().disconnect();
            this.getOut1().disconnect();
            this.getOut2().disconnect();
        }

        @Override
        protected RNATemplateElement.EdgeEndPoint getNextEndPoint(RNATemplateElement.EdgeEndPoint edgeEndPoint) {
            if (edgeEndPoint == this.in1) {
                return this.out1;
            }
            if (edgeEndPoint == this.in2) {
                return this.out2;
            }
            return edgeEndPoint.getOtherEndPoint();
        }

        @Override
        protected RNATemplateElement.EdgeEndPoint getPreviousEndPoint(RNATemplateElement.EdgeEndPoint edgeEndPoint) {
            if (edgeEndPoint == this.out1) {
                return this.in1;
            }
            if (edgeEndPoint == this.out2) {
                return this.in2;
            }
            return edgeEndPoint.getOtherEndPoint();
        }

        @Override
        public RNATemplateElement.EdgeEndPoint getIn1EndPoint() {
            return this.in1;
        }

        @Override
        public RNATemplateElement.EdgeEndPoint getEndPointFromPosition(EdgeEndPointPosition edgeEndPointPosition) {
            switch (edgeEndPointPosition) {
                case IN1: {
                    return this.getIn1();
                }
                case IN2: {
                    return this.getIn2();
                }
                case OUT1: {
                    return this.getOut1();
                }
                case OUT2: {
                    return this.getOut2();
                }
            }
            return null;
        }

        @Override
        public EdgeEndPointPosition getPositionFromEndPoint(RNATemplateElement.EdgeEndPoint edgeEndPoint) {
            if (edgeEndPoint == this.in1) {
                return EdgeEndPointPosition.IN1;
            }
            if (edgeEndPoint == this.in2) {
                return EdgeEndPointPosition.IN2;
            }
            if (edgeEndPoint == this.out1) {
                return EdgeEndPointPosition.OUT1;
            }
            if (edgeEndPoint == this.out2) {
                return EdgeEndPointPosition.OUT2;
            }
            return null;
        }
    }

    public abstract class RNATemplateElement {
        public int _id = RNATemplate.access$708();
        private final RNATemplateElement element = this;

        public String getName() {
            return "RNATemplate" + this._id;
        }

        public RNATemplateElement() {
            RNATemplate.this.elements.add(this);
        }

        public abstract void disconnectFromAny();

        public abstract EdgeEndPoint getIn1EndPoint();

        public RNATemplate getParentTemplate() {
            return RNATemplate.this.template;
        }

        protected abstract EdgeEndPoint getNextEndPoint(EdgeEndPoint var1);

        protected abstract EdgeEndPoint getPreviousEndPoint(EdgeEndPoint var1);

        public abstract EdgeEndPoint getEndPointFromPosition(EdgeEndPointPosition var1);

        public abstract EdgeEndPointPosition getPositionFromEndPoint(EdgeEndPoint var1);

        public void connectTo(EdgeEndPointPosition edgeEndPointPosition, EdgeEndPoint edgeEndPoint) throws ExceptionEdgeEndpointAlreadyConnected, ExceptionInvalidRNATemplate {
            EdgeEndPoint edgeEndPoint2 = this.getEndPointFromPosition(edgeEndPointPosition);
            edgeEndPoint2.connectTo(edgeEndPoint);
        }

        public void connectTo(EdgeEndPointPosition edgeEndPointPosition, RNATemplateElement rNATemplateElement, EdgeEndPointPosition edgeEndPointPosition2) throws ExceptionEdgeEndpointAlreadyConnected, ExceptionEdgeEndpointAlreadyConnected, ExceptionInvalidRNATemplate {
            EdgeEndPoint edgeEndPoint = rNATemplateElement.getEndPointFromPosition(edgeEndPointPosition2);
            this.connectTo(edgeEndPointPosition, edgeEndPoint);
        }

        public class EdgeEndPoint {
            private EdgeEndPoint otherEndPoint;

            private EdgeEndPoint() {
            }

            public EdgeEndPoint getNextEndPoint() {
                return RNATemplateElement.this.element.getNextEndPoint(this);
            }

            public EdgeEndPoint getPreviousEndPoint() {
                return RNATemplateElement.this.element.getPreviousEndPoint(this);
            }

            public EdgeEndPointPosition getPosition() {
                return RNATemplateElement.this.element.getPositionFromEndPoint(this);
            }

            public RNATemplateElement getElement() {
                return RNATemplateElement.this.element;
            }

            public EdgeEndPoint getOtherEndPoint() {
                return this.otherEndPoint;
            }

            public RNATemplateElement getOtherElement() {
                return this.otherEndPoint != null ? this.otherEndPoint.getElement() : null;
            }

            public void disconnect() {
                if (this.otherEndPoint != null) {
                    this.otherEndPoint.otherEndPoint = null;
                    this.otherEndPoint = null;
                }
            }

            public boolean isConnected() {
                return this.otherEndPoint != null;
            }

            public void connectTo(EdgeEndPoint edgeEndPoint) throws ExceptionEdgeEndpointAlreadyConnected, ExceptionInvalidRNATemplate {
                if (this.otherEndPoint != null || edgeEndPoint.otherEndPoint != null) {
                    throw new ExceptionEdgeEndpointAlreadyConnected();
                }
                if (RNATemplate.this.template != edgeEndPoint.getElement().getParentTemplate()) {
                    throw new ExceptionInvalidRNATemplate("Elements from different templates cannot be connected with each other.");
                }
                this.otherEndPoint = edgeEndPoint;
                edgeEndPoint.otherEndPoint = this;
            }

            public String toString() {
                return "Edge endpoint on element " + RNATemplateElement.this.element.toString() + " at position " + this.getPosition().toString();
            }
        }
    }

    public static enum EdgeEndPointPosition {
        IN1,
        IN2,
        OUT1,
        OUT2;

    }

    public static enum In1Is {
        IN1_IS_5PRIME,
        IN1_IS_3PRIME;

    }

    private class LoadFromXml {
        private Document xmlDocument;
        private Map<String, RNATemplateElement> elementNames = new HashMap<String, RNATemplateElement>();

        public LoadFromXml(Document document) {
            this.xmlDocument = document;
        }

        private Point2D.Double pointFromXml(Element element) {
            Point2D.Double double_ = new Point2D.Double();
            double_.x = Double.parseDouble(element.getAttribute("x"));
            double_.y = Double.parseDouble(element.getAttribute("y"));
            return double_;
        }

        private double vectorLengthFromXml(Element element) {
            return Double.parseDouble(element.getAttribute("length"));
        }

        private double vectorAngleFromXml(Element element) {
            return Double.parseDouble(element.getAttribute("angle"));
        }

        private RNATemplateElement.EdgeEndPoint endPointFromXml(Element element) throws ExceptionXmlLoading {
            String string = element.getAttribute("endpoint");
            if (string == null || string == "") {
                throw new ExceptionXmlLoading("Missing endpoint attribute on " + element);
            }
            String string2 = element.getAttribute("position");
            if (string2 == null || string2 == "") {
                throw new ExceptionXmlLoading("Missing position attribute on " + element);
            }
            if (this.elementNames.containsKey(string)) {
                RNATemplateElement rNATemplateElement = this.elementNames.get(string);
                EdgeEndPointPosition edgeEndPointPosition = EdgeEndPointPosition.valueOf(string2);
                if (edgeEndPointPosition == null) {
                    throw new ExceptionXmlLoading("Could not compute relativePosition");
                }
                return rNATemplateElement.getEndPointFromPosition(edgeEndPointPosition);
            }
            throw new ExceptionXmlLoading("Edge is connected on unkown element: " + string);
        }

        private String connectErrMsg(RNATemplateElement.EdgeEndPoint edgeEndPoint, RNATemplateElement.EdgeEndPoint edgeEndPoint2, String string) {
            return "Error while connecting\n" + edgeEndPoint.toString() + " to\n" + edgeEndPoint2.toString() + " because:\n" + string;
        }

        private void connect(RNATemplateElement.EdgeEndPoint edgeEndPoint, RNATemplateElement.EdgeEndPoint edgeEndPoint2) throws ExceptionXmlLoading {
            if (edgeEndPoint == null || edgeEndPoint2 == null) {
                throw new ExceptionXmlLoading("Invalid edge: missing endpoint\n v1 = " + edgeEndPoint + "\n v2 = " + edgeEndPoint2);
            }
            if (edgeEndPoint2.isConnected()) {
                throw new ExceptionXmlLoading(this.connectErrMsg(edgeEndPoint, edgeEndPoint2, "Second vertex is already connected to " + edgeEndPoint2.getOtherElement().toString()));
            }
            if (edgeEndPoint.isConnected()) {
                throw new ExceptionXmlLoading(this.connectErrMsg(edgeEndPoint, edgeEndPoint2, "First vertex is already connected to " + edgeEndPoint.getOtherElement().toString()));
            }
            try {
                edgeEndPoint.connectTo(edgeEndPoint2);
            }
            catch (ExceptionEdgeEndpointAlreadyConnected exceptionEdgeEndpointAlreadyConnected) {
                throw new ExceptionXmlLoading("A vertex is on two edges at the same time: " + exceptionEdgeEndpointAlreadyConnected.getMessage());
            }
            catch (ExceptionInvalidRNATemplate exceptionInvalidRNATemplate) {
                throw new ExceptionXmlLoading("ExceptionInvalidRNATemplate: " + exceptionInvalidRNATemplate.getMessage());
            }
        }

        public void load() throws ExceptionXmlLoading {
            Object object;
            Node node;
            Object object2;
            Object object3;
            Object object4;
            Node node2;
            Element element = (Element)this.xmlDocument.getElementsByTagName("elements").item(0);
            Object object5 = element.getChildNodes();
            for (int i = 0; i < object5.getLength(); ++i) {
                Node node3;
                int n;
                Node node4 = object5.item(i);
                if (!(node4 instanceof Element)) continue;
                node2 = (Element)node4;
                object4 = node2.getTagName();
                if (object4 == "helix") {
                    object3 = new RNATemplateHelix(node2.getAttribute("id"));
                    ((RNATemplateHelix)object3).setFlipped(Boolean.parseBoolean(node2.getAttribute("flipped")));
                    ((RNATemplateHelix)object3).setLength(Integer.parseInt(node2.getAttribute("length")));
                    if (node2.hasAttribute("caption")) {
                        ((RNATemplateHelix)object3).setCaption(node2.getAttribute("caption"));
                    }
                    this.elementNames.put(node2.getAttribute("id"), (RNATemplateElement)object3);
                    object2 = node2.getChildNodes();
                    for (n = 0; n < object2.getLength(); ++n) {
                        node3 = object2.item(n);
                        if (!(node3 instanceof Element)) continue;
                        node = (Element)node3;
                        object = node.getTagName();
                        if (object == "startPosition") {
                            ((RNATemplateHelix)object3).setStartPosition(this.pointFromXml((Element)node));
                            continue;
                        }
                        if (object != "endPosition") continue;
                        ((RNATemplateHelix)object3).setEndPosition(this.pointFromXml((Element)node));
                    }
                    continue;
                }
                if (object4 != "sequence") continue;
                object3 = new RNATemplateUnpairedSequence(node2.getAttribute("id"));
                ((RNATemplateUnpairedSequence)object3).setLength(Integer.parseInt(node2.getAttribute("length")));
                this.elementNames.put(node2.getAttribute("id"), (RNATemplateElement)object3);
                object2 = node2.getChildNodes();
                for (n = 0; n < object2.getLength(); ++n) {
                    node3 = object2.item(n);
                    if (!(node3 instanceof Element)) continue;
                    node = (Element)node3;
                    object = node.getTagName();
                    if (object == "inTangentVector") {
                        ((RNATemplateUnpairedSequence)object3).setInTangentVectorLength(this.vectorLengthFromXml((Element)node));
                        ((RNATemplateUnpairedSequence)object3).setInTangentVectorAngle(this.vectorAngleFromXml((Element)node));
                        continue;
                    }
                    if (object == "outTangentVector") {
                        ((RNATemplateUnpairedSequence)object3).setOutTangentVectorLength(this.vectorLengthFromXml((Element)node));
                        ((RNATemplateUnpairedSequence)object3).setOutTangentVectorAngle(this.vectorAngleFromXml((Element)node));
                        continue;
                    }
                    if (object == "vertex5") {
                        ((RNATemplateUnpairedSequence)object3).setVertex5(this.pointFromXml((Element)node));
                        continue;
                    }
                    if (object != "vertex3") continue;
                    ((RNATemplateUnpairedSequence)object3).setVertex3(this.pointFromXml((Element)node));
                }
            }
            object5 = (Element)this.xmlDocument.getElementsByTagName("edges").item(0);
            NodeList nodeList = object5.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                node2 = nodeList.item(i);
                if (!(node2 instanceof Element) || (object4 = (Element)node2).getTagName() != "edge") continue;
                object3 = null;
                object2 = null;
                NodeList nodeList2 = object4.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    node = nodeList2.item(j);
                    if (!(node instanceof Element)) continue;
                    object = (Element)node;
                    String string = object.getTagName();
                    if (string == "from") {
                        object3 = this.endPointFromXml((Element)object);
                        continue;
                    }
                    if (string != "to") continue;
                    object2 = this.endPointFromXml((Element)object);
                }
                if (object3 == null) {
                    throw new ExceptionXmlLoading("Invalid edge: missing \"from\" declaration");
                }
                if (object2 == null) {
                    throw new ExceptionXmlLoading("Invalid edge: missing \"to\" declaration");
                }
                this.connect((RNATemplateElement.EdgeEndPoint)object3, (RNATemplateElement.EdgeEndPoint)object2);
            }
        }
    }

    private class ConvertToXml {
        private Map<RNATemplateElement, String> elementNames = new HashMap<RNATemplateElement, String>();
        private Element connectionsXmlElement;
        private Document document;

        private ConvertToXml() {
        }

        private void addConnectionIfNecessary(RNATemplateElement.EdgeEndPoint edgeEndPoint) {
            if (edgeEndPoint != null && edgeEndPoint.isConnected()) {
                RNATemplateElement rNATemplateElement = edgeEndPoint.getElement();
                EdgeEndPointPosition edgeEndPointPosition = edgeEndPoint.getPosition();
                RNATemplateElement rNATemplateElement2 = edgeEndPoint.getOtherElement();
                EdgeEndPointPosition edgeEndPointPosition2 = edgeEndPoint.getOtherEndPoint().getPosition();
                Element element = this.document.createElement("edge");
                Element element2 = this.document.createElement("from");
                element2.setAttribute("endpoint", this.elementNames.get(rNATemplateElement));
                element2.setAttribute("position", edgeEndPointPosition.toString());
                element.appendChild(element2);
                element2 = this.document.createElement("to");
                element2.setAttribute("endpoint", this.elementNames.get(rNATemplateElement2));
                element2.setAttribute("position", edgeEndPointPosition2.toString());
                element.appendChild(element2);
                this.connectionsXmlElement.appendChild(element);
            }
        }

        public Document toXMLDocument() throws ExceptionXMLGeneration, ExceptionInvalidRNATemplate {
            try {
                RNATemplateElement rNATemplateElement;
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                this.document = documentBuilder.newDocument();
                Element element = this.document.createElement("RNATemplate");
                this.document.appendChild(element);
                Element element2 = this.document.createElement("elements");
                element.appendChild(element2);
                this.connectionsXmlElement = this.document.createElement("edges");
                element.appendChild(this.connectionsXmlElement);
                int n = 1;
                int n2 = 1;
                for (Object object : RNATemplate.this.elements) {
                    if (object instanceof RNATemplateHelix) {
                        rNATemplateElement = (RNATemplateHelix)object;
                        if (this.elementNames.containsKey(rNATemplateElement)) continue;
                        this.elementNames.put(rNATemplateElement, "H ID " + n);
                        ++n;
                        continue;
                    }
                    if (object instanceof RNATemplateUnpairedSequence) {
                        rNATemplateElement = (RNATemplateUnpairedSequence)object;
                        if (this.elementNames.containsKey(rNATemplateElement)) continue;
                        this.elementNames.put(rNATemplateElement, "S ID " + n2);
                        ++n2;
                        continue;
                    }
                    throw new ExceptionInvalidRNATemplate("We have an endpoint which is neither an helix nor a sequence. What is that?");
                }
                for (RNATemplateElement rNATemplateElement2 : RNATemplate.this.elements) {
                    Element element3;
                    Object object;
                    String string = this.elementNames.get(rNATemplateElement2);
                    if (rNATemplateElement2 instanceof RNATemplateHelix) {
                        rNATemplateElement = (RNATemplateHelix)rNATemplateElement2;
                        object = this.document.createElement("helix");
                        object.setAttribute("id", string);
                        object.setAttribute("length", Integer.toString(((RNATemplateHelix)rNATemplateElement).getLength()));
                        object.setAttribute("flipped", Boolean.toString(((RNATemplateHelix)rNATemplateElement).isFlipped()));
                        if (((RNATemplateHelix)rNATemplateElement).hasCaption()) {
                            object.setAttribute("caption", ((RNATemplateHelix)rNATemplateElement).getCaption());
                        }
                        element3 = this.document.createElement("startPosition");
                        element3.setAttribute("x", Double.toString(((RNATemplateHelix)rNATemplateElement).getStartPosition().x));
                        element3.setAttribute("y", Double.toString(((RNATemplateHelix)rNATemplateElement).getStartPosition().y));
                        object.appendChild(element3);
                        element3 = this.document.createElement("endPosition");
                        element3.setAttribute("x", Double.toString(((RNATemplateHelix)rNATemplateElement).getEndPosition().x));
                        element3.setAttribute("y", Double.toString(((RNATemplateHelix)rNATemplateElement).getEndPosition().y));
                        object.appendChild(element3);
                        this.addConnectionIfNecessary(((RNATemplateHelix)rNATemplateElement).getOut1());
                        this.addConnectionIfNecessary(((RNATemplateHelix)rNATemplateElement).getOut2());
                    } else if (rNATemplateElement2 instanceof RNATemplateUnpairedSequence) {
                        rNATemplateElement = (RNATemplateUnpairedSequence)rNATemplateElement2;
                        object = this.document.createElement("sequence");
                        object.setAttribute("id", string);
                        object.setAttribute("length", Integer.toString(((RNATemplateUnpairedSequence)rNATemplateElement).getLength()));
                        element3 = this.document.createElement("vertex5");
                        element3.setAttribute("x", Double.toString(((RNATemplateUnpairedSequence)rNATemplateElement).getVertex5().x));
                        element3.setAttribute("y", Double.toString(((RNATemplateUnpairedSequence)rNATemplateElement).getVertex5().y));
                        object.appendChild(element3);
                        element3 = this.document.createElement("vertex3");
                        element3.setAttribute("x", Double.toString(((RNATemplateUnpairedSequence)rNATemplateElement).getVertex3().x));
                        element3.setAttribute("y", Double.toString(((RNATemplateUnpairedSequence)rNATemplateElement).getVertex3().y));
                        object.appendChild(element3);
                        element3 = this.document.createElement("inTangentVector");
                        element3.setAttribute("angle", Double.toString(((RNATemplateUnpairedSequence)rNATemplateElement).getInTangentVectorAngle()));
                        element3.setAttribute("length", Double.toString(((RNATemplateUnpairedSequence)rNATemplateElement).getInTangentVectorLength()));
                        object.appendChild(element3);
                        element3 = this.document.createElement("outTangentVector");
                        element3.setAttribute("angle", Double.toString(((RNATemplateUnpairedSequence)rNATemplateElement).getOutTangentVectorAngle()));
                        element3.setAttribute("length", Double.toString(((RNATemplateUnpairedSequence)rNATemplateElement).getOutTangentVectorLength()));
                        object.appendChild(element3);
                        this.addConnectionIfNecessary(((RNATemplateUnpairedSequence)rNATemplateElement).getOut());
                    } else {
                        throw new ExceptionInvalidRNATemplate("We have an endpoint which is neither an helix nor a sequence. What is that?");
                    }
                    element2.appendChild((Node)object);
                }
                return this.document;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new ExceptionXMLGeneration("ParserConfigurationException: " + parserConfigurationException.getMessage());
            }
        }
    }

    private class ConvertToTree {
        private Set<RNATemplateHelix> removedHelixes;
        private Iterator<RNATemplateElement> iter;
        private Set<RNATemplateHelix> knownHelixes;

        public ConvertToTree(Set<RNATemplateHelix> set) {
            this.iter = RNATemplate.this.template.rnaIterator();
            this.knownHelixes = new HashSet<RNATemplateHelix>();
            this.removedHelixes = set;
        }

        public Tree<RNANodeValueTemplate> convert() throws ExceptionInvalidRNATemplate {
            Tree<RNANodeValueTemplate> tree = new Tree<RNANodeValueTemplate>();
            tree.setValue(null);
            this.makeChildren(tree);
            return tree;
        }

        private void makeChildren(Tree<RNANodeValueTemplate> tree) throws ExceptionInvalidRNATemplate {
            List<Tree<RNANodeValueTemplate>> list = tree.getChildren();
            try {
                block2: while (true) {
                    int n;
                    RNATemplateElement rNATemplateElement;
                    RNATemplateElement rNATemplateElement2;
                    if ((rNATemplateElement2 = this.iter.next()) instanceof RNATemplateHelix) {
                        int n2;
                        rNATemplateElement = (RNATemplateHelix)rNATemplateElement2;
                        if (this.removedHelixes.contains(rNATemplateElement)) {
                            if (this.knownHelixes.contains(rNATemplateElement)) {
                                n = 0;
                            } else {
                                this.knownHelixes.add((RNATemplateHelix)rNATemplateElement);
                                n = 1;
                            }
                            int n3 = ((RNATemplateHelix)rNATemplateElement).getLength();
                            if (n3 < 1) {
                                throw new ExceptionInvalidRNATemplate("Helix length < 1");
                            }
                            n2 = n != 0 ? 0 : n3;
                            int n4 = n != 0 ? n3 : 2 * n3;
                            int n5 = n2;
                            while (true) {
                                if (n5 >= n4) continue block2;
                                RNANodeValueTemplateBrokenBasePair rNANodeValueTemplateBrokenBasePair = new RNANodeValueTemplateBrokenBasePair();
                                rNANodeValueTemplateBrokenBasePair.setHelix((RNATemplateHelix)rNATemplateElement);
                                rNANodeValueTemplateBrokenBasePair.setPositionInHelix(n5);
                                Tree<RNANodeValueTemplateBrokenBasePair> tree2 = new Tree<RNANodeValueTemplateBrokenBasePair>();
                                tree2.setValue(rNANodeValueTemplateBrokenBasePair);
                                tree.getChildren().add(tree2);
                                ++n5;
                            }
                        }
                        if (this.knownHelixes.contains(rNATemplateElement)) {
                            if (!(tree.getValue() instanceof RNANodeValueTemplateBasePair) || ((RNANodeValueTemplateBasePair)tree.getValue()).getHelix() != rNATemplateElement) {
                                throw new ExceptionInvalidRNATemplate("Unexpected helix. Looks like there still are pseudoknots even after we removed them so something is wrong about the template.");
                            }
                            return;
                        }
                        this.knownHelixes.add((RNATemplateHelix)rNATemplateElement);
                        n = ((RNATemplateHelix)rNATemplateElement).getLength();
                        if (n < 1) {
                            throw new ExceptionInvalidRNATemplate("Helix length < 1");
                        }
                        Tree<RNANodeValueTemplate> tree3 = tree;
                        for (n2 = 0; n2 < n; ++n2) {
                            RNANodeValueTemplateBasePair rNANodeValueTemplateBasePair = new RNANodeValueTemplateBasePair();
                            rNANodeValueTemplateBasePair.setHelix((RNATemplateHelix)rNATemplateElement);
                            rNANodeValueTemplateBasePair.setPositionInHelix(n2);
                            Tree<RNANodeValueTemplateBasePair> tree4 = new Tree<RNANodeValueTemplateBasePair>();
                            tree4.setValue(rNANodeValueTemplateBasePair);
                            tree3.getChildren().add(tree4);
                            tree3 = tree4;
                        }
                        this.makeChildren(tree3);
                        continue;
                    }
                    if (!(rNATemplateElement2 instanceof RNATemplateUnpairedSequence)) break;
                    rNATemplateElement = (RNATemplateUnpairedSequence)rNATemplateElement2;
                    n = ((RNATemplateUnpairedSequence)rNATemplateElement).getLength();
                    if (n < 1) {
                        throw new ExceptionInvalidRNATemplate("Non-paired sequence length < 1");
                    }
                    RNANodeValueTemplateSequence rNANodeValueTemplateSequence = new RNANodeValueTemplateSequence();
                    rNANodeValueTemplateSequence.setSequence((RNATemplateUnpairedSequence)rNATemplateElement);
                    Tree<RNANodeValueTemplateSequence> tree5 = new Tree<RNANodeValueTemplateSequence>();
                    tree5.setValue(rNANodeValueTemplateSequence);
                    list.add(tree5);
                }
                throw new ExceptionInvalidRNATemplate("We have an endpoint which is neither an helix nor a sequence. What is that?");
            }
            catch (NoSuchElementException noSuchElementException) {
                if (tree.getValue() == null) {
                    return;
                }
                throw new ExceptionInvalidRNATemplate("Unexpected end of template endpoint list.");
            }
        }
    }

    private class RemovePseudoKnots {
        private ArrayList<RNATemplateHelix> helixesSeq;
        private ArrayList<Integer> helixesStruct;
        private int[] helixesStructWithoutPseudoKnots;

        private RemovePseudoKnots() {
        }

        private void initArrays() throws ExceptionInvalidRNATemplate {
            this.helixesSeq = new ArrayList();
            this.helixesStruct = new ArrayList();
            Hashtable<RNATemplateHelix, Integer> hashtable = new Hashtable<RNATemplateHelix, Integer>();
            Iterator<RNATemplateElement> iterator = RNATemplate.this.rnaIterator();
            while (iterator.hasNext()) {
                RNATemplateElement rNATemplateElement = iterator.next();
                if (!(rNATemplateElement instanceof RNATemplateHelix)) continue;
                this.helixesSeq.add((RNATemplateHelix)rNATemplateElement);
                int n = this.helixesSeq.size() - 1;
                if (hashtable.containsKey(rNATemplateElement)) {
                    int n2 = (Integer)hashtable.get(rNATemplateElement);
                    this.helixesStruct.add(n2);
                    if (this.helixesStruct.get(n2) != -1) {
                        throw new ExceptionInvalidRNATemplate("We met an helix 3 times. Is there a cycle?");
                    }
                    this.helixesStruct.set(n2, n);
                    continue;
                }
                hashtable.put((RNATemplateHelix)rNATemplateElement, n);
                this.helixesStruct.add(-1);
            }
        }

        private boolean isSelfCrossing() {
            Stack<Point> stack = new Stack<Point>();
            stack.add(new Point(0, this.helixesStruct.size() - 1));
            while (!stack.empty()) {
                Point point = (Point)stack.pop();
                if (point.x > point.y) continue;
                if (this.helixesStruct.get(point.x) == -1) {
                    stack.push(new Point(point.x + 1, point.y));
                    continue;
                }
                int n = point.x;
                int n2 = point.y;
                int n3 = this.helixesStruct.get(n);
                if (n3 <= n || n3 > n2) {
                    return true;
                }
                stack.push(new Point(n + 1, n3 - 1));
                stack.push(new Point(n3 + 1, n2));
            }
            return false;
        }

        private void removePseudoKnotsAux() {
            if (!this.isSelfCrossing()) {
                this.helixesStructWithoutPseudoKnots = new int[this.helixesStruct.size()];
                for (int i = 0; i < this.helixesStructWithoutPseudoKnots.length; ++i) {
                    this.helixesStructWithoutPseudoKnots[i] = this.helixesStruct.get(i);
                }
            } else {
                int n;
                int n2;
                int n3;
                int n4;
                int n5 = this.helixesStruct.size();
                int[] nArray = new int[n5];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = -1;
                }
                short[][] sArray = new short[n5][n5];
                short[][] sArray2 = new short[n5][n5];
                for (n4 = 0; n4 < nArray.length; ++n4) {
                    sArray2[n4][n4] = -1;
                }
                for (n4 = 1; n4 < n5; ++n4) {
                    for (int i = 0; i < n5 - n4; ++i) {
                        n3 = i + n4;
                        sArray[i][n3] = sArray[i + 1][n3];
                        sArray2[i][n3] = -1;
                        n2 = this.helixesStruct.get(i);
                        assert (n2 != -1);
                        if (n2 > n3 || i >= n2) continue;
                        n = this.helixesSeq.get(i).getLength();
                        if (i + 1 <= n2 - 1) {
                            n += sArray[i + 1][n2 - 1];
                        }
                        if (n2 + 1 <= n3) {
                            n += sArray[n2 + 1][n3];
                        }
                        if (n <= sArray[i][n3]) continue;
                        sArray[i][n3] = (short)n;
                        sArray2[i][n3] = (short)n2;
                    }
                }
                Stack<Point> stack = new Stack<Point>();
                stack.add(new Point(0, n5 - 1));
                while (!stack.empty()) {
                    Point point = (Point)stack.pop();
                    if (point.x > point.y) continue;
                    if (sArray2[point.x][point.y] == -1) {
                        nArray[point.x] = -1;
                        stack.push(new Point(point.x + 1, point.y));
                        continue;
                    }
                    n3 = point.x;
                    n2 = point.y;
                    nArray[n3] = n = sArray2[n3][n2];
                    nArray[n] = n3;
                    stack.push(new Point(n3 + 1, n - 1));
                    stack.push(new Point(n + 1, n2));
                }
                this.helixesStructWithoutPseudoKnots = nArray;
            }
        }

        private Set<RNATemplateHelix> makeSet() {
            HashSet<RNATemplateHelix> hashSet = new HashSet<RNATemplateHelix>();
            for (int i = 0; i < this.helixesStructWithoutPseudoKnots.length; ++i) {
                if (this.helixesStructWithoutPseudoKnots[i] >= 0) continue;
                hashSet.add(this.helixesSeq.get(i));
            }
            return hashSet;
        }

        public Set<RNATemplateHelix> removePseudoKnots() throws ExceptionInvalidRNATemplate {
            this.initArrays();
            this.removePseudoKnotsAux();
            return this.makeSet();
        }
    }

    private class MakeEdgeList {
        List<RNATemplateElement.EdgeEndPoint> list = new LinkedList<RNATemplateElement.EdgeEndPoint>();

        private MakeEdgeList() {
        }

        private void addEdgeIfNecessary(RNATemplateElement.EdgeEndPoint edgeEndPoint) {
            if (edgeEndPoint.isConnected()) {
                this.list.add(edgeEndPoint);
            }
        }

        public List<RNATemplateElement.EdgeEndPoint> make() {
            for (RNATemplateElement rNATemplateElement : RNATemplate.this.elements) {
                RNATemplateElement rNATemplateElement2;
                if (rNATemplateElement instanceof RNATemplateHelix) {
                    rNATemplateElement2 = (RNATemplateHelix)rNATemplateElement;
                    this.addEdgeIfNecessary(((RNATemplateHelix)rNATemplateElement2).getIn1());
                    this.addEdgeIfNecessary(((RNATemplateHelix)rNATemplateElement2).getIn2());
                    continue;
                }
                if (!(rNATemplateElement instanceof RNATemplateUnpairedSequence)) continue;
                rNATemplateElement2 = (RNATemplateUnpairedSequence)rNATemplateElement;
                this.addEdgeIfNecessary(((RNATemplateUnpairedSequence)rNATemplateElement2).getIn());
            }
            return this.list;
        }
    }

    private class VertexIterator
    implements Iterator<RNATemplateElement.EdgeEndPoint> {
        private RNATemplateElement.EdgeEndPoint endpoint;

        private VertexIterator() {
            this.endpoint = RNATemplate.this.getFirstEndPoint();
        }

        @Override
        public boolean hasNext() {
            return this.endpoint != null;
        }

        @Override
        public RNATemplateElement.EdgeEndPoint next() {
            if (this.endpoint == null) {
                throw new NoSuchElementException();
            }
            RNATemplateElement.EdgeEndPoint edgeEndPoint = this.endpoint;
            this.endpoint = edgeEndPoint.getNextEndPoint();
            return edgeEndPoint;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class RNAIterator
    implements Iterator<RNATemplateElement> {
        private Iterator<RNATemplateElement.EdgeEndPoint> iter;

        private RNAIterator() {
            this.iter = RNATemplate.this.vertexIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public RNATemplateElement next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            RNATemplateElement.EdgeEndPoint edgeEndPoint = this.iter.next();
            switch (edgeEndPoint.getPosition()) {
                case IN1: 
                case IN2: {
                    edgeEndPoint = this.iter.next();
                }
            }
            return edgeEndPoint.getElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

