/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.geom;

import java.awt.geom.Point2D;

public class CubicBezierCurve {
    private Point2D.Double P0;
    private Point2D.Double P1;
    private Point2D.Double P2;
    private Point2D.Double P3;
    private int n;
    private Point2D.Double[] points;
    private double[] lengths;
    private Point2D.Double[] unitVectors;

    public int getN() {
        return this.n;
    }

    public double getApproxCurveLength() {
        return this.lengths[this.n - 1];
    }

    public Point2D.Double standardParam(double d) {
        double d2 = Math.pow(1.0 - d, 3.0) * this.P0.x + 3.0 * Math.pow(1.0 - d, 2.0) * d * this.P1.x + 3.0 * (1.0 - d) * d * d * this.P2.x + d * d * d * this.P3.x;
        double d3 = Math.pow(1.0 - d, 3.0) * this.P0.y + 3.0 * Math.pow(1.0 - d, 2.0) * d * this.P1.y + 3.0 * (1.0 - d) * d * d * this.P2.y + d * d * d * this.P3.y;
        return new Point2D.Double(d2, d3);
    }

    public Point2D.Double[] uniformParam(double[] dArray) {
        int n = dArray.length;
        Point2D.Double[] doubleArray = new Point2D.Double[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            while (n2 < this.n && this.lengths[n2] < dArray[i]) {
                ++n2;
            }
            if (n2 >= this.n) {
                n2 = this.n - 1;
            }
            if (dArray[i] < 0.0) {
                throw new IllegalArgumentException("t[" + i + "] < 0");
            }
            double d = dArray[i] - (n2 != 0 ? this.lengths[n2 - 1] : 0.0);
            double d2 = this.points[n2].x + this.unitVectors[n2].x * d;
            double d3 = this.points[n2].y + this.unitVectors[n2].y * d;
            doubleArray[i] = new Point2D.Double(d2, d3);
        }
        return doubleArray;
    }

    public CubicBezierCurve(Point2D.Double double_, Point2D.Double double_2, Point2D.Double double_3, Point2D.Double double_4, int n) {
        this.P0 = double_;
        this.P1 = double_2;
        this.P2 = double_3;
        this.P3 = double_4;
        this.n = n;
        if (n < 1) {
            throw new IllegalArgumentException("n must be at least 1");
        }
        this.computeData();
    }

    private void computeData() {
        this.points = new Point2D.Double[this.n + 1];
        for (int i = 0; i <= this.n; ++i) {
            this.points[i] = this.standardParam((double)i / (double)this.n);
        }
        this.lengths = new double[this.n];
        this.unitVectors = new Point2D.Double[this.n];
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            double d2 = this.lineLength(this.points[i], this.points[i + 1]);
            double d3 = (this.points[i + 1].x - this.points[i].x) / d2;
            double d4 = (this.points[i + 1].y - this.points[i].y) / d2;
            this.unitVectors[i] = new Point2D.Double(d3, d4);
            this.lengths[i] = d += d2;
        }
    }

    private double lineLength(Point2D.Double double_, Point2D.Double double_2) {
        return double_2.distance(double_);
    }

    public Point2D.Double getP0() {
        return this.P0;
    }

    public Point2D.Double getP1() {
        return this.P1;
    }

    public Point2D.Double getP2() {
        return this.P2;
    }

    public Point2D.Double getP3() {
        return this.P3;
    }
}

