/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models.export;

import fr.orsay.lri.varna.models.export.SecStrDrawingProducer;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class SVGExport
extends SecStrDrawingProducer {
    private double _fontsize = 10.0;
    private Rectangle2D.Double _bb = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
    double _thickness = 2.0;

    public SVGExport() {
        super.setScale(0.5);
    }

    private String getRGBString(Color color) {
        int n = (int)((double)color.getRed() / 255.0 * 100.0);
        int n2 = (int)((double)color.getGreen() / 255.0 * 100.0);
        int n3 = (int)((double)color.getBlue() / 255.0 * 100.0);
        return "rgb(" + n + "%, " + n2 + "%, " + n3 + "%)";
    }

    @Override
    public String drawCircleS(Point2D.Double double_, double d, double d2) {
        this._thickness = d2;
        return "<circle cx=\"" + double_.x + "\" cy=\"" + (this._bb.height - double_.y) + "\" r=\"" + d + "\" stroke=\"" + this.getRGBString(this._curColor) + "\" stroke-width=\"" + d2 + "\" fill=\"none\"/>\n";
    }

    @Override
    public String drawLineS(Point2D.Double double_, Point2D.Double double_2, double d) {
        this._thickness = d;
        return "<line x1=\"" + double_.x + "\" y1=\"" + (this._bb.height - double_.y) + "\" x2=\"" + double_2.x + "\" y2=\"" + (this._bb.height - double_2.y) + "\" stroke=\"" + this.getRGBString(this._curColor) + "\" stroke-width=\"" + d + "\" />\n";
    }

    @Override
    public String drawRectangleS(Point2D.Double double_, Point2D.Double double_2, double d) {
        this._thickness = d;
        return "<rect x=\"" + double_.x + "\" y=\"" + (this._bb.height - double_.y - double_2.y) + "\" width=\"" + double_2.x + "\" height=\"" + double_2.y + "\" fill=\"none\" style=\"stroke-width:" + d + ";stroke:" + this.getRGBString(this._curColor) + "\"/>";
    }

    @Override
    public String drawTextS(Point2D.Double double_, String string) {
        return "<text x=\"" + double_.x + "\" y=\"" + (this._bb.height - double_.y + 0.4 * this._fontsize) + "\" text-anchor=\"middle\" font-family=\"Verdana\" font-size=\"" + this._fontsize + "\" fill=\"" + this.getRGBString(this._curColor) + "\" >" + string + "</text>\n";
    }

    @Override
    public String fillCircleS(Point2D.Double double_, double d, double d2, Color color) {
        this._thickness = d2;
        return "<circle cx=\"" + double_.x + "\" cy=\"" + (this._bb.height - double_.y) + "\" r=\"" + d + "\" stroke=\"none\" stroke-width=\"" + d2 + "\" fill=\"" + this.getRGBString(color) + "\"/>\n";
    }

    @Override
    public String footerS() {
        return "</svg>\n";
    }

    @Override
    public String headerS(Rectangle2D.Double double_) {
        this._bb = double_;
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \n\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n\n<svg width=\"100%\" height=\"100%\" version=\"1.1\"\nxmlns=\"http://www.w3.org/2000/svg\">\n";
    }

    @Override
    public String setFontS(int n, double d) {
        this._fontsize = 0.5 * d;
        return "";
    }

    @Override
    public String drawArcS(Point2D.Double double_, double d, double d2, double d3, double d4) {
        double d5 = d / 2.0;
        double d6 = d2 / 2.0;
        double d7 = double_.x;
        double d8 = this._bb.height - double_.y;
        double d9 = double_.x + d;
        double d10 = this._bb.height - double_.y;
        String string = "<path d=\"M " + d7 + "," + d8 + " A " + d5 + "," + d6 + " 0 0,1 " + d9 + "," + d10 + "\" style=\"fill:none; stroke:" + this.getRGBString(this._curColor) + "; stroke-width:" + this._thickness + "\"/>\n";
        return string;
    }

    @Override
    public String drawPolygonS(Point2D.Double[] doubleArray, double d) {
        String string = "<path d=\"";
        for (int i = 0; i < doubleArray.length; ++i) {
            string = i == 0 ? string + "M " + doubleArray[i].x + " " + (this._bb.height - doubleArray[i].y) + " " : string + "L " + doubleArray[i].x + " " + (this._bb.height - doubleArray[i].y) + " ";
        }
        string = string + "z\" style=\"fill:none; stroke:" + this.getRGBString(this._curColor) + "; stroke-width:" + d + ";\"/>\n";
        return string;
    }

    @Override
    public String fillPolygonS(Point2D.Double[] doubleArray, Color color) {
        String string = "<path d=\"";
        for (int i = 0; i < doubleArray.length; ++i) {
            string = i == 0 ? string + "M " + doubleArray[i].x + " " + (this._bb.height - doubleArray[i].y) + " " : string + "L " + doubleArray[i].x + " " + (this._bb.height - doubleArray[i].y) + " ";
        }
        string = string + "z\" fill=\"" + this.getRGBString(color) + "\" style=\"stroke:none;\"/>\n";
        return string;
    }
}

