/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.deploy;

import java.io.File;
import net.sf.jnati.NativeCodeException;
import net.sf.jnati.deploy.NativeArtefactLocator;
import net.sf.jnati.deploy.artefact.Artefact;
import net.sf.jnati.deploy.artefact.ArtefactFile;
import org.apache.log4j.Logger;

public class NativeLibraryLoader {
    private static final Logger LOG = Logger.getLogger(NativeLibraryLoader.class);

    public static void loadLibrary(String id, String version) throws NativeCodeException {
        NativeArtefactLocator locator = new NativeArtefactLocator();
        Artefact artefact = locator.getArtefact(id, version);
        File root = artefact.getPath();
        for (ArtefactFile mr : artefact.getFileList()) {
            if (!mr.isLibrary()) continue;
            File file = new File(root, mr.getPath());
            String path = file.getPath();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading library: " + path));
            }
            try {
                System.load(path);
            }
            catch (UnsatisfiedLinkError e) {
                LOG.error((Object)("Error loading native library: " + path), (Throwable)e);
                throw new NativeCodeException("Error loading native library: " + path, e);
            }
        }
    }
}

