/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.cache;

import com.threerings.getdown.util.FileUtil;
import jalview.util.FileUtils;
import java.io.File;
import java.io.IOException;

public class ResourceCache {
    private final File _cacheDir;
    static final String LAST_ACCESSED_FILE_SUFFIX = ".lastAccessed";

    public ResourceCache(File _cacheDir) throws IOException {
        this._cacheDir = _cacheDir;
        this.createDirectoryIfNecessary(_cacheDir);
    }

    private void createDirectoryIfNecessary(File dir) throws IOException {
        if (!dir.exists() && !FileUtils.mkdirs(dir)) {
            throw new IOException("unable to create directory: " + dir.getAbsolutePath());
        }
    }

    public File cacheFile(File fileToCache, String cacheSubdir, String digest) throws IOException {
        File cacheLocation = new File(this._cacheDir, cacheSubdir);
        this.createDirectoryIfNecessary(cacheLocation);
        File cachedFile = new File(cacheLocation, digest + this.getFileSuffix(fileToCache));
        File lastAccessedFile = new File(cacheLocation, cachedFile.getName() + LAST_ACCESSED_FILE_SUFFIX);
        if (!cachedFile.exists()) {
            this.createNewFile(cachedFile);
            FileUtil.copy(fileToCache, cachedFile);
        }
        if (lastAccessedFile.exists()) {
            lastAccessedFile.setLastModified(System.currentTimeMillis());
        } else {
            this.createNewFile(lastAccessedFile);
        }
        return cachedFile;
    }

    private void createNewFile(File fileToCreate) throws IOException {
        if (!fileToCreate.exists() && !fileToCreate.createNewFile()) {
            throw new IOException("unable to create new file: " + fileToCreate.getAbsolutePath());
        }
    }

    private String getFileSuffix(File fileToCache) {
        String fileName = fileToCache.getName();
        int index = fileName.lastIndexOf(".");
        return index > -1 ? fileName.substring(index) : "";
    }
}

