/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.dbsources;

import com.stevesoft.pat.Regex;
import jalview.api.FeatureSettingsModelI;
import jalview.bin.Console;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.gui.Desktop;
import jalview.io.DataSourceType;
import jalview.io.FileFormat;
import jalview.io.FormatAdapter;
import jalview.io.PDBFeatureSettings;
import jalview.structure.StructureImportSettings;
import jalview.structure.StructureMapping;
import jalview.structure.StructureSelectionManager;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.ws.datamodel.alphafold.PAEContactMatrix;
import jalview.ws.dbsources.EbiFileRetrievedProxy;
import jalview.ws.utils.UrlDownloadClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;

public class EBIAlfaFold
extends EbiFileRetrievedProxy {
    private static final String SEPARATOR = "|";
    private static final String COLON = ":";
    private static String AF_VERSION = null;
    private static final long PAE_CACHE_STALE_TIME = 86400000L;
    private static Map<String, File> paeDownloadCache = new HashMap<String, File>();

    @Override
    public String getAccessionSeparator() {
        return null;
    }

    @Override
    public Regex getAccessionValidator() {
        Regex validator = new Regex("(AF-[A-Z]+[0-9]+[A-Z0-9]+-F1)");
        validator.setIgnoreCase(true);
        return validator;
    }

    @Override
    public String getDbSource() {
        return "ALPHAFOLD";
    }

    @Override
    public String getDbVersion() {
        return "1";
    }

    public static String pingAPIVersion() {
        if (AF_VERSION != null) {
            return AF_VERSION;
        }
        String Version = null;
        try {
            URL ping = new URL("https://alphafold.ebi.ac.uk/api/prediction/Q5VSL9");
            Object resp = Platform.parseJSON(ping.openStream());
            if (resp != null && resp instanceof JSONArray) {
                AF_VERSION = Version = ((JSONObject)((JSONArray)resp).get(0)).get("latestVersion").toString();
            }
        }
        catch (Throwable x) {
            Console.errPrintln("Couldn't get EBI AlphaFold DB latest version!");
            Console.errPrintln(x);
        }
        return Version;
    }

    public static String getAlphaFoldCifDownloadUrl(String id, String vnum) {
        if (vnum == null || vnum.length() == 0) {
            EBIAlfaFold.pingAPIVersion();
            vnum = AF_VERSION;
        }
        return "https://alphafold.ebi.ac.uk/files/" + id + "-model_v" + vnum + ".cif";
    }

    public static String getAlphaFoldPaeDownloadUrl(String id, String vnum) {
        if (vnum == null || vnum.length() == 0) {
            EBIAlfaFold.pingAPIVersion();
            vnum = AF_VERSION;
        }
        return "https://alphafold.ebi.ac.uk/files/" + id + "-predicted_aligned_error_v" + vnum + ".json";
    }

    @Override
    public AlignmentI getSequenceRecords(String queries) throws Exception {
        return this.getSequenceRecords(queries, null);
    }

    public AlignmentI getSequenceRecords(String queries, String retrievalUrl) throws Exception {
        AlignmentI pdbAlignment = null;
        String chain = null;
        String id = null;
        if (queries.indexOf(COLON) > -1) {
            chain = queries.substring(queries.indexOf(COLON) + 1);
            id = queries.substring(0, queries.indexOf(COLON));
        } else {
            id = queries;
        }
        if (!this.isValidReference(id)) {
            Console.errPrintln("(AFClient) Ignoring invalid alphafold query: '" + id + "'");
            this.stopQuery();
            return null;
        }
        String alphaFoldCif = EBIAlfaFold.getAlphaFoldCifDownloadUrl(id, AF_VERSION);
        if (retrievalUrl != null) {
            alphaFoldCif = retrievalUrl;
        }
        try {
            File tmpFile = File.createTempFile(id, ".cif");
            Console.debug("Retrieving structure file for " + id + " from " + alphaFoldCif);
            UrlDownloadClient.download(alphaFoldCif, tmpFile);
            this.file = tmpFile.getAbsolutePath();
            if (this.file == null) {
                return null;
            }
            pdbAlignment = EBIAlfaFold.importDownloadedStructureFromUrl(alphaFoldCif, tmpFile, id, chain, this.getDbSource(), this.getDbVersion());
            if (pdbAlignment == null || pdbAlignment.getHeight() < 1) {
                throw new Exception(MessageManager.formatMessage("exception.no_pdb_records_for_chain", new String[]{id, chain == null ? "' '" : chain}));
            }
        }
        catch (Exception ex) {
            this.stopQuery();
            throw ex;
        }
        return pdbAlignment;
    }

    public static File fetchAlphaFoldPAE(String id, String retrievalUrl) throws IOException {
        String paeURL = EBIAlfaFold.getAlphaFoldPaeDownloadUrl(id, AF_VERSION);
        if (retrievalUrl != null) {
            paeURL = retrievalUrl.replace("model", "predicted_aligned_error").replace(".cif", ".json");
        }
        return EBIAlfaFold.fetchAPAE_from(id, paeURL);
    }

    public static File fetchAPAE_from(String id, String paeURL) throws IOException {
        File pae = paeDownloadCache.get(paeURL);
        if (pae != null && pae.exists() && new Date().getTime() - pae.lastModified() < 86400000L) {
            Console.debug("Using existing file in PAE cache for '" + paeURL + "'");
            return pae;
        }
        try {
            pae = File.createTempFile(id == null ? "af_pae" : id, "pae_json");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Console.debug("Downloading pae from " + paeURL + " to " + pae.toString());
        UrlDownloadClient.download(paeURL, pae);
        paeDownloadCache.put(paeURL, pae);
        return pae;
    }

    public static void retrieve_AlphaFold_pAE(String id, AlignmentI pdbAlignment, String retrievalUrl) throws IOException {
        File pae = EBIAlfaFold.fetchAlphaFoldPAE(id, retrievalUrl);
        EBIAlfaFold.addAlphaFoldPAE(pdbAlignment, pae, 0, null, false, false, null);
    }

    public static void addAlphaFoldPAE(AlignmentI pdbAlignment, File pae, int index, String id, boolean isStruct, boolean isStructId, String label) {
        FileInputStream paeInput = null;
        try {
            paeInput = new FileInputStream(pae);
        }
        catch (FileNotFoundException e) {
            Console.error("Could not find pAE file '" + pae.getAbsolutePath() + "'", e);
            return;
        }
        if (isStruct) {
            StructureSelectionManager ssm = StructureSelectionManager.getStructureSelectionManager(Desktop.instance);
            if (ssm != null) {
                String structFilename = isStructId ? ssm.findFileForPDBId(id) : id;
                EBIAlfaFold.addPAEToStructure(ssm, structFilename, pae, label);
            }
        } else {
            try {
                if (!EBIAlfaFold.importPaeJSONAsContactMatrixToSequence(pdbAlignment, paeInput, index, id, label)) {
                    Console.warn("Could not import contact matrix from '" + pae.getAbsolutePath() + "' to sequence.");
                }
            }
            catch (IOException e1) {
                Console.error("Error when importing pAE file '" + pae.getAbsolutePath() + "'", e1);
            }
            catch (ParseException e2) {
                Console.error("Error when parsing pAE file '" + pae.getAbsolutePath() + "'", e2);
            }
        }
    }

    public static void addPAEToStructure(StructureSelectionManager ssm, String structFilename, File pae, String label) {
        FileInputStream paeInput = null;
        try {
            paeInput = new FileInputStream(pae);
        }
        catch (FileNotFoundException e) {
            Console.error("Could not find pAE file '" + pae.getAbsolutePath() + "'", e);
            return;
        }
        if (ssm == null) {
            ssm = StructureSelectionManager.getStructureSelectionManager(Desktop.instance);
        }
        if (ssm != null) {
            StructureMapping[] smArray = ssm.getMapping(structFilename);
            try {
                if (!EBIAlfaFold.importPaeJSONAsContactMatrixToStructure(smArray, (InputStream)paeInput, label)) {
                    Console.warn("Could not import contact matrix from '" + pae.getAbsolutePath() + "' to structure.");
                }
            }
            catch (IOException e1) {
                Console.error("Error when importing pAE file '" + pae.getAbsolutePath() + "'", e1);
            }
            catch (ParseException e2) {
                Console.error("Error when parsing pAE file '" + pae.getAbsolutePath() + "'", e2);
            }
        }
    }

    public static boolean importPaeJSONAsContactMatrixToSequence(AlignmentI pdbAlignment, InputStream pae_input, int index, String seqId, String label) throws IOException, ParseException {
        SequenceI sequence = null;
        if (seqId == null) {
            int seqToGet = index > 0 ? index : 0;
            sequence = pdbAlignment.getSequenceAt(seqToGet);
        }
        if (sequence == null) {
            SequenceI[] sequences = pdbAlignment.findSequenceMatch(seqId);
            if (sequences == null || sequences.length < 1) {
                Console.warn("Could not find sequence with id '" + seqId + "' to attach pAE matrix to. Ignoring matrix.");
                return false;
            }
            sequence = sequences[0];
        }
        if (sequence == null) {
            return false;
        }
        return EBIAlfaFold.importPaeJSONAsContactMatrixToSequence(pdbAlignment, pae_input, sequence, label);
    }

    public static boolean importPaeJSONAsContactMatrixToSequence(AlignmentI pdbAlignment, InputStream pae_input, SequenceI sequence, String label) throws IOException, ParseException {
        JSONObject paeDict = EBIAlfaFold.parseJSONtoPAEContactMatrix(pae_input);
        if (paeDict == null) {
            Console.debug("JSON file did not parse properly.");
            return false;
        }
        PAEContactMatrix matrix = new PAEContactMatrix(sequence, paeDict);
        AlignmentAnnotation cmannot = sequence.addContactList(matrix);
        if (label != null) {
            cmannot.label = label;
        }
        pdbAlignment.addAnnotation(cmannot);
        return true;
    }

    public static JSONObject parseJSONtoPAEContactMatrix(InputStream pae_input) throws IOException, ParseException {
        JSONArray jsonArray;
        Object paeJson = Platform.parseJSON(pae_input);
        JSONObject paeDict = null;
        if (paeJson instanceof JSONObject) {
            paeDict = (JSONObject)paeJson;
        } else if (paeJson instanceof JSONArray && (jsonArray = (JSONArray)paeJson).size() > 0) {
            paeDict = (JSONObject)jsonArray.get(0);
        }
        return paeDict;
    }

    public static boolean importPaeJSONAsContactMatrixToStructure(StructureMapping[] smArray, InputStream paeInput, String label) throws IOException, ParseException {
        boolean someDone = false;
        for (StructureMapping sm : smArray) {
            boolean thisDone = EBIAlfaFold.importPaeJSONAsContactMatrixToStructure(sm, paeInput, label);
            someDone |= thisDone;
        }
        return someDone;
    }

    public static boolean importPaeJSONAsContactMatrixToStructure(StructureMapping sm, InputStream paeInput, String label) throws IOException, ParseException {
        JSONObject pae_obj = EBIAlfaFold.parseJSONtoPAEContactMatrix(paeInput);
        if (pae_obj == null) {
            Console.debug("JSON file did not parse properly.");
            return false;
        }
        SequenceI seq = sm.getSequence();
        PAEContactMatrix matrix = new PAEContactMatrix(seq, pae_obj);
        AlignmentAnnotation cmannot = sm.getSequence().addContactList(matrix);
        return true;
    }

    public static AlignmentI importDownloadedStructureFromUrl(String alphaFoldCif, File tmpFile, String id, String chain, String dbSource, String dbVersion) throws Exception {
        StructureImportSettings.TFType tempfacType;
        FileFormat fileFormat;
        String file = tmpFile.getAbsolutePath();
        AlignmentI pdbAlignment = new FormatAdapter().readFile(tmpFile, file, DataSourceType.FILE, fileFormat = FileFormat.MMCif, tempfacType = StructureImportSettings.TFType.PLDDT);
        if (pdbAlignment != null) {
            ArrayList<SequenceI> toremove = new ArrayList<SequenceI>();
            for (SequenceI pdbcs : pdbAlignment.getSequences()) {
                String chid = null;
                for (PDBEntry pid : pdbcs.getAllPDBEntries()) {
                    if (pid.getFile() != file) continue;
                    chid = pid.getChainCode();
                }
                if (chain == null || chid != null && (chid.equals(chain) || chid.trim().equals(chain.trim()) || chain.trim().length() == 0 && chid.equals("_"))) {
                    pdbcs.setName(id + SEPARATOR + pdbcs.getName());
                    if (dbSource == null) continue;
                    DBRefEntry dbentry = new DBRefEntry(dbSource, dbVersion, (String)(chid == null ? id : id + chid));
                    pdbcs.addDBRef(dbentry);
                    List<SequenceFeature> allsf = pdbcs.getFeatures().getAllFeatures(new String[0]);
                    ArrayList<SequenceFeature> newsf = new ArrayList<SequenceFeature>();
                    if (allsf == null || allsf.size() <= 0) continue;
                    for (SequenceFeature f : allsf) {
                        if (file.equals(f.getFeatureGroup())) {
                            f = new SequenceFeature(f, f.type, f.begin, f.end, id, f.score);
                        }
                        newsf.add(f);
                    }
                    pdbcs.setSequenceFeatures(newsf);
                    continue;
                }
                toremove.add(pdbcs);
            }
            for (SequenceI pdbcs : toremove) {
                pdbAlignment.deleteSequence(pdbcs);
                if (pdbcs.getAnnotation() == null) continue;
                for (AlignmentAnnotation aa : pdbcs.getAnnotation()) {
                    pdbAlignment.deleteAnnotation(aa);
                }
            }
        }
        return pdbAlignment;
    }

    @Override
    public boolean isValidReference(String accession) {
        Regex r = this.getAccessionValidator();
        return r.search(accession.trim());
    }

    @Override
    public String getTestQuery() {
        return "AF-O15552-F1";
    }

    @Override
    public String getDbName() {
        return "ALPHAFOLD";
    }

    @Override
    public int getTier() {
        return 0;
    }

    @Override
    public FeatureSettingsModelI getFeatureColourScheme() {
        return new PDBFeatureSettings();
    }
}

