/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.util.ErrorLog;
import jalview.util.HttpUtils;
import jalview.util.LaunchUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class FileUtils {
    public static List<File> getFilesFromGlob(String pattern) {
        return FileUtils.getFilesFromGlob(pattern, true);
    }

    public static List<File> getFilesFromGlob(String pattern, boolean allowSingleFilenameThatDoesNotExist) {
        String relativePattern = (pattern = FileUtils.substituteHomeDir(pattern)).startsWith(File.separator) ? null : pattern;
        final ArrayList<File> files = new ArrayList<File>();
        int firstGlobChar = -1;
        boolean foundGlobChar = false;
        for (char c : new char[]{'*', '{', '?'}) {
            if (pattern.indexOf(c) <= -1 || pattern.indexOf(c) >= firstGlobChar && foundGlobChar) continue;
            firstGlobChar = pattern.indexOf(c);
            foundGlobChar = true;
        }
        int lastFS = pattern.lastIndexOf(File.separatorChar, firstGlobChar);
        if (foundGlobChar) {
            Path parentDir;
            String pS = pattern.substring(0, lastFS + 1);
            String rest = pattern.substring(lastFS + 1);
            if ("".equals(pS)) {
                pS = ".";
            }
            if ((parentDir = Paths.get(pS, new String[0])).toFile().exists()) {
                try {
                    Object glob = "glob:" + parentDir.toString() + File.separator + rest;
                    if (System.getProperty("os.name").indexOf("Win") >= 0) {
                        glob = ((String)glob).replaceAll("\\\\", "\\\\\\\\");
                    }
                    final PathMatcher pm = FileSystems.getDefault().getPathMatcher((String)glob);
                    int maxDepth = rest.contains("**") ? 1028 : (int)rest.chars().filter(ch -> ch == File.separatorChar).count() + 1;
                    Files.walkFileTree(parentDir, EnumSet.of(FileVisitOption.FOLLOW_LINKS), maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                            if (pm.matches(path)) {
                                files.add(path.toFile());
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            File f = new File(pattern);
            if (allowSingleFilenameThatDoesNotExist || f.exists()) {
                files.add(f);
            }
        }
        Collections.sort(files);
        return files;
    }

    public static List<String> getFilenamesFromGlob(String pattern) {
        return FileUtils.getFilesFromGlob(pattern).stream().map(f -> f.getPath()).collect(Collectors.toList());
    }

    public static String substituteHomeDir(String path) {
        return path.startsWith("~" + File.separator) ? System.getProperty("user.home") + path.substring(1) : path;
    }

    public static String getBasename(File file) {
        return FileUtils.getBasenameOrExtension(file, false);
    }

    public static String getExtension(File file) {
        return FileUtils.getBasenameOrExtension(file, true);
    }

    public static String getBasenameOrExtension(File file, boolean extension) {
        if (file == null) {
            return null;
        }
        String value = null;
        String filename = file.getName();
        int lastDot = filename.lastIndexOf(46);
        value = lastDot > 0 ? (extension ? filename.substring(lastDot + 1) : filename.substring(0, lastDot)) : (extension ? "" : filename);
        return value;
    }

    public static String getDirname(File file) {
        if (file == null) {
            return null;
        }
        String dirname = null;
        File p = file.getParentFile();
        if (p == null) {
            p = new File(".");
        }
        File d = new File(FileUtils.substituteHomeDir(p.getPath()));
        dirname = d.getPath();
        return dirname;
    }

    public static String convertWildcardsToPath(String value, String wildcard, String dirname, String basename) {
        if (value == null) {
            return null;
        }
        StringBuilder path = new StringBuilder();
        int lastFileSeparatorIndex = value.lastIndexOf(File.separatorChar);
        int wildcardBeforeIndex = value.indexOf(wildcard);
        if (lastFileSeparatorIndex > wildcard.length() - 1 && wildcardBeforeIndex < lastFileSeparatorIndex) {
            path.append(value.substring(0, wildcardBeforeIndex));
            path.append(dirname);
            path.append(value.substring(wildcardBeforeIndex + wildcard.length(), lastFileSeparatorIndex + 1));
        } else {
            path.append(value.substring(0, lastFileSeparatorIndex + 1));
        }
        int wildcardAfterIndex = value.indexOf(wildcard, lastFileSeparatorIndex);
        if (wildcardAfterIndex > lastFileSeparatorIndex) {
            path.append(value.substring(lastFileSeparatorIndex + 1, wildcardAfterIndex));
            path.append(basename);
            path.append(value.substring(wildcardAfterIndex + wildcard.length()));
        } else {
            path.append(value.substring(lastFileSeparatorIndex + 1));
        }
        return path.toString();
    }

    public static File getParentDir(File file) {
        if (file == null) {
            return null;
        }
        File parentDir = file.getAbsoluteFile().getParentFile();
        return parentDir;
    }

    public static boolean checkParentDir(File file, boolean mkdirs) {
        if (file == null) {
            return false;
        }
        File parentDir = FileUtils.getParentDir(file);
        if (parentDir.exists()) {
            return true;
        }
        if (!mkdirs) {
            return false;
        }
        Path path = file.toPath();
        for (int i = 0; i < path.getNameCount(); ++i) {
            Path p = path.getName(i);
            if (!"..".equals(p.toString())) continue;
            LaunchUtils.syserr(true, false, "Cautiously not running mkdirs on " + file.toString() + " because the path to be made contains '..'");
            return false;
        }
        return FileUtils.mkdirs(parentDir);
    }

    public static String getExtension(String filename) {
        return FileUtils.getBaseOrExtension(filename, true);
    }

    public static String getBase(String filename) {
        return FileUtils.getBaseOrExtension(filename, false);
    }

    public static String getBaseOrExtension(String filename0, boolean extension) {
        boolean hasExtension;
        if (filename0 == null) {
            return null;
        }
        String filename = filename0;
        boolean isUrl = false;
        if (HttpUtils.startsWithHttpOrHttps(filename)) {
            try {
                URL url = new URL(filename);
                filename = url.getPath();
                isUrl = true;
            }
            catch (MalformedURLException url) {
                // empty catch block
            }
        }
        int dot = filename.lastIndexOf(46);
        int slash = filename.lastIndexOf(47);
        if (!File.separator.equals("/") && !isUrl) {
            slash = filename.lastIndexOf(File.separator);
        }
        boolean bl = hasExtension = dot > slash + 1;
        if (extension) {
            return hasExtension ? filename.substring(dot + 1) : null;
        }
        dot = filename0.lastIndexOf(46);
        return hasExtension ? filename0.substring(0, dot + 1) : filename0;
    }

    public static Path getCanonicalPath(Path path) {
        return path.normalize();
    }

    public static Path getCanonicalPath(File file) {
        return FileUtils.getCanonicalPath(file.toPath());
    }

    public static Path getCanonicalPath(String pathString) {
        return FileUtils.getCanonicalPath(Paths.get(pathString, new String[0]));
    }

    public static File getCanonicalFile(File file) {
        return FileUtils.getCanonicalPath(file).toFile();
    }

    public static File getCanonicalFile(String pathString) {
        return FileUtils.getCanonicalPath(Paths.get(pathString, new String[0])).toFile();
    }

    public static boolean mkdirs(File file) {
        try {
            Files.createDirectories(FileUtils.getCanonicalPath(file), new FileAttribute[0]);
            return file.exists();
        }
        catch (IOException e) {
            LaunchUtils.syserr(true, false, "Failed to make directory " + file + "\n" + e.getStackTrace());
            return false;
        }
    }

    public static List<File> getMatchingVersionedFiles(String[] templates, String[] roots, String[] versionWhitelist, String[] versionBlacklist, String versionSeparator, boolean exists) {
        HashSet<File> matchingFiles = new HashSet<File>();
        if (templates == null) {
            ErrorLog.errPrintln("getMatchingVersionedFiles called with a null template array");
            ArrayList<File> files = new ArrayList<File>();
            files.addAll(matchingFiles);
            return files;
        }
        for (String template : templates) {
            ErrorLog.errPrintln("Using template '" + template + "'");
            for (String root : roots) {
                String string;
                File file;
                ErrorLog.errPrintln("Using root '" + root + "'");
                if (versionBlacklist != null) {
                    String string2 = String.format(template, root, "*");
                    ErrorLog.errPrintln("Using glob '" + string2 + "'");
                    List<File> foundFiles = FileUtils.getFilesFromGlob(string2, false);
                    for (File found : foundFiles) {
                        ErrorLog.errPrintln("Checking " + found.getPath() + " is okay");
                        boolean add = true;
                        for (String notVersion : versionBlacklist) {
                            StringBuilder vSB = new StringBuilder();
                            if (versionSeparator != null) {
                                vSB.append(versionSeparator);
                            }
                            vSB.append(notVersion);
                            String versionString = vSB.toString();
                            if (!String.format(template, root, versionString).equals(found.getPath())) continue;
                            add = false;
                            ErrorLog.errPrintln("Not adding " + found.getPath() + ": version '" + notVersion + "' is in the blacklist");
                            break;
                        }
                        if (!add) continue;
                        ErrorLog.errPrintln("Adding " + found.getPath() + " to list");
                        matchingFiles.add(found);
                    }
                    if (versionSeparator != null) {
                        String nonVersioned2 = String.format(template, root, "");
                        matchingFiles.addAll(FileUtils.getFilesFromGlob(nonVersioned2, false));
                    }
                }
                if (versionWhitelist == null) continue;
                ErrorLog.errPrintln("Adding " + versionWhitelist.length + " whitelist versions");
                for (String addVersion : versionWhitelist) {
                    StringBuilder vSB = new StringBuilder();
                    if (versionSeparator != null) {
                        vSB.append(versionSeparator);
                    }
                    vSB.append(addVersion);
                    String versionString = vSB.toString();
                    String versionPath = String.format(template, root, versionString);
                    ErrorLog.errPrintln("Adding whitelist path '" + versionPath + "'");
                    File file2 = new File(versionPath);
                    if (!file2.exists() && exists) continue;
                    matchingFiles.add(file2);
                }
                if (versionSeparator == null || !(file = new File(string = String.format(template, root, ""))).exists() && exists) continue;
                matchingFiles.add(file);
            }
        }
        ArrayList files = new ArrayList();
        files.addAll(matchingFiles);
        return files;
    }
}

