/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.JalviewColourScheme;
import java.awt.Color;
import java.util.Map;

public class IdColourScheme
implements ColourSchemeI {
    AlignViewportI view = null;

    public IdColourScheme() {
    }

    public IdColourScheme(AlignViewportI view, AnnotatedCollectionI coll) {
        this.view = view;
    }

    @Override
    public String getSchemeName() {
        return JalviewColourScheme.IdColour.toString();
    }

    @Override
    public ColourSchemeI getInstance(AlignViewportI view, AnnotatedCollectionI coll) {
        return new IdColourScheme(view, coll);
    }

    @Override
    public void alignmentChanged(AnnotatedCollectionI alignment, Map<SequenceI, SequenceCollectionI> hiddenReps) {
    }

    @Override
    public Color findColour(char symbol, int position, SequenceI seq, String consensusResidue, float pid) {
        if (this.view == null) {
            return Color.WHITE;
        }
        Color col = this.view.getSequenceColour(seq);
        return Color.WHITE.equals(col) ? Color.WHITE : col.darker();
    }

    @Override
    public boolean hasGapColour() {
        return false;
    }

    @Override
    public boolean isApplicableTo(AnnotatedCollectionI ac) {
        return true;
    }

    @Override
    public boolean isSimple() {
        return false;
    }
}

