/*
 * Decompiled with CFR 0.152.
 */
package jalview.ext.rbvi.chimera;

import ext.edu.ucsf.rbvi.strucviz2.ChimeraManager;
import ext.edu.ucsf.rbvi.strucviz2.ChimeraModel;
import ext.edu.ucsf.rbvi.strucviz2.StructureManager;
import jalview.api.AlignmentViewPanel;
import jalview.bin.Console;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SearchResultMatchI;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.ext.rbvi.chimera.ChimeraCommands;
import jalview.ext.rbvi.chimera.ChimeraListener;
import jalview.ext.rbvi.chimera.ChimeraXCommands;
import jalview.ext.rbvi.chimera.ChimeraXManager;
import jalview.gui.StructureViewer;
import jalview.httpserver.AbstractRequestHandler;
import jalview.io.DataSourceType;
import jalview.structure.AtomSpec;
import jalview.structure.AtomSpecModel;
import jalview.structure.StructureCommand;
import jalview.structure.StructureCommandI;
import jalview.structure.StructureSelectionManager;
import jalview.structures.models.AAStructureBindingModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.BindException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class JalviewChimeraBinding
extends AAStructureBindingModel {
    public static final String CHIMERA_SESSION_EXTENSION = ".py";
    public static final String CHIMERA_FEATURE_GROUP = "Chimera";
    private ChimeraManager chimeraManager;
    private AbstractRequestHandler chimeraListener;
    protected Map<String, List<ChimeraModel>> chimeraMaps = new LinkedHashMap<String, List<ChimeraModel>>();
    String lastHighlightCommand;

    protected AtomSpec parseAtomSpec(String atomSpec) {
        return AtomSpec.fromChimeraAtomspec(atomSpec);
    }

    public boolean openFile(PDBEntry pe) {
        String file = pe.getFile();
        try {
            ArrayList<ChimeraModel> modelsToMap = new ArrayList<ChimeraModel>();
            List<ChimeraModel> oldList = this.chimeraManager.getModelList();
            boolean alreadyOpen = false;
            for (ChimeraModel open : oldList) {
                if (!open.getModelName().equals(pe.getId())) continue;
                alreadyOpen = true;
                modelsToMap.add(open);
            }
            if (!alreadyOpen) {
                this.chimeraManager.openModel(file, pe.getId(), StructureManager.ModelType.PDB_MODEL);
                this.addChimeraModel(pe, modelsToMap);
            }
            this.chimeraMaps.put(file, modelsToMap);
            if (this.getSsm() != null) {
                this.getSsm().addStructureViewerListener(this);
            }
            return true;
        }
        catch (Exception q) {
            this.log("Exception when trying to open model " + file + "\n" + q.toString());
            q.printStackTrace();
            return false;
        }
    }

    protected void addChimeraModel(PDBEntry pe, List<ChimeraModel> modelsToMap) {
        List<ChimeraModel> newList = this.chimeraManager.getModelList();
        for (ChimeraModel cm : newList) {
            if (!cm.getModelName().equals(pe.getId())) continue;
            modelsToMap.add(cm);
        }
    }

    public JalviewChimeraBinding(StructureSelectionManager ssm, PDBEntry[] pdbentry, SequenceI[][] sequenceIs, DataSourceType protocol) {
        super(ssm, pdbentry, sequenceIs, protocol);
        boolean chimeraX = StructureViewer.ViewerType.CHIMERAX.equals((Object)this.getViewerType());
        this.chimeraManager = chimeraX ? new ChimeraXManager(new StructureManager(true)) : new ChimeraManager(new StructureManager(true));
        this.setStructureCommands(chimeraX ? new ChimeraXCommands() : new ChimeraCommands());
    }

    @Override
    protected StructureViewer.ViewerType getViewerType() {
        return StructureViewer.ViewerType.CHIMERA;
    }

    public void startChimeraListener() {
        try {
            this.chimeraListener = new ChimeraListener(this);
            this.startListening(this.chimeraListener.getUri());
        }
        catch (BindException e) {
            Console.errPrintln("Failed to start Chimera listener: " + e.getMessage());
        }
    }

    @Override
    public void closeViewer(boolean closeChimera) {
        super.closeViewer(closeChimera);
        if (this.chimeraListener != null) {
            this.chimeraListener.shutdown();
            this.chimeraListener = null;
        }
        if (closeChimera && this.getViewerType() == StructureViewer.ViewerType.CHIMERA) {
            this.chimeraManager.getChimeraProcess().destroy();
        }
        this.chimeraManager.clearOnChimeraExit();
        this.chimeraManager = null;
    }

    protected String getModelSpec(int pdbfnum) {
        if (pdbfnum < 0 || pdbfnum >= this.getPdbCount()) {
            return "#" + pdbfnum;
        }
        List<ChimeraModel> maps = this.chimeraMaps.get(this.getStructureFiles()[pdbfnum]);
        boolean hasSubModels = maps != null && maps.size() > 1;
        return "#" + String.valueOf(pdbfnum) + (hasSubModels ? ".1" : "");
    }

    public boolean launchChimera() {
        if (this.chimeraManager.isChimeraLaunched()) {
            return true;
        }
        boolean launched = this.chimeraManager.launchChimera(this.getChimeraPaths());
        if (launched) {
            this.startExternalViewerMonitor(this.chimeraManager.getChimeraProcess());
        } else {
            this.log("Failed to launch Chimera!");
        }
        return launched;
    }

    protected List<String> getChimeraPaths() {
        return StructureManager.getChimeraPaths(false);
    }

    @Override
    public boolean isViewerRunning() {
        return this.chimeraManager != null && this.chimeraManager.isChimeraLaunched();
    }

    @Override
    public List<String> executeCommand(StructureCommandI command, boolean getResponse) {
        if (this.chimeraManager == null || command == null) {
            return null;
        }
        List<String> reply = null;
        String cmd = command.getCommand().trim();
        List<String> lastReply = this.chimeraManager.sendChimeraCommand(cmd, getResponse);
        if (getResponse) {
            reply = lastReply;
            if (Console.isDebugEnabled()) {
                Console.debug("Response from command ('" + cmd + "') was:\n" + lastReply);
            }
        } else if (Console.isDebugEnabled()) {
            Console.debug("Command executed: " + cmd);
        }
        return reply;
    }

    @Override
    public synchronized String[] getStructureFiles() {
        if (this.chimeraManager == null) {
            return new String[0];
        }
        this.modelFileNames = new String[this.chimeraMaps.size()];
        return this.chimeraMaps.keySet().toArray(this.modelFileNames);
    }

    @Override
    public void highlightAtoms(List<AtomSpec> atoms) {
        if (atoms == null || atoms.size() == 0) {
            return;
        }
        boolean forChimeraX = this.chimeraManager.isChimeraX();
        StringBuilder cmd = new StringBuilder(128);
        boolean first = true;
        boolean found = false;
        for (AtomSpec atom : atoms) {
            int pdbResNum = atom.getPdbResNum();
            String chain = atom.getChain();
            String pdbfile = atom.getPdbFile();
            List<ChimeraModel> cms = this.chimeraMaps.get(pdbfile);
            if (cms == null || cms.isEmpty()) continue;
            if (first) {
                cmd.append(forChimeraX ? "label #" : "rlabel #");
            } else {
                cmd.append(",");
            }
            first = false;
            if (forChimeraX) {
                cmd.append(cms.get(0).getModelNumber()).append("/").append(chain).append(":").append(pdbResNum);
            } else {
                cmd.append(cms.get(0).getModelNumber()).append(":").append(pdbResNum);
                if (!chain.equals(" ") && !forChimeraX) {
                    cmd.append(".").append(chain);
                }
            }
            found = true;
        }
        String command = cmd.toString();
        if (command.equals(this.lastHighlightCommand)) {
            return;
        }
        if (!found) {
            cmd.setLength(0);
        }
        if (this.lastHighlightCommand != null) {
            cmd.insert(0, ";");
            cmd.insert(0, this.lastHighlightCommand);
            cmd.insert(0, "~");
        }
        if (cmd.length() > 0) {
            this.executeCommand(true, null, new StructureCommand(cmd.toString(), new String[0]));
        }
        if (found) {
            this.lastHighlightCommand = command;
        }
    }

    public void highlightChimeraSelection() {
        final StructureCommandI command = this.getCommandGenerator().getSelectedResidues();
        Runnable action = new Runnable(){

            @Override
            public void run() {
                List<String> chimeraReply = JalviewChimeraBinding.this.executeCommand(command, true);
                ArrayList<String> selectedResidues = new ArrayList<String>();
                if (chimeraReply != null) {
                    for (String inputLine : chimeraReply) {
                        String[] inputLineParts = inputLine.split("\\s+");
                        if (inputLineParts.length < 5) continue;
                        selectedResidues.add(inputLineParts[2]);
                    }
                }
                List<AtomSpec> atomSpecs = JalviewChimeraBinding.this.convertStructureResiduesToAlignment(selectedResidues);
                JalviewChimeraBinding.this.getSsm().mouseOverStructure(atomSpecs);
            }
        };
        new Thread(action).start();
    }

    protected List<AtomSpec> convertStructureResiduesToAlignment(List<String> structureSelection) {
        ArrayList<AtomSpec> atomSpecs = new ArrayList<AtomSpec>();
        for (String atomSpec : structureSelection) {
            try {
                AtomSpec spec = this.parseAtomSpec(atomSpec);
                String pdbfilename = this.getPdbFileForModel(spec.getModelNumber());
                spec.setPdbFile(pdbfilename);
                atomSpecs.add(spec);
            }
            catch (IllegalArgumentException e) {
                Console.error("Failed to parse atomspec: " + atomSpec);
            }
        }
        return atomSpecs;
    }

    protected String getPdbFileForModel(int modelId) {
        String pdbfilename = this.modelFileNames[0];
        block0: for (String pdbfile : this.chimeraMaps.keySet()) {
            for (ChimeraModel cm : this.chimeraMaps.get(pdbfile)) {
                if (cm.getModelNumber() != modelId) continue;
                pdbfilename = pdbfile;
                break block0;
            }
        }
        return pdbfilename;
    }

    private void log(String message) {
        Console.errPrintln("## Chimera log: " + message);
    }

    public int sendFeaturesToViewer(AlignmentViewPanel avp) {
        Map<String, Map<Object, AtomSpecModel>> featureValues = this.buildFeaturesMap(avp);
        List<StructureCommandI> commands = this.getCommandGenerator().setAttributes(featureValues);
        if (commands.size() > 10) {
            this.sendCommandsByFile(commands);
        } else {
            this.executeCommands(commands, false, null);
        }
        return commands.size();
    }

    protected void sendCommandsByFile(List<StructureCommandI> commands) {
        try {
            StructureCommandI command2;
            File tmp = File.createTempFile("chim", this.getCommandFileExtension());
            tmp.deleteOnExit();
            PrintWriter out = new PrintWriter(new FileOutputStream(tmp));
            for (StructureCommandI command2 : commands) {
                out.println(command2.getCommand());
            }
            out.flush();
            out.close();
            String path = tmp.getAbsolutePath();
            command2 = this.getCommandGenerator().openCommandFile(path);
            this.executeCommand(false, null, command2);
        }
        catch (IOException e) {
            Console.errPrintln("Sending commands to Chimera via file failed with " + e.getMessage());
        }
    }

    protected String getCommandFileExtension() {
        return ".com";
    }

    @Override
    protected int createFeaturesForAttributes(String attName, List<String> residues) {
        int featuresAdded = 0;
        String featureGroup = this.getViewerFeatureGroup();
        for (String residue : residues) {
            AtomSpec spec = null;
            String[] tokens = residue.split(" ");
            if (tokens.length < 5) continue;
            String atomSpec = tokens[2];
            String attValue = tokens[4];
            if ("None".equalsIgnoreCase(attValue) || "False".equalsIgnoreCase(attValue)) continue;
            try {
                spec = this.parseAtomSpec(atomSpec);
            }
            catch (IllegalArgumentException e) {
                Console.error("Problem parsing atomspec " + atomSpec);
                continue;
            }
            String chainId = spec.getChain();
            String description = attValue;
            float score = Float.NaN;
            try {
                score = Float.valueOf(attValue).floatValue();
                description = chainId;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String pdbFile = this.getPdbFileForModel(spec.getModelNumber());
            spec.setPdbFile(pdbFile);
            List<AtomSpec> atoms = Collections.singletonList(spec);
            SearchResultsI sr = this.getSsm().findAlignmentPositionsForStructurePositions(atoms);
            for (SearchResultMatchI m : sr.getResults()) {
                int end;
                int start;
                SequenceFeature sf;
                SequenceI seq = m.getSequence();
                if (!seq.addSequenceFeature(sf = new SequenceFeature(attName, description, start = m.getStart(), end = m.getEnd(), score, featureGroup))) continue;
                ++featuresAdded;
            }
        }
        return featuresAdded;
    }

    protected String getViewerFeatureGroup() {
        return CHIMERA_FEATURE_GROUP;
    }

    @Override
    public String getModelIdForFile(String pdbFile) {
        List<ChimeraModel> foundModels = this.chimeraMaps.get(pdbFile);
        if (foundModels != null && !foundModels.isEmpty()) {
            return String.valueOf(foundModels.get(0).getModelNumber());
        }
        return "";
    }

    public List<String> getChimeraAttributes() {
        ArrayList<String> attributes = new ArrayList<String>();
        StructureCommandI command = this.getCommandGenerator().listResidueAttributes();
        List<String> reply = this.executeCommand(command, true);
        if (reply != null) {
            for (String inputLine : reply) {
                String attName;
                String[] lineParts = inputLine.split("\\s");
                if (lineParts.length != 2 || !lineParts[0].equals("resattr") || (attName = lineParts[1]).startsWith("jv_")) continue;
                attributes.add(attName);
            }
        }
        return attributes;
    }

    @Override
    public String getSessionFileExtension() {
        return CHIMERA_SESSION_EXTENSION;
    }

    @Override
    public String getHelpURL() {
        return "https://www.cgl.ucsf.edu/chimera/docs/UsersGuide";
    }
}

