/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.ContactListI;
import jalview.datamodel.ContactListImpl;
import jalview.datamodel.ContactListProviderI;
import jalview.datamodel.ContactMatrixI;
import jalview.datamodel.SequenceI;
import jalview.util.MapList;
import jalview.ws.datamodel.alphafold.MappableContactMatrix;

public class SeqDistanceContactMatrix
extends MappableContactMatrix<SeqDistanceContactMatrix>
implements ContactMatrixI {
    private static final String SEQUENCE_DISTANCE = "SEQUENCE_DISTANCE";
    private int width = 0;

    public SeqDistanceContactMatrix(int width) {
        this.width = width;
    }

    @Override
    public float getMin() {
        return 0.0f;
    }

    @Override
    public float getMax() {
        return this.width;
    }

    @Override
    public ContactListI getContactList(final int column) {
        if (column < 0 || column >= this.width) {
            return null;
        }
        return new ContactListImpl(new ContactListProviderI(){
            int p;
            {
                this.p = column;
            }

            @Override
            public int getContactHeight() {
                return SeqDistanceContactMatrix.this.width;
            }

            @Override
            public int getPosition() {
                return this.p;
            }

            @Override
            public double getContactAt(int column2) {
                return Math.abs(column2 - this.p);
            }
        });
    }

    @Override
    public String getAnnotDescr() {
        return "Sequence distance matrix";
    }

    @Override
    public String getAnnotLabel() {
        return "Sequence Distance";
    }

    @Override
    public String getType() {
        return SEQUENCE_DISTANCE;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.width;
    }

    @Override
    public double getElementAt(int _column, int i) {
        return Math.abs(_column - i);
    }

    @Override
    protected SeqDistanceContactMatrix newMappableContactMatrix(SequenceI newRefSeq, MapList newFromMapList) {
        return new SeqDistanceContactMatrix(this.width);
    }
}

