/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.util.Constants;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;

public class AlignmentAnnotationUtils {
    public static void getShownHiddenTypes(Map<String, List<List<String>>> shownTypes, Map<String, List<List<String>>> hiddenTypes, List<AlignmentAnnotation> annotations, List<SequenceI> forSequences) {
        BitSet visibleGraphGroups = AlignmentAnnotationUtils.getVisibleLineGraphGroups(annotations);
        HashMap groupLabels = new HashMap();
        ArrayList<CallSite> addedToShown = new ArrayList<CallSite>();
        ArrayList<CallSite> addedToHidden = new ArrayList<CallSite>();
        for (AlignmentAnnotation aa : annotations) {
            if (aa.annotations == null || forSequences == null || aa.sequenceRef == null || !forSequences.contains(aa.sequenceRef)) continue;
            String calcId = aa.getCalcId();
            ArrayList<String> labelAsList = new ArrayList<String>();
            String displayLabel = aa.label;
            labelAsList.add(displayLabel);
            if (aa.graph == 2 && aa.graphGroup > -1) {
                Map groupLabelsForCalcId;
                if (!groupLabels.containsKey(calcId)) {
                    groupLabels.put(calcId, new HashMap());
                }
                if ((groupLabelsForCalcId = (Map)groupLabels.get(calcId)).containsKey(aa.graphGroup)) {
                    if (((List)groupLabelsForCalcId.get(aa.graphGroup)).contains(displayLabel)) continue;
                    ((List)groupLabelsForCalcId.get(aa.graphGroup)).add(displayLabel);
                    continue;
                }
                groupLabelsForCalcId.put(aa.graphGroup, labelAsList);
                continue;
            }
            String rememberAs = calcId + "!" + displayLabel;
            if (aa.isForDisplay() && !addedToShown.contains(rememberAs)) {
                if (!shownTypes.containsKey(calcId)) {
                    shownTypes.put(calcId, new ArrayList());
                }
                shownTypes.get(calcId).add(labelAsList);
                addedToShown.add((CallSite)((Object)rememberAs));
                continue;
            }
            if (aa.visible || addedToHidden.contains(rememberAs)) continue;
            if (!hiddenTypes.containsKey(calcId)) {
                hiddenTypes.put(calcId, new ArrayList());
            }
            hiddenTypes.get(calcId).add(labelAsList);
            addedToHidden.add((CallSite)((Object)rememberAs));
        }
        for (String calcId : groupLabels.keySet()) {
            Iterator iterator = ((Map)groupLabels.get(calcId)).keySet().iterator();
            while (iterator.hasNext()) {
                int group = (Integer)iterator.next();
                List groupLabel = (List)((Map)groupLabels.get(calcId)).get(group);
                Collections.sort(groupLabel);
                if (visibleGraphGroups.get(group)) {
                    if (!shownTypes.containsKey(calcId)) {
                        shownTypes.put(calcId, new ArrayList());
                    }
                    if (shownTypes.get(calcId).contains(groupLabel)) continue;
                    shownTypes.get(calcId).add(groupLabel);
                    continue;
                }
                if (!hiddenTypes.containsKey(calcId)) {
                    hiddenTypes.put(calcId, new ArrayList());
                }
                if (hiddenTypes.get(calcId).contains(groupLabel)) continue;
                hiddenTypes.get(calcId).add(groupLabel);
            }
        }
    }

    public static void getShownHiddenSecondaryStructureProvidersForGroup(List<String> shownTypes, List<String> hiddenTypes, List<AlignmentAnnotation> annotations, SequenceGroup selectedSequenceGroup) {
        if (selectedSequenceGroup == null || annotations == null) {
            return;
        }
        List<String> ssSourcesForSelectedGroup = selectedSequenceGroup.getSecondaryStructureSources();
        if (ssSourcesForSelectedGroup == null || ssSourcesForSelectedGroup.isEmpty()) {
            return;
        }
        for (AlignmentAnnotation aa : annotations) {
            if (aa.annotations == null || aa.groupRef == null || selectedSequenceGroup != aa.groupRef || !aa.label.startsWith("Secondary Structure Consensus")) continue;
            Optional<String> provider = ssSourcesForSelectedGroup.stream().filter(aa.label::contains).findFirst().map(substring -> aa.label.substring(0, aa.label.indexOf((String)substring) + substring.length()));
            provider.ifPresent(p -> {
                if (aa.visible && !shownTypes.contains(p)) {
                    shownTypes.add((String)p);
                } else if (!aa.visible && !shownTypes.contains(p)) {
                    hiddenTypes.add((String)p);
                }
            });
        }
    }

    public static BitSet getVisibleLineGraphGroups(List<AlignmentAnnotation> annotations) {
        BitSet result = new BitSet();
        for (AlignmentAnnotation ann : annotations) {
            int gg;
            if (ann.graph != 2 || !ann.visible || (gg = ann.graphGroup) <= -1) continue;
            result.set(gg);
        }
        return result;
    }

    public static List<AlignmentAnnotation> asList(AlignmentAnnotation[] anns) {
        return anns == null ? Collections.emptyList() : Arrays.asList(anns);
    }

    public static void replaceAnnotationOnAlignmentWith(AlignmentAnnotation newAnnot, String typeName, String calcId, SequenceI aSeq) {
        SequenceI dsseq = aSeq.getDatasetSequence();
        while (dsseq.getDatasetSequence() != null) {
            dsseq = dsseq.getDatasetSequence();
        }
        List<AlignmentAnnotation> dsan = dsseq.getAlignmentAnnotations(calcId, typeName);
        if (dsan != null && dsan.size() > 0) {
            for (AlignmentAnnotation dssan : dsan) {
                dsseq.removeAlignmentAnnotation(dssan);
            }
        }
        AlignmentAnnotation dssan = new AlignmentAnnotation(newAnnot);
        dsseq.addAlignmentAnnotation(dssan);
        dssan.adjustForAlignment();
    }

    public static String extractSSSourceFromAnnotationDescription(AlignmentAnnotation aa) {
        if (aa == null || aa.label == null) {
            return null;
        }
        String label = aa.label;
        if (!Constants.SECONDARY_STRUCTURE_LABELS.containsKey(label)) {
            return null;
        }
        String provider = aa.getProperty("SS_PROVIDER");
        if (provider != null) {
            if ("PDB".equals(aa.getProperty("SS_PROVIDER")) && aa.getProperty("PDBID") != null && !aa.hasAnnotationDetailsProperty()) {
                Object annotDetails = aa.getProperty("PDBID");
                if (aa.getProperty("CHAINID") != null) {
                    annotDetails = (String)annotDetails + ":" + aa.getProperty("CHAINID");
                }
                aa.setAnnotationDetailsProperty((String)annotDetails);
            }
            return provider;
        }
        if ("jnetpred".equals(label)) {
            provider = Constants.SECONDARY_STRUCTURE_LABELS.get(label);
            aa.setProperty("SS_PROVIDER", provider);
            return provider;
        }
        if (aa.description != null && "Secondary Structure".equals(label) && "Secondary Structure".equals(aa.description)) {
            provider = Constants.SECONDARY_STRUCTURE_LABELS.get(label);
            aa.setProperty("SS_PROVIDER", provider);
            return provider;
        }
        if (aa.sequenceRef == null || aa.sequenceRef.getDatasetSequence() == null) {
            return null;
        }
        Vector<PDBEntry> pdbEntries = aa.sequenceRef.getDatasetSequence().getAllPDBEntries();
        if (pdbEntries == null || pdbEntries.isEmpty()) {
            return null;
        }
        for (PDBEntry entry : pdbEntries) {
            String entryId;
            int colonIndex;
            if (entry == null || entry.getId() == null) continue;
            String entryProvider = entry.getProvider();
            if (entryProvider == null) {
                entryProvider = "PDB";
            }
            if ((colonIndex = (entryId = entry.getId()).indexOf(58)) != -1) {
                entryId = entryId.substring(0, colonIndex);
            }
            if ("PDB".equals(entryProvider) && aa.description != null && aa.description.toLowerCase().contains("secondary structure for " + entryId.toLowerCase())) {
                aa.setProperty("SS_PROVIDER", "PDB");
                Object annotDetails = aa.getProperty("PDBID");
                if (annotDetails != null && aa.getProperty("CHAINID") != null) {
                    annotDetails = (String)annotDetails + ":" + aa.getProperty("CHAINID");
                }
                if (annotDetails != null) {
                    aa.setAnnotationDetailsProperty((String)annotDetails);
                }
                return "PDB";
            }
            if ("PDB".equals(entryProvider) || !aa.description.toLowerCase().contains(entryId.toLowerCase())) continue;
            aa.setProperty("SS_PROVIDER", entryProvider);
            return entryProvider;
        }
        return null;
    }
}

