/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ChunkHolder {
    String chunk;
    long position;

    private ChunkHolder() {
    }

    public ChunkHolder(String chunk, long position) {
        if (position < 0L) {
            throw new IndexOutOfBoundsException("Position in a file could not be negative! Given value: " + position);
        }
        if (chunk == null) {
            throw new NullPointerException("Chunk must not be NULL!");
        }
        this.chunk = chunk;
        this.position = position;
    }

    public String getChunk() {
        return this.chunk;
    }

    public long getNextPosition() {
        return this.position;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ChunkHolder ch = null;
        if (!(obj instanceof ChunkHolder)) {
            ch = (ChunkHolder)obj;
        }
        if (this.position != ch.position) {
            return false;
        }
        return this.chunk.equals(ch.chunk);
    }

    public String toString() {
        String value = "Position: " + this.position + "\n";
        value = value + "Chunk size: " + this.chunk.length() + "\n";
        value = value + "Chunk: " + this.chunk + "\n";
        return value;
    }

    public int hashCode() {
        return new Long(this.position + (long)this.chunk.hashCode()).intValue();
    }
}

