/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.api.SC;
import org.jmol.i18n.GT;
import org.jmol.i18n.Language;
import org.jmol.modelset.Group;
import org.jmol.popup.JmolGenericPopup;
import org.jmol.popup.MainPopupResourceBundle;
import org.jmol.popup.PopupResource;
import org.jmol.util.Elements;

public abstract class JmolPopup
extends JmolGenericPopup {
    protected static final int UPDATE_NEVER = -1;
    protected static final int UPDATE_ALL = 0;
    protected static final int UPDATE_CONFIG = 1;
    protected static final int UPDATE_SHOW = 2;
    protected int updateMode = 0;
    private static final int itemMax = 25;
    private int titleWidthMax = 20;
    private String nullModelSetName;
    private String modelSetName;
    private String modelSetFileName;
    private String modelSetRoot;
    private String currentFrankId = null;
    private String configurationSelected = "";
    private String altlocs;
    private Object[][] frankList = new Object[10][];
    private Map<String, Object> modelSetInfo;
    protected Map<String, Object> modelInfo;
    private Lst<SC> NotPDB = new Lst();
    private Lst<SC> PDBOnly = new Lst();
    private Lst<SC> FileUnitOnly = new Lst();
    private Lst<SC> FileMolOnly = new Lst();
    private Lst<SC> UnitcellOnly = new Lst();
    private Lst<SC> SingleModelOnly = new Lst();
    private Lst<SC> FramesOnly = new Lst();
    private Lst<SC> VibrationOnly = new Lst();
    protected Lst<SC> Special = new Lst();
    private Lst<SC> SymmetryOnly = new Lst();
    private Lst<SC> ChargesOnly = new Lst();
    private Lst<SC> TemperatureOnly = new Lst();
    private boolean fileHasUnitCell;
    private boolean haveBFactors;
    private boolean haveCharges;
    private boolean isLastFrame;
    private boolean isMultiConfiguration;
    private boolean isMultiFrame;
    private boolean isPDB;
    private boolean hasSymmetry;
    private boolean isUnitCell;
    private boolean isVibration;
    private boolean isZapped;
    protected int modelIndex;
    private int modelCount;
    private int ac;
    private String group3List;
    private int[] group3Counts;
    private Lst<String> cnmrPeaks;
    private Lst<String> hnmrPeaks;
    private static final int MENUITEM_HEIGHT = 20;
    private final String[] noZapped = new String[]{"surfaceMenu", "measureMenu", "pickingMenu", "computationMenu", "SIGNEDJAVAcaptureMenuSPECIAL"};

    @Override
    public void jpiDispose() {
        super.jpiDispose();
        this.helper.menuClearListeners(this.frankPopup);
        this.frankPopup = null;
    }

    @Override
    protected PopupResource getBundle(String menu) {
        this.strMenuStructure = menu;
        return new MainPopupResourceBundle(this.strMenuStructure, this.menuText);
    }

    @Override
    protected boolean showFrankMenu() {
        this.getViewerData();
        this.setFrankMenu(this.currentMenuItemId);
        this.thisx = -this.thisx - 50;
        if (this.nFrankList > 1) {
            this.thisy -= this.nFrankList * 20;
            this.menuShowPopup(this.frankPopup, this.thisx, this.thisy);
            return false;
        }
        return true;
    }

    @Override
    public void jpiUpdateComputedMenus() {
        if (this.updateMode == -1) {
            return;
        }
        this.isTainted = true;
        this.getViewerData();
        this.updateMode = 0;
        this.updateMenus();
    }

    protected void updateMenus() {
        this.updateSelectMenu();
        this.updateModelSetComputedMenu();
        this.updateAboutSubmenu();
        if (this.updateMode == 0) {
            this.updateFileMenu();
            this.updateElementsComputedMenu(this.vwr.getElementsPresentBitSet(this.modelIndex));
            this.updateHeteroComputedMenu(this.vwr.ms.getHeteroList(this.modelIndex));
            this.updateSurfMoComputedMenu((Map)this.modelInfo.get("moData"));
            this.updateFileTypeDependentMenus();
            this.updatePDBComputedMenus();
            this.updateMode = 1;
            this.updateConfigurationComputedMenu();
            this.updateSYMMETRYComputedMenus();
            this.updateFRAMESbyModelComputedMenu();
            this.updateLanguageSubmenu();
        } else {
            this.updateSpectraMenu();
            this.updateFRAMESbyModelComputedMenu();
            this.updateSceneComputedMenu();
            int i = this.Special.size();
            while (--i >= 0) {
                this.updateSpecialMenuItem((SC)this.Special.get(i));
            }
        }
    }

    @Override
    protected void appCheckItem(String item, SC newMenu) {
        if (item.indexOf("!PDB") >= 0) {
            this.NotPDB.addLast(newMenu);
        } else if (item.indexOf("PDB") >= 0) {
            this.PDBOnly.addLast(newMenu);
        }
        if (item.indexOf("CHARGE") >= 0) {
            this.ChargesOnly.addLast(newMenu);
        } else if (item.indexOf("BFACTORS") >= 0) {
            this.TemperatureOnly.addLast(newMenu);
        } else if (item.indexOf("UNITCELL") >= 0) {
            this.UnitcellOnly.addLast(newMenu);
        } else if (item.indexOf("FILEUNIT") >= 0) {
            this.FileUnitOnly.addLast(newMenu);
        } else if (item.indexOf("FILEMOL") >= 0) {
            this.FileMolOnly.addLast(newMenu);
        }
        if (item.indexOf("!FRAMES") >= 0) {
            this.SingleModelOnly.addLast(newMenu);
        } else if (item.indexOf("FRAMES") >= 0) {
            this.FramesOnly.addLast(newMenu);
        }
        if (item.indexOf("VIBRATION") >= 0) {
            this.VibrationOnly.addLast(newMenu);
        } else if (item.indexOf("SYMMETRY") >= 0) {
            this.SymmetryOnly.addLast(newMenu);
        }
        if (item.indexOf("SPECIAL") >= 0) {
            this.Special.addLast(newMenu);
        }
    }

    @Override
    protected String appGetMenuAsString(String title) {
        return new MainPopupResourceBundle(this.strMenuStructure, null).getMenuAsText(title);
    }

    @Override
    protected String getScriptForCallback(SC source, String id, String script) {
        if (script == "" || id.endsWith("Checkbox")) {
            return script;
        }
        if (script.indexOf("SELECT") == 0) {
            return "select thisModel and (" + script.substring(6) + ")";
        }
        int pt = id.lastIndexOf("[");
        if (pt >= 0) {
            if ((pt = (id = id.substring(pt + 1)).indexOf("]")) >= 0) {
                id = id.substring(0, pt);
            }
            id = id.replace('_', ' ');
            if (script.indexOf("[]") < 0) {
                script = "[] " + script;
            }
            script = script.replace('_', ' ');
            return PT.rep(script, "[]", id);
        }
        if (script.indexOf("?FILEROOT?") >= 0) {
            script = PT.rep(script, "FILEROOT?", this.modelSetRoot);
        } else if (script.indexOf("?FILE?") >= 0) {
            script = PT.rep(script, "FILE?", this.modelSetFileName);
        } else if (script.indexOf("?PdbId?") >= 0) {
            script = PT.rep(script, "PdbId?", "=xxxx");
        }
        return script;
    }

    @Override
    protected void appRestorePopupMenu() {
        this.thisPopup = this.popupMenu;
        if (this.vwr.isJSNoAWT || this.nFrankList < 2) {
            return;
        }
        int i = this.nFrankList;
        while (--i > 0) {
            Object[] f = this.frankList[i];
            this.helper.menuInsertSubMenu((SC)f[0], (SC)f[1], (Integer)f[2]);
        }
        this.nFrankList = 1;
    }

    @Override
    protected void appUpdateSpecialCheckBoxValue(SC item, String what, boolean TF) {
        if (!this.updatingForShow && what.indexOf("#CONFIG") >= 0) {
            this.configurationSelected = what;
            this.updateConfigurationComputedMenu();
            this.updateModelSetComputedMenu();
        }
    }

    private void setFrankMenu(String id) {
        if (this.currentFrankId != null && this.currentFrankId == id && this.nFrankList > 0) {
            return;
        }
        if (this.frankPopup == null) {
            this.frankPopup = this.helper.menuCreatePopup("Frank", this.vwr.html5Applet);
        }
        this.thisPopup = this.frankPopup;
        this.menuRemoveAll(this.frankPopup, 0);
        this.menuCreateItem(this.frankPopup, this.getMenuText("mainMenuText"), "MAIN", "");
        this.currentFrankId = id;
        this.nFrankList = 0;
        this.frankList[this.nFrankList++] = new Object[]{null, null, null};
        if (id != null) {
            int iNew;
            int i = id.indexOf(".", 2) + 1;
            while ((iNew = id.indexOf(".", i)) >= 0) {
                SC menu = (SC)this.htMenus.get(id.substring(i, iNew));
                this.frankList[this.nFrankList++] = new Object[]{menu.getParent(), menu, this.vwr.isJSNoAWT ? 0 : this.menuGetListPosition(menu)};
                this.menuAddSubMenu(this.frankPopup, menu);
                i = iNew + 1;
            }
        }
        this.thisPopup = this.popupMenu;
    }

    private boolean checkBoolean(String key) {
        return this.modelSetInfo != null && this.modelSetInfo.get(key) == Boolean.TRUE;
    }

    private void getViewerData() {
        this.modelSetName = this.vwr.ms.modelSetName;
        this.modelSetFileName = this.vwr.getModelSetFileName();
        int i = this.modelSetFileName.lastIndexOf(".");
        this.isZapped = "zapped".equals(this.modelSetName);
        if (this.isZapped || "string".equals(this.modelSetFileName) || "String[]".equals(this.modelSetFileName)) {
            this.modelSetFileName = "";
        }
        this.modelSetRoot = this.modelSetFileName.substring(0, i < 0 ? this.modelSetFileName.length() : i);
        if (this.modelSetRoot.length() == 0) {
            this.modelSetRoot = "Jmol";
        }
        this.modelIndex = this.vwr.am.cmi;
        this.modelCount = this.vwr.ms.mc;
        this.ac = this.vwr.ms.getAtomCountInModel(this.modelIndex);
        this.modelSetInfo = this.vwr.getModelSetAuxiliaryInfo();
        this.modelInfo = this.vwr.ms.getModelAuxiliaryInfo(this.modelIndex);
        if (this.modelInfo == null) {
            this.modelInfo = new Hashtable<String, Object>();
        }
        this.isPDB = this.checkBoolean("isPDB");
        this.isMultiFrame = this.modelCount > 1;
        this.hasSymmetry = this.modelInfo.containsKey("hasSymmetry");
        this.isUnitCell = this.modelInfo.containsKey("unitCellParams");
        this.fileHasUnitCell = this.isPDB && this.isUnitCell || this.checkBoolean("fileHasUnitCell");
        this.isLastFrame = this.modelIndex == this.modelCount - 1;
        this.altlocs = this.vwr.ms.getAltLocListInModel(this.modelIndex);
        this.isMultiConfiguration = this.altlocs.length() > 0;
        this.isVibration = this.vwr.modelHasVibrationVectors(this.modelIndex);
        this.haveCharges = this.vwr.ms.getPartialCharges() != null;
        this.haveBFactors = this.vwr.getBooleanProperty("haveBFactors");
        this.cnmrPeaks = (Lst)this.modelInfo.get("jdxAtomSelect_13CNMR");
        this.hnmrPeaks = (Lst)this.modelInfo.get("jdxAtomSelect_1HNMR");
    }

    @Override
    public void appCheckSpecialMenu(String item, SC subMenu, String word) {
        if ("modelSetMenu".equals(item)) {
            this.nullModelSetName = word;
            this.menuEnable(subMenu, false);
        }
    }

    @Override
    protected void appUpdateForShow() {
        if (this.updateMode == -1) {
            return;
        }
        this.isTainted = true;
        this.getViewerData();
        this.updateMode = 2;
        this.updateMenus();
    }

    protected void updateFileMenu() {
        boolean ignore;
        SC menu = (SC)this.htMenus.get("fileMenu");
        if (menu == null) {
            return;
        }
        String text = this.getMenuText("writeFileTextVARIABLE");
        menu = (SC)this.htMenus.get("writeFileTextVARIABLE");
        if (menu == null) {
            return;
        }
        boolean bl = ignore = this.modelSetFileName.equals("zapped") || this.modelSetFileName.equals("");
        if (ignore) {
            this.menuSetLabel(menu, "");
            this.menuEnable(menu, false);
        } else {
            this.menuSetLabel(menu, GT.o(GT.$(text), this.modelSetFileName));
            this.menuEnable(menu, true);
        }
    }

    private String getMenuText(String key) {
        String str = this.menuText.getProperty(key);
        return str == null ? key : str;
    }

    protected void updateSelectMenu() {
        SC menu = (SC)this.htMenus.get("selectMenuText");
        if (menu == null) {
            return;
        }
        this.menuEnable(menu, this.ac != 0);
        this.menuSetLabel(menu, this.gti("selectMenuText", this.vwr.slm.getSelectionCount()));
    }

    protected void updateElementsComputedMenu(BS elementsPresentBitSet) {
        SC menu = (SC)this.htMenus.get("elementsComputedMenu");
        if (menu == null) {
            return;
        }
        this.menuRemoveAll(menu, 0);
        this.menuEnable(menu, false);
        if (elementsPresentBitSet == null) {
            return;
        }
        int i = elementsPresentBitSet.nextSetBit(0);
        while (i >= 0) {
            String elementName = Elements.elementNameFromNumber(i);
            String elementSymbol = Elements.elementSymbolFromNumber(i);
            String entryName = elementSymbol + " - " + elementName;
            this.menuCreateItem(menu, entryName, "SELECT " + elementName, null);
            i = elementsPresentBitSet.nextSetBit(i + 1);
        }
        for (i = 4; i < Elements.altElementMax; ++i) {
            int n = Elements.elementNumberMax + i;
            if (!elementsPresentBitSet.get(n)) continue;
            n = Elements.altElementNumberFromIndex(i);
            String elementName = Elements.elementNameFromNumber(n);
            String elementSymbol = Elements.elementSymbolFromNumber(n);
            String entryName = elementSymbol + " - " + elementName;
            this.menuCreateItem(menu, entryName, "SELECT " + elementName, null);
        }
        this.menuEnable(menu, true);
    }

    protected void updateSpectraMenu() {
        SC menuc;
        SC menu = (SC)this.htMenus.get("spectraMenu");
        if (menu == null) {
            return;
        }
        SC menuh = (SC)this.htMenus.get("hnmrMenu");
        if (menuh != null) {
            this.menuRemoveAll(menuh, 0);
        }
        if ((menuc = (SC)this.htMenus.get("cnmrMenu")) != null) {
            this.menuRemoveAll(menuc, 0);
        }
        this.menuRemoveAll(menu, 0);
        boolean isOK = this.setSpectraMenu(menuh, this.hnmrPeaks) | this.setSpectraMenu(menuc, this.cnmrPeaks);
        if (isOK) {
            if (menuh != null) {
                this.menuAddSubMenu(menu, menuh);
            }
            if (menuc != null) {
                this.menuAddSubMenu(menu, menuc);
            }
        }
        this.menuEnable(menu, isOK);
    }

    private boolean setSpectraMenu(SC menu, Lst<String> peaks) {
        int n;
        int n2 = n = peaks == null ? 0 : peaks.size();
        if (n == 0) {
            return false;
        }
        if (menu == null) {
            return false;
        }
        this.menuEnable(menu, false);
        for (int i = 0; i < n; ++i) {
            String peak = (String)peaks.get(i);
            String title = PT.getQuotedAttribute(peak, "title");
            String atoms = PT.getQuotedAttribute(peak, "atoms");
            if (atoms == null) continue;
            this.menuCreateItem(menu, title, "select visible & (@" + PT.rep(atoms, ",", " or @") + ")", "Focus" + i);
        }
        this.menuEnable(menu, true);
        return true;
    }

    protected void updateHeteroComputedMenu(Map<String, String> htHetero) {
        SC menu = (SC)this.htMenus.get("PDBheteroComputedMenu");
        if (menu == null) {
            return;
        }
        this.menuRemoveAll(menu, 0);
        this.menuEnable(menu, false);
        if (htHetero == null) {
            return;
        }
        int n = 0;
        for (Map.Entry<String, String> hetero : htHetero.entrySet()) {
            String heteroCode = hetero.getKey();
            String heteroName = hetero.getValue();
            if (heteroName.length() > 20) {
                heteroName = heteroName.substring(0, 20) + "...";
            }
            String entryName = heteroCode + " - " + heteroName;
            this.menuCreateItem(menu, entryName, "SELECT [" + heteroCode + "]", null);
            ++n;
        }
        this.menuEnable(menu, n > 0);
    }

    protected void updateSurfMoComputedMenu(Map<String, Object> moData) {
        SC menu = (SC)this.htMenus.get("surfMoComputedMenuText");
        if (menu == null) {
            return;
        }
        this.menuRemoveAll(menu, 0);
        Lst mos = moData == null ? null : (Lst)moData.get("mos");
        int nOrb = mos == null ? 0 : mos.size();
        String text = this.getMenuText("surfMoComputedMenuText");
        if (nOrb == 0) {
            this.menuSetLabel(menu, GT.o(GT.$(text), ""));
            this.menuEnable(menu, false);
            return;
        }
        this.menuSetLabel(menu, GT.i(GT.$(text), nOrb));
        this.menuEnable(menu, true);
        SC subMenu = menu;
        int nmod = nOrb % 25;
        if (nmod == 0) {
            nmod = 25;
        }
        int pt = nOrb > 25 ? 0 : Integer.MIN_VALUE;
        int i = nOrb;
        while (--i >= 0) {
            if (pt >= 0 && pt++ % nmod == 0) {
                if (pt == nmod + 1) {
                    nmod = 25;
                }
                String id = "mo" + pt + "Menu";
                subMenu = this.menuNewSubMenu(Math.max(i + 2 - nmod, 1) + "..." + (i + 1), this.menuGetId(menu) + "." + id);
                this.menuAddSubMenu(menu, subMenu);
                this.htMenus.put(id, subMenu);
                pt = 1;
            }
            Map mo = (Map)mos.get(i);
            String entryName = "#" + (i + 1) + " " + (mo.containsKey("type") ? mo.get("type") + " " : "") + (mo.containsKey("symmetry") ? mo.get("symmetry") + " " : "") + (mo.containsKey("occupancy") ? "(" + mo.get("occupancy") + ") " : "") + (mo.containsKey("energy") ? mo.get("energy") : "");
            String script = "mo " + (i + 1);
            this.menuCreateItem(subMenu, entryName, script, null);
        }
    }

    protected void updateFileTypeDependentMenus() {
        int i = this.NotPDB.size();
        while (--i >= 0) {
            this.menuEnable((SC)this.NotPDB.get(i), !this.isPDB);
        }
        i = this.PDBOnly.size();
        while (--i >= 0) {
            this.menuEnable((SC)this.PDBOnly.get(i), this.isPDB);
        }
        i = this.UnitcellOnly.size();
        while (--i >= 0) {
            this.menuEnable((SC)this.UnitcellOnly.get(i), this.isUnitCell);
        }
        i = this.FileUnitOnly.size();
        while (--i >= 0) {
            this.menuEnable((SC)this.FileUnitOnly.get(i), this.isUnitCell || this.fileHasUnitCell);
        }
        i = this.FileMolOnly.size();
        while (--i >= 0) {
            this.menuEnable((SC)this.FileMolOnly.get(i), this.isUnitCell || this.fileHasUnitCell);
        }
        i = this.SingleModelOnly.size();
        while (--i >= 0) {
            this.menuEnable((SC)this.SingleModelOnly.get(i), this.isLastFrame);
        }
        i = this.FramesOnly.size();
        while (--i >= 0) {
            this.menuEnable((SC)this.FramesOnly.get(i), this.isMultiFrame);
        }
        i = this.VibrationOnly.size();
        while (--i >= 0) {
            this.menuEnable((SC)this.VibrationOnly.get(i), this.isVibration);
        }
        i = this.SymmetryOnly.size();
        while (--i >= 0) {
            this.menuEnable((SC)this.SymmetryOnly.get(i), this.hasSymmetry && this.isUnitCell);
        }
        i = this.ChargesOnly.size();
        while (--i >= 0) {
            this.menuEnable((SC)this.ChargesOnly.get(i), this.haveCharges);
        }
        i = this.TemperatureOnly.size();
        while (--i >= 0) {
            this.menuEnable((SC)this.TemperatureOnly.get(i), this.haveBFactors);
        }
        this.updateSignedAppletItems();
    }

    protected void updateSceneComputedMenu() {
        SC menu = (SC)this.htMenus.get("sceneComputedMenu");
        if (menu == null) {
            return;
        }
        this.menuRemoveAll(menu, 0);
        this.menuEnable(menu, false);
        String[] scenes = (String[])this.vwr.ms.getInfoM("scenes");
        if (scenes == null) {
            return;
        }
        for (int i = 0; i < scenes.length; ++i) {
            this.menuCreateItem(menu, scenes[i], "restore scene " + PT.esc(scenes[i]) + " 1.0", null);
        }
        this.menuEnable(menu, true);
    }

    protected void updatePDBComputedMenus() {
        SC menu2;
        SC menu1;
        SC menu3 = (SC)this.htMenus.get("PDBaaResiduesComputedMenu");
        if (menu3 != null) {
            this.menuRemoveAll(menu3, 0);
            this.menuEnable(menu3, false);
        }
        if ((menu1 = (SC)this.htMenus.get("PDBnucleicResiduesComputedMenu")) != null) {
            this.menuRemoveAll(menu1, 0);
            this.menuEnable(menu1, false);
        }
        if ((menu2 = (SC)this.htMenus.get("PDBcarboResiduesComputedMenu")) != null) {
            this.menuRemoveAll(menu2, 0);
            this.menuEnable(menu2, false);
        }
        if (this.modelSetInfo == null) {
            return;
        }
        int n = this.modelIndex < 0 ? 0 : this.modelIndex + 1;
        String[] lists = (String[])this.modelSetInfo.get("group3Lists");
        this.group3List = lists == null ? null : lists[n];
        int[] nArray = this.group3Counts = lists == null ? null : ((int[][])this.modelSetInfo.get("group3Counts"))[n];
        if (this.group3List == null) {
            return;
        }
        int nItems = 0;
        String groupList = Group.standardGroupList;
        if (menu3 != null) {
            for (int i = 1; i < 24; ++i) {
                nItems += this.updateGroup3List(menu3, groupList.substring(i * 6 - 4, i * 6 - 1).trim());
            }
            this.menuEnable(menu3, (nItems += this.augmentGroup3List(menu3, "p>", true)) > 0);
            this.menuEnable((SC)this.htMenus.get("PDBproteinMenu"), nItems > 0);
        }
        if (menu1 != null) {
            Map dssr;
            nItems = this.augmentGroup3List(menu1, "n>", false);
            this.menuEnable(menu1, nItems > 0);
            this.menuEnable((SC)this.htMenus.get("PDBnucleicMenu"), nItems > 0);
            Map map = dssr = nItems > 0 && this.modelIndex >= 0 ? (Map)this.vwr.ms.getInfo(this.modelIndex, "dssr") : null;
            if (dssr != null) {
                this.setSecStrucMenu((SC)this.htMenus.get("aaStructureMenu"), dssr);
            }
        }
        if (menu2 != null) {
            nItems = this.augmentGroup3List(menu2, "c>", false);
            this.menuEnable(menu2, nItems > 0);
            this.menuEnable((SC)this.htMenus.get("PDBcarboMenu"), nItems > 0);
        }
    }

    private boolean setSecStrucMenu(SC menu, Map<String, Object> dssr) {
        Map counts = (Map)dssr.get("counts");
        if (counts == null) {
            return false;
        }
        Object[] keys = new String[counts.size()];
        counts.keySet().toArray(keys);
        Arrays.sort(keys);
        if (keys.length == 0) {
            return false;
        }
        menu.removeAll();
        for (int i = 0; i < keys.length; ++i) {
            this.menuCreateItem(menu, (String)keys[i] + " (" + counts.get(keys[i]) + ")", "select modelIndex=" + this.modelIndex + " && within('dssr', '" + (String)keys[i] + "');", null);
        }
        return true;
    }

    private int updateGroup3List(SC menu, String name) {
        int nItems = 0;
        int n = this.group3Counts[this.group3List.indexOf(name) / 6];
        name = name.trim();
        String script = null;
        if (n > 0) {
            script = "SELECT " + name;
            name = name + "  (" + n + ")";
            ++nItems;
        }
        SC item = this.menuCreateItem(menu, name, script, this.menuGetId(menu) + "." + name);
        if (n == 0) {
            this.menuEnable(item, false);
        }
        return nItems;
    }

    private int augmentGroup3List(SC menu, String type, boolean addSeparator) {
        int pt = 138;
        int nItems = 0;
        while ((pt = this.group3List.indexOf(type, pt)) >= 0) {
            if (nItems++ == 0 && addSeparator) {
                this.menuAddSeparator(menu);
            }
            int n = this.group3Counts[pt / 6];
            String heteroCode = this.group3List.substring(pt + 2, pt + 5);
            String name = heteroCode + "  (" + n + ")";
            this.menuCreateItem(menu, name, "SELECT [" + heteroCode + "]", this.menuGetId(menu) + "." + name);
            ++pt;
        }
        return nItems;
    }

    protected void updateSYMMETRYComputedMenus() {
        this.updateSYMMETRYSelectComputedMenu();
        this.updateSYMMETRYShowComputedMenu();
    }

    protected void updateSYMMETRYShowComputedMenu() {
        SC menu = (SC)this.htMenus.get("SYMMETRYShowComputedMenu");
        if (menu == null) {
            return;
        }
        this.menuRemoveAll(menu, 0);
        this.menuEnable(menu, false);
        if (!this.hasSymmetry || this.modelIndex < 0) {
            return;
        }
        Map info = (Map)this.vwr.getProperty("DATA_API", "spaceGroupInfo", null);
        if (info == null) {
            return;
        }
        Object[][] infolist = (Object[][])info.get("operations");
        if (infolist == null) {
            return;
        }
        String name = (String)info.get("spaceGroupName");
        this.menuSetLabel(menu, name == null ? GT.$("Space Group") : name);
        SC subMenu = menu;
        int pt = infolist.length > 25 ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < infolist.length; ++i) {
            String sym;
            if (pt >= 0 && pt++ % 25 == 0) {
                String id = "drawsymop" + pt + "Menu";
                subMenu = this.menuNewSubMenu(i + 1 + "..." + Math.min(i + 25, infolist.length), this.menuGetId(menu) + "." + id);
                this.menuAddSubMenu(menu, subMenu);
                this.htMenus.put(id, subMenu);
                pt = 1;
            }
            if (i == 0) {
                this.menuEnable(this.menuCreateItem(subMenu, GT.$("none"), "draw sym_* delete", null), true);
            }
            if ((sym = (String)infolist[i][1]).indexOf("x1") < 0) {
                sym = (String)infolist[i][0];
            }
            String entryName = i + 1 + " " + infolist[i][2] + " (" + sym + ")";
            this.menuEnable(this.menuCreateItem(subMenu, entryName, "draw SYMOP " + (i + 1), null), true);
        }
        this.menuEnable(menu, true);
    }

    protected void updateSYMMETRYSelectComputedMenu() {
        SC menu = (SC)this.htMenus.get("SYMMETRYSelectComputedMenu");
        if (menu == null) {
            return;
        }
        this.menuRemoveAll(menu, 0);
        this.menuEnable(menu, false);
        if (!this.hasSymmetry || this.modelIndex < 0) {
            return;
        }
        String[] list = (String[])this.modelInfo.get("symmetryOperations");
        if (list == null) {
            return;
        }
        int[] cellRange = (int[])this.modelInfo.get("unitCellRange");
        boolean haveUnitCellRange = cellRange != null;
        SC subMenu = menu;
        int nmod = 25;
        int pt = list.length > 25 ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < list.length; ++i) {
            if (pt >= 0 && pt++ % nmod == 0) {
                String id = "symop" + pt + "Menu";
                subMenu = this.menuNewSubMenu(i + 1 + "..." + Math.min(i + 25, list.length), this.menuGetId(menu) + "." + id);
                this.menuAddSubMenu(menu, subMenu);
                this.htMenus.put(id, subMenu);
                pt = 1;
            }
            String entryName = "symop=" + (i + 1) + " # " + list[i];
            this.menuEnable(this.menuCreateItem(subMenu, entryName, "SELECT symop=" + (i + 1), null), haveUnitCellRange);
        }
        this.menuEnable(menu, true);
    }

    protected void updateFRAMESbyModelComputedMenu() {
        SC menu = (SC)this.htMenus.get("FRAMESbyModelComputedMenu");
        if (menu == null) {
            return;
        }
        this.menuEnable(menu, this.modelCount > 0);
        this.menuSetLabel(menu, this.modelIndex < 0 ? this.gti("allModelsText", this.modelCount) : this.gto("modelMenuText", this.modelIndex + 1 + "/" + this.modelCount));
        this.menuRemoveAll(menu, 0);
        if (this.modelCount < 1) {
            return;
        }
        if (this.modelCount > 1) {
            this.menuCreateCheckboxItem(menu, GT.$("All"), "frame 0 ##", null, this.modelIndex < 0, false);
        }
        SC subMenu = menu;
        int pt = this.modelCount > 25 ? 0 : Integer.MIN_VALUE;
        for (int i = 0; i < this.modelCount; ++i) {
            if (pt >= 0 && pt++ % 25 == 0) {
                String id = "model" + pt + "Menu";
                subMenu = this.menuNewSubMenu(i + 1 + "..." + Math.min(i + 25, this.modelCount), this.menuGetId(menu) + "." + id);
                this.menuAddSubMenu(menu, subMenu);
                this.htMenus.put(id, subMenu);
                pt = 1;
            }
            String script = "" + this.vwr.getModelNumberDotted(i);
            String entryName = this.vwr.getModelName(i);
            String spectrumTypes = (String)this.vwr.ms.getInfo(i, "spectrumTypes");
            if (spectrumTypes != null && entryName.startsWith(spectrumTypes)) {
                spectrumTypes = null;
            }
            if (!entryName.equals(script)) {
                int ipt = entryName.indexOf(";PATH");
                if (ipt >= 0) {
                    entryName = entryName.substring(0, ipt);
                }
                if (entryName.indexOf("Model[") == 0 && (ipt = entryName.indexOf("]:")) >= 0) {
                    entryName = entryName.substring(ipt + 2);
                }
                entryName = script + ": " + entryName;
            }
            if (entryName.length() > 60) {
                entryName = entryName.substring(0, 55) + "...";
            }
            if (spectrumTypes != null) {
                entryName = entryName + " (" + spectrumTypes + ")";
            }
            this.menuCreateCheckboxItem(subMenu, entryName, "model " + script + " ##", null, this.modelIndex == i, false);
        }
    }

    protected void updateConfigurationComputedMenu() {
        SC menu = (SC)this.htMenus.get("configurationComputedMenu");
        if (menu == null) {
            return;
        }
        this.menuEnable(menu, this.isMultiConfiguration);
        if (!this.isMultiConfiguration) {
            return;
        }
        int nAltLocs = this.altlocs.length();
        this.menuSetLabel(menu, this.gti("configurationMenuText", nAltLocs));
        this.menuRemoveAll(menu, 0);
        String script = "hide none ##CONFIG";
        this.menuCreateCheckboxItem(menu, GT.$("All"), script, null, this.updateMode == 1 && this.configurationSelected.equals(script), false);
        for (int i = 0; i < nAltLocs; ++i) {
            script = "configuration " + (i + 1) + "; hide thisModel and not selected ##CONFIG";
            String entryName = "" + (i + 1) + " -- \"" + this.altlocs.charAt(i) + "\"";
            this.menuCreateCheckboxItem(menu, entryName, script, null, this.updateMode == 1 && this.configurationSelected.equals(script), false);
        }
    }

    protected void updateModelSetComputedMenu() {
        SC menu = (SC)this.htMenus.get("modelSetMenu");
        if (menu == null) {
            return;
        }
        this.menuRemoveAll(menu, 0);
        this.menuSetLabel(menu, this.nullModelSetName);
        this.menuEnable(menu, false);
        int i = this.noZapped.length;
        while (--i >= 0) {
            this.menuEnable((SC)this.htMenus.get(this.noZapped[i]), !this.isZapped);
        }
        if (this.modelSetName == null || this.isZapped) {
            return;
        }
        if (this.isMultiFrame) {
            this.modelSetName = this.gti("modelSetCollectionText", this.modelCount);
            if (this.modelSetName.length() > this.titleWidthMax) {
                this.modelSetName = this.modelSetName.substring(0, this.titleWidthMax) + "...";
            }
        } else if (this.vwr.getBooleanProperty("hideNameInPopup")) {
            this.modelSetName = this.getMenuText("hiddenModelSetText");
        } else if (this.modelSetName.length() > this.titleWidthMax) {
            this.modelSetName = this.modelSetName.substring(0, this.titleWidthMax) + "...";
        }
        this.menuSetLabel(menu, this.modelSetName);
        this.menuEnable(menu, true);
        this.menuEnable((SC)this.htMenus.get("computationMenu"), this.ac <= 100);
        this.addMenuItem(menu, this.gti("atomsText", this.ac));
        this.addMenuItem(menu, this.gti("bondsText", this.vwr.ms.getBondCountInModel(this.modelIndex)));
        if (this.isPDB) {
            Lst biomolecules;
            this.menuAddSeparator(menu);
            this.addMenuItem(menu, this.gti("groupsText", this.vwr.ms.getGroupCountInModel(this.modelIndex)));
            this.addMenuItem(menu, this.gti("chainsText", this.vwr.ms.getChainCountInModelWater(this.modelIndex, false)));
            this.addMenuItem(menu, this.gti("polymersText", this.vwr.ms.getBioPolymerCountInModel(this.modelIndex)));
            SC submenu = (SC)this.htMenus.get("BiomoleculesMenu");
            if (submenu == null) {
                submenu = this.menuNewSubMenu(GT.$(this.getMenuText("biomoleculesMenuText")), this.menuGetId(menu) + ".biomolecules");
                this.menuAddSubMenu(menu, submenu);
            }
            this.menuRemoveAll(submenu, 0);
            this.menuEnable(submenu, false);
            if (this.modelIndex >= 0 && (biomolecules = (Lst)this.vwr.ms.getInfo(this.modelIndex, "biomolecules")) != null) {
                this.menuEnable(submenu, true);
                int nBiomolecules = biomolecules.size();
                for (int i2 = 0; i2 < nBiomolecules; ++i2) {
                    String script = this.isMultiFrame ? "" : "save orientation;load \"\" FILTER \"biomolecule " + (i2 + 1) + "\";restore orientation;";
                    int nAtoms = (Integer)((Map)biomolecules.get(i2)).get("atomCount");
                    String entryName = this.gto(this.isMultiFrame ? "biomoleculeText" : "loadBiomoleculeText", new Object[]{i2 + 1, nAtoms});
                    this.menuCreateItem(submenu, entryName, script, null);
                }
            }
        }
        if (this.isApplet && !this.vwr.getBooleanProperty("hideNameInPopup")) {
            this.menuAddSeparator(menu);
            this.menuCreateItem(menu, this.gto("viewMenuText", this.modelSetFileName), "show url", null);
        }
    }

    private String gti(String s, int n) {
        return GT.i(GT.$(this.getMenuText(s)), n);
    }

    private String gto(String s, Object o) {
        return GT.o(GT.$(this.getMenuText(s)), o);
    }

    protected void updateAboutSubmenu() {
        Runtime runtime;
        int n;
        if (this.isApplet) {
            this.setText("APPLETid", this.vwr.appletName);
        }
        if ((n = (runtime = Runtime.getRuntime()).availableProcessors()) > 0) {
            this.setText("JAVAprocessors", GT.i(GT.$("{0} processors"), n));
        }
        this.setText("JAVAmemTotal", GT.i(GT.$("{0} MB total"), JmolPopup.convertToMegabytes(runtime.totalMemory())));
        this.setText("JAVAmemMax", GT.i(GT.$("{0} MB maximum"), JmolPopup.convertToMegabytes(runtime.maxMemory())));
    }

    protected void updateLanguageSubmenu() {
        SC menu = (SC)this.htMenus.get("languageComputedMenu");
        if (menu == null) {
            return;
        }
        this.menuRemoveAll(menu, 0);
        String language = GT.getLanguage();
        String id = this.menuGetId(menu);
        Language[] languages = GT.getLanguageList(null);
        int p = 0;
        for (int i = 0; i < languages.length; ++i) {
            if (language.equals(languages[i].code)) {
                languages[i].display = true;
            }
            if (!languages[i].display) continue;
            String code = languages[i].code;
            String name = languages[i].language;
            String nativeName = languages[i].nativeLanguage;
            String menuLabel = code + " - " + GT.$(name);
            if (nativeName != null && !nativeName.equals(GT.$(name))) {
                menuLabel = menuLabel + " - " + nativeName;
            }
            if (p++ > 0 && p % 4 == 1) {
                this.menuAddSeparator(menu);
            }
            this.menuCreateCheckboxItem(menu, menuLabel, "language = \"" + code + "\" ##" + name, id + "." + code, language.equals(code), false);
        }
    }

    protected void updateSpecialMenuItem(SC m) {
        m.setText(this.getSpecialLabel(m.getName(), m.getText()));
    }

    protected String getSpecialLabel(String name, String text) {
        int pt = text.indexOf(" (");
        if (pt < 0) {
            pt = text.length();
        }
        String info = null;
        if (name.indexOf("captureLooping") >= 0) {
            info = this.vwr.am.animationReplayMode == 1073742070 ? "ONCE" : "LOOP";
        } else if (name.indexOf("captureFps") >= 0) {
            info = "" + this.vwr.getInt(553648132);
        } else if (name.indexOf("captureMenu") >= 0) {
            info = this.vwr.captureParams == null ? GT.$("not capturing") : this.vwr.fm.getFilePath((String)this.vwr.captureParams.get("captureFileName"), false, true) + " " + this.vwr.captureParams.get("captureCount");
        }
        return info == null ? text : text.substring(0, pt) + " (" + info + ")";
    }
}

