/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.objects.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Pattern;
import uk.ac.vamsas.objects.core.Sequence;
import uk.ac.vamsas.objects.core.SequenceType;
import uk.ac.vamsas.objects.utils.Seq;

public class SeqSet {
    public static void write_Fasta(OutputStream os, SequenceType[] seqs) throws IOException {
        SeqSet.write_Fasta(os, seqs, 80);
    }

    public static void write_Fasta(OutputStream os, SequenceType[] seqs, boolean width80) throws IOException {
        SeqSet.write_Fasta(os, seqs, width80 ? 80 : 0);
    }

    public static void write_Fasta(OutputStream os, SequenceType[] seqs, int width) throws IOException {
        int nseq = seqs.length;
        BufferedWriter fasta_out = new BufferedWriter(new OutputStreamWriter(os));
        System.err.println("NOT FULLY IMPLEMENTED!");
        for (int i = 0; i < nseq; ++i) {
            fasta_out.write(">" + seqs[i].getName() + "\n");
            if (width <= 0) {
                fasta_out.write(seqs[i].getSequence() + "\n");
                continue;
            }
            String tempseq = seqs[i].getSequence();
            int k = tempseq.length();
            for (int j = 0; j < k; j += width) {
                int d = k - j;
                if (d >= width) {
                    fasta_out.write(tempseq, j, width);
                } else {
                    fasta_out.write(tempseq, j, d);
                }
                fasta_out.write("\n");
            }
        }
        fasta_out.flush();
    }

    public static Sequence[] read_SeqFasta(InputStream os) throws IOException {
        String line;
        Vector<Sequence> seqs = new Vector<Sequence>();
        int nseq = 0;
        BufferedReader infasta = new BufferedReader(new InputStreamReader(os));
        System.err.println("NOT FULLY IMPLEMENTED!");
        Object seq = null;
        Pattern aaMatch = Pattern.compile("[ARNDCQEGHILKMFPSTUWYV]", 2);
        String sname = "";
        String seqstr = null;
        do {
            if ((line = infasta.readLine()) == null || line.startsWith(">")) {
                if (seqstr != null) {
                    seqs.add(Seq.newSequence(sname.substring(1), seqstr, "info:iubmb.org/aminoacids", 0, 0));
                }
                sname = line;
                seqstr = "";
                continue;
            }
            String subseq = Pattern.compile("//s+").matcher(line).replaceAll("");
            seqstr = seqstr + subseq;
        } while (line != null);
        nseq = seqs.size();
        if (nseq > 0) {
            Sequence[] seqset = new Sequence[nseq];
            for (int i = 0; i < nseq; ++i) {
                seqset[i] = (Sequence)seqs.elementAt(i);
            }
            return seqset;
        }
        return null;
    }

    public static Hashtable uniquify(SequenceType[] sequences) {
        System.err.println("NOT FULLY IMPLEMENTED!");
        Hashtable<String, String> map = new Hashtable<String, String>();
        for (int i = 0; i < sequences.length; ++i) {
            String safename = new String("Sequence" + i);
            map.put(safename, sequences[i].getName());
            sequences[i].setName(safename);
        }
        return map;
    }

    public static boolean deuniquify(Hashtable map, SequenceType[] sequences) {
        System.err.println("NOT FULLY IMPLEMENTED!");
        boolean allfound = true;
        for (int i = 0; i < sequences.length; ++i) {
            if (map.containsKey(sequences[i].getName())) {
                String unsafename = (String)map.get(sequences[i].getName());
                sequences[i].setName(unsafename);
                continue;
            }
            allfound = false;
        }
        return allfound;
    }
}

