/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.picking;

import java.net.Socket;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.picking.IMessageHandler;
import uk.ac.vamsas.client.picking.IPickManager;
import uk.ac.vamsas.client.picking.Message;
import uk.ac.vamsas.client.picking.PickEndPoint;
import uk.ac.vamsas.client.picking.PickServer;

public class SocketManager
implements IPickManager {
    private Log logger = LogFactory.getLog((Class)SocketManager.class);
    private LinkedList clients;
    private PickServer server = new PickServer(this);
    private IMessageHandler msgHandler;
    private boolean isRunning = true;

    public SocketManager() {
        this.clients = new LinkedList();
        new InitializeThread().start();
    }

    public void registerMessageHandler(IMessageHandler handler) {
        this.msgHandler = handler;
    }

    synchronized boolean addEndPoint(Socket socket) {
        PickEndPoint client = new PickEndPoint(this, socket);
        if (client.openConnection()) {
            this.clients.add(client);
            return true;
        }
        return false;
    }

    public void sendMessage(Message message) {
        this.forwardMessage(null, message);
    }

    private void forwardMessage(PickEndPoint origin, Message message) {
        for (int i = this.clients.size() - 1; i >= 0; --i) {
            try {
                PickEndPoint client = (PickEndPoint)this.clients.get(i);
                if (client == origin) continue;
                client.send(message);
                continue;
            }
            catch (Exception e) {
                System.out.println("FORWARD: " + e);
            }
        }
    }

    void processMessage(PickEndPoint origin, Message message) {
        if (this.server.isServer()) {
            this.forwardMessage(origin, message);
        }
        if (this.msgHandler != null) {
            this.msgHandler.handleMessage(message);
        }
    }

    synchronized void removeEndPoint(PickEndPoint client) {
        this.clients.remove(client);
        if (this.clients.size() == 0 && this.isRunning) {
            new InitializeThread().start();
        }
    }

    public void shutdown() {
        this.logger.debug((Object)"Shutting down socket manager.");
        if (this.server == null) {
            throw new Error("Client Implementation Error: shutdown() called on uninitialized SocketManager.");
        }
        this.isRunning = false;
        if (this.server.isServer()) {
            this.server.terminate();
        }
        while (this.clients.size() > 0) {
            this.logger.debug((Object)"Closing endpoint.");
            ((PickEndPoint)this.clients.getFirst()).terminate();
        }
        this.logger.debug((Object)"Shutdown of socketmanager completed.");
    }

    private class InitializeThread
    extends Thread {
        private InitializeThread() {
        }

        public void run() {
            SocketManager.this.logger.debug((Object)"Initializing connection...");
            boolean connected = false;
            while (!connected && SocketManager.this.isRunning) {
                try {
                    Thread.sleep((int)(10.0 * Math.random()));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (SocketManager.this.server.isServer() || SocketManager.this.server.createServer()) {
                    connected = true;
                    continue;
                }
                if (!SocketManager.this.addEndPoint(null)) continue;
                connected = true;
            }
            SocketManager.this.logger.debug((Object)"Completed initializing connection.");
        }
    }
}

