/*
 * Decompiled with CFR 0.152.
 */
package org.robsite.jswingreader.ui.prefs;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.robsite.jswingreader.ui.Main;
import org.robsite.jswingreader.ui.prefs.GeneralPage;
import org.robsite.jswingreader.ui.prefs.PreferencesPage;
import org.robsite.jswingreader.ui.prefs.PrefsItemsRenderer;
import org.robsite.jswingreader.ui.prefs.ProxyPage;

public class PreferencesPanel
extends JPanel {
    private JSplitPane _splitPane = new JSplitPane();
    private JPanel _contentPanel = new JPanel();
    private CardLayout _contentLayout = new CardLayout();
    private BorderLayout _layout = new BorderLayout();
    private JList _categoryList = new JList();
    private JScrollPane _scrollPane = new JScrollPane(this._categoryList);

    public PreferencesPanel() {
        try {
            this.jbInit();
            this._postInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this._splitPane.setOrientation(1);
        this._splitPane.setLeftComponent(this._scrollPane);
        this._splitPane.setRightComponent(this._contentPanel);
        this._contentPanel.setPreferredSize(new Dimension(400, 300));
        this._contentPanel.setLayout(this._contentLayout);
        this._scrollPane.setPreferredSize(new Dimension(125, 300));
        this._scrollPane.setMinimumSize(new Dimension(120, 100));
        this.setLayout(this._layout);
        this.add((Component)this._splitPane, "Center");
    }

    private void _postInit() throws Exception {
        DefaultListModel model = new DefaultListModel();
        this._categoryList.setModel(model);
        this._categoryList.setCellRenderer(new PrefsItemsRenderer());
        this._categoryList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    PreferencesPanel.this._pageChanged();
                }
            }
        });
        this.registerPage(new GeneralPage());
        this.registerPage(new ProxyPage());
        this._categoryList.setSelectedIndex(0);
    }

    public void registerPage(PreferencesPage page) {
        DefaultListModel model = (DefaultListModel)this._categoryList.getModel();
        model.addElement(page);
        this._contentPanel.add(page.getPage(), page.getName());
        Map properties = (Map)Main.getPreferences().get(page.getKey());
        if (properties != null) {
            page.setProperties(properties);
        }
    }

    public void savePreferences() {
        int numItems = this._categoryList.getModel().getSize();
        int i = 0;
        while (i < numItems) {
            PreferencesPage page = (PreferencesPage)this._categoryList.getModel().getElementAt(i);
            Main.getPreferences().put(page.getKey(), page.getProperties());
            ++i;
        }
        Main.savePreferences();
    }

    private void _pageChanged() {
        PreferencesPage page = (PreferencesPage)this._categoryList.getSelectedValue();
        if (page == null) {
            return;
        }
        this._contentLayout.show(this._contentPanel, page.getName());
    }
}

