/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.vamsas;

import jalview.bin.Console;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.io.VamsasAppDatastore;
import jalview.io.vamsas.Rangetype;
import jalview.util.UrlLink;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.objects.core.DataSet;
import uk.ac.vamsas.objects.core.DataSetAnnotations;
import uk.ac.vamsas.objects.core.Link;
import uk.ac.vamsas.objects.core.Property;
import uk.ac.vamsas.objects.core.Provenance;
import uk.ac.vamsas.objects.core.RangeAnnotation;
import uk.ac.vamsas.objects.core.RangeType;
import uk.ac.vamsas.objects.core.Score;
import uk.ac.vamsas.objects.core.Seg;
import uk.ac.vamsas.objects.core.Sequence;
import uk.ac.vamsas.objects.utils.Properties;

public class Sequencefeature
extends Rangetype {
    DataSet dataset;
    Sequence sequence;
    private SequenceI dsSeq;

    public Sequencefeature(VamsasAppDatastore vamsasAppDatastore, SequenceFeature sequenceFeature, DataSet dataset, Sequence sequence) {
        super(vamsasAppDatastore, sequenceFeature, DataSetAnnotations.class);
        this.dataset = dataset;
        this.sequence = sequence;
        this.doSync();
    }

    public Sequencefeature(VamsasAppDatastore vamsasAppDatastore, DataSetAnnotations dseta, SequenceI dsSeq) {
        super(vamsasAppDatastore, (Vobject)dseta, SequenceFeature.class);
        this.dsSeq = dsSeq;
        this.doJvUpdate();
    }

    @Override
    public void addToDocument() {
        DataSetAnnotations dsa = (DataSetAnnotations)this.vobj;
        SequenceFeature feature = (SequenceFeature)this.jvobj;
        dsa = (DataSetAnnotations)this.getDSAnnotationFromJalview((RangeAnnotation)new DataSetAnnotations(), feature);
        if (dsa.getProvenance() == null) {
            dsa.setProvenance(new Provenance());
        }
        this.addProvenance(dsa.getProvenance(), "created");
        dsa.addSeqRef((Object)this.sequence);
        this.bindjvvobj(feature, (Vobject)dsa);
        this.dataset.addDataSetAnnotations(dsa);
    }

    @Override
    public void addFromDocument() {
        DataSetAnnotations dsa = (DataSetAnnotations)this.vobj;
        if (dsa.getSeqRefCount() != 1) {
            Console.warn("Not binding " + dsa.getVorbaId() + " to Sequence Feature - has multiple dataset sequence references.");
            return;
        }
        SequenceFeature sf = (SequenceFeature)this.jvobj;
        sf = this.getJalviewSeqFeature((RangeAnnotation)dsa);
        this.dsSeq.addSequenceFeature(sf);
        this.jvobj = sf;
        this.bindjvvobj(sf, (Vobject)dsa);
    }

    @Override
    public void conflict() {
        log.warn("Untested sequencefeature conflict code");
        DataSetAnnotations dsa = (DataSetAnnotations)this.vobj;
        SequenceFeature feature = (SequenceFeature)this.jvobj;
        SequenceFeature sf = this.getJalviewSeqFeature((RangeAnnotation)dsa);
        this.replaceJvObjMapping(feature, sf);
        this.dsSeq.addSequenceFeature(sf);
        this.addToDocument();
    }

    @Override
    public void updateToDoc() {
        DataSetAnnotations dsa = (DataSetAnnotations)this.vobj;
        SequenceFeature feature = (SequenceFeature)this.jvobj;
        if (dsa.getSeqRefCount() != 1) {
            this.replaceJvObjMapping(feature, null);
            Console.warn("Binding of annotation to jalview feature has changed. Removing binding and recreating.");
            this.doSync();
        } else {
            long oldref = dsa.get__last_hash();
            this.getDSAnnotationFromJalview((RangeAnnotation)dsa, feature);
            if (oldref != (long)dsa.hashCode()) {
                Console.debug("Updated dataset sequence annotation from feature.");
                this.addProvenance(dsa.getProvenance(), "modified");
            }
        }
    }

    @Override
    public void updateFromDoc() {
        DataSetAnnotations dsa = (DataSetAnnotations)this.vobj;
        SequenceFeature feature = (SequenceFeature)this.jvobj;
        if (dsa.getSeqRefCount() != 1) {
            this.replaceJvObjMapping(feature, null);
            Console.warn("annotation (" + dsa.getVorbaId() + " bound to jalview feature cannot be mapped. Removing binding, deleting feature, and deleting feature.");
            this.dsSeq.deleteFeature(feature);
        } else {
            SequenceFeature newsf = this.getJalviewSeqFeature((RangeAnnotation)dsa);
            this.dsSeq.deleteFeature(feature);
            this.replaceJvObjMapping(feature, newsf);
            this.dsSeq.addSequenceFeature(newsf);
            if (feature.otherDetails != null) {
                feature.otherDetails.clear();
            }
        }
    }

    private RangeAnnotation getDSAnnotationFromJalview(RangeAnnotation dsa, SequenceFeature feature) {
        dsa.setType(feature.getType());
        Seg vSeg = new Seg();
        vSeg.setStart(feature.getBegin());
        vSeg.setEnd(feature.getEnd());
        vSeg.setInclusive(true);
        if (dsa.getSegCount() > 1) {
            Console.debug("About to destroy complex annotation in vamsas document mapped to sequence feature (" + dsa.getVorbaId() + ")");
        }
        dsa.setSeg(new Seg[]{vSeg});
        dsa.setDescription(feature.getDescription());
        dsa.setStatus(feature.getStatus());
        if (feature.links != null && feature.links.size() > 0) {
            int iSize = feature.links.size();
            for (int i = 0; i < iSize; ++i) {
                String link = feature.links.elementAt(i);
                UrlLink ulink = new UrlLink(link);
                if (!ulink.isValid()) continue;
                Link vLink = new Link();
                vLink.setContent(ulink.getLabel());
                vLink.setHref(ulink.getTarget());
                dsa.addLink(vLink);
            }
        }
        dsa.setGroup(feature.getFeatureGroup());
        if (!Float.isNaN(feature.getScore())) {
            Score fscore = new Score();
            dsa.setScore(new Score[]{fscore});
            fscore.setContent(feature.getScore());
            fscore.setName(feature.getType());
        }
        if (feature.otherDetails != null) {
            Iterator<String> iter = feature.otherDetails.keySet().iterator();
            Vector props = dsa.getPropertyAsReference();
            while (iter.hasNext()) {
                String key = iter.next();
                if (key.equalsIgnoreCase("score") || key.equalsIgnoreCase("status")) continue;
                Property nprop = new Property();
                nprop.setName(key);
                Object vlu = feature.getValue(key);
                nprop.setContent(feature.getValue(key).toString());
                boolean valid = false;
                if (vlu instanceof String) {
                    nprop.setType("string");
                    valid = true;
                } else if (vlu instanceof Integer) {
                    valid = true;
                    nprop.setType("integer");
                } else if (vlu instanceof Float) {
                    nprop.setType("float");
                    valid = true;
                }
                if (!valid) continue;
                if (props != null) {
                    Properties.addOrReplace((Vector)props, (Property)nprop);
                    continue;
                }
                dsa.addProperty(nprop);
            }
        }
        return dsa;
    }

    private SequenceFeature getJalviewSeqFeature(RangeAnnotation dseta) {
        int[] se = this.getBounds((RangeType)dseta);
        boolean scoreFound = false;
        float theScore = 0.0f;
        String featureType = dseta.getType();
        if (dseta.getScoreCount() > 0) {
            Enumeration scr = dseta.enumerateScore();
            while (scr.hasMoreElements()) {
                Score score = (Score)scr.nextElement();
                if (!score.getName().equals(featureType)) continue;
                theScore = score.getContent();
                scoreFound = true;
            }
        }
        SequenceFeature sf = null;
        sf = scoreFound ? new SequenceFeature(featureType, dseta.getDescription(), se[0], se[1], theScore, dseta.getGroup()) : new SequenceFeature(featureType, dseta.getDescription(), se[0], se[1], dseta.getGroup());
        sf.setStatus(dseta.getStatus());
        if (dseta.getLinkCount() > 0) {
            Link[] links = dseta.getLink();
            for (int i = 0; i < links.length; ++i) {
                sf.addLink(links[i].getContent() + "|" + links[i].getHref());
            }
        }
        if (dseta.getScoreCount() > 0) {
            Enumeration scr = dseta.enumerateScore();
            while (scr.hasMoreElements()) {
                Score score = (Score)scr.nextElement();
                if (score.getName().equals(sf.getType())) continue;
                sf.setValue(score.getName(), "" + score.getContent());
            }
        }
        Enumeration props = dseta.enumerateProperty();
        while (props.hasMoreElements()) {
            Property p = (Property)props.nextElement();
            Object val = null;
            if (!Properties.isValid((Property)p)) continue;
            if (Properties.isString((Property)p)) {
                val = p.getContent();
            }
            if (Properties.isBoolean((Property)p)) {
                try {
                    val = Boolean.valueOf(p.getContent());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (Properties.isFloat((Property)p)) {
                try {
                    val = Float.valueOf(p.getContent());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (Properties.isInteger((Property)p)) {
                try {
                    val = Integer.valueOf(p.getContent());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (val == null) continue;
            sf.setValue(p.getName(), val);
        }
        return sf;
    }
}

