/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.api.ComplexAlignFile;
import jalview.api.FeatureSettingsModelI;
import jalview.api.FeaturesDisplayedI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.JSONFile;
import jalview.io.PDBFeatureSettings;
import java.io.IOException;
import java.io.StringReader;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class HtmlFile
extends AlignFile
implements ComplexAlignFile {
    public static final String FILE_EXT = "html";
    public static final String FILE_DESC = "HTML";
    private String globalColourScheme;
    private boolean showSeqFeatures;
    private HiddenColumns hiddenColumns;
    private SequenceI[] hiddenSequences;
    private FeaturesDisplayedI displayedFeatures;

    public HtmlFile() {
    }

    public HtmlFile(FileParse source) throws IOException {
        super(source);
    }

    public HtmlFile(String inFile, DataSourceType sourceType) throws IOException {
        super(inFile, sourceType);
    }

    @Override
    public void parse() throws IOException {
        Element content = null;
        Document doc = null;
        try {
            String currentLine;
            StringBuilder htmlData = new StringBuilder();
            while ((currentLine = this.nextLine()) != null) {
                htmlData.append(currentLine);
            }
            doc = Jsoup.parse((String)htmlData.toString());
        }
        catch (OutOfMemoryError oom) {
            this.errormessage = "Not enough memory to process HTML document";
            throw new IOException(this.errormessage);
        }
        boolean contentFromDiv = true;
        content = doc.select("div[id=seqData]").first();
        if (content == null) {
            contentFromDiv = false;
            content = doc.getElementById("seqData");
        }
        if (content == null) {
            this.errormessage = "The html document is not embedded with BioJSON data";
            throw new IOException(this.errormessage);
        }
        JSONFile jsonFile = new JSONFile().parse(new StringReader(contentFromDiv ? content.text() : content.val()));
        this.seqs = jsonFile.getSeqs();
        this.seqGroups = jsonFile.getSeqGroups();
        this.annotations = jsonFile.getAnnotations();
        this.showSeqFeatures = jsonFile.isShowSeqFeatures();
        this.globalColourScheme = jsonFile.getGlobalColourScheme();
        this.hiddenSequences = jsonFile.getHiddenSequences();
        this.hiddenColumns = jsonFile.getHiddenColumns();
        this.displayedFeatures = jsonFile.getDisplayedFeatures();
    }

    @Override
    public String print(SequenceI[] sqs, boolean jvsuffix) {
        throw new UnsupportedOperationException("Print method of HtmlFile is not supported!");
    }

    @Override
    public boolean isShowSeqFeatures() {
        return this.showSeqFeatures;
    }

    public void setShowSeqFeatures(boolean showSeqFeatures) {
        this.showSeqFeatures = showSeqFeatures;
    }

    @Override
    public String getGlobalColourScheme() {
        return this.globalColourScheme;
    }

    public void setColourScheme(String globalColourScheme) {
        this.globalColourScheme = globalColourScheme;
    }

    @Override
    public HiddenColumns getHiddenColumns() {
        return this.hiddenColumns;
    }

    public void setHiddenColumns(HiddenColumns hidden) {
        this.hiddenColumns = hidden;
    }

    @Override
    public SequenceI[] getHiddenSequences() {
        return this.hiddenSequences;
    }

    public void setHiddenSequences(SequenceI[] hiddenSequences) {
        this.hiddenSequences = hiddenSequences;
    }

    @Override
    public FeaturesDisplayedI getDisplayedFeatures() {
        return this.displayedFeatures;
    }

    @Override
    public FeatureSettingsModelI getFeatureColourScheme() {
        return new PDBFeatureSettings();
    }
}

