/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.analysis.AlignmentAnnotationUtils;
import jalview.analysis.AlignmentSorter;
import jalview.analysis.AlignmentUtils;
import jalview.analysis.AnnotationSorter;
import jalview.analysis.AverageDistanceTree;
import jalview.analysis.NJTree;
import jalview.analysis.TreeBuilder;
import jalview.analysis.TreeModel;
import jalview.analysis.scoremodels.ScoreModels;
import jalview.api.analysis.ScoreModelI;
import jalview.api.analysis.SimilarityParamsI;
import jalview.bin.Cache;
import jalview.bin.Console;
import jalview.commands.CommandI;
import jalview.commands.OrderCommand;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.BinaryNode;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.NodeTransformI;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.datamodel.SequenceNode;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.FontChooser;
import jalview.gui.ImageExporter;
import jalview.gui.OOMWarning;
import jalview.gui.PaintRefresher;
import jalview.gui.TreeCanvas;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.io.NewickFile;
import jalview.io.exceptions.ImageOutputException;
import jalview.jbgui.GTreePanel;
import jalview.util.ColorUtils;
import jalview.util.Constants;
import jalview.util.DBRefUtils;
import jalview.util.ImageMaker;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.jibble.epsgraphics.EpsGraphics2D;

public class TreePanel
extends GTreePanel {
    String treeType;
    String scoreModelName;
    String treeTitle;
    SimilarityParamsI similarityParams;
    private TreeCanvas treeCanvas;
    TreeModel tree;
    private AlignViewport av;
    boolean annotationBased = false;
    JPanel ssProviderPanel;
    private Map<String, Color> secondaryStructureProviderColorMap;
    private static final int GAP_WIDTH = 2;
    private static final int SS_PROVIDER_PANEL_FONT_SIZE = 10;
    private static final int TOGGLE_BUTTON_ICON_WIDTH = 10;
    private static final int TOGGLE_BUTTON_ICON_HEIGHT = 10;
    private static final int SCROLLBAR_HEIGHT = 8;
    private static final int SCROLL_PANEL_HEIGHT = 30;
    private static final int TOGGLE_BUTTON_MARGIN = 1;
    private static final int NO_PADDING = 0;
    private static final int NO_WIDTH_PREFERENCE = 0;
    boolean forAnnotation = false;
    boolean columnWise = false;
    AlignmentAnnotation assocAnnotation = null;

    public TreePanel(AlignmentPanel ap, String type, String modelName, SimilarityParamsI options) {
        this.setFrameIcon(null);
        this.similarityParams = options;
        this.initTreePanel(ap, type, modelName, null, null, null, null);
    }

    public TreePanel(AlignmentPanel alignPanel, NewickFile newtree, String theTitle, AlignmentView inputData) {
        this(alignPanel, newtree, theTitle, inputData, null, null);
    }

    public TreePanel(AlignmentPanel alignPanel, NewickFile newtree, String theTitle, AlignmentView inputData, AlignmentAnnotation[] leafAnnotations, String subTitle) {
        this.forAnnotation = leafAnnotations != null && leafAnnotations.length > 0;
        this.setFrameIcon(null);
        this.treeTitle = theTitle;
        this.initTreePanel(alignPanel, null, null, newtree, inputData, null, null);
    }

    public TreePanel(AlignmentPanel alignPanel, NewickFile fin, AlignmentAnnotation aa, String title) {
        this.columnWise = true;
        this.assocAnnotation = aa;
        this.setFrameIcon(null);
        this.treeTitle = title;
        this.initTreePanel(alignPanel, null, null, fin, null, null, null);
    }

    public TreePanel(AlignmentPanel alignPanel, NewickFile newtree, String theTitle, AlignmentView inputData, AlignmentAnnotation[] leafAnnotations, String subTitle, Map<String, AlignmentAnnotation> annotationIds) {
        this.forAnnotation = leafAnnotations != null && leafAnnotations.length > 0;
        this.setFrameIcon(null);
        this.treeTitle = theTitle;
        this.initTreePanel(alignPanel, null, null, newtree, inputData, null, annotationIds);
    }

    public boolean isColumnWise() {
        return this.columnWise;
    }

    public boolean isAnnotationBased() {
        return this.annotationBased;
    }

    public void setAnnotationBased(boolean annotationBased) {
        this.annotationBased = annotationBased;
    }

    public AlignmentAnnotation getAssocAnnotation() {
        return this.assocAnnotation;
    }

    public AlignmentI getAlignment() {
        return this.getTreeCanvas().getViewport().getAlignment();
    }

    public AlignmentViewport getViewPort() {
        return this.getTreeCanvas().getViewport();
    }

    public Map<String, Color> getSecondaryStructureProviderColorMap() {
        return this.secondaryStructureProviderColorMap;
    }

    public void restoreSecondaryStructureProviderColorMap(Map<String, Color> colorMap) {
        this.secondaryStructureProviderColorMap = colorMap;
        ColorUtils.restoreMyHSBSpacedColours(colorMap);
    }

    void initTreePanel(AlignmentPanel ap, String type, String modelName, NewickFile newTree, AlignmentView inputData, AlignmentAnnotation[] leafAnnotations, Map<String, AlignmentAnnotation> annotationIds) {
        this.av = ap.av;
        this.treeType = type;
        this.scoreModelName = modelName;
        this.treeCanvas = new TreeCanvas(this, ap, this.scrollPane);
        this.scrollPane.setViewportView(this.treeCanvas);
        if (this.isAnnotationBased() || this.similarityParams != null && this.similarityParams.getSecondaryStructureSource() != null) {
            this.showSecondaryStructureProviderMenu.setVisible(true);
            this.sortAnnotationAssocViews.setVisible(true);
            this.setAnnotationBased(true);
        } else {
            this.showSecondaryStructureProviderMenu.setVisible(false);
            this.sortAnnotationAssocViews.setVisible(false);
            this.setAnnotationBased(false);
        }
        if (leafAnnotations != null) {
            this.forAnnotation = true;
        }
        if (this.columnWise) {
            this.bootstrapMenu.setVisible(false);
            this.placeholdersMenu.setState(false);
            this.placeholdersMenu.setVisible(false);
            this.fitToWindow.setState(false);
            this.sortAssocViews.setVisible(false);
            this.sortAnnotationAssocViews.setVisible(false);
        }
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 27: {
                        TreePanel.this.treeCanvas.clearSelectedLeaves();
                        e.consume();
                    }
                }
            }
        });
        PaintRefresher.Register(this, ap.av.getSequenceSetId());
        this.buildAssociatedViewMenu();
        final PropertyChangeListener listener = this.addAlignmentListener();
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent evt) {
                if (TreePanel.this.av != null) {
                    TreePanel.this.av.removePropertyChangeListener(listener);
                }
                TreePanel.this.releaseReferences();
            }
        });
        TreeLoader tl = new TreeLoader(newTree, inputData, leafAnnotations, annotationIds);
        tl.start();
    }

    public void addSSProviderPanel() {
        if (this.secondaryStructureProviderColorMap == null || this.secondaryStructureProviderColorMap.isEmpty()) {
            return;
        }
        JPanel ssProviderColorMapPanel = new JPanel();
        ssProviderColorMapPanel.setLayout(new BoxLayout(ssProviderColorMapPanel, 0));
        ArrayList<Map.Entry<String, Color>> sortedSSProviderColorMap = new ArrayList<Map.Entry<String, Color>>(this.secondaryStructureProviderColorMap.entrySet());
        sortedSSProviderColorMap.sort(Map.Entry.comparingByKey());
        for (Map.Entry entry : sortedSSProviderColorMap) {
            JPanel toggleButtonPanel = this.createToggleButtonForProvider(entry);
            ssProviderColorMapPanel.add(toggleButtonPanel);
            ssProviderColorMapPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        }
        ssProviderColorMapPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        ssProviderColorMapPanel.revalidate();
        ssProviderColorMapPanel.repaint();
        JScrollPane colorMapScrollPanel = this.initializeColorMapScrollPanel(ssProviderColorMapPanel);
        this.ssProviderPanel = new JPanel(new CardLayout());
        this.ssProviderPanel.add((Component)colorMapScrollPanel, "colorMapScrollPanel");
        CardLayout ssProviderCardLayout = (CardLayout)this.ssProviderPanel.getLayout();
        if (this.showStructureProviderColouredLines.isSelected()) {
            ssProviderCardLayout.show(this.ssProviderPanel, "colorMapScrollPanel");
            this.ssProviderPanel.setVisible(true);
        } else {
            this.ssProviderPanel.setVisible(false);
        }
        this.ssProviderPanel.repaint();
        this.add((Component)this.ssProviderPanel, "North");
        this.revalidate();
        this.repaint();
    }

    private JPanel createToggleButtonForProvider(Map.Entry<String, Color> colorKey) {
        String provider = colorKey.getKey();
        Color color = colorKey.getValue();
        JToggleButton toggleButton = this.createToggleButton(provider, color);
        JPanel toggleButtonPanel = new JPanel();
        toggleButtonPanel.setLayout(new BoxLayout(toggleButtonPanel, 0));
        toggleButtonPanel.add(toggleButton);
        toggleButtonPanel.add(Box.createRigidArea(new Dimension(2, 0)));
        return toggleButtonPanel;
    }

    private JToggleButton createToggleButton(String provider, final Color color) {
        JToggleButton ssProviderToggleButton = new JToggleButton(provider);
        ssProviderToggleButton.setFont(new Font(this.getTreeFont().getName(), this.getTreeFont().getStyle(), 10));
        ssProviderToggleButton.setMargin(new Insets(1, 1, 1, 1));
        Icon toggleButtonColorIcon = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor(color);
                g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            }

            @Override
            public int getIconWidth() {
                return 10;
            }

            @Override
            public int getIconHeight() {
                return 10;
            }
        };
        ssProviderToggleButton.setIcon(toggleButtonColorIcon);
        ssProviderToggleButton.setBorder(BorderFactory.createBevelBorder(0));
        ssProviderToggleButton.setIconTextGap(2);
        ssProviderToggleButton.setSelected(false);
        ssProviderToggleButton.addItemListener(e -> {
            boolean selected = e.getStateChange() == 1;
            this.toggleStructureProviderColouredLine(provider, selected);
        });
        return ssProviderToggleButton;
    }

    private JScrollPane initializeColorMapScrollPanel(JPanel jPanel) {
        JScrollPane scrollPanel = new JScrollPane(jPanel);
        scrollPanel.setPreferredSize(new Dimension(0, 30));
        scrollPanel.setHorizontalScrollBarPolicy(30);
        JScrollBar horizontalScrollBar = scrollPanel.getHorizontalScrollBar();
        horizontalScrollBar.setPreferredSize(new Dimension(0, 8));
        return scrollPanel;
    }

    public void releaseReferences() {
        this.tree = null;
        this.treeCanvas.tree = null;
        this.treeCanvas.nodeHash = null;
        this.treeCanvas.nameHash = null;
    }

    protected PropertyChangeListener addAlignmentListener() {
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("alignment")) {
                    if (TreePanel.this.tree == null) {
                        Console.outPrintln("tree is null");
                        return;
                    }
                    if (evt.getNewValue() == null) {
                        Console.outPrintln("new alignment sequences vector value is null");
                    }
                    TreePanel.this.tree.updatePlaceHolders((List)evt.getNewValue());
                    TreePanel.this.treeCanvas.nameHash.clear();
                    TreePanel.this.repaint();
                }
            }
        };
        this.av.addPropertyChangeListener(listener);
        return listener;
    }

    @Override
    public void viewMenu_menuSelected() {
        this.buildAssociatedViewMenu();
    }

    void buildAssociatedViewMenu() {
        AlignmentPanel[] aps = PaintRefresher.getAssociatedPanels(this.av.getSequenceSetId());
        if (aps.length == 1 && this.getTreeCanvas().getAssociatedPanel() == aps[0]) {
            this.associateLeavesMenu.setVisible(false);
            return;
        }
        this.associateLeavesMenu.setVisible(true);
        if (this.viewMenu.getItem(this.viewMenu.getItemCount() - 2) instanceof JMenuItem) {
            this.viewMenu.insertSeparator(this.viewMenu.getItemCount() - 1);
        }
        this.associateLeavesMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        int iSize = aps.length;
        final TreePanel thisTreePanel = this;
        for (int i = 0; i < iSize; ++i) {
            final AlignmentPanel ap = aps[i];
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(ap.av.getViewName(), ap == this.treeCanvas.getAssociatedPanel());
            buttonGroup.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    TreePanel.this.treeCanvas.applyToAllViews = false;
                    TreePanel.this.treeCanvas.setAssociatedPanel(ap);
                    TreePanel.this.treeCanvas.setViewport(ap.av);
                    PaintRefresher.Register(thisTreePanel, ap.av.getSequenceSetId());
                }
            });
            this.associateLeavesMenu.add(item);
        }
        final JRadioButtonMenuItem itemf = new JRadioButtonMenuItem(MessageManager.getString("label.all_views"));
        buttonGroup.add(itemf);
        itemf.setSelected(this.treeCanvas.applyToAllViews);
        itemf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePanel.this.treeCanvas.applyToAllViews = itemf.isSelected();
            }
        });
        this.associateLeavesMenu.add(itemf);
    }

    public void showDistances(boolean b) {
        this.treeCanvas.setShowDistances(b);
        this.distanceMenu.setSelected(b);
    }

    public void showBootstrap(boolean b) {
        this.treeCanvas.setShowBootstrap(b);
        this.bootstrapMenu.setSelected(b);
    }

    public void showPlaceholders(boolean b) {
        this.placeholdersMenu.setState(b);
        this.treeCanvas.setMarkPlaceholders(b);
    }

    public TreeModel getTree() {
        return this.tree;
    }

    @Override
    public void textbox_actionPerformed(ActionEvent e) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        String newTitle = this.getPanelTitle();
        NewickFile fout = new NewickFile(this.tree.getTopNode());
        try {
            cap.setText(fout.print(this.tree.hasBootstrap(), this.tree.hasDistances(), this.tree.hasRootDistance()));
            Desktop.addInternalFrame(cap, newTitle, 500, 100);
        }
        catch (OutOfMemoryError oom) {
            new OOMWarning("generating newick tree file", oom);
            cap.dispose();
        }
    }

    @Override
    public void saveAsNewick_actionPerformed(ActionEvent e) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.save_tree_as_newick"));
        chooser.setToolTipText(MessageManager.getString("action.save"));
        int value = chooser.showSaveDialog(null);
        if (value == 0) {
            String choice = chooser.getSelectedFile().getPath();
            Cache.setProperty("LAST_DIRECTORY", chooser.getSelectedFile().getParent());
            try {
                NewickFile fout = new NewickFile(this.tree.getTopNode());
                String output = fout.print(this.tree.hasBootstrap(), this.tree.hasDistances(), this.tree.hasRootDistance());
                PrintWriter out = new PrintWriter(new FileWriter(choice));
                out.println(output);
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void printMenu_actionPerformed(ActionEvent e) {
        this.treeCanvas.startPrinting();
    }

    @Override
    public void originalSeqData_actionPerformed(ActionEvent e) {
        AlignmentView originalData = this.tree.getOriginalData();
        if (originalData == null) {
            Console.info("Unexpected call to originalSeqData_actionPerformed - should have hidden this menu action.");
            return;
        }
        char gc = '-';
        try {
            gc = this.av.getGapCharacter();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object[] alAndColsel = originalData.getAlignmentAndHiddenColumns(gc);
        if (alAndColsel != null && alAndColsel[0] != null) {
            AlignmentI dataset;
            Alignment al = new Alignment((SequenceI[])alAndColsel[0]);
            AlignmentI alignmentI = dataset = this.av != null && this.av.getAlignment() != null ? this.av.getAlignment().getDataset() : null;
            if (dataset != null) {
                al.setDataset(dataset);
            }
            AlignFrame af = new AlignFrame((AlignmentI)al, (HiddenColumns)alAndColsel[1], 700, 500);
            Desktop.addInternalFrame(af, MessageManager.formatMessage("label.original_data_for_params", this.title), 700, 500);
        }
    }

    @Override
    public void fitToWindow_actionPerformed(ActionEvent e) {
        this.treeCanvas.fitToWindow = this.fitToWindow.isSelected();
        this.repaint();
    }

    public void setShowAnnotationAs(String viewName) {
        if (this.isAnnotationBased()) {
            this.addSSProviderPanel();
            this.showSecondaryStructureProviderMenu.setVisible(true);
            this.setShowAnnotationAsView(viewName);
            this.sortAnnotationAssocViews.setVisible(true);
        }
        this.treeCanvas.revalidate();
        this.revalidate();
        this.repaint();
    }

    public void setShowAnnotationAsView(String viewName) {
        for (AbstractButton abstractButton : Arrays.asList(this.showStructureProviderLabels, this.showStructureProviderColouredLines, this.hideStructureProviders)) {
            if (!abstractButton.getText().equals(viewName)) continue;
            abstractButton.doClick();
            return;
        }
        this.hideStructureProviders.doClick();
    }

    public String getShowAnnotationAs() {
        for (AbstractButton abstractButton : Arrays.asList(this.showStructureProviderLabels, this.showStructureProviderColouredLines, this.hideStructureProviders)) {
            if (!abstractButton.isSelected()) continue;
            return abstractButton.getText();
        }
        return this.hideStructureProviders.getText();
    }

    @Override
    public void sortByTree_actionPerformed() {
        if (this.treeCanvas.applyToAllViews) {
            final ArrayList<CommandI> commands = new ArrayList<CommandI>();
            for (AlignmentPanel ap : PaintRefresher.getAssociatedPanels(this.av.getSequenceSetId())) {
                commands.add(this.sortAlignmentIn(ap.av.getAlignPanel()));
            }
            this.av.getAlignPanel().alignFrame.addHistoryItem(new CommandI(){

                @Override
                public void undoCommand(AlignmentI[] views) {
                    for (CommandI tsort : commands) {
                        tsort.undoCommand(views);
                    }
                }

                @Override
                public int getSize() {
                    return commands.size();
                }

                @Override
                public String getDescription() {
                    return "Tree Sort (many views)";
                }

                @Override
                public void doCommand(AlignmentI[] views) {
                    for (CommandI tsort : commands) {
                        tsort.doCommand(views);
                    }
                }
            });
            for (AlignmentPanel ap : PaintRefresher.getAssociatedPanels(this.av.getSequenceSetId())) {
                ap.alignFrame.updateEditMenuBar();
            }
        } else {
            this.treeCanvas.getAssociatedPanel().alignFrame.addHistoryItem(this.sortAlignmentIn(this.treeCanvas.getAssociatedPanel()));
        }
    }

    @Override
    public void sortAnnotationByTree_actionPerformed() {
        if (this.getAlignment() != null && this.getAlignment().getAlignmentAnnotation() != null && this.getAlignment().getAlignmentAnnotation().length > 0) {
            AnnotationSorter sorter = new AnnotationSorter(this.getAlignment(), this.av.isShowAutocalculatedAbove());
            sorter.sortByTree(this.getAlignment().getAlignmentAnnotation(), this.tree);
            this.av.setSortAnnotationsBy(AnnotationSorter.SequenceAnnotationOrder.NONE);
            this.av.getAlignPanel().repaint();
        }
    }

    public CommandI sortAlignmentIn(AlignmentPanel ap) {
        AlignViewport viewport = ap.av;
        SequenceI[] oldOrder = viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByTree(viewport.getAlignment(), this.tree);
        OrderCommand undo = new OrderCommand("Tree Sort", oldOrder, viewport.getAlignment());
        ap.paintAlignment(true, false);
        return undo;
    }

    @Override
    public void font_actionPerformed(ActionEvent e) {
        if (this.treeCanvas == null) {
            return;
        }
        new FontChooser(this);
    }

    public Font getTreeFont() {
        return this.treeCanvas.font;
    }

    public void setTreeFont(Font f) {
        if (this.treeCanvas != null) {
            this.treeCanvas.setFont(f);
        }
    }

    @Override
    public void distanceMenu_actionPerformed(ActionEvent e) {
        this.treeCanvas.setShowDistances(this.distanceMenu.isSelected());
    }

    @Override
    public void hideStructureProviders_actionPerformed(ActionEvent e) {
        this.treeCanvas.hideStructureProviders(this.hideStructureProviders.isSelected());
        CardLayout ssProviderCardLayout = (CardLayout)this.ssProviderPanel.getLayout();
        if (this.showStructureProviderColouredLines.isSelected()) {
            ssProviderCardLayout.show(this.ssProviderPanel, "colorMapScrollPanel");
            this.ssProviderPanel.setVisible(true);
        } else {
            this.ssProviderPanel.setVisible(false);
        }
        this.ssProviderPanel.repaint();
    }

    @Override
    public void showStructureProviderColouredLines_actionPerformed(ActionEvent e) {
        this.treeCanvas.setShowStructureProviderColouredLines(this.showStructureProviderColouredLines.isSelected());
        CardLayout ssProviderCardLayout = (CardLayout)this.ssProviderPanel.getLayout();
        if (this.showStructureProviderColouredLines.isSelected()) {
            ssProviderCardLayout.show(this.ssProviderPanel, "colorMapScrollPanel");
            this.ssProviderPanel.setVisible(true);
        } else {
            this.ssProviderPanel.setVisible(false);
        }
        this.ssProviderPanel.repaint();
    }

    @Override
    public void showStructureProviderLabels_actionPerformed(ActionEvent e) {
        this.treeCanvas.setShowStructureProviderLabels(this.showStructureProviderLabels.isSelected());
        CardLayout ssProviderCardLayout = (CardLayout)this.ssProviderPanel.getLayout();
        if (this.showStructureProviderColouredLines.isSelected()) {
            ssProviderCardLayout.show(this.ssProviderPanel, "colorMapScrollPanel");
            this.ssProviderPanel.setVisible(true);
        } else {
            this.ssProviderPanel.setVisible(false);
        }
        this.ssProviderPanel.repaint();
    }

    public void toggleStructureProviderColouredLine(String provider, boolean action) {
        this.treeCanvas.toggleStructureProviderColouredLine(provider, action);
    }

    @Override
    public void bootstrapMenu_actionPerformed(ActionEvent e) {
        this.treeCanvas.setShowBootstrap(this.bootstrapMenu.isSelected());
    }

    @Override
    public void placeholdersMenu_actionPerformed(ActionEvent e) {
        this.treeCanvas.setMarkPlaceholders(this.placeholdersMenu.isSelected());
    }

    @Override
    public void writeTreeImage(ImageMaker.TYPE imageFormat) {
        final int width = this.treeCanvas.getWidth();
        final int height = this.treeCanvas.getHeight();
        ImageExporter.ImageWriterI writer = new ImageExporter.ImageWriterI(){

            @Override
            public void exportImage(Graphics g) throws Exception {
                TreePanel.this.treeCanvas.draw(g, width, height);
            }
        };
        String tree = MessageManager.getString("label.tree");
        ImageExporter exporter = new ImageExporter(writer, null, imageFormat, tree);
        try {
            exporter.doExport(null, this, width, height, tree.toLowerCase(Locale.ROOT));
        }
        catch (ImageOutputException ioex) {
            Console.error("Unexpected error whilst writing " + imageFormat.toString(), ioex);
        }
    }

    public void changeNames(final String labelClass) {
        this.tree.applyToNodes(new NodeTransformI(){

            @Override
            public void transform(BinaryNode node) {
                if (node instanceof SequenceNode && !((SequenceNode)node).isPlaceholder() && !((SequenceNode)node).isDummy()) {
                    Object newname = null;
                    SequenceI sq = (SequenceI)node.element();
                    if (sq != null) {
                        List<DBRefEntry> refs = DBRefUtils.selectRefs(sq.getDBRefs(), new String[]{labelClass.toUpperCase(Locale.ROOT)});
                        if (refs != null) {
                            int ni = refs.size();
                            for (int i = 0; i < ni; ++i) {
                                newname = newname == null ? new String(refs.get(i).getAccessionId()) : newname + "; " + refs.get(i).getAccessionId();
                            }
                        }
                        if (newname == null) {
                            List<SequenceFeature> features = sq.getFeatures().getPositionalFeatures(labelClass);
                            for (SequenceFeature feature : features) {
                                if (newname == null) {
                                    newname = feature.getDescription();
                                    continue;
                                }
                                newname = (String)newname + "; " + feature.getDescription();
                            }
                        }
                    }
                    if (newname != null) {
                        node.setName((String)newname);
                    }
                }
            }
        });
    }

    public String getPanelTitle() {
        if (this.treeTitle != null) {
            return this.treeTitle;
        }
        String treecalcnm = MessageManager.getString("label.tree_calc_" + this.treeType.toLowerCase(Locale.ROOT));
        String smn = this.scoreModelName;
        String ttl = MessageManager.formatMessage("label.calc_title", treecalcnm, smn);
        return ttl;
    }

    protected void writeEpsFile(File outFile, boolean textOption) {
        try {
            int width = this.treeCanvas.getWidth();
            int height = this.treeCanvas.getHeight();
            FileOutputStream out = new FileOutputStream(outFile);
            EpsGraphics2D pg = new EpsGraphics2D("Tree", out, 0, 0, width, height);
            pg.setAccurateTextMode(!textOption);
            this.treeCanvas.draw(pg, width, height);
            pg.flush();
            pg.close();
        }
        catch (Exception ex) {
            Console.errPrintln("Error writing tree as EPS");
            ex.printStackTrace();
        }
    }

    public AlignViewport getViewport() {
        return this.av;
    }

    public void setViewport(AlignViewport av) {
        this.av = av;
    }

    public TreeCanvas getTreeCanvas() {
        return this.treeCanvas;
    }

    public static TreePanel newTreeForAnnotations(AlignmentPanel alignPanel, NewickFile nf, Map<String, AlignmentAnnotation> annotationIds, String treeTitle, AlignmentView input) {
        TreePanel tp = new TreePanel(alignPanel, nf, treeTitle, input, null, "Annotation Tree", annotationIds);
        return tp;
    }

    private static void processTreeNodes(TreeModel tree, Map<String, AlignmentAnnotation> annotationIds) {
        BinaryNode topNode = tree.getTopNode();
        Vector<BinaryNode> leafNodes = tree.findLeaves(topNode);
        tree.setNode(leafNodes);
        tree.applyToNodes(node -> {
            Object element = node.element();
            String nodeName = node.getName();
            String annotId = nodeName.replaceAll("[^a-zA-Z0-9]", "");
            AlignmentAnnotation annot = (AlignmentAnnotation)annotationIds.get(annotId);
            if (annot != null) {
                SequenceI seq = annot.sequenceRef;
                node.setElement(seq);
                node.setName(seq.getName());
                String ssAnnotProvider = AlignmentAnnotationUtils.extractSSSourceFromAnnotationDescription(annot);
                node.setLabel(ssAnnotProvider);
                node.setAlignmentAnnotation(annot);
                if (annot.hasAnnotationDetailsProperty()) {
                    node.setAnnotationDetails(annot.getAnnotationDetailsProperty());
                }
            } else if (element instanceof SequenceI) {
                node.setLabel(Constants.STRUCTURE_PROVIDERS.get("None"));
            }
        });
    }

    class TreeLoader
    extends Thread {
        private NewickFile newtree;
        private AlignmentView odata = null;
        private AlignmentAnnotation[] leafAnnotations;
        private Map<String, AlignmentAnnotation> annotationIds = null;

        public TreeLoader(NewickFile newickFile, AlignmentView inputData, AlignmentAnnotation[] leafAnnotations, Map<String, AlignmentAnnotation> annotationIds) {
            this.newtree = newickFile;
            this.odata = inputData;
            this.leafAnnotations = leafAnnotations;
            this.annotationIds = annotationIds;
            if (newickFile != null) {
                TreePanel.this.showBootstrap(newickFile.HasBootstrap());
                TreePanel.this.showDistances(newickFile.HasDistances());
            }
        }

        @Override
        public void run() {
            if (this.newtree != null) {
                TreePanel.this.tree = new TreeModel(TreePanel.this.av.getAlignment().getSequencesArray(), this.odata, this.newtree, this.leafAnnotations);
                if (TreePanel.this.tree.getOriginalData() == null) {
                    TreePanel.this.originalSeqData.setVisible(false);
                }
            } else {
                ScoreModelI sm = ScoreModels.getInstance().getScoreModel(TreePanel.this.scoreModelName, TreePanel.this.treeCanvas.getAssociatedPanel());
                TreeBuilder njtree = TreePanel.this.treeType.equals("NJ") ? new NJTree(TreePanel.this.av, sm, TreePanel.this.similarityParams) : new AverageDistanceTree(TreePanel.this.av, sm, TreePanel.this.similarityParams);
                List<String> labels = njtree.getLabels();
                if (labels != null && labels.size() > 0) {
                    TreePanel.this.secondaryStructureProviderColorMap = AlignmentUtils.assignColorsForSecondaryStructureProviders(labels);
                    if (TreePanel.this.secondaryStructureProviderColorMap.size() > 0) {
                        TreePanel.this.addSSProviderPanel();
                    }
                }
                TreePanel.this.tree = new TreeModel(njtree);
            }
            if (this.annotationIds != null && this.annotationIds.size() > 0) {
                TreePanel.processTreeNodes(TreePanel.this.tree, this.annotationIds);
            }
            TreePanel.this.showDistances(!TreePanel.this.columnWise);
            TreePanel.this.tree.reCount(TreePanel.this.tree.getTopNode());
            TreePanel.this.tree.findHeight(TreePanel.this.tree.getTopNode());
            TreePanel.this.treeCanvas.setTree(TreePanel.this.tree);
            TreePanel.this.treeCanvas.repaint();
            TreePanel.this.av.setCurrentTree(TreePanel.this.tree);
            if (TreePanel.this.av.getSortByTree()) {
                TreePanel.this.sortByTree_actionPerformed();
            }
        }
    }
}

