/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Console;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignmentPanel;
import jalview.gui.IdCanvas;
import jalview.gui.SeqCanvas;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PaintRefresher {
    static Map<String, List<Component>> components = new HashMap<String, List<Component>>();

    public static void Register(Component comp, String seqSetId) {
        if (components.containsKey(seqSetId)) {
            List<Component> comps = components.get(seqSetId);
            if (!comps.contains(comp)) {
                comps.add(comp);
            }
        } else {
            ArrayList<Component> vcoms = new ArrayList<Component>();
            vcoms.add(comp);
            components.put(seqSetId, vcoms);
        }
    }

    public static void RemoveComponent(Component comp) {
        if (components == null) {
            return;
        }
        Iterator<String> it = components.keySet().iterator();
        while (it.hasNext()) {
            List<Component> comps = components.get(it.next());
            comps.remove(comp);
            if (!comps.isEmpty()) continue;
            it.remove();
        }
    }

    public static void Refresh(Component source, String id) {
        PaintRefresher.Refresh(source, id, false, false);
    }

    public static void Refresh(Component source, String id, boolean alignmentChanged, boolean validateSequences) {
        List<Component> comps = components.get(id);
        if (comps == null) {
            return;
        }
        for (Component comp : comps) {
            if (comp == source) continue;
            if (comp instanceof AlignmentPanel) {
                if (validateSequences && source instanceof AlignmentPanel) {
                    PaintRefresher.validateSequences(((AlignmentPanel)source).av.getAlignment(), ((AlignmentPanel)comp).av.getAlignment());
                }
                if (alignmentChanged) {
                    ((AlignmentPanel)comp).alignmentChanged();
                }
            } else if (comp instanceof IdCanvas) {
                ((IdCanvas)comp).fastPaint = false;
            } else if (comp instanceof SeqCanvas) {
                ((SeqCanvas)comp).fastPaint = false;
            }
            comp.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void validateSequences(AlignmentI source, AlignmentI comp) {
        int j;
        int i;
        SequenceI[] a2;
        int jSize;
        SequenceI[] a1 = source.getHiddenSequences().getSize() > 0 ? source.getHiddenSequences().getFullAlignment().getSequencesArray() : source.getSequencesArray();
        int iSize = a1.length;
        if (iSize == (jSize = (a2 = comp.getHiddenSequences().getSize() > 0 ? comp.getHiddenSequences().getFullAlignment().getSequencesArray() : comp.getSequencesArray()).length)) {
            return;
        }
        boolean exists = false;
        for (i = 0; i < iSize; ++i) {
            exists = false;
            for (j = 0; j < jSize; ++j) {
                if (a2[j] != a1[i]) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            if (i < comp.getHeight()) {
                List<SequenceI> alsq;
                if (comp.getDataset() != source.getDataset()) {
                    Console.errPrintln("IMPLEMENTATION PROBLEM: DATASET out of sync due to an insert whilst calling PaintRefresher.validateSequences(AlignmentI, ALignmentI)");
                }
                List<SequenceI> list = alsq = comp.getSequences();
                synchronized (list) {
                    alsq.add(i, a1[i]);
                }
            } else {
                comp.addSequence(a1[i]);
            }
            a2 = comp.getHiddenSequences().getSize() > 0 ? comp.getHiddenSequences().getFullAlignment().getSequencesArray() : comp.getSequencesArray();
            jSize = a2.length;
        }
        iSize = a1.length;
        jSize = a2.length;
        for (j = 0; j < jSize; ++j) {
            exists = false;
            for (i = 0; i < iSize; ++i) {
                if (a2[j] != a1[i]) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            comp.deleteSequence(a2[j]);
        }
    }

    static AlignmentPanel[] getAssociatedPanels(String id) {
        List<Component> comps = components.get(id);
        if (comps == null) {
            return new AlignmentPanel[0];
        }
        ArrayList<AlignmentPanel> tmp = new ArrayList<AlignmentPanel>();
        for (Component comp : comps) {
            if (!(comp instanceof AlignmentPanel)) continue;
            tmp.add((AlignmentPanel)comp);
        }
        return tmp.toArray(new AlignmentPanel[tmp.size()]);
    }
}

