/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import ext.edu.ucsf.rbvi.strucviz2.ChimeraModel;
import ext.edu.ucsf.rbvi.strucviz2.StructureManager;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.ext.rbvi.chimera.ChimeraXCommands;
import jalview.gui.ChimeraViewFrame;
import jalview.gui.JalviewChimeraBindingModel;
import jalview.gui.StructureViewer;
import jalview.io.DataSourceType;
import jalview.structure.AtomSpec;
import jalview.structure.StructureCommand;
import jalview.structure.StructureSelectionManager;
import java.util.List;

public class JalviewChimeraXBindingModel
extends JalviewChimeraBindingModel {
    public static final String CHIMERAX_SESSION_EXTENSION = ".cxs";

    public JalviewChimeraXBindingModel(ChimeraViewFrame chimeraViewFrame, StructureSelectionManager ssm, PDBEntry[] pdbentry, SequenceI[][] sequenceIs, DataSourceType protocol) {
        super(chimeraViewFrame, ssm, pdbentry, sequenceIs, protocol);
        this.setStructureCommands(new ChimeraXCommands());
    }

    @Override
    protected List<String> getChimeraPaths() {
        return StructureManager.getChimeraPaths(true);
    }

    @Override
    protected void addChimeraModel(PDBEntry pe, List<ChimeraModel> modelsToMap) {
        int modelNumber = this.chimeraMaps.size() + 1;
        String command = "setattr #" + modelNumber + " models name " + pe.getId();
        this.executeCommand(new StructureCommand(command, new String[0]), false);
        modelsToMap.add(new ChimeraModel(pe.getId(), StructureManager.ModelType.PDB_MODEL, modelNumber, 0));
    }

    @Override
    protected String getCommandFileExtension() {
        return ".cxc";
    }

    @Override
    public String getSessionFileExtension() {
        return CHIMERAX_SESSION_EXTENSION;
    }

    @Override
    public String getHelpURL() {
        return "http://www.rbvi.ucsf.edu/chimerax/docs/user/index.html";
    }

    @Override
    protected StructureViewer.ViewerType getViewerType() {
        return StructureViewer.ViewerType.CHIMERAX;
    }

    @Override
    protected String getModelId(int pdbfnum, String file) {
        return String.valueOf(pdbfnum + 1);
    }

    @Override
    protected AtomSpec parseAtomSpec(String atomSpec) {
        return AtomSpec.fromChimeraXAtomspec(atomSpec);
    }
}

