/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class RangeElementsIterator
implements Iterator<Integer> {
    private int last;
    private int current;
    private int next;
    private Iterator<int[]> rangeIterator;
    private int[] nextRange = null;

    RangeElementsIterator(Iterator<int[]> it) {
        this.rangeIterator = it;
        if (this.rangeIterator.hasNext()) {
            this.nextRange = this.rangeIterator.next();
            this.next = this.nextRange[0];
            this.last = this.nextRange[1];
        }
    }

    @Override
    public boolean hasNext() {
        return this.rangeIterator.hasNext() || this.next <= this.last;
    }

    @Override
    public Integer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = this.next++;
        this.checkNextRange();
        return this.current;
    }

    private void checkNextRange() {
        if (this.nextRange != null && this.next > this.nextRange[1]) {
            if (this.rangeIterator.hasNext()) {
                this.nextRange = this.rangeIterator.next();
                this.next = this.nextRange[0];
                this.last = this.nextRange[1];
            } else {
                this.nextRange = null;
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

