/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.analysis.AverageDistanceTree;
import jalview.analysis.NJTree;
import jalview.analysis.TreeBuilder;
import jalview.analysis.TreeModel;
import jalview.analysis.scoremodels.ScoreModels;
import jalview.analysis.scoremodels.SimilarityParams;
import jalview.api.analysis.ScoreModelI;
import jalview.appletgui.AlignFrame;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.CutAndPasteTransfer;
import jalview.appletgui.EmbmenuFrame;
import jalview.appletgui.FontChooser;
import jalview.appletgui.TreeCanvas;
import jalview.bin.Console;
import jalview.bin.JalviewLite;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceI;
import jalview.io.NewickFile;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class TreePanel
extends EmbmenuFrame
implements ActionListener,
ItemListener,
AutoCloseable {
    SequenceI[] seq;
    String type;
    String pwtype;
    int start;
    int end;
    TreeCanvas treeCanvas;
    TreeModel tree;
    AlignmentPanel ap;
    AlignViewport av;
    BorderLayout borderLayout1 = new BorderLayout();
    protected ScrollPane scrollPane = new ScrollPane();
    MenuBar jMenuBar1 = new MenuBar();
    Menu jMenu2 = new Menu();
    protected MenuItem fontSize = new MenuItem();
    protected CheckboxMenuItem bootstrapMenu = new CheckboxMenuItem();
    protected CheckboxMenuItem distanceMenu = new CheckboxMenuItem();
    protected CheckboxMenuItem placeholdersMenu = new CheckboxMenuItem();
    protected CheckboxMenuItem fitToWindow = new CheckboxMenuItem();
    Menu fileMenu = new Menu();
    MenuItem newickOutput = new MenuItem();
    MenuItem inputData = new MenuItem();

    public TreeModel getTree() {
        return this.tree;
    }

    @Override
    public void close() {
        this.ap = null;
        this.av = null;
        super.close();
    }

    public TreePanel(AlignmentPanel alignPanel, String type, String pwtype) {
        try {
            this.jbInit();
            this.setMenuBar(this.jMenuBar1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.initTreePanel(alignPanel, type, pwtype, null);
    }

    public TreePanel(AlignmentPanel ap, String type, String pwtype, NewickFile newtree) {
        try {
            this.jbInit();
            this.setMenuBar(this.jMenuBar1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initTreePanel(ap, type, pwtype, newtree);
    }

    void initTreePanel(AlignmentPanel ap, String type, String pwtype, NewickFile newTree) {
        this.ap = ap;
        this.av = ap.av;
        this.type = type;
        this.pwtype = pwtype;
        this.treeCanvas = new TreeCanvas(ap, this.scrollPane);
        TreeLoader tl = new TreeLoader(newTree);
        tl.start();
        this.embedMenuIfNeeded(this.treeCanvas);
        this.scrollPane.add((Component)this.treeCanvas, "Center");
    }

    void showOriginalData() {
        if (this.tree.getOriginalData() != null) {
            char gc = '-';
            try {
                gc = this.av.getGapCharacter();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Object[] alAndColsel = this.tree.getOriginalData().getAlignmentAndHiddenColumns(gc);
            if (alAndColsel != null && alAndColsel[0] != null) {
                Alignment al = new Alignment((SequenceI[])alAndColsel[0]);
                AlignFrame af = new AlignFrame(al, this.av.applet, "Original Data for Tree", false);
                af.viewport.getAlignment().setHiddenColumns((HiddenColumns)alAndColsel[1]);
            }
        } else {
            Console.outPrintln("Original Tree Data not available");
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.newickOutput) {
            this.newickOutput_actionPerformed();
        } else if (evt.getSource() == this.fontSize) {
            this.fontSize_actionPerformed();
        } else if (evt.getSource() == this.inputData) {
            this.showOriginalData();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.fitToWindow) {
            this.treeCanvas.fitToWindow = this.fitToWindow.getState();
        } else if (evt.getSource() == this.distanceMenu) {
            this.treeCanvas.setShowDistances(this.distanceMenu.getState());
        } else if (evt.getSource() == this.bootstrapMenu) {
            this.treeCanvas.setShowBootstrap(this.bootstrapMenu.getState());
        } else if (evt.getSource() == this.placeholdersMenu) {
            this.treeCanvas.setMarkPlaceholders(this.placeholdersMenu.getState());
        }
        this.treeCanvas.repaint();
    }

    public void newickOutput_actionPerformed() {
        NewickFile fout = new NewickFile(this.tree.getTopNode());
        String output = fout.print(false, true);
        CutAndPasteTransfer cap = new CutAndPasteTransfer(false, null);
        cap.setText(output);
        Frame frame = new Frame();
        frame.add(cap);
        JalviewLite.addFrame(frame, this.type + " " + this.pwtype, 500, 100);
    }

    public Font getTreeFont() {
        return this.treeCanvas.font;
    }

    public void setTreeFont(Font font) {
        this.treeCanvas.font = font;
        this.treeCanvas.repaint();
    }

    protected void fontSize_actionPerformed() {
        if (this.treeCanvas == null) {
            return;
        }
        new FontChooser(this);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setBackground(Color.white);
        this.setFont(new Font("Verdana", 0, 12));
        this.jMenu2.setLabel(MessageManager.getString("action.view"));
        this.fontSize.setLabel(MessageManager.getString("action.font"));
        this.fontSize.addActionListener(this);
        this.bootstrapMenu.setLabel(MessageManager.getString("label.show_bootstrap_values"));
        this.bootstrapMenu.addItemListener(this);
        this.distanceMenu.setLabel(MessageManager.getString("label.show_distances"));
        this.distanceMenu.addItemListener(this);
        this.placeholdersMenu.setLabel(MessageManager.getString("label.mark_unassociated_leaves"));
        this.placeholdersMenu.addItemListener(this);
        this.fitToWindow.setState(true);
        this.fitToWindow.setLabel(MessageManager.getString("label.fit_to_window"));
        this.fitToWindow.addItemListener(this);
        this.fileMenu.setLabel(MessageManager.getString("action.file"));
        this.newickOutput.setLabel(MessageManager.getString("label.newick_format"));
        this.newickOutput.addActionListener(this);
        this.inputData.setLabel(MessageManager.getString("label.input_data"));
        this.add((Component)this.scrollPane, "Center");
        this.jMenuBar1.add(this.fileMenu);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu2.add(this.fitToWindow);
        this.jMenu2.add(this.fontSize);
        this.jMenu2.add(this.distanceMenu);
        this.jMenu2.add(this.bootstrapMenu);
        this.jMenu2.add(this.placeholdersMenu);
        this.fileMenu.add(this.newickOutput);
        this.fileMenu.add(this.inputData);
        this.inputData.addActionListener(this);
    }

    class TreeLoader
    extends Thread {
        NewickFile newtree;
        AlignmentView odata = null;

        public TreeLoader(NewickFile newtree) {
            this.newtree = newtree;
        }

        @Override
        public void run() {
            if (this.newtree != null) {
                TreePanel.this.tree = new TreeModel(TreePanel.this.av.getAlignment().getSequencesArray(), this.odata, this.newtree, null);
            } else {
                ScoreModelI sm1;
                ScoreModelI sm = sm1 = ScoreModels.getInstance().getScoreModel(TreePanel.this.pwtype, TreePanel.this.treeCanvas.ap);
                TreeBuilder njtree = TreePanel.this.type.equals("NJ") ? new NJTree(TreePanel.this.av, sm, SimilarityParams.Jalview) : new AverageDistanceTree(TreePanel.this.av, sm, SimilarityParams.Jalview);
                TreePanel.this.tree = new TreeModel(njtree);
            }
            TreePanel.this.tree.reCount(TreePanel.this.tree.getTopNode());
            TreePanel.this.tree.findHeight(TreePanel.this.tree.getTopNode());
            TreePanel.this.treeCanvas.setTree(TreePanel.this.tree);
            if (this.newtree != null) {
                boolean showDist = this.newtree.HasDistances() && TreePanel.this.av.applet.getDefaultParameter("showTreeDistances", this.newtree.HasDistances());
                boolean showBoots = this.newtree.HasBootstrap() && TreePanel.this.av.applet.getDefaultParameter("showTreeBootstraps", this.newtree.HasBootstrap());
                TreePanel.this.distanceMenu.setState(showDist);
                TreePanel.this.bootstrapMenu.setState(showBoots);
                TreePanel.this.treeCanvas.setShowBootstrap(showBoots);
                TreePanel.this.treeCanvas.setShowDistances(showDist);
                TreePanel.this.treeCanvas.setMarkPlaceholders(TreePanel.this.av.applet.getDefaultParameter("showUnlinkedTreeNodes", false));
            }
            TreePanel.this.treeCanvas.repaint();
            TreePanel.this.av.setCurrentTree(TreePanel.this.tree);
        }
    }
}

