/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.metadata.Option;
import compbio.metadata.RunnerConfig;
import compbio.metadata.WrongParameterException;
import compbio.util.SysPrefs;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Preset<T> {
    @XmlTransient
    private static final String SPACE = " ";
    @XmlElement(required=true, nillable=false)
    String name;
    String description;
    @XmlElement(required=true, nillable=false)
    @XmlElementWrapper(name="optlist")
    List<String> option;

    public void setOptions(List<String> option) {
        this.option = option;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getOptions() {
        return new ArrayList<String>(this.option);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Option<T>> getArguments(RunnerConfig<T> rconfig) throws WrongParameterException {
        ArrayList<Option<T>> options = new ArrayList<Option<T>>();
        for (String optionName : this.option) {
            String oname = this.getName(optionName = optionName.trim());
            Option<T> option = rconfig.getArgumentByOptionName(oname);
            if (option == null) continue;
            if (this.containValue(optionName)) {
                option.setDefaultValue(this.getValue(optionName));
            } else {
                option.setDefaultValue(oname);
            }
            options.add(option);
        }
        return options;
    }

    boolean containValue(String option) {
        return option.trim().contains(SPACE);
    }

    String getName(String option) {
        if (this.containValue(option = option.trim())) {
            return option.substring(0, option.indexOf(SPACE)).trim();
        }
        return option;
    }

    String getValue(String option) {
        assert (this.containValue(option));
        option = option.trim();
        return option.substring(option.indexOf(SPACE) + 1).trim();
    }

    public String toString() {
        String value = "Preset name: '" + this.name + "'" + SysPrefs.newlinechar;
        value = value + "Description: " + this.description + SysPrefs.newlinechar;
        value = value + "Options used: " + SysPrefs.newlinechar;
        for (String oname : this.option) {
            value = value + oname + SysPrefs.newlinechar;
        }
        return value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.option == null ? 0 : this.option.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Preset other = (Preset)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.option == null ? other.option != null : !this.option.equals(other.option));
    }
}

