/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.models;

import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.exceptions.ExceptionNAViewAlgorithm;
import fr.orsay.lri.varna.models.rna.ModeleBP;
import fr.orsay.lri.varna.models.rna.ModeleBase;
import fr.orsay.lri.varna.models.rna.RNA;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class VARNAEdits {
    public static final double MAX_DISTANCE = 55.0;

    public static class RedrawEdit
    extends AbstractUndoableEdit {
        private int _prevMode;
        private int _newMode;
        private boolean _prevFlat;
        private boolean _newFlat;
        private ArrayList<Point2D.Double> _backupCoords = new ArrayList();
        private ArrayList<Point2D.Double> _backupCenters = new ArrayList();
        private VARNAPanel _vp;

        public RedrawEdit(VARNAPanel vARNAPanel, boolean bl) {
            this(vARNAPanel.getRNA().getDrawMode(), vARNAPanel, bl);
        }

        public RedrawEdit(int n, VARNAPanel vARNAPanel) {
            this(n, vARNAPanel, vARNAPanel.getFlatExteriorLoop());
        }

        public RedrawEdit(int n, VARNAPanel vARNAPanel, boolean bl) {
            this._vp = vARNAPanel;
            this._newMode = n;
            this._newFlat = bl;
            this._prevFlat = this._vp.getFlatExteriorLoop();
            for (ModeleBase modeleBase : this._vp.getRNA().get_listeBases()) {
                this._backupCoords.add(new Point2D.Double(modeleBase.getCoords().x, modeleBase.getCoords().y));
                this._backupCenters.add(new Point2D.Double(modeleBase.getCenter().x, modeleBase.getCenter().y));
            }
            this._prevMode = this._vp.getDrawMode();
        }

        @Override
        public void undo() throws CannotUndoException {
            RNA rNA = this._vp.getRNA();
            this._vp.setFlatExteriorLoop(this._prevFlat);
            rNA.setDrawMode(this._prevMode);
            for (int i = 0; i < this._vp.getRNA().get_listeBases().size(); ++i) {
                Point2D.Double double_ = this._backupCoords.get(i);
                Point2D.Double double_2 = this._backupCenters.get(i);
                rNA.setCoord(i, double_);
                rNA.setCenter(i, double_2);
            }
            this._vp.repaint();
        }

        @Override
        public void redo() throws CannotRedoException {
            try {
                this._vp.setFlatExteriorLoop(this._newFlat);
                this._vp.getRNA().drawRNA(this._newMode, this._vp.getConfig());
            }
            catch (ExceptionNAViewAlgorithm exceptionNAViewAlgorithm) {
                exceptionNAViewAlgorithm.printStackTrace();
            }
            this._vp.repaint();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Redraw whole RNA";
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            return false;
        }
    }

    public static class RotateRNAEdit
    extends AbstractUndoableEdit {
        private double _angle;
        private VARNAPanel _vp;

        public RotateRNAEdit(double d, VARNAPanel vARNAPanel) {
            this._angle = d;
            this._vp = vARNAPanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            this._vp.getRNA().globalRotation(-this._angle);
            this._vp.repaint();
        }

        @Override
        public void redo() throws CannotRedoException {
            this._vp.getRNA().globalRotation(this._angle);
            this._vp.repaint();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Rotate RNA angle:" + this._angle + "";
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof RotateRNAEdit) {
                RotateRNAEdit rotateRNAEdit = (RotateRNAEdit)undoableEdit;
                if (Math.abs(this._angle + rotateRNAEdit._angle) < 30.0) {
                    this._angle += rotateRNAEdit._angle;
                    return true;
                }
            }
            return false;
        }
    }

    public static class RescaleRNAEdit
    extends AbstractUndoableEdit {
        private double _factor;
        private VARNAPanel _vp;

        public RescaleRNAEdit(double d, VARNAPanel vARNAPanel) {
            this._factor = d;
            this._vp = vARNAPanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            this._vp.getRNA().rescale(1.0 / this._factor);
            this._vp.repaint();
        }

        @Override
        public void redo() throws CannotRedoException {
            this._vp.getRNA().rescale(this._factor);
            this._vp.repaint();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Rescale RNA factor:" + this._factor + "";
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof RescaleRNAEdit) {
                RescaleRNAEdit rescaleRNAEdit = (RescaleRNAEdit)undoableEdit;
                double d = this._factor * rescaleRNAEdit._factor;
                if (d > 0.7 || d < 1.3) {
                    this._factor *= rescaleRNAEdit._factor;
                    return true;
                }
            }
            return false;
        }
    }

    public static class RemoveBPEdit
    extends AbstractUndoableEdit {
        private ModeleBP _msbp;
        private int _i;
        private int _j;
        private VARNAPanel _vp;

        public RemoveBPEdit(int n, int n2, ModeleBP modeleBP, VARNAPanel vARNAPanel) {
            this._msbp = modeleBP;
            this._i = n;
            this._j = n2;
            this._vp = vARNAPanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            this._vp.getRNA().addBP(this._i, this._j, this._msbp);
            this._vp.repaint();
        }

        @Override
        public void redo() throws CannotRedoException {
            this._vp.getRNA().removeBP(this._msbp);
            this._vp.repaint();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Remove BP (" + this._i + "," + this._j + ")";
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            return false;
        }
    }

    public static class AddBPEdit
    extends AbstractUndoableEdit {
        private ModeleBP _msbp;
        private int _i;
        private int _j;
        private VARNAPanel _vp;

        public AddBPEdit(int n, int n2, ModeleBP modeleBP, VARNAPanel vARNAPanel) {
            this._msbp = modeleBP;
            this._i = n;
            this._j = n2;
            this._vp = vARNAPanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            this._vp.getRNA().removeBP(this._msbp);
            this._vp.repaint();
        }

        @Override
        public void redo() throws CannotRedoException {
            this._vp.getRNA().addBP(this._i, this._j, this._msbp);
            this._vp.repaint();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Add BP (" + this._i + "," + this._j + ")";
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            return false;
        }
    }

    public static class HelixFlipEdit
    extends AbstractUndoableEdit {
        private Point _h;
        private VARNAPanel _vp;

        public HelixFlipEdit(Point point, VARNAPanel vARNAPanel) {
            this._h = point;
            this._vp = vARNAPanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            this._vp.getVARNAUI().UIFlipHelix(this._h);
            this._vp.repaint();
        }

        @Override
        public void redo() throws CannotRedoException {
            this._vp.getVARNAUI().UIFlipHelix(this._h);
            this._vp.repaint();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Helix #" + this._h + " flipped";
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            return false;
        }
    }

    public static class SingleBaseMoveEdit
    extends AbstractUndoableEdit {
        private int _index;
        private double _ox;
        private double _oy;
        private double _nx;
        private double _ny;
        private VARNAPanel _vp;

        public SingleBaseMoveEdit(int n, double d, double d2, VARNAPanel vARNAPanel) {
            this._index = n;
            ModeleBase modeleBase = vARNAPanel.getRNA().getBaseAt(n);
            this._ox = modeleBase.getCoords().x;
            this._oy = modeleBase.getCoords().y;
            this._nx = d;
            this._ny = d2;
            this._vp = vARNAPanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            this._vp.getRNA().setCoord(this._index, new Point2D.Double(this._ox, this._oy));
            this._vp.repaint();
        }

        @Override
        public void redo() throws CannotRedoException {
            this._vp.getRNA().setCoord(this._index, new Point2D.Double(this._nx, this._ny));
            this._vp.repaint();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Base #" + this._index + " moved";
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof SingleBaseMoveEdit) {
                SingleBaseMoveEdit singleBaseMoveEdit = (SingleBaseMoveEdit)undoableEdit;
                if (singleBaseMoveEdit._index == this._index) {
                    Point2D.Double double_ = new Point2D.Double(this._ox, this._oy);
                    Point2D.Double double_2 = new Point2D.Double(this._nx, this._ny);
                    Point2D.Double double_3 = new Point2D.Double(singleBaseMoveEdit._ox, singleBaseMoveEdit._oy);
                    Point2D.Double double_4 = new Point2D.Double(singleBaseMoveEdit._nx, singleBaseMoveEdit._ny);
                    if (double_2.equals(double_3) && double_.distance(double_4) < 55.0) {
                        this._nx = singleBaseMoveEdit._nx;
                        this._ny = singleBaseMoveEdit._ny;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public static class HelixRotateEdit
    extends AbstractUndoableEdit {
        private double _delta;
        private double _base;
        private double _pLimL;
        private double _pLimR;
        private Point _h;
        private Point _ml;
        private VARNAPanel _vp;

        public HelixRotateEdit(double d, double d2, double d3, double d4, Point point, Point point2, VARNAPanel vARNAPanel) {
            this._delta = d;
            this._base = d2;
            this._pLimL = d3;
            this._pLimR = d4;
            this._h = point;
            this._ml = point2;
            this._vp = vARNAPanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            this._vp.getVARNAUI().UIRotateEverything(-this._delta, this._base, this._pLimL, this._pLimR, this._h, this._ml);
            this._vp.repaint();
        }

        @Override
        public void redo() throws CannotRedoException {
            this._vp.getVARNAUI().UIRotateEverything(this._delta, this._base, this._pLimL, this._pLimR, this._h, this._ml);
            this._vp.repaint();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Helix #" + this._h + " rotated angle:" + this._delta;
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof HelixRotateEdit) {
                HelixRotateEdit helixRotateEdit = (HelixRotateEdit)undoableEdit;
                if (helixRotateEdit._h.equals(this._h)) {
                    double d;
                    for (d = helixRotateEdit._delta + this._delta; d > Math.PI; d -= Math.PI * 2) {
                    }
                    if (Math.abs(d) < 0.39269908169872414) {
                        this._delta = d;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public static class BasesShiftEdit
    extends AbstractUndoableEdit {
        private ArrayList<Integer> _indices;
        private double _dx;
        private double _dy;
        private VARNAPanel _vp;

        public BasesShiftEdit(ArrayList<Integer> arrayList, double d, double d2, VARNAPanel vARNAPanel) {
            this._indices = arrayList;
            this._dx = d;
            this._dy = d2;
            this._vp = vARNAPanel;
        }

        @Override
        public void undo() throws CannotUndoException {
            for (int n : this._indices) {
                ModeleBase modeleBase = this._vp.getRNA().getBaseAt(n);
                this._vp.getRNA().setCoord(n, new Point2D.Double(modeleBase.getCoords().x - this._dx, modeleBase.getCoords().y - this._dy));
                this._vp.getRNA().setCenter(n, new Point2D.Double(modeleBase.getCenter().x - this._dx, modeleBase.getCenter().y - this._dy));
            }
            this._vp.repaint();
        }

        @Override
        public void redo() throws CannotRedoException {
            for (int n : this._indices) {
                ModeleBase modeleBase = this._vp.getRNA().getBaseAt(n);
                this._vp.getRNA().setCoord(n, new Point2D.Double(modeleBase.getCoords().x + this._dx, modeleBase.getCoords().y + this._dy));
                this._vp.getRNA().setCenter(n, new Point2D.Double(modeleBase.getCenter().x - this._dx, modeleBase.getCenter().y - this._dy));
            }
            this._vp.repaint();
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public boolean canRedo() {
            return true;
        }

        @Override
        public String getPresentationName() {
            return "Base #" + this._indices + " shifted";
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof BasesShiftEdit) {
                Point2D.Double double_;
                BasesShiftEdit basesShiftEdit = (BasesShiftEdit)undoableEdit;
                if (basesShiftEdit._indices.equals(this._indices) && (double_ = new Point2D.Double(this._dx + basesShiftEdit._dx, this._dy + basesShiftEdit._dy)).distance(0.0, 0.0) < 55.0) {
                    this._dx += basesShiftEdit._dx;
                    this._dy += basesShiftEdit._dy;
                    return true;
                }
            }
            return false;
        }
    }
}

