/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.deploy.source;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.jnati.deploy.artefact.Artefact;
import net.sf.jnati.deploy.source.ArtefactSource;
import org.apache.log4j.Logger;

public class UrlSource
extends ArtefactSource {
    private static final Logger LOG = Logger.getLogger(UrlSource.class);
    private final URL manifestUrl;
    private final String rootPath;
    private final Artefact artefact;

    public UrlSource(URL url, Artefact artefact, String artefactPath) {
        this.manifestUrl = url;
        this.rootPath = artefactPath;
        this.artefact = artefact;
    }

    public InputStream openFile(String path) throws IOException {
        URL u = this.findUrl(path);
        if (u == null) {
            throw new FileNotFoundException("File not found: " + path);
        }
        return u.openStream();
    }

    private URL findUrl(String path) {
        String file = this.rootPath + path;
        URL u = Thread.currentThread().getContextClassLoader().getResource(file);
        if (u != null) {
            LOG.debug((Object)("found '" + file + "' : " + u));
        }
        return u;
    }

    public void close() throws IOException {
    }

    public boolean containsFile(String path) throws IOException {
        URL u = this.findUrl(path);
        return u != null;
    }

    public boolean isLocal() {
        return false;
    }

    public File getPath() {
        return null;
    }
}

