/*
 * Decompiled with CFR 0.152.
 */
package org.robsite.jswingreader.ui.prefs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.robsite.jswingreader.ui.Main;
import org.robsite.jswingreader.ui.prefs.PreferencesPage;

public class ProxyPage
extends JPanel
implements PreferencesPage {
    private static final Icon _icon = new ImageIcon(Main.class.getResource("image/PrefsProxy.gif"));
    private JCheckBox chkUseProxy = new JCheckBox();
    private JLabel lblProxyPort = new JLabel();
    private JTextField taProxyPort = new JTextField();
    private JLabel lblProxyName = new JLabel();
    private JTextField taProxyHostName = new JTextField();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public ProxyPage() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Component getPage() {
        return this;
    }

    public String getName() {
        return "Proxy Server";
    }

    public Map getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("enabled", Boolean.toString(this.chkUseProxy.isSelected()));
        map.put("proxyHost", this.taProxyHostName.getText());
        map.put("proxyPort", this.taProxyPort.getText());
        return map;
    }

    public void setProperties(Map map) {
        String value = (String)map.get("enabled");
        this.chkUseProxy.setSelected(Boolean.valueOf(value));
        this.taProxyHostName.setText((String)map.get("proxyHost"));
        this.taProxyPort.setText((String)map.get("proxyPort"));
        this._updateProxyEnabledState();
    }

    public Object getKey() {
        return "proxy";
    }

    public Icon getIcon() {
        return _icon;
    }

    public void onEntry() {
    }

    public void onExit() {
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.chkUseProxy.setText("Use Proxy Server");
        this.chkUseProxy.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ProxyPage.this._updateProxyEnabledState();
            }
        });
        this.lblProxyPort.setText("HTTP Proxy Server Port Number:");
        this.lblProxyName.setText("HTTP Proxy Server Host Name:");
        this.add((Component)this.chkUseProxy, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.lblProxyName, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 15, 5, 5), 0, 0));
        this.add((Component)this.taProxyHostName, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 15, 5, 5), 0, 0));
        this.add((Component)this.lblProxyPort, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 15, 5, 5), 0, 0));
        this.add((Component)this.taProxyPort, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 15, 5, 5), 0, 0));
    }

    private void _updateProxyEnabledState() {
        this.taProxyHostName.setEnabled(this.chkUseProxy.isSelected());
        this.taProxyPort.setEnabled(this.chkUseProxy.isSelected());
        if (this.chkUseProxy.isSelected()) {
            System.setProperty("http.proxyHost", this.taProxyHostName.getText());
            System.setProperty("http.proxyPort", this.taProxyPort.getText());
        } else {
            System.getProperties().remove("http.proxyHost");
            System.getProperties().remove("http.ProxyPort");
        }
    }
}

